# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MarkerSettingArgs', 'MarkerSetting']

@pulumi.input_type
class MarkerSettingArgs:
    def __init__(__self__, *,
                 color: pulumi.Input[str],
                 dataset: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        The set of arguments for constructing a MarkerSetting resource.
        :param pulumi.Input[str] color: The color set for the marker as a hex color code (e.g. `#DF4661`)
        :param pulumi.Input[str] dataset: The dataset this marker setting is placed on.
        :param pulumi.Input[str] type: The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Input[str]:
        """
        The color set for the marker as a hex color code (e.g. `#DF4661`)
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: pulumi.Input[str]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this marker setting is placed on.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _MarkerSettingState:
    def __init__(__self__, *,
                 color: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MarkerSetting resources.
        :param pulumi.Input[str] color: The color set for the marker as a hex color code (e.g. `#DF4661`)
        :param pulumi.Input[str] created_at: Timestamp when the marker setting was created.
        :param pulumi.Input[str] dataset: The dataset this marker setting is placed on.
        :param pulumi.Input[str] type: The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        :param pulumi.Input[str] updated_at: Timestamp when the marker setting was last modified.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[str]]:
        """
        The color set for the marker as a hex color code (e.g. `#DF4661`)
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the marker setting was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this marker setting is placed on.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the marker setting was last modified.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class MarkerSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: MarkerSetting

        Creates a marker setting. For more information about marker settings, check out the [Marker Settings API](https://docs.honeycomb.io/api/marker-settings/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        type = config.require("type")
        marker_setting = honeycomb.MarkerSetting("markerSetting",
            type=type,
            color="#DF4661",
            dataset=dataset)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color: The color set for the marker as a hex color code (e.g. `#DF4661`)
        :param pulumi.Input[str] dataset: The dataset this marker setting is placed on.
        :param pulumi.Input[str] type: The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MarkerSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: MarkerSetting

        Creates a marker setting. For more information about marker settings, check out the [Marker Settings API](https://docs.honeycomb.io/api/marker-settings/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        type = config.require("type")
        marker_setting = honeycomb.MarkerSetting("markerSetting",
            type=type,
            color="#DF4661",
            dataset=dataset)
        ```

        :param str resource_name: The name of the resource.
        :param MarkerSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MarkerSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MarkerSettingArgs.__new__(MarkerSettingArgs)

            if color is None and not opts.urn:
                raise TypeError("Missing required property 'color'")
            __props__.__dict__["color"] = color
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(MarkerSetting, __self__).__init__(
            'honeycomb:index/markerSetting:MarkerSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'MarkerSetting':
        """
        Get an existing MarkerSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color: The color set for the marker as a hex color code (e.g. `#DF4661`)
        :param pulumi.Input[str] created_at: Timestamp when the marker setting was created.
        :param pulumi.Input[str] dataset: The dataset this marker setting is placed on.
        :param pulumi.Input[str] type: The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        :param pulumi.Input[str] updated_at: Timestamp when the marker setting was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MarkerSettingState.__new__(_MarkerSettingState)

        __props__.__dict__["color"] = color
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return MarkerSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Output[str]:
        """
        The color set for the marker as a hex color code (e.g. `#DF4661`)
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp when the marker setting was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this marker setting is placed on.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the marker setting, Honeycomb.io can display markers in different colors depending on their type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Timestamp when the marker setting was last modified.
        """
        return pulumi.get(self, "updated_at")

