# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BoardQueryArgs',
    'BoardQueryGraphSettingsArgs',
    'BurnAlertRecipientArgs',
    'BurnAlertRecipientNotificationDetailsArgs',
    'GetQuerySpecificationCalculationArgs',
    'GetQuerySpecificationFilterArgs',
    'GetQuerySpecificationHavingArgs',
    'GetQuerySpecificationOrderArgs',
    'GetRecipientDetailFilterArgs',
    'GetRecipientsDetailFilterArgs',
    'TriggerRecipientArgs',
    'TriggerRecipientNotificationDetailsArgs',
    'TriggerThresholdArgs',
]

@pulumi.input_type
class BoardQueryArgs:
    def __init__(__self__, *,
                 query_id: pulumi.Input[str],
                 caption: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 graph_settings: Optional[pulumi.Input['BoardQueryGraphSettingsArgs']] = None,
                 query_annotation_id: Optional[pulumi.Input[str]] = None,
                 query_style: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] query_id: The ID of the Query to run.
        :param pulumi.Input[str] caption: A description of the query that will be displayed on the board. Supports markdown.
        :param pulumi.Input[str] dataset: The dataset this query is associated with.
        :param pulumi.Input['BoardQueryGraphSettingsArgs'] graph_settings: A map of boolean toggles to manages the settings for this query's graph on the board.
               If a value is unspecified, it is assumed to be false.
               Currently supported toggles are:
               * `hide_markers`
               * `log_scale`
               * `omit_missing_values`
               * `stacked_graphs`
               * `utc_xaxis`
        :param pulumi.Input[str] query_annotation_id: The ID of the Query Annotation to associate with this query.
        :param pulumi.Input[str] query_style: How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        pulumi.set(__self__, "query_id", query_id)
        if caption is not None:
            pulumi.set(__self__, "caption", caption)
        if dataset is not None:
            warnings.warn("""Board Queries no longer require the dataset as they rely on the provided Query ID's dataset.""", DeprecationWarning)
            pulumi.log.warn("""dataset is deprecated: Board Queries no longer require the dataset as they rely on the provided Query ID's dataset.""")
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if graph_settings is not None:
            pulumi.set(__self__, "graph_settings", graph_settings)
        if query_annotation_id is not None:
            pulumi.set(__self__, "query_annotation_id", query_annotation_id)
        if query_style is not None:
            pulumi.set(__self__, "query_style", query_style)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[str]:
        """
        The ID of the Query to run.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_id", value)

    @property
    @pulumi.getter
    def caption(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the query that will be displayed on the board. Supports markdown.
        """
        return pulumi.get(self, "caption")

    @caption.setter
    def caption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "caption", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this query is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="graphSettings")
    def graph_settings(self) -> Optional[pulumi.Input['BoardQueryGraphSettingsArgs']]:
        """
        A map of boolean toggles to manages the settings for this query's graph on the board.
        If a value is unspecified, it is assumed to be false.
        Currently supported toggles are:
        * `hide_markers`
        * `log_scale`
        * `omit_missing_values`
        * `stacked_graphs`
        * `utc_xaxis`
        """
        return pulumi.get(self, "graph_settings")

    @graph_settings.setter
    def graph_settings(self, value: Optional[pulumi.Input['BoardQueryGraphSettingsArgs']]):
        pulumi.set(self, "graph_settings", value)

    @property
    @pulumi.getter(name="queryAnnotationId")
    def query_annotation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Query Annotation to associate with this query.
        """
        return pulumi.get(self, "query_annotation_id")

    @query_annotation_id.setter
    def query_annotation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_annotation_id", value)

    @property
    @pulumi.getter(name="queryStyle")
    def query_style(self) -> Optional[pulumi.Input[str]]:
        """
        How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        return pulumi.get(self, "query_style")

    @query_style.setter
    def query_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_style", value)


@pulumi.input_type
class BoardQueryGraphSettingsArgs:
    def __init__(__self__, *,
                 hide_markers: Optional[pulumi.Input[bool]] = None,
                 log_scale: Optional[pulumi.Input[bool]] = None,
                 omit_missing_values: Optional[pulumi.Input[bool]] = None,
                 stacked_graphs: Optional[pulumi.Input[bool]] = None,
                 utc_xaxis: Optional[pulumi.Input[bool]] = None):
        if hide_markers is not None:
            pulumi.set(__self__, "hide_markers", hide_markers)
        if log_scale is not None:
            pulumi.set(__self__, "log_scale", log_scale)
        if omit_missing_values is not None:
            pulumi.set(__self__, "omit_missing_values", omit_missing_values)
        if stacked_graphs is not None:
            pulumi.set(__self__, "stacked_graphs", stacked_graphs)
        if utc_xaxis is not None:
            pulumi.set(__self__, "utc_xaxis", utc_xaxis)

    @property
    @pulumi.getter(name="hideMarkers")
    def hide_markers(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "hide_markers")

    @hide_markers.setter
    def hide_markers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_markers", value)

    @property
    @pulumi.getter(name="logScale")
    def log_scale(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "log_scale")

    @log_scale.setter
    def log_scale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_scale", value)

    @property
    @pulumi.getter(name="omitMissingValues")
    def omit_missing_values(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "omit_missing_values")

    @omit_missing_values.setter
    def omit_missing_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "omit_missing_values", value)

    @property
    @pulumi.getter(name="stackedGraphs")
    def stacked_graphs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "stacked_graphs")

    @stacked_graphs.setter
    def stacked_graphs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stacked_graphs", value)

    @property
    @pulumi.getter(name="utcXaxis")
    def utc_xaxis(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "utc_xaxis")

    @utc_xaxis.setter
    def utc_xaxis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "utc_xaxis", value)


@pulumi.input_type
class BurnAlertRecipientArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 notification_details: Optional[pulumi.Input['BurnAlertRecipientNotificationDetailsArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param pulumi.Input['BurnAlertRecipientNotificationDetailsArgs'] notification_details: a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        :param pulumi.Input[str] target: Target of the recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param pulumi.Input[str] type: The type of the recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if notification_details is not None:
            pulumi.set(__self__, "notification_details", notification_details)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="notificationDetails")
    def notification_details(self) -> Optional[pulumi.Input['BurnAlertRecipientNotificationDetailsArgs']]:
        """
        a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        """
        return pulumi.get(self, "notification_details")

    @notification_details.setter
    def notification_details(self, value: Optional[pulumi.Input['BurnAlertRecipientNotificationDetailsArgs']]):
        pulumi.set(self, "notification_details", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class BurnAlertRecipientNotificationDetailsArgs:
    def __init__(__self__, *,
                 pagerduty_severity: pulumi.Input[str]):
        pulumi.set(__self__, "pagerduty_severity", pagerduty_severity)

    @property
    @pulumi.getter(name="pagerdutySeverity")
    def pagerduty_severity(self) -> pulumi.Input[str]:
        return pulumi.get(self, "pagerduty_severity")

    @pagerduty_severity.setter
    def pagerduty_severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "pagerduty_severity", value)


@pulumi.input_type
class GetQuerySpecificationCalculationArgs:
    def __init__(__self__, *,
                 op: str,
                 column: Optional[str] = None):
        """
        :param str op: The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str column: The column to apply the operator to, not needed with `COUNT` or `CONCURRENCY`.
        """
        pulumi.set(__self__, "op", op)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the operator to, not needed with `COUNT` or `CONCURRENCY`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[str]):
        pulumi.set(self, "column", value)


@pulumi.input_type
class GetQuerySpecificationFilterArgs:
    def __init__(__self__, *,
                 column: str,
                 op: str,
                 value: Optional[str] = None,
                 value_boolean: Optional[bool] = None,
                 value_float: Optional[float] = None,
                 value_integer: Optional[int] = None,
                 value_string: Optional[str] = None):
        """
        :param str column: The column to apply the filter to.
        :param str op: The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        :param str value: The value used for the filter. Not needed if op is `exists`, `not-exists`, `in` or `not-in`. Mutually exclusive with the other `value_*` options.
        :param bool value_boolean: Deprecated: use 'value' instead. The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        :param float value_float: Deprecated: use 'value' instead. The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        :param int value_integer: Deprecated: use 'value' instead. The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        :param str value_string: Deprecated: use 'value' instead. The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "op", op)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_boolean is not None:
            warnings.warn("""Use of attribute `value_boolean` is discouraged and will fail to plan if using 'false'. Use of `value` is encouraged.""", DeprecationWarning)
            pulumi.log.warn("""value_boolean is deprecated: Use of attribute `value_boolean` is discouraged and will fail to plan if using 'false'. Use of `value` is encouraged.""")
        if value_boolean is not None:
            pulumi.set(__self__, "value_boolean", value_boolean)
        if value_float is not None:
            warnings.warn("""Use of attribute `value_float` is discouraged and will fail to plan if using '0'. Use of `value` is encouraged.""", DeprecationWarning)
            pulumi.log.warn("""value_float is deprecated: Use of attribute `value_float` is discouraged and will fail to plan if using '0'. Use of `value` is encouraged.""")
        if value_float is not None:
            pulumi.set(__self__, "value_float", value_float)
        if value_integer is not None:
            warnings.warn("""Use of attribute `value_integer` is discouraged and will fail to plan if using '0'. Use of `value` is encouraged.""", DeprecationWarning)
            pulumi.log.warn("""value_integer is deprecated: Use of attribute `value_integer` is discouraged and will fail to plan if using '0'. Use of `value` is encouraged.""")
        if value_integer is not None:
            pulumi.set(__self__, "value_integer", value_integer)
        if value_string is not None:
            warnings.warn("""Use of attribute `value_string` is discouraged and will fail to plan if using the empty string. Use of `value` is encouraged.""", DeprecationWarning)
            pulumi.log.warn("""value_string is deprecated: Use of attribute `value_string` is discouraged and will fail to plan if using the empty string. Use of `value` is encouraged.""")
        if value_string is not None:
            pulumi.set(__self__, "value_string", value_string)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        The column to apply the filter to.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: str):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value used for the filter. Not needed if op is `exists`, `not-exists`, `in` or `not-in`. Mutually exclusive with the other `value_*` options.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueBoolean")
    def value_boolean(self) -> Optional[bool]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_boolean")

    @value_boolean.setter
    def value_boolean(self, value: Optional[bool]):
        pulumi.set(self, "value_boolean", value)

    @property
    @pulumi.getter(name="valueFloat")
    def value_float(self) -> Optional[float]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_float")

    @value_float.setter
    def value_float(self, value: Optional[float]):
        pulumi.set(self, "value_float", value)

    @property
    @pulumi.getter(name="valueInteger")
    def value_integer(self) -> Optional[int]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_integer")

    @value_integer.setter
    def value_integer(self, value: Optional[int]):
        pulumi.set(self, "value_integer", value)

    @property
    @pulumi.getter(name="valueString")
    def value_string(self) -> Optional[str]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_string")

    @value_string.setter
    def value_string(self, value: Optional[str]):
        pulumi.set(self, "value_string", value)


@pulumi.input_type
class GetQuerySpecificationHavingArgs:
    def __init__(__self__, *,
                 calculate_op: str,
                 op: str,
                 value: float,
                 column: Optional[str] = None):
        """
        :param str calculate_op: The calculation operator to apply, supports all of the [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators) with the exception of `HEATMAP`.
        :param str op: The operator to apply to filter the query results. One of `=`, `!=`, `>`, `>=`, `<`, or `<=`.
        :param float value: The value used with `op`. Currently assumed to be a number.
        :param str column: The column to apply the `calculate_op` to, not needed with `COUNT` or `CONCURRENCY`.
        """
        pulumi.set(__self__, "calculate_op", calculate_op)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter(name="calculateOp")
    def calculate_op(self) -> str:
        """
        The calculation operator to apply, supports all of the [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators) with the exception of `HEATMAP`.
        """
        return pulumi.get(self, "calculate_op")

    @calculate_op.setter
    def calculate_op(self, value: str):
        pulumi.set(self, "calculate_op", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply to filter the query results. One of `=`, `!=`, `>`, `>=`, `<`, or `<=`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value used with `op`. Currently assumed to be a number.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: float):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the `calculate_op` to, not needed with `COUNT` or `CONCURRENCY`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[str]):
        pulumi.set(self, "column", value)


@pulumi.input_type
class GetQuerySpecificationOrderArgs:
    def __init__(__self__, *,
                 column: Optional[str] = None,
                 op: Optional[str] = None,
                 order: Optional[str] = None):
        """
        :param str column: Either a column present in `breakdown` or a column to `op` applies to.
        :param str op: The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str order: The sort direction, if set must be `ascending` or `descending`.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Either a column present in `breakdown` or a column to `op` applies to.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[str]:
        """
        The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: Optional[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        The sort direction, if set must be `ascending` or `descending`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[str]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class GetRecipientDetailFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_regex: Optional[str] = None):
        """
        :param str name: The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        :param str value: The value of the detail field to match on.
        :param str value_regex: A regular expression string to apply to the value of the detail field to match on.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_regex is not None:
            pulumi.set(__self__, "value_regex", value_regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the detail field to match on.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueRegex")
    def value_regex(self) -> Optional[str]:
        """
        A regular expression string to apply to the value of the detail field to match on.
        """
        return pulumi.get(self, "value_regex")

    @value_regex.setter
    def value_regex(self, value: Optional[str]):
        pulumi.set(self, "value_regex", value)


@pulumi.input_type
class GetRecipientsDetailFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_regex: Optional[str] = None):
        """
        :param str name: The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        :param str value: The value of the detail field to match on.
        :param str value_regex: A regular expression string to apply to the value of the detail field to match on.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_regex is not None:
            pulumi.set(__self__, "value_regex", value_regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the detail field to match on.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueRegex")
    def value_regex(self) -> Optional[str]:
        """
        A regular expression string to apply to the value of the detail field to match on.
        """
        return pulumi.get(self, "value_regex")

    @value_regex.setter
    def value_regex(self, value: Optional[str]):
        pulumi.set(self, "value_regex", value)


@pulumi.input_type
class TriggerRecipientArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 notification_details: Optional[pulumi.Input['TriggerRecipientNotificationDetailsArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param pulumi.Input['TriggerRecipientNotificationDetailsArgs'] notification_details: a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        :param pulumi.Input[str] target: Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param pulumi.Input[str] type: The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if notification_details is not None:
            pulumi.set(__self__, "notification_details", notification_details)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="notificationDetails")
    def notification_details(self) -> Optional[pulumi.Input['TriggerRecipientNotificationDetailsArgs']]:
        """
        a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        """
        return pulumi.get(self, "notification_details")

    @notification_details.setter
    def notification_details(self, value: Optional[pulumi.Input['TriggerRecipientNotificationDetailsArgs']]):
        pulumi.set(self, "notification_details", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TriggerRecipientNotificationDetailsArgs:
    def __init__(__self__, *,
                 pagerduty_severity: pulumi.Input[str]):
        pulumi.set(__self__, "pagerduty_severity", pagerduty_severity)

    @property
    @pulumi.getter(name="pagerdutySeverity")
    def pagerduty_severity(self) -> pulumi.Input[str]:
        return pulumi.get(self, "pagerduty_severity")

    @pagerduty_severity.setter
    def pagerduty_severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "pagerduty_severity", value)


@pulumi.input_type
class TriggerThresholdArgs:
    def __init__(__self__, *,
                 op: pulumi.Input[str],
                 value: pulumi.Input[float]):
        """
        :param pulumi.Input[str] op: The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        :param pulumi.Input[float] value: The value to be used with the operator.
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        The value to be used with the operator.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


