# Using gaarf in Airflow


If you want to use Apache Airflow to run any gaarf-based projects you can use
`airflow-google-ads-api-report-fetcher` package.

Install it with `pip install airflow-google-ads-api-report-fetcher` -
it will make  `airflow_gaarf` library available.

> Install the latest development version with `pip install -e git+https://github.com/google/ads-api-report-fetcher.git#egg=airflow-google-ads-api-report-fetcher\&subdirectory=py/airflow_gaarf`

The library comes with two operators - `GaarfOperator` and `GaarfBqOperator` which can
be used to simplify executing `google_ads_queries` and `bq_queries` respectively.

## Setup
### Connections

Template pipeline expects two type of connections - go to *Admin - Connections*,
add new connection (type *Generic*) and in *Extra* add the values specified below:

* `google_ads_default`

		{"google_ads_client":
			{"developer_token": "",
			"client_id": "",
			"client_secret": "",
			"refresh_token": "",
			"login_customer_id": "",
			"client_customer_id": "",
			"use_proto_plus": "true"
			}
		}

* `gcp_conn_id`

	  {"cloud":
			{"project_id": "your-project"}
	  }


### Dag

Once the above connections were setup you may proceed to configuring DAG.

`src/template_dag.py` contains a template DAG where you need to specify the following:

* `solution_directory` - absolute path to the directory containing queries.
* `path_to_config` - yaml file that is generated by running `gaarf` and `gaarf-bq` commands

Don't forget to replace `template_gaarf_dag` to DAG name that aligns with your
naming conventions and update `schedule_interval` and `start_date`.
