# AUTOGENERATED! DO NOT EDIT! File to edit: datasets.ipynb (unless otherwise specified).

__all__ = ['download_oxford5k', 'download_aachen_daynight', 'get_all_images_in_subdirs', 'get_aachen_db_images',
           'get_aachen_query_images', 'RetrievalDataset']

# Cell
from .io import *
import tarfile
def download_oxford5k(save_to_dir):
    url = 'http://www.robots.ox.ac.uk/~vgg/data/oxbuildings/oxbuild_images.tgz'
    md5sum ='c5af8e1457ddfd5d7a8d66fec5293417'
    fname = 'oxbuild_images.tgz'
    saved_fname = download_file(url, fname, md5sum, True)
    tar = tarfile.open(saved_fname, "r:gz")
    tar.extractall(save_to_dir)
    tar.close()
    return

# Cell
import zipfile
def download_aachen_daynight(save_to_dir):
    url = 'https://data.ciirc.cvut.cz/public/projects/2020VisualLocalization/Aachen-Day-Night/aachen_v1_1.zip'
    md5sum ='498be8ccf98644f2dbd3705b0dfadc4c'
    fname = 'aachen_v1_1.zip'
    saved_fname = download_file(url, fname, md5sum, True)
    with zipfile.ZipFile(saved_fname, 'r') as zip_ref:
        zip_ref.extractall(save_to_dir)
    return

# Cell
def get_all_images_in_subdirs(dirname):
    import os
    from PIL import Image
    fnames = []
    for path, subdirs, files in os.walk(dirname):
        for fname in files:
            fullpath = os.path.join(path,fname)
            try:
                im = Image.open(fullpath)
                fnames.append(fullpath)
            except:
                pass
    return sorted(fnames)
def get_aachen_db_images(path_to_aachen_root):
    import os
    return get_all_images_in_subdirs(os.path.join(path_to_aachen_root, 'images_upright/sequences'))
def get_aachen_query_images(path_to_aachen_root):
    import os
    return get_all_images_in_subdirs(os.path.join(path_to_aachen_root, 'images_upright/query'))

# Cell
import cv2
import torch
import os
class RetrievalDataset(torch.utils.data.Dataset):
    """Retrieval dataset."""

    def __init__(self, imglist, root_dir, transform=None):
        """
        Args:
            imglist (list): List of image paths
            root_dir (string): Path to the root directory if imglist is relative.
            transform (callable, optional): Optional transform to be applied
                on a sample.
        """
        self.imglist = imglist
        self.root_dir = root_dir
        self.transform = transform

    def __len__(self):
        return len(self.imglist)

    def __getitem__(self, idx):
        if torch.is_tensor(idx):
            idx = idx.tolist()
        img_name = os.path.join(self.root_dir,
                                self.imglist[idx])
        image = cv2.cvtColor(cv2.imread(img_name), cv2.COLOR_BGR2RGB)
        if self.transform:
            image = self.transform(image)
        return image