# -*- coding: utf-8 -*-
"""TesteAPI.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1jSRO4u7E_4kgOnXf5TQmvOTLcxT-rkpn
"""

# !pip install XaI-Ensemble-VOCs-API==0.3.7

# !pip install XaI-Ensemble-VOCs-API==0.3.7
from xaiensemble import ExplainableAPI, Run_methods
# import xaiensemble as xai_e
import os
"""# **LOAD DATA**"""

import tensorflow as tf
from keras.models import load_model
# Create an instance of the class
# Albicans = 1
# Glabrata = 2
# Haemulonii = 3
# Kodamaea_ohmeri = 4
# Krusei = 5
# Parapsilosis = 6
features_name = ["TGS-826","TGS-2611","TGS-2603","TGS-813","TGS-822","TGS-2602","TGS-823"]
class_names = ['Albicans', 'Glabrata', 'Haemulonii', 'Kodamaea_ohmeri', 'Krusei', 'Parapsilosis']
api = ExplainableAPI(features_name)
base_dir = os.path.dirname(__file__)
X_train, y_train = api.load_data(path=base_dir+"/src/AllCandidas_TRAIN.csv", sep=",")  # Replace with actual path and separator
X_test, y_test = api.load_data(path=base_dir+"/src/AllCandidas_TEST.csv", sep=",")  # Replace with actual path and separator
SAMPLE_INDEX = 8# amostra que será selecionada do df de teste
model = tf.keras.models.load_model(base_dir+'/src/best_model.hdf5')

main = Run_methods(api)
# df = api.group_sensor(features_name, X_test[SAMPLE_INDEX])

api.get_predicted_class(X_test[SAMPLE_INDEX], model)

data = api.get_samples_from_db(X_train, y_train,api.get_predicted_class(X_test[SAMPLE_INDEX], model))

current_read = api.group_sensor(features_name,X_train[SAMPLE_INDEX])
api.plot_chart_line_df(current_read)

api.plot_samples_db(data)

df_LIME, df_shap, df_GRAD, df_final, df_caounts = main.run_2_methods_mult(X_train, X_test[SAMPLE_INDEX], model, class_names,'conv1d_30', 4)

df_caounts

df_final

"""# **PLOTS AND MAPPING**"""

main.plot_all_bar_charts(df_LIME, df_shap, df_GRAD)

print(main.print_result(df_caounts, base_dir+"/src/MappingVOC_DB.db",api.QUERY_FUNGI, api.QUERY_SENSOR))

main.plot_bar_chart_all_methods(df_final)