# numbers-parser

*THIS IS A WORK IN PROGRESS*

Parsing of Numbers files is still something that is being debugged as the author unpicks the
data structures of the stored spreadsheets.

<a href="https://travis-ci.org/psobot/numbers-parser"><img src="https://travis-ci.com/psobot/numbers-parser.svg?branch=master" alt="build:" /></a>

`numbers-parser` is a Python module for parsing [Apple Numbers](https://www.apple.com/numbers/)
`.numbers` files. It supports Numbers files generated by Numbers version 10.3
(current as of February 2021).

Numbers uses a proprietary, compressed binary format to store its tables.
This format is comprised of a zip file containing images, as well as
[Snappy](https://github.com/google/snappy)-compressed
[Protobuf](https://github.com/protocolbuffers/protobuf) `.iwa` files containing
metadata, text, and all other definitions used in the spreadsheet.


## Updates

As `numbers-parser` includes private Protobuf definitions extracted from a copy of Numbers,
new versions of Numbers will inevitably create `.numbers` files that cannot be read by `numbers-parser`.
As new versions of Numbers are released, the following steps must be undertaken:

* Run [proto-dump](https://github.com/masaccio/proto-dump) on the new copy of Numbers to dump
  new Proto files.
  * proto-dump assumes version 2.5.0 of Google Protobuf  which may need changes to build on more
    modern OSes.  The version linked here is maintained by the author and tested on recent macOS
	for both arm64 and x86_64 architectures.
  * Any `.` characters in the Protobuf definitions must be changed to `_` characters manually, or via
    the `rename_proto_files.py` script in the `protos` directory of this repo.
* Connect to a running copy of `Numbers` with `lldb` (or any other debugger) and manually copy
  and reformat the results of `po [TSPRegistry sharedRegistry]` into `mapping.py`.
  * Versions of macOS >= 10.11 may protect Numbers from being attached to by a debugger -
    to attach, [temporarily disable System IntegrityProtection](https://developer.apple.com/documentation/security/disabling_and_enabling_system_integrity_protection)
    to get this data.
  * The `generate_mapping.py` script in `protos` should help turn the output from this step into a
    recreation of `mapping.py`

Running `make bootstrap` will perform all of these steps and generate the Python protos files as
well as `mapping.py`. The makefile assumes that [proto-dump](https://github.com/masaccio/proto-dump)
is in a repo parallel to this one, but the make variable `PROTO_DUMP` can be overridden to pass
the path to a working version of `proto-dump`.

## Credits

`numbers-parser` was built by [Jon Connell](http://github.com/masaccio) but derived enormously
from [prior work](https://github.com/psobot/keynote-parser) by [Peter Sobot](https://petersobot.com).
Both modules are derived from [previous work](https://github.com/obriensp/iWorkFileFormat/blob/master/Docs/index.md)
by [Sean Patrick O'Brien](http://www.obriensp.com).

Decoding the data structures inside Numbers files was helped greatly by
[previous work](https://github.com/slott56/Stingray-Reader) by [Steven Lott](https://github.com/slott56).

## License

All code in this repository is licensed under the MIT License.

```
Copyright 2021 Jon Connell
Copyright 2019-2020 Peter Sobot

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```
