# Generated by Django 2.0.4 on 2018-04-25 00:27

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("calaccess_processed_filings", "0003_auto_20180424_2300"),
    ]

    operations = [
        migrations.CreateModel(
            name="Form496Part1Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        help_text="First name of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_office_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the office sought sought by the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="candidate office code",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the ballot measure supported or opposed by the recipient (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_NAME)",
                        max_length=200,
                        verbose_name="Ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_number",
                    models.CharField(
                        blank=True,
                        help_text="Ballot measure number (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="Ballot measure number",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="Jurisdiction of the ballot measure supported or opposed by the recipient (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "support_opposition_code",
                    models.CharField(
                        blank=True,
                        choices=[("O", "Opposition"), ("S", "Support")],
                        help_text="Code describing whether the contribuitor supports or opposesthe candidate or ballot measure (from CVR_CAMPAIGN_DISCLOSURE_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support opposition code",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Unique identification number for the Schedule 496 filing (from S496_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="calaccess_processed_filings.Form496Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 496 (Late Independent Expenditure) Part 1 item",
            },
        ),
        migrations.CreateModel(
            name="Form496Part1ItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        help_text="First name of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_office_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the office sought sought by the candidate (from CVR_CAMPAIGN_DISCLOSURE_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="candidate office code",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the ballot measure supported or opposed by the recipient (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_NAME)",
                        max_length=200,
                        verbose_name="Ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_number",
                    models.CharField(
                        blank=True,
                        help_text="Ballot measure number (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="Ballot measure number",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="Jurisdiction of the ballot measure supported or opposed by the recipient (from CVR_CAMPAIGN_DISCLOSURE_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "support_opposition_code",
                    models.CharField(
                        blank=True,
                        choices=[("O", "Opposition"), ("S", "Support")],
                        help_text="Code describing whether the contribuitor supports or opposesthe candidate or ballot measure (from CVR_CAMPAIGN_DISCLOSURE_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support opposition code",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Schedule 496 that includes the received contribution",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="calaccess_processed_filings.Form496FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 496 (Late Independent Expenditure) Part 1 item version",
            },
        ),
    ]
