# This file has been autogenerated by the pywayland scanner

# Copyright 2021 Isaac Freund
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlOutput
from ..wayland import WlSurface
from .ext_session_lock_surface_v1 import ExtSessionLockSurfaceV1


class ExtSessionLockV1(Interface):
    """Manage lock state and create lock surfaces

    On creation of this object either the locked or finished event will
    immediately be sent.

    The locked event indicates that the session is locked. This means that the
    compositor should stop rendering and providing input to normal clients.
    Instead the compositor should blank all outputs with an opaque color such
    that their normal content is fully hidden.

    The only surfaces that should be rendered while the session is locked are
    the lock surfaces created through this interface and optionally, at the
    compositor's discretion, special privileged surfaces such as input methods
    or portions of desktop shell UIs.

    If the client dies while the session is locked, the compositor should not
    unlock the session in response. It is acceptable for the session to be
    permanently locked if this happens. The compositor may choose to continue
    to display the lock surfaces the client had mapped before it died or
    alternatively fall back to a solid color, this is compositor policy.

    Compositors may also allow a secure way to recover the session, the details
    of this are compositor policy. Compositors may allow a new client to create
    a :class:`ExtSessionLockV1` object and take responsibility for unlocking
    the session, they may even start a new lock client instance automatically.
    """

    name = "ext_session_lock_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_destroy = 0
        invalid_unlock = 1
        role = 2
        duplicate_output = 3
        already_constructed = 4


class ExtSessionLockV1Proxy(Proxy[ExtSessionLockV1]):
    interface = ExtSessionLockV1

    @ExtSessionLockV1.request()
    def destroy(self) -> None:
        """Destroy the session lock

        This informs the compositor that the lock object will no longer be
        used. Existing objects created through this interface remain valid.

        After this request is made, lock surfaces created through this object
        should be destroyed by the client as they will no longer be used by the
        compositor.

        It is a protocol error to make this request if the locked event was
        sent, the unlock_and_destroy request must be used instead.
        """
        self._marshal(0)
        self._destroy()

    @ExtSessionLockV1.request(
        Argument(ArgumentType.NewId, interface=ExtSessionLockSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def get_lock_surface(self, surface: WlSurface, output: WlOutput) -> Proxy[ExtSessionLockSurfaceV1]:
        """Create a lock surface for a given output

        The client is expected to create lock surfaces for all outputs
        currently present and any new outputs as they are advertised. These
        won't be displayed by the compositor unless the lock is successful and
        the locked event is sent.

        Providing a :class:`~pywayland.protocol.wayland.WlSurface` which
        already has a role or already has a buffer attached or committed is a
        protocol error, as is attaching/committing a buffer before the first
        :func:`ExtSessionLockSurfaceV1.configure()
        <pywayland.protocol.ext_session_lock_v1.ExtSessionLockSurfaceV1.configure>`
        event.

        Attempting to create more than one lock surface for a given output is a
        duplicate_output protocol error.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        :returns:
            :class:`~pywayland.protocol.ext_session_lock_v1.ExtSessionLockSurfaceV1`
        """
        id = self._marshal_constructor(1, ExtSessionLockSurfaceV1, surface, output)
        return id

    @ExtSessionLockV1.request()
    def unlock_and_destroy(self) -> None:
        """Unlock the session, destroying the object

        This request indicates that the session should be unlocked, for example
        because the user has entered their password and it has been verified by
        the client.

        This request also informs the compositor that the lock object will no
        longer be used and may be safely destroyed. Existing objects created
        through this interface remain valid.

        After this request is made, lock surfaces created through this object
        should be destroyed by the client as they will no longer be used by the
        compositor.

        It is a protocol error to make this request if the locked event has not
        been sent. In that case, the lock object may only be destroyed using
        the destroy request.
        """
        self._marshal(2)
        self._destroy()


class ExtSessionLockV1Resource(Resource):
    interface = ExtSessionLockV1

    @ExtSessionLockV1.event()
    def locked(self) -> None:
        """Session successfully locked

        This client is now responsible for displaying graphics while the
        session is locked and deciding when to unlock the session.

        Either this event or the finished event will be sent immediately on
        creation of this object.

        If this event is sent, making the destroy request is a protocol error,
        the lock object may only be destroyed using the unlock_and_destroy
        request.
        """
        self._post_event(0)

    @ExtSessionLockV1.event()
    def finished(self) -> None:
        """The session lock object should be destroyed

        The compositor has decided that the session lock should be destroyed.
        Exactly when this event is sent is compositor policy, but it will never
        be sent more than once for a given session lock object.

        This might be sent because there is already another
        :class:`ExtSessionLockV1` object held by a client, or the compositor
        has decided to deny the request to lock the session for some other
        reason. This might also be sent because the compositor implements some
        alternative, secure way to authenticate and unlock the session.

        Either this event or the locked event will be sent exactly once on
        creation of this object. If the locked event is sent on creation of
        this object, the finished event may still be sent at some later time in
        this object's lifetime, this is compositor policy.

        Upon receiving this event, the client should make either the destroy
        request or the unlock_and_destroy request, depending on whether or not
        the locked event was received on this object.
        """
        self._post_event(1)


class ExtSessionLockV1Global(Global):
    interface = ExtSessionLockV1


ExtSessionLockV1._gen_c()
ExtSessionLockV1.proxy_class = ExtSessionLockV1Proxy
ExtSessionLockV1.resource_class = ExtSessionLockV1Resource
ExtSessionLockV1.global_class = ExtSessionLockV1Global
