"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import frogml_proto.qwak.builds.build_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BuildStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BuildStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BuildStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _BuildStatus.ValueType  # 0
    """An invalid state build status, the default if unset"""
    IN_PROGRESS: _BuildStatus.ValueType  # 1
    """Build is in progress"""
    SUCCESSFUL: _BuildStatus.ValueType  # 2
    """Build is successful"""
    FAILED: _BuildStatus.ValueType  # 3
    """Build failed"""
    REMOTE_BUILD_INITIALIZING: _BuildStatus.ValueType  # 4
    """Remote build is initializing"""
    REMOTE_BUILD_CANCELLED: _BuildStatus.ValueType  # 5
    """Remote build status is cancelled"""
    REMOTE_BUILD_TIMED_OUT: _BuildStatus.ValueType  # 6
    """Remote build status is timed out"""
    REMOTE_BUILD_UNKNOWN: _BuildStatus.ValueType  # 7
    """Remote build is unknown"""
    SYNCING_ENVIRONMENTS: _BuildStatus.ValueType  # 8
    """Build image is syncing between environments"""
    FINISHED_SYNCING: _BuildStatus.ValueType  # 9
    """Build artifact is synced and ready"""
    BUILD_REQUESTED: _BuildStatus.ValueType  # 10
    """Initiate Build Event Was Sent In Internal Queue"""
    BUILD_PENDING: _BuildStatus.ValueType  # 11
    """Build Creation Request Was Sent to Admiral"""
    FAILED_INITIATING_BUILD: _BuildStatus.ValueType  # 12
    """Build Creation Request to Admiral Failed"""

class BuildStatus(_BuildStatus, metaclass=_BuildStatusEnumTypeWrapper): ...

INVALID: BuildStatus.ValueType  # 0
"""An invalid state build status, the default if unset"""
IN_PROGRESS: BuildStatus.ValueType  # 1
"""Build is in progress"""
SUCCESSFUL: BuildStatus.ValueType  # 2
"""Build is successful"""
FAILED: BuildStatus.ValueType  # 3
"""Build failed"""
REMOTE_BUILD_INITIALIZING: BuildStatus.ValueType  # 4
"""Remote build is initializing"""
REMOTE_BUILD_CANCELLED: BuildStatus.ValueType  # 5
"""Remote build status is cancelled"""
REMOTE_BUILD_TIMED_OUT: BuildStatus.ValueType  # 6
"""Remote build status is timed out"""
REMOTE_BUILD_UNKNOWN: BuildStatus.ValueType  # 7
"""Remote build is unknown"""
SYNCING_ENVIRONMENTS: BuildStatus.ValueType  # 8
"""Build image is syncing between environments"""
FINISHED_SYNCING: BuildStatus.ValueType  # 9
"""Build artifact is synced and ready"""
BUILD_REQUESTED: BuildStatus.ValueType  # 10
"""Initiate Build Event Was Sent In Internal Queue"""
BUILD_PENDING: BuildStatus.ValueType  # 11
"""Build Creation Request Was Sent to Admiral"""
FAILED_INITIATING_BUILD: BuildStatus.ValueType  # 12
"""Build Creation Request to Admiral Failed"""
global___BuildStatus = BuildStatus

class _MetricOperatorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetricOperatorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetricOperatorType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METRIC_OPERATOR_TYPE_INVALID: _MetricOperatorType.ValueType  # 0
    METRIC_OPERATOR_TYPE_EQUALS: _MetricOperatorType.ValueType  # 1
    METRIC_OPERATOR_TYPE_NOT_EQUALS: _MetricOperatorType.ValueType  # 2
    METRIC_OPERATOR_TYPE_LESS_THAN: _MetricOperatorType.ValueType  # 3
    METRIC_OPERATOR_TYPE_LESS_THAN_EQUALS: _MetricOperatorType.ValueType  # 4
    METRIC_OPERATOR_TYPE_GREATER_THAN: _MetricOperatorType.ValueType  # 5
    METRIC_OPERATOR_TYPE_GREATER_THAN_EQUALS: _MetricOperatorType.ValueType  # 6

class MetricOperatorType(_MetricOperatorType, metaclass=_MetricOperatorTypeEnumTypeWrapper): ...

METRIC_OPERATOR_TYPE_INVALID: MetricOperatorType.ValueType  # 0
METRIC_OPERATOR_TYPE_EQUALS: MetricOperatorType.ValueType  # 1
METRIC_OPERATOR_TYPE_NOT_EQUALS: MetricOperatorType.ValueType  # 2
METRIC_OPERATOR_TYPE_LESS_THAN: MetricOperatorType.ValueType  # 3
METRIC_OPERATOR_TYPE_LESS_THAN_EQUALS: MetricOperatorType.ValueType  # 4
METRIC_OPERATOR_TYPE_GREATER_THAN: MetricOperatorType.ValueType  # 5
METRIC_OPERATOR_TYPE_GREATER_THAN_EQUALS: MetricOperatorType.ValueType  # 6
global___MetricOperatorType = MetricOperatorType

class _ParameterOperatorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ParameterOperatorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ParameterOperatorType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PARAMETER_OPERATOR_TYPE_INVALID: _ParameterOperatorType.ValueType  # 0
    PARAMETER_OPERATOR_TYPE_EQUALS: _ParameterOperatorType.ValueType  # 1
    PARAMETER_OPERATOR_TYPE_NOT_EQUALS: _ParameterOperatorType.ValueType  # 2

class ParameterOperatorType(_ParameterOperatorType, metaclass=_ParameterOperatorTypeEnumTypeWrapper): ...

PARAMETER_OPERATOR_TYPE_INVALID: ParameterOperatorType.ValueType  # 0
PARAMETER_OPERATOR_TYPE_EQUALS: ParameterOperatorType.ValueType  # 1
PARAMETER_OPERATOR_TYPE_NOT_EQUALS: ParameterOperatorType.ValueType  # 2
global___ParameterOperatorType = ParameterOperatorType

class ModelSchema(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITIES_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    PREDICTIONS_FIELD_NUMBER: builtins.int
    INFERENCE_OUTPUT_FIELD_NUMBER: builtins.int
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Entity]:
        """list of model entities"""
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Feature]:
        """list of model features (Explicit / Batch / OnTheFly)"""
    @property
    def predictions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Prediction]:
        """List of model predictions (Model output)"""
    @property
    def inference_output(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InferenceOutput]:
        """List of model predictions (Model output)"""
    def __init__(
        self,
        *,
        entities: collections.abc.Iterable[global___Entity] | None = ...,
        features: collections.abc.Iterable[global___Feature] | None = ...,
        predictions: collections.abc.Iterable[global___Prediction] | None = ...,
        inference_output: collections.abc.Iterable[global___InferenceOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entities", b"entities", "features", b"features", "inference_output", b"inference_output", "predictions", b"predictions"]) -> None: ...

global___ModelSchema = ModelSchema

class Entity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Entity name"""
    @property
    def type(self) -> global___ValueType:
        """Entity type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___Entity = Entity

class Feature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATCH_FEATURE_FIELD_NUMBER: builtins.int
    EXPLICIT_FEATURE_FIELD_NUMBER: builtins.int
    ON_THE_FLY_FEATURE_FIELD_NUMBER: builtins.int
    STREAMING_FEATURE_FIELD_NUMBER: builtins.int
    REQUEST_INPUT_FIELD_NUMBER: builtins.int
    STREAMING_AGGREGATION_FEATURE_FIELD_NUMBER: builtins.int
    BATCH_FEATURE_V1_FIELD_NUMBER: builtins.int
    STREAMING_FEATURE_V1_FIELD_NUMBER: builtins.int
    @property
    def batch_feature(self) -> global___BatchFeature: ...
    @property
    def explicit_feature(self) -> global___ExplicitFeature: ...
    @property
    def on_the_fly_feature(self) -> global___OnTheFlyFeature: ...
    @property
    def streaming_feature(self) -> global___StreamingFeature: ...
    @property
    def request_input(self) -> global___RequestInput: ...
    @property
    def streaming_aggregation_feature(self) -> global___StreamingAggregationFeature: ...
    @property
    def batch_feature_v1(self) -> global___BatchFeatureV1: ...
    @property
    def streaming_feature_v1(self) -> global___StreamingFeatureV1: ...
    def __init__(
        self,
        *,
        batch_feature: global___BatchFeature | None = ...,
        explicit_feature: global___ExplicitFeature | None = ...,
        on_the_fly_feature: global___OnTheFlyFeature | None = ...,
        streaming_feature: global___StreamingFeature | None = ...,
        request_input: global___RequestInput | None = ...,
        streaming_aggregation_feature: global___StreamingAggregationFeature | None = ...,
        batch_feature_v1: global___BatchFeatureV1 | None = ...,
        streaming_feature_v1: global___StreamingFeatureV1 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_feature", b"batch_feature", "batch_feature_v1", b"batch_feature_v1", "explicit_feature", b"explicit_feature", "on_the_fly_feature", b"on_the_fly_feature", "request_input", b"request_input", "streaming_aggregation_feature", b"streaming_aggregation_feature", "streaming_feature", b"streaming_feature", "streaming_feature_v1", b"streaming_feature_v1", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_feature", b"batch_feature", "batch_feature_v1", b"batch_feature_v1", "explicit_feature", b"explicit_feature", "on_the_fly_feature", b"on_the_fly_feature", "request_input", b"request_input", "streaming_aggregation_feature", b"streaming_aggregation_feature", "streaming_feature", b"streaming_feature", "streaming_feature_v1", b"streaming_feature_v1", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["batch_feature", "explicit_feature", "on_the_fly_feature", "streaming_feature", "request_input", "streaming_aggregation_feature", "batch_feature_v1", "streaming_feature_v1"] | None: ...

global___Feature = Feature

class OnTheFlyFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SOURCE_FEATURES_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    @property
    def source_features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceFeature]:
        """The source feature on the fly build on"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
        source_features: collections.abc.Iterable[global___SourceFeature] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name", "source_features", b"source_features"]) -> None: ...

global___OnTheFlyFeature = OnTheFlyFeature

class BatchFeatureV1(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___BatchFeatureV1 = BatchFeatureV1

class StreamingFeatureV1(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingFeatureV1 = StreamingFeatureV1

class BatchFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___BatchFeature = BatchFeature

class StreamingFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingFeature = StreamingFeature

class StreamingAggregationFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingAggregationFeature = StreamingAggregationFeature

class ExplicitFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Feature name"""
    @property
    def type(self) -> global___ValueType:
        """Feature type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___ExplicitFeature = ExplicitFeature

class RequestInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Feature name"""
    @property
    def type(self) -> global___ValueType:
        """Feature type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___RequestInput = RequestInput

class SourceFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPLICIT_FEATURE_FIELD_NUMBER: builtins.int
    REQUEST_INPUT_FIELD_NUMBER: builtins.int
    @property
    def explicit_feature(self) -> global___ExplicitFeature: ...
    @property
    def request_input(self) -> global___RequestInput: ...
    def __init__(
        self,
        *,
        explicit_feature: global___ExplicitFeature | None = ...,
        request_input: global___RequestInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["explicit_feature", b"explicit_feature", "request_input", b"request_input", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["explicit_feature", b"explicit_feature", "request_input", b"request_input", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["explicit_feature", "request_input"] | None: ...

global___SourceFeature = SourceFeature

class Prediction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Prediction name"""
    @property
    def type(self) -> global___ValueType:
        """Prediction type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___Prediction = Prediction

class InferenceOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Prediction name"""
    @property
    def type(self) -> global___ValueType:
        """Prediction type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___InferenceOutput = InferenceOutput

class ValueType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Types:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ValueType._Types.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: ValueType._Types.ValueType  # 0
        BYTES: ValueType._Types.ValueType  # 1
        STRING: ValueType._Types.ValueType  # 2
        INT32: ValueType._Types.ValueType  # 3
        INT64: ValueType._Types.ValueType  # 4
        DOUBLE: ValueType._Types.ValueType  # 5
        FLOAT: ValueType._Types.ValueType  # 6
        BOOL: ValueType._Types.ValueType  # 7

    class Types(_Types, metaclass=_TypesEnumTypeWrapper): ...
    INVALID: ValueType.Types.ValueType  # 0
    BYTES: ValueType.Types.ValueType  # 1
    STRING: ValueType.Types.ValueType  # 2
    INT32: ValueType.Types.ValueType  # 3
    INT64: ValueType.Types.ValueType  # 4
    DOUBLE: ValueType.Types.ValueType  # 5
    FLOAT: ValueType.Types.ValueType  # 6
    BOOL: ValueType.Types.ValueType  # 7

    TYPE_FIELD_NUMBER: builtins.int
    type: global___ValueType.Types.ValueType
    def __init__(
        self,
        *,
        type: global___ValueType.Types.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type", b"type"]) -> None: ...

global___ValueType = ValueType

class ParameterCategory(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Category:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CategoryEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ParameterCategory._Category.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: ParameterCategory._Category.ValueType  # 0
        """An invalid parameter type, the default if unset"""
        ENTITY: ParameterCategory._Category.ValueType  # 1
        """Entity parameter"""
        FEATURE: ParameterCategory._Category.ValueType  # 2
        """Feature parameter"""
        PREDICTION: ParameterCategory._Category.ValueType  # 3
        """Prediction parameter"""
        INFERENCEOUTPUT: ParameterCategory._Category.ValueType  # 4
        """New Prediction parameter"""

    class Category(_Category, metaclass=_CategoryEnumTypeWrapper): ...
    INVALID: ParameterCategory.Category.ValueType  # 0
    """An invalid parameter type, the default if unset"""
    ENTITY: ParameterCategory.Category.ValueType  # 1
    """Entity parameter"""
    FEATURE: ParameterCategory.Category.ValueType  # 2
    """Feature parameter"""
    PREDICTION: ParameterCategory.Category.ValueType  # 3
    """Prediction parameter"""
    INFERENCEOUTPUT: ParameterCategory.Category.ValueType  # 4
    """New Prediction parameter"""

    def __init__(
        self,
    ) -> None: ...

global___ParameterCategory = ParameterCategory

class Build(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ParamsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class MetricsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.float
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    BUILDID_FIELD_NUMBER: builtins.int
    COMMITID_FIELD_NUMBER: builtins.int
    BRANCHID_FIELD_NUMBER: builtins.int
    BUILDCONFIG_FIELD_NUMBER: builtins.int
    BUILD_STATUS_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    STEPS_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    MODEL_SCHEMA_FIELD_NUMBER: builtins.int
    AUDIT_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    SDK_VERSION_FIELD_NUMBER: builtins.int
    IMAGE_NAME_TAG_FIELD_NUMBER: builtins.int
    BUILD_CONFIGURATION_MESSAGE_FIELD_NUMBER: builtins.int
    END_DATE_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    BUILD_DESTINED_IMAGE_FIELD_NUMBER: builtins.int
    FRAMEWORK_MODELS_FIELD_NUMBER: builtins.int
    BUILD_DESTINED_IMAGE_PULL_SECRET_FIELD_NUMBER: builtins.int
    FAILURE_REASON_CODE_FIELD_NUMBER: builtins.int
    BUILD_NAME_FIELD_NUMBER: builtins.int
    BUILD_VERSION_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    buildId: builtins.str
    commitId: builtins.str
    branchId: builtins.str
    buildConfig: builtins.str
    build_status: global___BuildStatus.ValueType
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def steps(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def params(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def metrics(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.float]: ...
    @property
    def model_schema(self) -> global___ModelSchema: ...
    @property
    def audit(self) -> global___Audit: ...
    model_uuid: builtins.str
    sdk_version: builtins.str
    image_name_tag: builtins.str
    @property
    def build_configuration_message(self) -> global___BuildConfiguration: ...
    @property
    def end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End date of build"""
    environment_id: builtins.str
    build_destined_image: builtins.str
    @property
    def framework_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FrameworkModel]: ...
    build_destined_image_pull_secret: builtins.str
    """The name of pull secret if needed"""
    failure_reason_code: builtins.str
    """Failure reason code if we recognize it."""
    build_name: builtins.str
    build_version: builtins.int
    duration: builtins.int
    model_version_id: builtins.str
    def __init__(
        self,
        *,
        buildId: builtins.str = ...,
        commitId: builtins.str = ...,
        branchId: builtins.str = ...,
        buildConfig: builtins.str = ...,
        build_status: global___BuildStatus.ValueType = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        steps: collections.abc.Iterable[builtins.str] | None = ...,
        params: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        metrics: collections.abc.Mapping[builtins.str, builtins.float] | None = ...,
        model_schema: global___ModelSchema | None = ...,
        audit: global___Audit | None = ...,
        model_uuid: builtins.str = ...,
        sdk_version: builtins.str = ...,
        image_name_tag: builtins.str = ...,
        build_configuration_message: global___BuildConfiguration | None = ...,
        end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        environment_id: builtins.str = ...,
        build_destined_image: builtins.str = ...,
        framework_models: collections.abc.Iterable[global___FrameworkModel] | None = ...,
        build_destined_image_pull_secret: builtins.str = ...,
        failure_reason_code: builtins.str = ...,
        build_name: builtins.str = ...,
        build_version: builtins.int = ...,
        duration: builtins.int = ...,
        model_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["audit", b"audit", "build_configuration_message", b"build_configuration_message", "end_date", b"end_date", "model_schema", b"model_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audit", b"audit", "branchId", b"branchId", "buildConfig", b"buildConfig", "buildId", b"buildId", "build_configuration_message", b"build_configuration_message", "build_destined_image", b"build_destined_image", "build_destined_image_pull_secret", b"build_destined_image_pull_secret", "build_name", b"build_name", "build_status", b"build_status", "build_version", b"build_version", "commitId", b"commitId", "duration", b"duration", "end_date", b"end_date", "environment_id", b"environment_id", "failure_reason_code", b"failure_reason_code", "framework_models", b"framework_models", "image_name_tag", b"image_name_tag", "metrics", b"metrics", "model_schema", b"model_schema", "model_uuid", b"model_uuid", "model_version_id", b"model_version_id", "params", b"params", "sdk_version", b"sdk_version", "steps", b"steps", "tags", b"tags"]) -> None: ...

global___Build = Build

class Audit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_BY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_BY_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    created_by: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    last_modified_by: builtins.str
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        created_by: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_by: builtins.str = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "last_modified_at", b"last_modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "last_modified_at", b"last_modified_at", "last_modified_by", b"last_modified_by"]) -> None: ...

global___Audit = Audit

class BuildConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_PROPERTIES_FIELD_NUMBER: builtins.int
    BUILD_ENV_FIELD_NUMBER: builtins.int
    PRE_BUILD_FIELD_NUMBER: builtins.int
    POST_BUILD_FIELD_NUMBER: builtins.int
    STEP_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    @property
    def build_properties(self) -> global___BuildProperties: ...
    @property
    def build_env(self) -> global___BuildEnvironment: ...
    @property
    def pre_build(self) -> global___BuildEnvironment: ...
    @property
    def post_build(self) -> global___BuildEnvironment: ...
    @property
    def step(self) -> global___Step: ...
    verbose: builtins.int
    def __init__(
        self,
        *,
        build_properties: global___BuildProperties | None = ...,
        build_env: global___BuildEnvironment | None = ...,
        pre_build: global___BuildEnvironment | None = ...,
        post_build: global___BuildEnvironment | None = ...,
        step: global___Step | None = ...,
        verbose: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_env", b"build_env", "build_properties", b"build_properties", "post_build", b"post_build", "pre_build", b"pre_build", "step", b"step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_env", b"build_env", "build_properties", b"build_properties", "post_build", b"post_build", "pre_build", b"pre_build", "step", b"step", "verbose", b"verbose"]) -> None: ...

global___BuildConfiguration = BuildConfiguration

class BuildProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_URI_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    ENVIRONMENT_NAME_FIELD_NUMBER: builtins.int
    GPU_COMPATIBLE_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    @property
    def model_uri(self) -> global___BuildModelUri: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    build_id: builtins.str
    branch: builtins.str
    environment_name: builtins.str
    gpu_compatible: builtins.bool
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        model_uri: global___BuildModelUri | None = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        build_id: builtins.str = ...,
        branch: builtins.str = ...,
        environment_name: builtins.str = ...,
        gpu_compatible: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model_uri", b"model_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "build_id", b"build_id", "environment_name", b"environment_name", "gpu_compatible", b"gpu_compatible", "model_id", b"model_id", "model_uri", b"model_uri", "tags", b"tags"]) -> None: ...

global___BuildProperties = BuildProperties

class BuildModelUri(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URI_FIELD_NUMBER: builtins.int
    GIT_BRANCH_FIELD_NUMBER: builtins.int
    MAIN_DIR_FIELD_NUMBER: builtins.int
    DEPENDENCY_REQUIRED_FOLDERS_FIELD_NUMBER: builtins.int
    uri: builtins.str
    git_branch: builtins.str
    main_dir: builtins.str
    @property
    def dependency_required_folders(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        uri: builtins.str = ...,
        git_branch: builtins.str = ...,
        main_dir: builtins.str = ...,
        dependency_required_folders: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dependency_required_folders", b"dependency_required_folders", "git_branch", b"git_branch", "main_dir", b"main_dir", "uri", b"uri"]) -> None: ...

global___BuildModelUri = BuildModelUri

class BuildEnvironment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOCKER_FIELD_NUMBER: builtins.int
    LOCAL_FIELD_NUMBER: builtins.int
    PYTHON_ENV_FIELD_NUMBER: builtins.int
    REMOTE_FIELD_NUMBER: builtins.int
    @property
    def docker(self) -> global___DockerBuild: ...
    @property
    def local(self) -> global___LocalBuild: ...
    @property
    def python_env(self) -> global___PythonBuild: ...
    @property
    def remote(self) -> global___RemoteBuild: ...
    def __init__(
        self,
        *,
        docker: global___DockerBuild | None = ...,
        local: global___LocalBuild | None = ...,
        python_env: global___PythonBuild | None = ...,
        remote: global___RemoteBuild | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["docker", b"docker", "local", b"local", "python_env", b"python_env", "remote", b"remote"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["docker", b"docker", "local", b"local", "python_env", b"python_env", "remote", b"remote"]) -> None: ...

global___BuildEnvironment = BuildEnvironment

class DockerBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class BuildArgsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    BASE_IMAGE_FIELD_NUMBER: builtins.int
    BUILD_ARGS_FIELD_NUMBER: builtins.int
    ENV_VARS_FIELD_NUMBER: builtins.int
    NO_CACHE_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    ASSUMED_IAM_ROLE_ARN_FIELD_NUMBER: builtins.int
    CACHE_FIELD_NUMBER: builtins.int
    PUSH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_KEY_SECRET_NAME_FIELD_NUMBER: builtins.int
    base_image: builtins.str
    @property
    def build_args(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def env_vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    no_cache: builtins.bool
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    assumed_iam_role_arn: builtins.str
    cache: builtins.bool
    push: builtins.bool
    service_account_key_secret_name: builtins.str
    def __init__(
        self,
        *,
        base_image: builtins.str = ...,
        build_args: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        env_vars: collections.abc.Iterable[builtins.str] | None = ...,
        no_cache: builtins.bool = ...,
        params: collections.abc.Iterable[builtins.str] | None = ...,
        assumed_iam_role_arn: builtins.str = ...,
        cache: builtins.bool = ...,
        push: builtins.bool = ...,
        service_account_key_secret_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["assumed_iam_role_arn", b"assumed_iam_role_arn", "base_image", b"base_image", "build_args", b"build_args", "cache", b"cache", "env_vars", b"env_vars", "no_cache", b"no_cache", "params", b"params", "push", b"push", "service_account_key_secret_name", b"service_account_key_secret_name"]) -> None: ...

global___DockerBuild = DockerBuild

class LocalBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AWS_PROFILE_FIELD_NUMBER: builtins.int
    NO_PUSH_FIELD_NUMBER: builtins.int
    aws_profile: builtins.str
    no_push: builtins.bool
    def __init__(
        self,
        *,
        aws_profile: builtins.str = ...,
        no_push: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["aws_profile", b"aws_profile", "no_push", b"no_push"]) -> None: ...

global___LocalBuild = LocalBuild

class PythonBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QWAK_SDK_EXTRA_INDEX_URL_FIELD_NUMBER: builtins.int
    VIRTUALENV_FIELD_NUMBER: builtins.int
    CONDA_FIELD_NUMBER: builtins.int
    POETRY_FIELD_NUMBER: builtins.int
    DEPENDENCY_FILE_PATH_FIELD_NUMBER: builtins.int
    USE_DEPRECATED_RESOLVER_FIELD_NUMBER: builtins.int
    qwak_sdk_extra_index_url: builtins.str
    @property
    def virtualenv(self) -> global___VirtualEnvironmentBuild: ...
    @property
    def conda(self) -> global___CondaBuild: ...
    @property
    def poetry(self) -> global___PoetryBuild: ...
    dependency_file_path: builtins.str
    use_deprecated_resolver: builtins.bool
    def __init__(
        self,
        *,
        qwak_sdk_extra_index_url: builtins.str = ...,
        virtualenv: global___VirtualEnvironmentBuild | None = ...,
        conda: global___CondaBuild | None = ...,
        poetry: global___PoetryBuild | None = ...,
        dependency_file_path: builtins.str = ...,
        use_deprecated_resolver: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["conda", b"conda", "poetry", b"poetry", "virtualenv", b"virtualenv"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conda", b"conda", "dependency_file_path", b"dependency_file_path", "poetry", b"poetry", "qwak_sdk_extra_index_url", b"qwak_sdk_extra_index_url", "use_deprecated_resolver", b"use_deprecated_resolver", "virtualenv", b"virtualenv"]) -> None: ...

global___PythonBuild = PythonBuild

class CondaBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDA_FILE_FIELD_NUMBER: builtins.int
    conda_file: builtins.str
    def __init__(
        self,
        *,
        conda_file: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["conda_file", b"conda_file"]) -> None: ...

global___CondaBuild = CondaBuild

class PoetryBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    LOCK_FILE_FIELD_NUMBER: builtins.int
    python_version: builtins.str
    lock_file: builtins.str
    def __init__(
        self,
        *,
        python_version: builtins.str = ...,
        lock_file: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["lock_file", b"lock_file", "python_version", b"python_version"]) -> None: ...

global___PoetryBuild = PoetryBuild

class VirtualEnvironmentBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    REQUIREMENTS_TXT_FIELD_NUMBER: builtins.int
    python_version: builtins.str
    requirements_txt: builtins.str
    def __init__(
        self,
        *,
        python_version: builtins.str = ...,
        requirements_txt: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["python_version", b"python_version", "requirements_txt", b"requirements_txt"]) -> None: ...

global___VirtualEnvironmentBuild = VirtualEnvironmentBuild

class RemoteBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_REMOTE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    is_remote: builtins.bool
    @property
    def resources(self) -> global___RemoteBuildResources: ...
    def __init__(
        self,
        *,
        is_remote: builtins.bool = ...,
        resources: global___RemoteBuildResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_remote", b"is_remote", "resources", b"resources"]) -> None: ...

global___RemoteBuild = RemoteBuild

class RemoteBuildResources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPUS_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    GPU_TYPE_FIELD_NUMBER: builtins.int
    GPU_AMOUNT_FIELD_NUMBER: builtins.int
    INSTANCE_FIELD_NUMBER: builtins.int
    cpus: builtins.float
    memory: builtins.str
    gpu_type: frogml_proto.qwak.builds.build_pb2.GpuType.ValueType
    gpu_amount: builtins.int
    instance: builtins.str
    def __init__(
        self,
        *,
        cpus: builtins.float = ...,
        memory: builtins.str = ...,
        gpu_type: frogml_proto.qwak.builds.build_pb2.GpuType.ValueType = ...,
        gpu_amount: builtins.int = ...,
        instance: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpus", b"cpus", "gpu_amount", b"gpu_amount", "gpu_type", b"gpu_type", "instance", b"instance", "memory", b"memory"]) -> None: ...

global___RemoteBuildResources = RemoteBuildResources

class Step(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TESTS_FIELD_NUMBER: builtins.int
    VALIDATE_BUILD_ARTIFACT_FIELD_NUMBER: builtins.int
    VALIDATE_BUILD_ARTIFACT_TIMEOUT_FIELD_NUMBER: builtins.int
    tests: builtins.bool
    validate_build_artifact: builtins.bool
    validate_build_artifact_timeout: builtins.int
    def __init__(
        self,
        *,
        tests: builtins.bool = ...,
        validate_build_artifact: builtins.bool = ...,
        validate_build_artifact_timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tests", b"tests", "validate_build_artifact", b"validate_build_artifact", "validate_build_artifact_timeout", b"validate_build_artifact_timeout"]) -> None: ...

global___Step = Step

class BuildFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    METRIC_FILTERS_FIELD_NUMBER: builtins.int
    PARAMETER_FILTERS_FIELD_NUMBER: builtins.int
    REQUIRE_ALL_TAGS_FIELD_NUMBER: builtins.int
    INCLUDE_EXTRA_TAGS_FIELD_NUMBER: builtins.int
    BUILD_IDS_FIELD_NUMBER: builtins.int
    MODEL_VERSION_IDS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def metric_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetricFilter]: ...
    @property
    def parameter_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ParameterFilter]: ...
    require_all_tags: builtins.bool
    include_extra_tags: builtins.bool
    @property
    def build_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def model_version_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        metric_filters: collections.abc.Iterable[global___MetricFilter] | None = ...,
        parameter_filters: collections.abc.Iterable[global___ParameterFilter] | None = ...,
        require_all_tags: builtins.bool = ...,
        include_extra_tags: builtins.bool = ...,
        build_ids: collections.abc.Iterable[builtins.str] | None = ...,
        model_version_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_ids", b"build_ids", "include_extra_tags", b"include_extra_tags", "metric_filters", b"metric_filters", "model_version_ids", b"model_version_ids", "parameter_filters", b"parameter_filters", "require_all_tags", b"require_all_tags", "tags", b"tags"]) -> None: ...

global___BuildFilter = BuildFilter

class MetricFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRIC_NAME_FIELD_NUMBER: builtins.int
    METRIC_VALUE_FIELD_NUMBER: builtins.int
    OPERATOR_FIELD_NUMBER: builtins.int
    metric_name: builtins.str
    metric_value: builtins.float
    operator: global___MetricOperatorType.ValueType
    def __init__(
        self,
        *,
        metric_name: builtins.str = ...,
        metric_value: builtins.float = ...,
        operator: global___MetricOperatorType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metric_name", b"metric_name", "metric_value", b"metric_value", "operator", b"operator"]) -> None: ...

global___MetricFilter = MetricFilter

class ParameterFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMETER_NAME_FIELD_NUMBER: builtins.int
    PARAMETER_VALUE_FIELD_NUMBER: builtins.int
    OPERATOR_FIELD_NUMBER: builtins.int
    parameter_name: builtins.str
    parameter_value: builtins.str
    operator: global___ParameterOperatorType.ValueType
    def __init__(
        self,
        *,
        parameter_name: builtins.str = ...,
        parameter_value: builtins.str = ...,
        operator: global___ParameterOperatorType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["operator", b"operator", "parameter_name", b"parameter_name", "parameter_value", b"parameter_value"]) -> None: ...

global___ParameterFilter = ParameterFilter

class FrameworkModelsSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    FRAMEWORK_MODELS_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    @property
    def framework_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FrameworkModel]: ...
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        framework_models: collections.abc.Iterable[global___FrameworkModel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "framework_models", b"framework_models"]) -> None: ...

global___FrameworkModelsSpec = FrameworkModelsSpec

class FrameworkModel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HUGGINGFACE_MODEL_SPEC_FIELD_NUMBER: builtins.int
    @property
    def huggingface_model_spec(self) -> global___HuggingFaceModelSpec: ...
    def __init__(
        self,
        *,
        huggingface_model_spec: global___HuggingFaceModelSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["huggingface_model_spec", b"huggingface_model_spec", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["huggingface_model_spec", b"huggingface_model_spec", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["huggingface_model_spec"] | None: ...

global___FrameworkModel = FrameworkModel

class HuggingFaceModelSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    REPOSITORY_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    SHA1_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the model"""
    repository: builtins.str
    """The repository of"""
    model_name: builtins.str
    """model name"""
    sha1: builtins.str
    """The sha of the model"""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        repository: builtins.str = ...,
        model_name: builtins.str = ...,
        sha1: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_name", b"model_name", "repository", b"repository", "sha1", b"sha1", "version", b"version"]) -> None: ...

global___HuggingFaceModelSpec = HuggingFaceModelSpec

class ScanResultSummary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISSUES_FIELD_NUMBER: builtins.int
    UI_DIRECT_LINK_FIELD_NUMBER: builtins.int
    UI_SCAN_DIRECT_LINK_FIELD_NUMBER: builtins.int
    @property
    def issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Issue]:
        """List of issues"""
    ui_direct_link: builtins.str
    """Ui link scan result"""
    ui_scan_direct_link: builtins.str
    """direct scan link"""
    def __init__(
        self,
        *,
        issues: collections.abc.Iterable[global___Issue] | None = ...,
        ui_direct_link: builtins.str = ...,
        ui_scan_direct_link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["issues", b"issues", "ui_direct_link", b"ui_direct_link", "ui_scan_direct_link", b"ui_scan_direct_link"]) -> None: ...

global___ScanResultSummary = ScanResultSummary

class Issue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SEVERITY_FIELD_NUMBER: builtins.int
    ISSUE_TYPE_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the issue"""
    severity: builtins.str
    """The severity of the issue"""
    issue_type: builtins.str
    """The issue type"""
    summary: builtins.str
    """The summary"""
    description: builtins.str
    """The description"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        severity: builtins.str = ...,
        issue_type: builtins.str = ...,
        summary: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "issue_type", b"issue_type", "name", b"name", "severity", b"severity", "summary", b"summary"]) -> None: ...

global___Issue = Issue

class BuildImageDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FULL_PATH_FIELD_NUMBER: builtins.int
    IMAGE_PULL_SECRET_NAME_FIELD_NUMBER: builtins.int
    image_full_path: builtins.str
    image_pull_secret_name: builtins.str
    def __init__(
        self,
        *,
        image_full_path: builtins.str = ...,
        image_pull_secret_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["image_full_path", b"image_full_path", "image_pull_secret_name", b"image_pull_secret_name"]) -> None: ...

global___BuildImageDetails = BuildImageDetails

class ScanRequestType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCAN_SOFTWARE_COMPONENTS_REQUEST_FIELD_NUMBER: builtins.int
    SCAN_VULNERABILITIES_REQUEST_FIELD_NUMBER: builtins.int
    SCAN_MALICIOUS_PACKAGES_REQUEST_FIELD_NUMBER: builtins.int
    SCAN_POLICY_VIOLATIONS_REQUEST_FIELD_NUMBER: builtins.int
    SCAN_STATUS_REQUEST_FIELD_NUMBER: builtins.int
    SCAN_FEATURE_STATE_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def scan_software_components_request(self) -> global___ScanSoftwareComponentsRequest: ...
    @property
    def scan_vulnerabilities_request(self) -> global___ScanVulnerabilitiesRequest: ...
    @property
    def scan_malicious_packages_request(self) -> global___ScanMaliciousPackagesRequest: ...
    @property
    def scan_policy_violations_request(self) -> global___ScanPolicyViolationsRequest: ...
    @property
    def scan_status_request(self) -> global___ScanStatusRequest: ...
    @property
    def scan_feature_state_request(self) -> global___ScanFeatureStateRequest: ...
    def __init__(
        self,
        *,
        scan_software_components_request: global___ScanSoftwareComponentsRequest | None = ...,
        scan_vulnerabilities_request: global___ScanVulnerabilitiesRequest | None = ...,
        scan_malicious_packages_request: global___ScanMaliciousPackagesRequest | None = ...,
        scan_policy_violations_request: global___ScanPolicyViolationsRequest | None = ...,
        scan_status_request: global___ScanStatusRequest | None = ...,
        scan_feature_state_request: global___ScanFeatureStateRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["scan_feature_state_request", b"scan_feature_state_request", "scan_malicious_packages_request", b"scan_malicious_packages_request", "scan_policy_violations_request", b"scan_policy_violations_request", "scan_software_components_request", b"scan_software_components_request", "scan_status_request", b"scan_status_request", "scan_vulnerabilities_request", b"scan_vulnerabilities_request", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["scan_feature_state_request", b"scan_feature_state_request", "scan_malicious_packages_request", b"scan_malicious_packages_request", "scan_policy_violations_request", b"scan_policy_violations_request", "scan_software_components_request", b"scan_software_components_request", "scan_status_request", b"scan_status_request", "scan_vulnerabilities_request", b"scan_vulnerabilities_request", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["scan_software_components_request", "scan_vulnerabilities_request", "scan_malicious_packages_request", "scan_policy_violations_request", "scan_status_request", "scan_feature_state_request"] | None: ...

global___ScanRequestType = ScanRequestType

class ScanSoftwareComponentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScanSoftwareComponentsRequest = ScanSoftwareComponentsRequest

class ScanVulnerabilitiesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScanVulnerabilitiesRequest = ScanVulnerabilitiesRequest

class ScanMaliciousPackagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScanMaliciousPackagesRequest = ScanMaliciousPackagesRequest

class ScanPolicyViolationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScanPolicyViolationsRequest = ScanPolicyViolationsRequest

class ScanStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScanStatusRequest = ScanStatusRequest

class ScanFeatureStateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_NAME_FIELD_NUMBER: builtins.int
    feature_name: builtins.str
    """The feature name to scan e.g. 'contextual_analysis'"""
    def __init__(
        self,
        *,
        feature_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["feature_name", b"feature_name"]) -> None: ...

global___ScanFeatureStateRequest = ScanFeatureStateRequest
