# Generated by Django 3.1.1 on 2020-09-16 07:51

import django.db.models.deletion
from django.db import migrations, models

from revpayment.settings import api_settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(api_settings.ORDER_CLASS._meta.label),
    ]

    operations = [
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "category",
                    models.CharField(
                        choices=[("B2B", "B2B"), ("B2C", "B2C")],
                        default="B2C",
                        max_length=10,
                    ),
                ),
                ("amount", models.IntegerField(default=0)),
                (
                    "invoice_type",
                    models.CharField(
                        choices=[("neweb", "neweb"), ("ecpay", "ecpay")],
                        default="neweb",
                        max_length=64,
                    ),
                ),
                (
                    "invoice_status",
                    models.CharField(
                        choices=[
                            ("success", "success"),
                            ("failure", "failure"),
                            ("void", "void"),
                        ],
                        max_length=64,
                    ),
                ),
                ("invoice_number", models.CharField(max_length=128, null=True)),
                (
                    "carrier_type",
                    models.CharField(
                        choices=[
                            ("no_carrier", "no_carrier"),
                            ("mobile", "mobile"),
                            ("npc", "npc"),
                            ("donation", "donation"),
                            ("default", "default"),
                        ],
                        default="no_carrier",
                        max_length=128,
                        null=True,
                    ),
                ),
                (
                    "carrier_number",
                    models.CharField(blank=True, max_length=128, null=True),
                ),
                ("uni_no", models.CharField(blank=True, max_length=128, null=True)),
                ("print_flag", models.BooleanField(default=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("detail", models.TextField(blank=True)),
                (
                    "order",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=api_settings.ORDER_CLASS._meta.label,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
