from typing import Any, Callable, Dict, List, Optional, Type, TypeVar

import attr

from ..types import UNSET
from ..util.serialization import is_not_none

T = TypeVar("T", bound="AuthResetPasswordWithTokenRequest")


@attr.s(auto_attribs=True)
class AuthResetPasswordWithTokenRequest:
    """Token may be requested with AuthEmailPasswordResetToken.

    Attributes:
        new_password (str):
        token (str):
    """

    new_password: str
    token: str
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self, pick_by_predicate: Optional[Callable[[Any], bool]] = is_not_none) -> Dict[str, Any]:
        new_password = self.new_password
        token = self.token

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "newPassword": new_password,
                "token": token,
            }
        )

        field_dict = {k: v for k, v in field_dict.items() if v != UNSET}
        if pick_by_predicate is not None:
            field_dict = {k: v for k, v in field_dict.items() if pick_by_predicate(v)}

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        new_password = d.pop("newPassword")

        token = d.pop("token")

        auth_reset_password_with_token_request = cls(
            new_password=new_password,
            token=token,
        )

        auth_reset_password_with_token_request.additional_properties = d
        return auth_reset_password_with_token_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
