# WS Frappe CLI

A command-line tool for Frappe/ERPNext development environment management.

[![PyPI version](https://badge.fury.io/py/ws-frappe-cli.svg)](https://badge.fury.io/py/ws-frappe-cli)
[![Python Support](https://img.shields.io/pypi/pyversions/ws-frappe-cli.svg)](https://pypi.org/project/ws-frappe-cli/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

## Overview

WS Frappe CLI simplifies the setup, configuration, and management of Frappe/ERPNext development environments. It provides an intuitive command-line interface for common development tasks.

## Features

- 🚀 **Quick Setup**: Initialize Frappe development environment with a single command
- 🌐 **Site Management**: Create and configure new sites interactively
- 📦 **App Management**: Install predefined or custom Frappe apps easily
- 🎨 **Interactive Interface**: User-friendly prompts and colored output
- ⚡ **Efficient Workflow**: Streamlined commands for common development tasks

## Installation

### From PyPI (Recommended)

```bash
pip install ws-frappe-cli
```

### From Source

```bash
git clone https://github.com/whitestork-erp/ws-frappe-cli.git
cd ws-frappe-cli
pip install -e .
```

## Quick Start

### 1. Setup Development Environment

Initialize a new Frappe development environment:

```bash
ws-frappe-cli setup
```

This command will:
- Create a Python virtual environment
- Install frappe-bench
- Initialize a new bench with Frappe

### 2. Create a Site

Create a new Frappe site:

```bash
ws-frappe-cli create-site
```

Follow the interactive prompts to configure your site.

### 3. Install Apps

Install Frappe apps on your site:

```bash
# List available predefined apps
ws-frappe-cli fetch-app --list-predefined

# Install a predefined app
ws-frappe-cli fetch-app --app-name erpnext

# Install a custom app
ws-frappe-cli fetch-app --app-name myapp --github-url https://github.com/user/myapp
```

## Command Reference

### `ws-frappe-cli setup`

Initialize Frappe development environment.

**Options:**
- `--project-name TEXT`: Name of the project (default: current directory name)
- `--frappe-version TEXT`: Frappe version to install (default: v15.78.1)
- `--python-path TEXT`: Path to Python executable (default: python3)
- `--force`: Force setup even if virtual environment exists

**Example:**
```bash
ws-frappe-cli setup --project-name myproject --frappe-version v15.78.1
```

### `ws-frappe-cli create-site`

Create a new Frappe site.

**Options:**
- `--site-name TEXT`: Name of the site to create
- `--admin-password TEXT`: Administrator password
- `--db-name TEXT`: Database name
- `--db-port TEXT`: Database port (default: 3306)
- `--db-root-username TEXT`: Database root username (default: root)
- `--db-root-password TEXT`: Database root password
- `--set-default`: Set this site as the default site
- `--install-apps`: Install apps after site creation
- `--apps TEXT`: Specific apps to install (can be used multiple times)
- `--no-interactive`: Skip interactive prompts

**Example:**
```bash
ws-frappe-cli create-site \\
  --site-name mysite.localhost \\
  --admin-password mypassword \\
  --set-default \\
  --install-apps \\
  --apps erpnext
```

### `ws-frappe-cli fetch-app`

Fetch and install Frappe apps.

**Options:**
- `--app-name TEXT`: Name of the app to install
- `--github-url TEXT`: GitHub URL of the app
- `--branch TEXT`: Branch to install (default: develop)
- `--site TEXT`: Site to install the app on
- `--list-predefined`: List predefined apps available for installation
- `--no-install`: Only fetch the app, do not install on any site
- `--force`: Reinstall if app already exists

**Examples:**
```bash
# List predefined apps
ws-frappe-cli fetch-app --list-predefined

# Install ERPNext
ws-frappe-cli fetch-app --app-name erpnext

# Install custom app
ws-frappe-cli fetch-app \\
  --app-name custom-app \\
  --github-url https://github.com/user/custom-app \\
  --branch main \\
  --site mysite.localhost
```

## Predefined Apps

The CLI comes with several predefined apps that can be installed easily:

- **ERPNext**: Enterprise Resource Planning
- **HRMS**: Human Resource Management System
- **Payments**: Payment Gateway Integration
- **E-commerce Integrations**: E-commerce Platform Integrations

## Development Workflow

A typical development workflow with WS Frappe CLI:

1. **Initialize Environment**:
   ```bash
   mkdir my-frappe-project
   cd my-frappe-project
   ws-frappe-cli setup
   ```

2. **Create Development Site**:
   ```bash
   source env/bin/activate
   ws-frappe-cli create-site --site-name dev.localhost --set-default
   ```

3. **Install Required Apps**:
   ```bash
   ws-frappe-cli fetch-app --app-name erpnext
   ws-frappe-cli fetch-app --app-name hrms
   ```

4. **Start Development Server**:
   ```bash
   bench start
   ```

## Configuration

### Environment Variables

- `FRAPPE_CLI_DEFAULT_BRANCH`: Default branch for Frappe (default: v15.78.1)
- `FRAPPE_CLI_DEFAULT_PYTHON`: Default Python executable (default: python3)

### Config File

You can create a `.frappe-cli.yaml` file in your project root:

```yaml
default_frappe_version: "v15.78.1"
default_python: "python3"
default_apps:
  - erpnext
  - hrms
```

## Requirements

- Python 3.8+
- Git
- MariaDB/MySQL
- Redis
- Node.js (for building assets)

## Troubleshooting

### Common Issues

1. **Permission Errors**: Ensure you have proper permissions for the directory
2. **Database Connection**: Verify MariaDB/MySQL is running and accessible
3. **Python Version**: Ensure you're using Python 3.8 or higher

### Getting Help

- Check the [documentation](https://github.com/whitestork-erp/ws-frappe-cli#readme)
- Report issues on [GitHub](https://github.com/whitestork-erp/ws-frappe-cli/issues)
- Use `ws-frappe-cli --help` for command-specific help

## Contributing

Contributions are welcome! Please read our [Contributing Guide](CONTRIBUTING.md) for details.

### Development Setup

1. Clone the repository:
   ```bash
   git clone https://github.com/whitestork-erp/ws-frappe-cli.git
   cd ws-frappe-cli
   ```

2. Install in development mode:
   ```bash
   pip install -e ".[dev]"
   ```

3. Run tests:
   ```bash
   pytest
   ```

4. Run linting:
   ```bash
   black src tests
   isort src tests
   flake8 src tests
   ```

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Changelog

See [CHANGELOG.md](CHANGELOG.md) for a list of changes and releases.

## Credits

- Built for the [Frappe Framework](https://frappeframework.com/)
- Inspired by the official [bench](https://github.com/frappe/bench) tool
- Uses [Click](https://click.palletsprojects.com/) for the CLI interface