# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyweatherflowudp']

package_data = \
{'': ['*']}

install_requires = \
['MetPy>=1.1.0,<2.0.0']

setup_kwargs = {
    'name': 'pyweatherflowudp',
    'version': '1.0.0',
    'description': 'An event-based asynchronous library to read UDP packets from Weatherflow weather systems on a local network without any reliance on the cloud.',
    'long_description': '# pyweatherflowudp\n\nAn event-based asynchronous library to read UDP packets from Weatherflow weather systems on a local network without any reliance on the cloud.\n\nThe atomic data provided by WeatherFlow sensors is all natively metric. To help facilitate transformations to other units or to perform calculations and comparisons, this module utilizes [Pint](https://pint.readthedocs.io/en/stable/)\'s Quantity class as the type of most properties which have a unit of measurement. See the [Quantity](#Quantity) section below for more details.\n\nThis module utilizes [MetPy](https://unidata.github.io/MetPy/latest/index.html) to help with additional weather calculations that are derived from the various data points provided by the actual WeatherFlow sensors. While WeatherFlow has these additional data points available via the app and rest API, they are unavailable via the low-level UDP packet data. And while a list of [derived metrics](https://weatherflow.github.io/Tempest/api/derived-metric-formulas.html) and the associated equations has been posted, they can be quite complex to implement. As such, MetPy is an invaluable resource since the work has already been done and it eliminates the need to write all the equations in this module (and potentially get them wrong). You may notice that some of these values aren\'t an exact match with what is shown in the WeatherFlow app because there are different formulas (some simpler, some more complex) to calculate derived weather metrics. This is because WeatherFlow and MetPy may have chosen one of the sometimes many different formulas to get the result desired. They should still be relatively close, however.\n\n## Supported Devices\n\n- Tempest\n- Air (untested)\n- Sky (untested)\n\n## Usage\n\nThe primary way of interacting with this module, and the devices that are found with it, is via event subscriptions.\n\nThe classes and events which they currently support are outlined below, but you can also see an example tying this altogether in [demo.py](/demo.py).\n\n### Client\n\n#### `WeatherFlowListener`\n\n- EVENT_DEVICE_DISCOVERED - emitted when a new device (Hub, Air, Sky or Tempest) is disovered for the first time\n\nThe classes and events in this section can be imported from `pyweatherflowudp.client`.\n\n### Devices\n\n#### `HubDevice`\n\n- EVENT_LOAD_COMPLETE - emitted once when the hub has finished parsing a status update for the first time\n- EVENT_STATUS_UPDATE - emitted each time a status update has been parsed by the hub, including immediately following an EVENT_LOAD_COMPLETE\n\n#### `WeatherFlowSensorDevice` (base class for `AirDevice`, `SkyDevice` and `TempestDevice`)\n\n- EVENT_LOAD_COMPLETE - emitted once when the sensor has finished parsing one status update and one observation for the first time\n- EVENT_OBSERVATION - emitted each time an observation has been parsed by the sensor\n- EVENT_STATUS_UPDATE - emitted each time a status update has been parsed by the sensor\n\n#### `AirSensorType` (`AirDevice` / `TempestDevice`)\n\n- EVENT_STRIKE - emitted when a lightning strike has been detected\n\n#### `SkySensorType` (`SkyDevice` / `TempestDevice`)\n\n- EVENT_RAIN_START - emitted when rain has been detected\n- EVENT_RAPID_WIND - emitted every 3 seconds (or less frequently depending on battery voltage) to inform about current wind condtions\n\nThe classes and events in this section can be imported from `pyweatherflowudp.device`.\n\n## Properties\n\n### WeatherFlowListener\n\n| property     | type | description                                                                              |\n| ------------ | ---- | ---------------------------------------------------------------------------------------- |\n| devices      | list | The known devices.                                                                       |\n| hubs         | list | The known hubs.                                                                          |\n| is_listening | bool | `True` if the listener is currently monitoring UDP packets on the network, else `False`. |\n| sensors      | list | The known sensors.                                                                       |\n\n### WeatherFlowDevice\n\nBase for hubs and sensors.\n\n| property          | type     | description                                                        |\n| ----------------- | -------- | ------------------------------------------------------------------ |\n| firmware_revision | str      | The current firmware revision of the device.                       |\n| load_complete     | bool     | `True` if the device has parsed all initial updates, else `False`. |\n| model             | str      | The model of the device ("Hub", "Air", "Sky", "Tempest").          |\n| rssi              | Quantity | The signal strength of the device in decibels.                     |\n| serial_number     | str      | The serial number of the device.                                   |\n| timestamp         | datetime | The UTC timestamp from the last status update.                     |\n| uptime            | int      | The number of seconds the device has been up and running.          |\n\n### HubDevice\n\n| property    | type | description                         |\n| ----------- | ---- | ----------------------------------- |\n| reset_flags | list | The current reset flags of the hub. |\n\n### WeatherFlowSensorDevice\n\nBase for sensors.\n\n| property        | type     | description                                           |\n| --------------- | -------- | ----------------------------------------------------- |\n| battery         | Quantity | The current battery voltage.                          |\n| hub_rssi        | Quantity | The signal strength of the hub in decibels.           |\n| hub_sn          | str      | The serial number of the hub the sensor belongs to.   |\n| last_report     | datetime | The UTC timestamp from the last observation.          |\n| sensor_status   | list     | The list of issues the sensor is currently reporting. |\n| report_interval | Quantity | The report interval in minutes.                       |\n| reset_flags     | list     | The current reset flags of the hub.                   |\n\n### AirSensorType\n\nBase for "air" sensor measurements (Air/Tempest).\n\n| property                                   | type                 | description                                                            |\n| ------------------------------------------ | -------------------- | ---------------------------------------------------------------------- |\n| air_temperature                            | Quantity             | The current air temperature in degrees Celsius.                        |\n| last_lightning_strike_event                | LightningStrikeEvent | The last lightning strike event.                                       |\n| lightning_strike_average_distance          | Quantity             | The average distance for lightning strikes in kilometers.              |\n| lightning_strike_count                     | int                  | The number of lightning strikes.                                       |\n| relative_humidity                          | Quantity             | The relative humidity percentage.                                      |\n| station_pressure                           | Quantity             | The observed station pressure in millibars.                            |\n| air_density\\*                              | Quantity             | The calculated air density in kilograms per cubic meter.               |\n| delta_t\\*                                  | Quantity             | The calculated Delta T in delta degrees Celsius.                       |\n| dew_point_temperature\\*                    | Quantity             | The calculated dew point temperature in degrees Celsius.               |\n| heat_index\\*                               | Quantity             | The calculated heat index in degrees Celsius.                          |\n| vapor_pressure\\*                           | Quantity             | The calculated vapor pressure in millibars.                            |\n| wet_bulb_temperature\\*                     | Quantity             | The calculated wet bulb temperature in degrees Celsius.                |\n| _calculate_sea_level_pressure(height)_\\*\\* | Quantity             | Calculate the sea level pressure in millibars from a specified height. |\n\n\\* Indicates derived properties\n\n\\*\\* Indicates this is a method, not a property.\n\n### SkySensorType\n\nBase for "sky" sensor measurements (Sky/Tempest).\n\n| property                    | type              | description                                                           |\n| --------------------------- | ----------------- | --------------------------------------------------------------------- |\n| illuminance                 | Quantity          | The current illuminance in Lux.                                       |\n| last_rain_start_event       | RainStartEvent    | The last rain start event.                                            |\n| last_wind_event             | WindEvent         | The last wind event.                                                  |\n| precipitation_type          | PrecipitationType | The current precipitation type: (NONE, RAIN, HAIL or RAIN_HAIL).      |\n| rain_amount_previous_minute | Quantity          | The rain amount over the last minute in millimeters per minute.       |\n| solar_radiation             | Quantity          | The solar radiation in Watts per cubic meter.                         |\n| uv                          | int               | The current UV index.                                                 |\n| wind_average                | Quantity          | The wind speed average over the report interval in meters per second. |\n| wind_direction              | Quantity          | The wind direction over the report interval in degrees.               |\n| wind_gust                   | Quantity          | The wind gust (maximum 3 second sample) in meters per second.         |\n| wind_lull                   | Quantity          | The wind lull (minimum 3 second sample) in meters per second.         |\n| wind_sample_interval        | Quantity          | The wind sample interval in seconds.                                  |\n\n### TempestDevice\n\n| property                 | type     | description                                                 |\n| ------------------------ | -------- | ----------------------------------------------------------- |\n| feels_like_temperature\\* | Quantity | The calculated "feels like" temperature in degrees Celsius. |\n| wind_chill_temperature\\* | Quantity | The calculated wind chill temperature in degrees Celsius.   |\n\n\\* Indicates derived properties\n\n### Quantity\n\nThe `pint.Quantity` class has been utilized for device properties which are associated with a unit of measurement. This allows a conversion from the native metric unit to another of the user\'s choice such as degrees Celsius to degrees Fahrenheit, which produces another `pint.Quantity`:\n\n```python\ndevice.air_temperature.to("degF")\n```\n\nTo retrieve only the numeric value of a property, you can just append a `.magnitude` (or `.m` short form) like:\n\n```python\ndevice.air_temperature.m\n```\n\nYou can also retrieve only the units portion of a property with `.units` (or `.u` short form) like:\n\n```python\ndevice.air_temperature.u\n```\n\nCheck out the [Pint docs](https://pint.readthedocs.io/en/stable/#user-guide) for more tips.\n',
    'author': 'Nathan Spencer',
    'author_email': 'natekspencer@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/briis/pyweatherflowudp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
