# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['carrot_rcc']
entry_points = \
{'console_scripts': ['carrot-rcc = carrot_rcc:main']}

setup_kwargs = {
    'name': 'carrot-rcc',
    'version': '0.3.0',
    'description': 'Camunda external task Robot Framework RCC client',
    'long_description': "Camunda external task Robot Framework RCC client\n================================================\n\n**Technology preview.**\n\n`carrot-rcc` is an opinionated [Camunda external task](https://docs.camunda.org/manual/latest/user-guide/process-engine/external-tasks/) client for executing [Robot Framework](https://robotframework.org/rpa/) [RPA framework](https://rpaframework.org/) tasks. It is based on Robocorp [RCC toolchain](https://robocorp.com/docs/rcc/overview) and [Camunda external task client for Node JS](https://github.com/camunda/camunda-external-task-client-js).\n\n`carrot-rcc` executes robots build and wrapped into zip files following to [Robocorp documentation](https://robocorp.com/docs/). Single `carrot-rcc` service can subscribe multiple topics, execute tasks concurrently, but only locally on the same computer. `carrot-rcc` works on Windows, Linux and most probably also on MacOS.\n\n```bash\nusage: carrot-rcc [<robots>...]\n                  [--base-url] [--authorization]\n                  [--worker-id] [--max-tasks] [--poll-interval] [--log-level]\n                  [--rcc-executable] [--rcc-encoding] [--rcc-telemetry]\n                  [-h] [--help]\n\n<robots> could also be passed as a comma separated env RCC_ROBOTS\n\noptions:\n\n  --base-url[=<url>]                       [env: CAMUNDA_API_BASE_URL] [default: http://localhost:8080/engine-rest]\n  --authorization[=<header>]               [env: CAMUNDA_API_AUTHORIZATION] [example: Basic ZGVtbzpkZW1v]\n\n  --worker-id[=<string>]                   [env: CLIENT_WORKER_ID] [default: carrot-rcc]\n  --max-tasks[=<cpus>]                     [env: CLIENT_MAX_TASKS] [default: [cpu count]]\n  --poll-interval[=<milliseconds>]         [env: CLIENT_POLL_INTERVAL] [default: 10000]\n  --log-level[=<debug|info|warn|error>]    [env: CLIENT_LOG_LEVEL] [default: info]\n\n  --rcc-executable[=<path>]                [env: RCC_EXECUTABLE] [default: rcc]\n  --rcc-encoding[=<encoding>]              [env: RCC_ENCODING] [default: utf-8]\n  --rcc-telemetry                          [env: RCC_TELEMETRY] (default: do not track)\n\n  -h, --help\n```\n\n`carrot-rcc` in brief:\n\n* On startup, every given robot is examined for their task names `robot.yaml`.\n* Then `carrot-rcc` subscribes every task name as they were Camunda external task topics.\n* On a new task, its variables (also files) are saved as a [robot work item](https://robocorp.com/docs/libraries/rpa-framework/rpa-robocloud-items).\n* Next [RCC](https://robocorp.com/docs/rcc/overview) is called to resolve robot's dependencies and execute the robot.\n* Finally, `carrot-rcc` saves changed and new variables from the robot's saved work item with robot execution logs back to Camunda (onto the task execution context) and either completes of fails the task at Camunda.\n\n\nInstallation\n============\n\n`carrot-rcc` requires [NodeJS](https://nodejs.org/en/) 12 or later and [RCC](https://downloads.robocorp.com/rcc/releases/index.html) should be on its PATH (or passed with ``--rcc-executable`` argument).\n\nYet, it is possible to bootstrap everything with just RCC:\n\n1. Create a directory for `carrot-rcc` and download [RCC](https://downloads.robocorp.com/rcc/releases/index.html) into that directory.\n\n2. Download an example [conda.yaml](https://raw.githubusercontent.com/datakurre/carrot-rcc/main/conda.yaml) defining the requirements for `carrot-rcc`.\n\n3. Install `carrot-rcc` into RCC managed environment with\n\n   ```bash\n   $ rcc env new conda.yaml\n   ```\n\n   or\n\n   ```bash\n   $ rcc.exe env new conda.yaml\n   ```\n\n4. The hard part. Figure out from the logs where RCC did create the environment. Then copy a few files back and forth to give you access the environment and installed `carrot-rcc` and give `carrot-rcc` access to RCC with\n\n   ```bash\n   $ cp /home/user/.robocorp/live/850002f365eee60f/rcc_activate.sh .\n   $ cp rcc /home/user/.robocorp/live/850002f365eee60f/bin\n   ```\n\n   or\n\n   ```bash\n   $ copy C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\\rcc_activate.cmd .\n   $ copy C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\\Scripts\\carrot-rcc.exe .\n   $ copy rcc.exe C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\n   ```\n\n5. Finally, activate environment with\n\n   ```bash\n   $ source rcc_activate.sh\n   ```\n\n   or\n\n   ```bash\n   $ rcc_activate.cmd\n   ```\n\nDone, now `carrot-rcc` should be ready to be run, for example with:\n\n```bash\n$ carrot-rcc robot.zip --base-url=http://localhost:8080/engine-rest --log-level=debug\n```\n\nor\n\n```bash\n$ carrot-rcc.exe robot.zip --base-url=http://192.168.86.156:8080/engine-rest --log-level=debug\n```\n\nThe project has an example Camunda process [Search XKCD comic](https://github.com/datakurre/carrot-executor/tree/main/camunda/deployment) with an [example robot](https://github.com/datakurre/carrot-rcc/blob/main/xkcd-bot/robot.zip?raw=true) available.\n",
    'author': 'Asko Soukka',
    'author_email': 'asko.soukka@iki.fi',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/datakurre/carrot-rcc',
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
