import * as iam from '@aws-cdk/aws-iam';
import { IResource, Resource } from '@aws-cdk/core';
import { ITopicSubscription } from './subscriber';
/**
 * Represents an SNS topic.
 *
 * @stability stable
 */
export interface ITopic extends IResource {
    /**
     * The ARN of the topic.
     *
     * @stability stable
     * @attribute true
     */
    readonly topicArn: string;
    /**
     * The name of the topic.
     *
     * @stability stable
     * @attribute true
     */
    readonly topicName: string;
    /**
     * Subscribe some endpoint to this topic.
     *
     * @stability stable
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is imported (`Topic.import`), then this is a no-op.
     *
     * @stability stable
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * Grant topic publishing permissions to the given identity.
     *
     * @stability stable
     */
    grantPublish(identity: iam.IGrantable): iam.Grant;
}
/**
 * Either a new or imported Topic.
 *
 * @stability stable
 */
export declare abstract class TopicBase extends Resource implements ITopic {
    /**
     * The ARN of the topic.
     *
     * @stability stable
     */
    abstract readonly topicArn: string;
    /**
     * The name of the topic.
     *
     * @stability stable
     */
    abstract readonly topicName: string;
    /**
     * Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     *
     * @stability stable
     */
    protected abstract readonly autoCreatePolicy: boolean;
    private policy?;
    /**
     * Subscribe some endpoint to this topic.
     *
     * @stability stable
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is imported (`Topic.import`), then this is a no-op.
     *
     * @stability stable
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @stability stable
     */
    protected validate(): string[];
    /**
     * Grant topic publishing permissions to the given identity.
     *
     * @stability stable
     */
    grantPublish(grantee: iam.IGrantable): iam.Grant;
    private nextTokenId;
}
