/*
 * Copyright (C) 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * All rights reserved.
 *
 * This software may be modified and distributed under the terms of the
 * BSD-3-Clause license. See the accompanying LICENSE file for details.
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <Demo.h>

#include <yarp/os/idl/WireTypes.h>

class Demo_get_answer_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_get_answer_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static std::int32_t s_return_helper;
};

thread_local std::int32_t Demo_get_answer_helper::s_return_helper = {};

Demo_get_answer_helper::Demo_get_answer_helper()
{
    s_return_helper = {};
}

bool Demo_get_answer_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("get_answer", 1, 2)) {
        return false;
    }
    return true;
}

bool Demo_get_answer_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readI32(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class Demo_set_answer_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_set_answer_helper(const std::int32_t rightAnswer);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::int32_t m_rightAnswer;

    thread_local static bool s_return_helper;
};

thread_local bool Demo_set_answer_helper::s_return_helper = {};

Demo_set_answer_helper::Demo_set_answer_helper(const std::int32_t rightAnswer) :
        m_rightAnswer{rightAnswer}
{
    s_return_helper = {};
}

bool Demo_set_answer_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(3)) {
        return false;
    }
    if (!writer.writeTag("set_answer", 1, 2)) {
        return false;
    }
    if (!writer.writeI32(m_rightAnswer)) {
        return false;
    }
    return true;
}

bool Demo_set_answer_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class Demo_add_one_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_add_one_helper(const std::int32_t x);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::int32_t m_x;

    thread_local static std::int32_t s_return_helper;
};

thread_local std::int32_t Demo_add_one_helper::s_return_helper = {};

Demo_add_one_helper::Demo_add_one_helper(const std::int32_t x) :
        m_x{x}
{
    s_return_helper = {};
}

bool Demo_add_one_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(3)) {
        return false;
    }
    if (!writer.writeTag("add_one", 1, 2)) {
        return false;
    }
    if (!writer.writeI32(m_x)) {
        return false;
    }
    return true;
}

bool Demo_add_one_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readI32(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class Demo_start_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_start_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool Demo_start_helper::s_return_helper = {};

Demo_start_helper::Demo_start_helper()
{
    s_return_helper = {};
}

bool Demo_start_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("start", 1, 1)) {
        return false;
    }
    return true;
}

bool Demo_start_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class Demo_stop_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_stop_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool Demo_stop_helper::s_return_helper = {};

Demo_stop_helper::Demo_stop_helper()
{
    s_return_helper = {};
}

bool Demo_stop_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("stop", 1, 1)) {
        return false;
    }
    return true;
}

bool Demo_stop_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class Demo_is_running_helper :
        public yarp::os::Portable
{
public:
    explicit Demo_is_running_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool Demo_is_running_helper::s_return_helper = {};

Demo_is_running_helper::Demo_is_running_helper()
{
    s_return_helper = {};
}

bool Demo_is_running_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("is_running", 1, 2)) {
        return false;
    }
    return true;
}

bool Demo_is_running_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

// Constructor
Demo::Demo()
{
    yarp().setOwner(*this);
}

std::int32_t Demo::get_answer()
{
    Demo_get_answer_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::int32_t Demo::get_answer()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_get_answer_helper::s_return_helper : std::int32_t{};
}

bool Demo::set_answer(const std::int32_t rightAnswer)
{
    Demo_set_answer_helper helper{rightAnswer};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool Demo::set_answer(const std::int32_t rightAnswer)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_set_answer_helper::s_return_helper : bool{};
}

std::int32_t Demo::add_one(const std::int32_t x)
{
    Demo_add_one_helper helper{x};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::int32_t Demo::add_one(const std::int32_t x)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_add_one_helper::s_return_helper : std::int32_t{};
}

bool Demo::start()
{
    Demo_start_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool Demo::start()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_start_helper::s_return_helper : bool{};
}

bool Demo::stop()
{
    Demo_stop_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool Demo::stop()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_stop_helper::s_return_helper : bool{};
}

bool Demo::is_running()
{
    Demo_is_running_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool Demo::is_running()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? Demo_is_running_helper::s_return_helper : bool{};
}

// help method
std::vector<std::string> Demo::help(const std::string& functionName)
{
    bool showAll = (functionName == "--all");
    std::vector<std::string> helpString;
    if (showAll) {
        helpString.emplace_back("*** Available commands:");
        helpString.emplace_back("get_answer");
        helpString.emplace_back("set_answer");
        helpString.emplace_back("add_one");
        helpString.emplace_back("start");
        helpString.emplace_back("stop");
        helpString.emplace_back("is_running");
        helpString.emplace_back("help");
    } else {
        if (functionName == "get_answer") {
            helpString.emplace_back("std::int32_t get_answer() ");
        }
        if (functionName == "set_answer") {
            helpString.emplace_back("bool set_answer(const std::int32_t rightAnswer) ");
        }
        if (functionName == "add_one") {
            helpString.emplace_back("std::int32_t add_one(const std::int32_t x) ");
        }
        if (functionName == "start") {
            helpString.emplace_back("bool start() ");
        }
        if (functionName == "stop") {
            helpString.emplace_back("bool stop() ");
        }
        if (functionName == "is_running") {
            helpString.emplace_back("bool is_running() ");
        }
        if (functionName == "help") {
            helpString.emplace_back("std::vector<std::string> help(const std::string& functionName = \"--all\")");
            helpString.emplace_back("Return list of available commands, or help message for a specific function");
            helpString.emplace_back("@param functionName name of command for which to get a detailed description. If none or '--all' is provided, print list of available commands");
            helpString.emplace_back("@return list of strings (one string per line)");
        }
    }
    if (helpString.empty()) {
        helpString.emplace_back("Command not found");
    }
    return helpString;
}

// read from ConnectionReader
bool Demo::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }

    std::string tag = reader.readTag();
    bool direct = (tag == "__direct__");
    if (direct) {
        tag = reader.readTag();
    }
    while (!reader.isError()) {
        if (tag == "get_answer") {
            Demo_get_answer_helper::s_return_helper = get_answer();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeI32(Demo_get_answer_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "set_answer") {
            std::int32_t rightAnswer;
            if (!reader.readI32(rightAnswer)) {
                reader.fail();
                return false;
            }
            Demo_set_answer_helper::s_return_helper = set_answer(rightAnswer);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(Demo_set_answer_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "add_one") {
            std::int32_t x;
            if (!reader.readI32(x)) {
                reader.fail();
                return false;
            }
            Demo_add_one_helper::s_return_helper = add_one(x);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeI32(Demo_add_one_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "start") {
            Demo_start_helper::s_return_helper = start();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(Demo_start_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "stop") {
            Demo_stop_helper::s_return_helper = stop();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(Demo_stop_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "is_running") {
            Demo_is_running_helper::s_return_helper = is_running();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(Demo_is_running_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "help") {
            std::string functionName;
            if (!reader.readString(functionName)) {
                functionName = "--all";
            }
            auto help_strings = help(functionName);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeTag("many", 1, 0)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_INT32, static_cast<uint32_t>(help_strings.size()))) {
                    return false;
                }
                for (const auto& help_string : help_strings) {
                    if (!writer.writeString(help_string)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (reader.noMore()) {
            reader.fail();
            return false;
        }
        std::string next_tag = reader.readTag();
        if (next_tag == "") {
            break;
        }
        tag.append("_").append(next_tag);
    }
    return false;
}
