import os
import sys
import pycifstar
from cryspy.scripts.cl_rhochi import RhoChi


def template_for_single():
    s_out = """

data_mono
_setup_wavelength      1.40
_setup_field           1.00

_diffrn_radiation_polarization -0.87
_diffrn_radiation_efficiency    1.00

_extinction_mosaicity 0.5523
_extinction_radius    77.7983
_extinction_model     gauss

_diffrn_orient_matrix_UB_11 6.59783
_diffrn_orient_matrix_UB_12 -6.99807
_diffrn_orient_matrix_UB_13 3.3663
_diffrn_orient_matrix_UB_21 2.18396
_diffrn_orient_matrix_UB_22 -2.60871
_diffrn_orient_matrix_UB_23 -9.5302
_diffrn_orient_matrix_UB_31 7.4657
_diffrn_orient_matrix_UB_32 6.94702
_diffrn_orient_matrix_UB_33 -0.18685

_phase_label  Fe3O4

loop_
_diffrn_refln_index_h
_diffrn_refln_index_k
_diffrn_refln_index_l
_diffrn_refln_fr
_diffrn_refln_fr_sigma
_diffrn_refln_fr_calc
0 0 8  0.64545 0.01329 0.6712661351345524
2 0 6  1.75682 0.04540 1.7645623312806638
0 2 6  1.67974 0.03711 1.6365392780135470
2 0 10 0.90510 0.02316 0.9305458781468400
0 2 10 0.92428 0.01791 0.9390707747959662
4 -4 0 0.71857 0.01026 0.6835720140623864
    """
    
    return s_out

def template_for_pd():
    s_out = """
data_pd
_setup_wavelength      0.84
_setup_field           1.00
_setup_offset_2theta -0.385404

_chi2_sum True
_chi2_diff False
_chi2_up False
_chi2_down False

_range_2theta_min     4.000
_range_2theta_max    80.000

loop_
_pd_background_2theta
_pd_background_intensity
 4.5 256.0
40.0 158.0
80.0  65.0

loop_
_exclude_2theta_min
_exclude_2theta_max
0.0 1.0

_diffrn_radiation_polarization -0.87
_diffrn_radiation_efficiency    1.00

_extinction_mosaicity 0.5523
_extinction_radius    77.7983
_extinction_model     gauss

_diffrn_radiation_polarization 0.0
_diffrn_radiation_efficiency   1.0

_pd_instr_resolution_u 16.9776
_pd_instr_resolution_v -2.8357
_pd_instr_resolution_w  0.5763
_pd_instr_resolution_x  0.0
_pd_instr_resolution_y  0.0

loop_
_phase_label
_phase_scale
_phase_igsize
Fe3O4 0.02381 0.0

loop_
_pd_meas_2theta
_pd_meas_intensity_up
_pd_meas_intensity_up_sigma
_pd_meas_intensity_down
_pd_meas_intensity_down_sigma
4.0 465.8 128.97 301.88 129.3
4.2 323.78 118.22 206.06 120.0
4.4 307.14 115.9 230.47 116.53
4.6 172.13 115.84 236.52 113.74
4.8 164.31 110.75 291.6 110.73
5.0 166.47 106.51 426.73 109.08
5.2 217.67 104.66 183.24 107.79
5.4 84.01 99.91 179.87 99.98
5.6 220.87 98.72 297.76 99.83
5.8 223.46 98.77 149.78 98.18
6.0 408.25 96.89 356.86 96.41
6.2 381.21 94.03 287.26 96.94
6.4 239.85 94.06 101.64 95.3
6.6 58.16 90.93 194.35 89.9
6.8 127.79 88.33 273.48 89.35
7.0 148.69 87.5 165.7 89.52
7.2 34.61 87.11 223.81 88.08
    """
    return s_out

def template_for_pd2d():
    s_out = """

data_powder2d
_setup_wavelength     0.840
_setup_field          1.000
_setup_offset_2theta -0.385404
_setup_offset_phi     0.000

_chi2_sum  True
_chi2_diff False
_chi2_up   False
_chi2_down False

_range_2theta_min     4.000
_range_2theta_max    80.000
_range_phi_min       -2.000
_range_phi_max       40.000

_pd2d_background_2theta_phi_intensity
;
     2   4.50        40.00        80.00      
 -3.00 -350.0        -369(1)     -400.0      
 41.00 -350.0        -404(2)     -400.0  
;

loop_
_exclude_2theta_min
_exclude_2theta_max
_exclude_phi_min
_exclude_phi_max
0.0 1.0 -5.0 -4.0

_pd2d_instr_reflex_asymmetry_p1 0.0
_pd2d_instr_reflex_asymmetry_p2 0.0
_pd2d_instr_reflex_asymmetry_p3 0.0
_pd2d_instr_reflex_asymmetry_p4 0.0

_diffrn_radiation_polarization 1.0
_diffrn_radiation_efficiency   1.0

_pd2d_instr_resolution_u 16.9776
_pd2d_instr_resolution_v -2.8357
_pd2d_instr_resolution_w  0.5763
_pd2d_instr_resolution_x  0.0
_pd2d_instr_resolution_y  0.0

loop_
_phase_label
_phase_scale
_phase_igsize
Fe3O4 0.02381 0.0

_pd2d_meas_2theta_phi_intensity_up
;
         241   4.00         4.20         4.40         4.60         4.80         5.00         5.20         5.40         5.60         5.80         6.00         6.20         6.40         6.60         6.80         7.00         7.20         7.40         7.60         7.80         8.00         8.20         8.40         8.60         8.80         9.00         9.20         9.40         9.60         9.80        10.00        10.20        10.40        10.60        10.80        11.00        11.20        11.40        11.60        11.80        12.00        12.20        12.40        12.60        12.80        13.00        13.20        13.40        13.60        13.80        14.00        14.20        14.40        14.60        14.80        15.00        15.20        15.40        15.60        15.80        16.00        16.20        16.40        16.60        16.80        17.00        17.20        17.40        17.60        17.80        18.00        18.20        18.40        18.60        18.80        19.00        19.20        19.40        19.60        19.80        20.00        20.20        20.40        20.60        20.80        21.00        21.20        21.40        21.60        21.80        22.00        22.20        22.40        22.60        22.80        23.00        23.20        23.40        23.60        23.80        24.00        24.20        24.40        24.60        24.80        25.00        25.20        25.40        25.60        25.80        26.00        26.20        26.40        26.60        26.80        27.00        27.20        27.40        27.60        27.80        28.00        28.20        28.40        28.60        28.80        29.00        29.20        29.40        29.60        29.80        30.00        30.20        30.40        30.60        30.80        31.00        31.20        31.40        31.60        31.80        32.00        32.20        32.40        32.60        32.80        33.00        33.20        33.40        33.60        33.80        34.00        34.20        34.40        34.60        34.80        35.00        35.20        35.40        35.60        35.80        36.00        36.20        36.40        36.60        36.80        37.00        37.20        37.40        37.60        37.80        38.00        38.20        38.40        38.60        38.80        39.00        39.20        39.40        39.60        39.80        40.00        40.20        40.40        40.60        40.80        41.00        41.20        41.40        41.60        41.80        42.00        42.20        42.40        42.60        42.80        43.00        43.20        43.40        43.60        43.80        44.00        44.20        44.40        44.60        44.80        45.00        45.20        45.40        45.60        45.80        46.00        46.20        46.40        46.60        46.80        47.00        47.20        47.40        47.60        47.80        48.00        48.20        48.40        48.60        48.80        49.00        49.20        49.40        49.60        49.80        50.00        50.20        50.40        50.60        50.80        51.00        51.20        51.40        51.60        51.80        52.00        52.20        52.40        52.60        52.80        53.00        53.20        53.40        53.60        53.80        54.00        54.20        54.40        54.60        54.80        55.00        55.20        55.40        55.60        55.80        56.00        56.20        56.40        56.60        56.80        57.00        57.20        57.40        57.60        57.80        58.00        58.20        58.40        58.60        58.80        59.00        59.20        59.40        59.60        59.80        60.00        60.20        60.40        60.60        60.80        61.00        61.20        61.40        61.60        61.80        62.00        62.20        62.40        62.60        62.80        63.00        63.20        63.40        63.60        63.80        64.00        64.20        64.40        64.60        64.80        65.00        65.20        65.40        65.60        65.80        66.00        66.20        66.40        66.60        66.80        67.00        67.20        67.40        67.60        67.80        68.00        68.20        68.40        68.60        68.80        69.00        69.20        69.40        69.60        69.80        70.00        70.20        70.40        70.60        70.80        71.00        71.20        71.40        71.60        71.80        72.00        72.20        72.40        72.60        72.80        73.00        73.20        73.40        73.60        73.80        74.00        74.20        74.40        74.60        74.80        75.00        75.20        75.40        75.60        75.80        76.00        76.20        76.40        76.60        76.80        77.00        77.20        77.40        77.60        77.80        78.00        78.20        78.40        78.60        78.80        79.00        79.20        79.40        79.60        79.80        80.00        80.20        80.40        80.60        80.80        81.00        81.20        81.40        81.60        81.80        82.00        82.20        82.40        82.60        82.80        83.00        83.20        83.40        83.60        83.80        84.00        84.20        84.40        84.60        84.80        85.00        85.20        85.40        85.60        85.80        86.00        86.20        86.40        86.60        86.80        87.00        87.20        87.40        87.60        87.80        88.00        88.20        88.40        88.60        88.80        89.00        89.20        89.40        89.60        89.80        90.00        90.20        90.40        90.60        90.80        91.00        91.20        91.40        91.60        91.80        92.00        92.20        92.40        92.60        92.80        93.00        93.20        93.40        93.60        93.80        94.00        94.20        94.40        94.60        94.80        95.00        95.20        95.40        95.60        95.80        96.00        96.20        96.40        96.60        96.80        97.00        97.20        97.40        97.60        97.80        98.00        98.20        98.40        98.60        98.80        99.00        99.20        99.40        99.60        99.80       100.00       100.20       100.40       100.60       100.80       101.00       101.20       101.40       101.60       101.80       102.00       102.20       102.40       102.60       102.80       103.00       103.20       103.40       103.60       103.80       104.00       104.20       104.40       104.60       104.80       105.00       105.20       105.40       105.60       105.80       106.00       106.20       106.40       106.60       106.80       107.00       107.20       107.40       107.60       107.80       108.00       108.20       108.40       108.60       108.80       109.00       109.20       109.40       109.60       109.80       110.00       110.20       110.40       110.60       110.80       111.00       111.20       111.40       111.60       111.80       112.00       112.20       112.40       112.60       112.80       113.00       113.20       113.40       113.60       113.80       114.00       114.20       114.40       114.60       114.80       115.00       115.20       115.40       115.60       115.80       116.00       116.20       116.40       116.60       116.80       117.00       117.20       117.40       117.60       117.80       118.00       118.20       118.40       118.60       118.80       119.00       119.20       119.40       119.60       119.80       120.00       120.20       120.40       120.60       120.80       121.00       121.20       121.40       121.60       121.80       122.00       122.20       122.40       122.60       122.80       123.00       123.20       123.40       123.60       123.80       124.00       124.20       124.40       124.60       124.80       125.00       125.20       125.40       125.60       125.80       126.00       126.20       126.40       126.60       126.80       127.00       127.20       127.40       127.60       127.80       128.00       128.20       128.40       128.60       128.80       129.00       129.20       129.40       129.60       129.80       130.00       130.20       130.40       130.60       130.80       131.00       131.20       131.40       131.60       131.80       132.00       132.20       132.40       132.60       132.80       133.00       133.20       133.40       133.60       133.80       134.00       134.20       134.40       134.60       134.80       135.00       135.20       135.40       135.60       135.80       136.00       136.20       136.40       136.60       136.80       137.00       137.20       137.40       137.60       137.80       138.00       138.20       138.40       138.60       138.80       139.00       139.20       139.40       139.60       139.80       140.00       140.20       140.40       140.60       140.80       141.00       141.20       141.40       141.60       141.80       142.00       142.20       142.40       142.60       142.80       143.00       143.20       143.40       143.60       143.80       144.00       144.20       144.40       144.60       144.80       145.00       145.20       145.40       145.60       145.80       146.00       146.20       146.40       146.60       146.80       147.00       147.20       147.40       147.60       147.80       148.00       148.20       148.40       148.60       148.80       149.00       149.20       149.40       149.60       149.80       150.00      
      -40.00    -331.2243    -441.7184    -165.4574   -255.04425   -266.21728   -345.16936   -495.28545   -445.75888   -551.80308   -360.60401   -499.51811   -371.54139   -543.69325   -260.78826   -559.88329   -376.08355    -586.5902          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -39.50   -367.06001   -334.89957    -19.03981   -368.40767   -388.36626   -387.11145   -460.28206   -257.13416   -504.58813   -293.77682   -538.43688   -351.89403   -553.04223    -348.1433   -620.61851   -525.51391   -465.59408          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -39.00   -468.35805   -361.54946   -227.15401   -493.43758    -402.6348   -366.44569   -407.45424     -222.144    -347.5662   -408.85764   -551.88214   -282.41867   -610.12649   -427.75663   -568.01653   -710.07063   -528.54547   -663.15661          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -38.50   -606.87762   -452.83686   -464.09166   -396.85362   -332.25873   -373.29971   -287.82815   -416.85128   -235.26827   -526.47234   -567.25814   -261.42718    -596.6799   -309.53023   -507.12002   -586.46382    -613.4283   -397.89457          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -38.00     -694.919   -444.04782   -690.42553    -399.0268   -351.31291   -411.50137   -321.51628   -591.22956   -469.20376   -552.73062   -384.39595   -318.94882   -485.05304   -370.98635   -586.14907    -313.8733   -579.58312   -405.05731   -361.05863          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -37.50   -776.64279    -389.6432   -592.42334   -500.83156   -443.00434   -445.60401    -433.7251   -625.85655   -650.49811   -533.33019   -383.43967   -313.73056   -427.70581   -405.10723    -673.1846   -251.04336   -568.76724   -350.39637   -437.89349          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -37.00    -759.9152   -403.08861   -406.31955   -595.27785   -580.63246   -426.02261    -461.6027   -503.81581   -677.59363   -574.19638    -581.5985   -212.35447   -560.65991    -313.5657   -718.18155    -276.7793    -586.0278   -397.06087   -597.00431          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -36.50   -622.32881   -468.05825    -294.5157   -571.29413   -648.17915   -446.46198   -408.01001    -393.2001   -638.52494   -640.76154   -627.90651   -153.34645    -752.2095   -432.56585   -532.28515   -268.03385   -536.83857   -454.56064   -563.62727   -611.19243          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -36.00   -408.22453   -433.81354   -287.31635   -566.13651   -611.57294   -403.37151   -385.10632    -338.8391   -637.83769   -488.58669   -442.06497    -387.6944   -747.82186    -573.8694   -371.46455   -401.37807   -498.82525   -527.58375   -478.61673    -564.5507          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -35.50   -195.69738   -458.10344   -343.98894   -508.44441   -464.27254   -259.97047   -315.34288   -406.54311   -522.92514   -432.05187   -327.82603   -538.89756   -623.01659    -613.1353   -424.10743    -487.4463   -605.57891   -500.91466   -560.62472   -649.01162   -552.29683          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -35.00    -51.61986    -545.7686   -356.82895   -445.88495   -477.19686   -301.56418    -239.9977   -453.38839   -404.87399   -473.11957   -560.21834   -513.21903   -596.29412   -633.56666   -436.05303   -458.23075   -536.97248   -561.02371   -609.25462   -712.55607   -342.57897          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -34.50   -141.07709   -652.32446   -323.16753     -339.882   -648.70799   -441.07129   -318.93268    -422.2607   -386.15297   -523.84226   -842.91082   -434.17602   -444.81724   -610.84596   -602.57222   -422.62862   -489.37714   -666.73081   -530.29763   -719.86539   -457.87854   -571.90117          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -34.00   -220.03948   -602.56132   -312.47363   -321.67966   -773.98057   -629.28022   -384.45695   -353.41355   -417.79793   -488.56292   -705.97128    -399.2673   -416.61658   -572.56335   -664.72808   -417.44663   -643.53203    -554.5594   -530.28122   -704.24267   -552.33726   -506.20309          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -33.50   -288.59472   -558.98594   -417.74055   -321.58814   -651.64213   -627.14768   -410.52984   -462.57485    -447.3001   -480.63344   -491.92209   -443.78678   -594.81614   -461.56083   -550.68127   -472.47918   -626.95133    -439.9089   -355.50723   -615.55997   -393.78178   -638.19608   -443.00848          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -33.00   -336.06024   -572.50214   -544.39902   -298.79376   -584.42852   -521.08092   -451.36269   -397.50536   -530.45097   -507.24479    -507.4618   -472.55293   -741.07073   -298.42998   -570.68737   -549.43261   -444.61918   -419.80141    -554.1978    -645.9341   -447.49782   -613.55254   -552.64233   -518.12843          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -32.50   -331.86914   -497.88154   -528.03735   -349.04939   -540.72379   -407.28995   -427.26277    -93.83066   -589.25829   -438.41163   -486.32543    -535.8371   -460.59374   -492.17678   -611.88387   -469.85735   -472.74598   -452.14986   -591.14929   -816.25275   -622.17885   -443.27293   -692.63625   -320.31898          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -32.00   -270.72193   -389.31544   -462.84953   -395.17792   -506.33182   -283.37453   -414.74294   -184.80903   -642.02256   -349.61173   -421.29349   -630.42046   -353.00543   -659.69204   -492.93884    -423.9467   -605.00916   -388.49291   -431.57343   -672.98854   -365.63105   -446.04473   -553.87593   -387.53381     -3.96384          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -31.50   -223.16184   -272.48133   -349.44672   -329.66483    -478.5868   -238.99251   -390.40347   -368.54314   -676.06483   -351.24934   -419.18783   -547.83406   -691.47091   -492.00603   -490.69783   -488.40325   -508.18989   -435.75403   -443.29438   -542.16394   -370.35205   -395.76928    -524.0925   -557.33743   -146.47015          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -31.00    -205.5983   -185.11152   -285.08914   -164.21877   -412.88074   -290.62387   -385.73567   -405.81849   -600.64954   -433.14762   -417.98895   -411.38821   -886.81628   -546.76445   -434.05341   -613.15566   -444.09018    -484.8501   -494.99523   -562.73795   -439.36367   -275.75726    -622.2061   -484.85684   -336.71388    307.80236          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -30.50   -188.40366    -153.4209   -223.79855     25.05848   -316.80252   -339.39147   -493.03484   -451.01281   -408.61022   -473.97068    -390.6445   -369.45991   -576.58755   -493.26698   -635.21881   -544.76023   -425.43296   -558.35591   -441.17032   -473.29966   -376.91358   -466.16387    -601.9044    -452.8139   -328.86306    271.92318    650.09466          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -30.00   -172.31842   -176.60273   -102.03358     69.61031   -215.39666   -338.60142   -562.14617   -534.76451   -197.55878   -511.36645   -362.26233   -431.43702   -496.88139   -520.69946   -792.45839   -498.38863   -399.01671   -593.43736   -411.07168   -498.45045   -187.13588    -612.5478    -494.2902   -469.97985   -158.13735    429.80731    836.76616          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -29.50   -233.23526   -267.61512    -46.57541    -93.31525   -316.13216   -271.06385   -515.17719   -442.74206   -265.36314   -356.61416   -406.65881   -579.87562   -530.25425   -494.21783   -508.85248      -455.37   -422.73093   -595.81462   -447.94958   -344.54629   -232.86313   -510.41903   -412.34874   -302.05751      12.2394    277.33651    689.99443     738.9267          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -29.00   -300.58291   -322.67892    -60.04166   -244.02947   -425.08041   -244.25011   -556.66338    -309.2195   -461.74312    -47.94922   -422.31716   -654.77153   -571.28936   -365.60515   -302.40438   -464.19834    -395.2134   -670.38188   -459.14392   -415.62785   -398.56996   -484.12775    -412.8805   -333.45816    -56.69861    311.24953    763.19721    845.60518     68.66308          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -28.50   -392.50715   -309.37017   -139.88248   -386.57886   -465.42732   -301.23442   -588.29631    -231.5878   -536.48998   -232.08162   -403.80988   -487.85322   -531.22732    -382.7279    -247.0571   -555.30849     -373.122   -383.11052   -494.28892   -548.70794   -501.99908   -511.37095   -495.86247   -583.82477   -102.51601    565.87924   1011.31753    845.25418    136.41228   -230.96445          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -28.00   -481.03301   -256.68149   -242.19558   -566.85254   -447.92252   -378.43821   -470.84401   -274.71514   -575.10674   -517.20175   -404.98917   -335.93778   -497.62829   -385.43935    -272.5263   -551.86565   -356.72928   -122.51841   -461.64744   -572.63679   -500.40013   -551.73643   -561.26322   -481.10714   -213.40482    317.87994   1086.13502   1236.26115    369.24809   -137.90658   -554.39932          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -27.50    -539.2661   -199.80133   -308.76114   -675.71086    -452.1373   -419.72488   -451.60622    -381.9162   -640.30276   -615.32105   -365.18411   -349.00219   -406.27529   -347.77394    -323.8505     -438.439   -487.46448    -216.3031   -551.79068    -628.7448   -389.93588    -524.7648   -469.60438   -490.19501    -215.6707    429.08306   1242.37708   1350.57577     325.0766   -256.33944   -506.98616          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -27.00   -570.45735   -147.47918   -336.13876   -640.00318   -501.15556    -458.6669    -507.4006   -457.92189   -579.48865   -503.28948   -271.83559   -393.47215   -377.93062   -261.26031   -269.11304   -491.09559   -581.69652    -449.5632   -669.07264   -470.12111   -510.61155   -418.74734   -325.75296   -308.78052   -230.16213    606.76961   1171.57101   1344.94729    365.23042   -188.54079    -564.3297   -514.04892          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -26.50   -457.21714   -169.14712   -301.76638     -459.476   -517.25996   -518.89258   -523.69824   -415.59614   -541.61359   -394.72301   -246.68958   -404.73742   -496.42293   -344.17138   -477.72003   -277.66956   -468.73696   -510.82461   -686.33304   -410.98215   -569.77094   -440.40881   -487.71767   -419.54657   -218.72788    298.11232   1161.44916   1492.03168    687.51374    -36.02519   -522.11864   -494.05792   -558.22482          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -26.00     -288.442   -237.00917   -248.28262   -309.59265    -445.8851    -515.8947   -481.68359    -336.5975   -459.97202    -488.9034   -407.45568   -446.22153   -625.58943   -383.77743   -453.98168   -287.37043   -445.91151    -540.6656   -538.49156   -539.08749   -494.41053   -529.19069   -575.24633   -596.79772    -99.85317    524.78461   1288.11576   1552.32418    792.30936     48.74909    -447.4424   -554.78279   -575.63018   -507.75648          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -25.50   -186.96627   -372.66701   -175.83428   -276.14775   -302.04117   -376.06108   -389.00321   -409.11446   -472.95195   -608.97781   -462.01755   -422.22953   -473.01798    -493.5833   -270.61913   -396.19649   -379.02224   -529.06775   -436.85632   -549.30543   -403.90206   -486.42989   -394.51002   -447.99212    -86.98998    787.48848   1402.61974   1507.16231    746.91627    -54.34565   -613.27709   -391.94952   -574.74673   -639.59741   -621.25733          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -25.00   -175.74198   -421.76979   -195.31584   -284.72185   -226.83398   -261.23424   -329.56312   -483.76355   -418.04186    -467.8067   -280.02224   -444.52593   -332.38941   -561.93739   -237.92484   -418.06963   -340.70157   -285.08475   -396.42622   -568.37168   -425.91301   -589.01445   -362.92377   -387.72491    -33.27346    861.90515   1356.33189   1359.19083    789.51717    -24.69598   -439.72445   -799.54465   -655.01098   -763.05254   -462.90125    -465.6649          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -24.50    -200.9337   -401.53785   -229.16139   -266.82776   -224.01494    -225.5067   -326.16491   -497.31296   -281.82176   -265.73159    -98.85155   -504.50887    -331.9552   -360.17886   -421.80279   -465.23813     -466.932   -240.10275    -459.6983   -548.63923   -595.43167   -662.27076    -373.9681   -277.67562   -114.76749    659.95401   1596.12972   1370.96482     871.7427    117.97017   -385.13543   -511.46633   -773.83797   -736.71442   -536.41256   -471.55833   -589.74948          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -24.00   -190.34467   -334.24455   -256.16447   -290.39668   -223.67861   -255.22946   -371.90943   -508.62961   -217.99218   -371.76789   -200.95111   -485.57954   -169.68764   -270.04439   -436.34686   -531.03651   -571.85854   -399.05572   -543.16342   -436.17984    -519.0454   -433.12325   -268.14248   -378.42724   -108.28579    677.73215   1759.82359   1745.60201    968.87832    100.53082   -272.42048    -432.3906   -528.55675   -489.35545   -691.69319   -632.58673   -607.13396   -608.95604          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -23.50   -175.81527   -357.41343   -215.21876   -328.40331   -245.45954   -316.66473   -462.34119   -447.91033   -240.45526   -509.43625    -297.6193   -401.66817   -181.93735   -470.67871   -408.41368   -456.19306   -571.81424    -536.3981   -359.70114   -322.31158   -538.43065   -363.93537   -311.06854   -418.67003      4.85538    682.91645   1824.06833   1788.62468   1277.04134    233.17623   -178.28546   -539.50015   -442.23576   -460.48499   -506.38873   -486.77463   -539.21959   -689.36002   -466.72615   -616.75097          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -23.00   -259.55455   -434.96223   -125.35733   -368.40736   -273.04909   -414.01436   -470.34942   -357.47267   -370.33984   -476.27406   -336.87682   -412.89039   -299.40723   -578.08023    -480.0293   -226.10696   -487.39175    -544.5686   -204.91323   -302.12731   -465.45047   -503.76247   -429.08615   -290.34916     83.58453   1000.85907   1599.36705   1832.92097   1306.92783    195.48641   -453.54763   -641.75788   -453.86456   -418.08198   -284.42126   -467.79044   -607.50297   -690.62441    -416.0345   -712.38749   -547.02699          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -22.50   -346.84322     -466.137   -100.48248   -399.09159   -322.25478   -461.27882   -379.69999   -510.65724   -611.10581   -404.89819   -358.89349   -453.91717     -318.285    -384.3474   -545.60681   -122.43557   -476.12008   -533.98625   -170.85152   -318.12125   -362.81627   -504.83893   -372.64521   -261.22398    -40.16326    649.20285   1754.85001   2113.67365   1253.68916    181.47305   -403.43226   -456.50973   -469.65844   -521.95558   -368.78734   -495.46736   -626.40785   -651.25883   -455.10761   -427.32499   -629.80658   -430.40916          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -22.00   -413.06127   -503.95266   -193.90906   -454.98544   -392.92598   -452.23975   -331.38825   -608.61683   -669.92698   -479.40077   -358.39777   -379.84521   -313.50731   -357.21592   -647.64524   -330.40767   -566.85421   -588.84922    -327.4453   -450.90041   -292.98445   -421.97976   -513.30663   -210.72087   -157.02546    543.20814   1861.40761   2020.23523    1379.2288    155.04957    -329.8937   -608.47981   -255.67662   -478.89678   -382.27699   -440.28727   -601.50347    -536.0187   -553.20677   -646.81036   -494.99086   -456.55646   -462.68018          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -21.50   -404.34894   -553.41708   -316.42263   -482.26019   -319.14311    -438.2397   -357.51417   -539.05101   -446.48443    -639.9822   -387.62201   -318.80535   -285.76055   -443.84743   -679.11424    -534.5184   -570.58091   -434.81436   -429.54108   -453.66677   -338.67733   -350.14957   -479.87063   -301.56481     20.91238    713.09076   1994.47139   2051.67694   1540.81279    242.46206   -218.72212   -459.84605   -534.57448   -372.72457   -280.56205   -499.51436   -410.96821   -482.34096   -521.49816   -652.13009    -622.7677   -512.77694   -679.60547    -604.3037   -648.32974          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -21.00    -453.7302   -607.49127   -321.95929   -459.48349   -206.60313   -388.98206   -360.07321   -431.28525   -333.07713   -674.74127   -440.90016   -336.41948   -312.87517   -393.61631   -621.80586   -674.93756   -529.04106   -263.27978   -379.93836    -288.9744   -314.56607   -280.61333    -194.0241   -321.03524    -17.63987    627.34263   2031.98585   2335.63548   1518.01929    132.28718   -172.55163    -396.1334   -468.75417   -522.24367   -275.76625   -373.63397   -552.96149    -465.7595   -529.51111   -475.96793    -465.6473   -576.95096    -596.3065   -527.53801   -761.40344   -561.98354          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -20.50   -553.21942   -495.21845   -255.12402   -457.96448   -179.66189   -250.80841   -393.08168   -385.97112    -316.7391   -580.12173   -468.97905   -345.47585   -388.11258   -254.23278   -578.62797   -525.07456   -490.87092    -268.9452   -392.53379   -349.43488   -304.16918   -331.85035   -371.02059     -35.1782   -133.86877    502.41622   1941.29684   2558.68592   1266.94554    298.50582    -43.74669   -318.82502   -402.67195   -328.63083   -262.78336   -538.05292   -503.40832   -561.65637   -537.69355   -581.37581   -542.74819   -565.64012   -619.24982   -662.19076   -495.83439   -635.50675   -540.18317   -776.79732          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -20.00   -606.79421   -438.72108   -157.16875   -434.53714    -226.6931   -172.97728   -384.80177   -373.96956   -269.33908   -490.03615   -436.22778   -316.92729   -361.18153   -303.55977   -447.12106   -453.92164   -443.99342   -247.53571   -462.69582   -402.00064   -275.53877   -483.03754   -571.24412   -236.74744    -10.97578    557.02392    2002.7707   2467.89234   1178.40407    443.34834   -158.47648    -300.6645   -527.03618    -327.6897   -411.04948   -595.89165   -590.77682   -488.89375   -490.68093   -603.51512   -616.81918   -647.57329   -784.89674   -555.73327   -354.14997   -448.38799   -669.84628   -609.04252    -604.2092   -515.60185          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -19.50   -631.49847   -445.44888   -304.91009   -385.79853   -308.19238   -264.97152   -327.53682   -368.67216   -463.88129   -295.36973   -404.58978   -273.63699   -202.78679   -411.18313   -404.44784   -381.84595   -311.04687   -261.02966   -358.65176   -461.67227   -355.86783   -439.38585   -521.08555   -337.30847     -36.2368   1069.21651   2149.62273   2798.28849   1568.72538    375.33954   -229.78422   -283.04486   -463.26346   -442.31273   -585.08936   -544.36635   -482.67895   -571.81505   -436.63397   -578.61462    -549.4122   -483.04283   -678.88997   -431.57137   -564.86616   -469.21482   -730.61569   -671.48063   -694.19688    -593.3181   -669.78705          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -19.00   -578.32609    -474.8397    -484.7779    -344.9233   -385.27866   -420.95309   -277.00639    -436.2346   -691.17358   -241.90853   -285.44412    -140.1459   -177.40798   -351.80646   -369.04489   -357.43426   -185.68529   -449.12671   -278.82508   -517.66999   -709.20928   -441.54199   -520.40398   -210.35837    -54.88782    847.27556   2004.19748   2696.46814   1622.76837    317.80971   -224.58099   -493.73641   -254.93522   -473.28348   -423.48404   -467.02686   -464.80924   -350.75373   -412.26235   -552.03335   -658.74428   -489.28649   -558.45036   -659.43409   -593.18697   -670.08869   -586.43546   -681.20913    -596.7934   -682.45305   -770.83896   -435.44266   -622.01713          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -18.50   -432.51851   -486.20597   -583.23069   -405.53508   -402.80431   -542.35238   -300.29136   -401.72937   -615.95032   -369.65502   -167.89986   -108.11762   -588.44025   -301.27971   -452.91694   -432.88453   -196.47196   -431.09736   -233.29082   -459.20477     -526.074   -526.28468   -525.94767    -209.6761   -146.40976    709.46112   2300.80071   2704.24462   1828.95896    411.24806   -197.18082   -464.90652   -229.90793   -386.14666    -413.6424   -400.37207    -487.4396   -589.26029   -450.81429   -396.55362   -328.06205   -600.67109   -552.02019   -781.04819    -522.5856    -520.5826   -496.19344   -588.26939   -574.77095   -656.23634   -752.74232   -604.89561   -416.31278   -418.69106   -420.29739          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -18.00   -332.86202   -533.65358   -309.55158   -419.05725   -322.29201     -510.974   -312.96313   -292.42019   -436.78269   -406.76861   -282.41373   -158.83606    -674.8684   -427.04704   -625.34623   -449.39994   -500.05576   -367.82449   -355.53035   -374.01409   -404.49704   -503.07361   -402.00075   -283.49993   -216.65054    668.03204   2173.92683   3079.65504   1984.20775    409.66757     -96.2877   -384.99095   -309.62455   -410.48017   -421.85059   -429.65695   -424.81998   -459.23604   -392.30007    -479.4045   -493.31267   -594.10727   -610.71949   -471.56036   -506.43559   -616.25152   -471.01188   -790.06921   -583.64538   -660.01623   -462.78113   -484.53146   -552.11925   -646.30681    -557.2254   -753.99983   -384.31349          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -17.50   -290.36587   -536.42345    -79.68767   -380.14235   -205.88939   -396.15386   -309.27973     -201.229   -355.72711   -333.49536   -421.06313   -264.09238   -387.41181   -496.28377   -494.73323   -372.55456   -616.77883   -373.33541   -493.54812    -331.6429   -441.62122   -421.64958   -301.92812   -275.04414   -164.15944    908.39029   2222.69971   3202.76807   2045.54924    607.09756   -205.55561   -229.61036   -324.90902   -197.90688   -468.64865    -451.1599   -330.32431    -293.3827   -376.84239   -463.30543   -378.87886   -410.33955   -541.31334   -536.25346   -411.95866    -539.2182   -504.56395   -590.36193   -603.62945   -546.11522   -673.35682   -507.68546   -569.56135   -603.86347   -518.07806    -566.5664   -473.11166   -673.69077    -528.5936          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -17.00   -359.82652    -503.7039    -48.79794   -366.61365   -129.50547   -288.80768    -367.4624    -56.97612   -264.46477   -268.36546   -482.31643   -341.75912   -275.19979   -444.88832   -381.06445   -402.49438   -539.91808   -357.76077   -424.85638   -245.15137   -187.46616   -369.24525   -358.69321   -279.15168    -67.37581    933.86348   2477.52871   3157.75158   1714.40147    682.02458   -147.64086   -312.12561   -317.50388    -308.7061   -471.45014   -521.59861   -290.77207   -461.35879   -413.48838   -481.68377    -367.8263   -321.44286   -549.24456   -346.29982   -488.45709   -689.61131    -459.2413    -539.6499   -543.83537   -311.94094   -537.83337   -506.56981   -542.20025   -582.93972   -550.19619   -687.71778   -455.81168   -546.46462   -567.70941   -657.26478   -574.83304   -596.92529          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -16.50   -337.86934   -450.63983   -148.04354   -370.27593   -307.45004   -244.04189   -368.16572     89.16002    -199.3542   -259.20908    -522.9325   -450.34478   -132.20728   -301.03861   -501.95784   -357.43954   -219.56922   -337.50352   -310.52809   -263.29764   -144.89873   -237.41557   -314.55654   -289.53502     76.63247    910.99344   2358.76659   3057.00956   2134.63114    721.37631   -174.47567   -352.69878   -288.36762   -368.50331    -447.5537   -470.80382     -444.204   -366.69785   -418.27273   -467.61008   -348.10066   -484.19938   -414.72684   -467.59951    -494.8764   -533.68745   -457.35388   -653.04993   -603.02488   -558.06666   -611.79851   -583.46981   -476.94104   -607.54007   -596.27015   -552.95235   -437.40421   -483.34856   -438.09497   -576.83007   -689.61565   -529.40954   -444.93529   -559.71497          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -16.00   -233.71267   -430.04205   -207.05003    -282.1046   -441.90308   -331.97029   -333.90759     24.57569   -381.80778   -216.12986   -498.12452   -607.86116    -66.25713    -42.19653   -450.72746   -437.02777   -135.11912   -385.10642   -301.37786   -257.52429   -478.44425   -259.92187   -305.91908   -373.94402     104.7832    898.76087   2633.06103   3123.74023   2228.56043    948.13385   -140.12397   -430.85671   -317.54334   -190.84113   -494.62556   -420.54377     -490.176   -239.82219   -519.12653   -332.03227   -404.29989   -510.56043   -291.28519   -500.11054   -504.80145   -457.97686   -536.75654   -554.83227   -634.80928   -545.16813   -596.42589   -583.40872   -476.08494   -609.04363   -494.85942   -514.92431   -557.23465   -525.94608    -483.1442   -458.82912   -648.57901   -555.37727   -636.64168    -638.3438   -597.15592   -571.85381   -545.79891          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -15.50   -171.32104   -436.26043   -223.73203   -246.88328   -489.66577   -445.42093   -335.79988   -310.35079     -514.855   -221.21668   -446.93713    -492.8456   -113.01503   -150.20473    -99.64436   -533.40565   -322.65944   -361.55272   -361.88171   -359.83274   -273.19282   -354.55276   -475.97715   -369.67604       4.7018    982.47027   2678.37777   3266.65718    2291.6341    566.37109    -33.31655   -306.39845   -310.33022   -413.11994   -422.91657   -448.99664   -459.06435   -270.12316   -343.42019   -209.74463   -708.39005   -548.11877   -626.53815   -603.31996   -377.36307   -539.73569   -600.94667   -597.79803   -370.07306   -587.51268   -616.79193   -592.64854   -317.61832   -558.42966   -499.73019   -650.07743   -465.14713   -476.70517   -515.30822   -549.60812   -503.67528    -580.8382   -519.91026   -612.67942   -574.78188   -552.92123   -532.01759   -646.01084   -539.26865          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -15.00   -167.47619   -479.67958   -260.64123   -309.13451   -532.79931   -462.72838   -426.98727   -532.05635   -485.83145   -249.27365   -245.76512   -351.36499   -214.74394   -497.71618   -143.51769   -537.58294   -216.76291   -227.98188   -333.78889   -448.79897   -280.31436   -300.96928   -458.09705   -170.90991   -109.40009    977.04213   2451.86462   3413.42734   2291.82443    710.73075    -52.46202   -305.20901    -341.2244   -402.17814   -427.09547   -392.14517   -457.49551   -364.95763   -420.49827   -329.61381     -405.754   -342.95779   -435.27818   -568.86643    -451.4652    -574.0811   -578.34642   -578.71659   -393.08868    -486.4415    -639.3593   -595.09478    -446.9715   -506.87148   -655.58498   -589.97712   -568.75558   -599.57107   -548.11428   -487.99608   -334.74145   -732.59468    -247.6186   -582.01423   -464.24977   -641.55332   -562.80451   -481.75872   -528.33301   -303.17199   -281.63725    146.63378          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -14.50   -238.10164   -515.79521   -328.15266   -463.04229   -594.90294   -283.87655    -501.6268   -448.46157   -383.59519   -331.03933   -123.29186   -405.80546   -322.00975   -399.86546   -360.14898   -520.86153     68.20692   -372.64801   -362.72873   -402.53892   -449.05882   -411.44599   -188.43722    -244.5341    -39.57791    912.85009   2466.50312   3398.66018   2443.65288   1011.72891   -123.00878   -337.82402   -172.89826   -333.78517   -517.78918   -382.16698   -429.84351   -421.21564   -322.58519   -406.04976    -265.7888   -411.66864   -425.69128   -385.19699   -392.21196   -451.17321   -374.77144   -487.94222    -453.6501   -564.54834   -490.32535   -485.56783    -738.9919   -446.27962   -442.89492   -618.42295   -502.21853   -478.67949    -534.8055   -376.51486   -523.64489   -510.58231   -525.23985   -591.81168   -531.63307   -425.55027   -468.44865   -629.95461   -592.02366   -523.29054   -208.06101    412.04896    328.22991     32.30775   -269.18657   -632.36718          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -14.00   -437.36299   -517.95195   -446.02187   -630.62602   -383.16011    -99.64912   -264.58969   -412.76449   -256.98307   -366.80586   -275.28838   -477.36689   -447.26763   -360.17474   -414.16256    -457.5366   -200.31788   -475.22584   -276.59553   -356.22913   -420.29494   -461.99348   -314.60256   -325.72239     68.25439    971.02042   2471.48349   3456.04518    2607.3286   1069.77936    162.28084   -406.42524   -291.90852   -271.07344   -601.66115   -458.91414   -469.34279   -324.64711   -467.75807   -363.15178   -258.28499   -577.16551   -481.18187   -480.74186   -360.76244   -482.97306   -388.01516   -599.00785   -579.22202   -578.11516    -693.3071   -505.02563   -564.68349   -549.77622    -429.4909   -695.37661   -435.96879   -541.92199   -490.01385   -568.64394   -632.42687   -559.48828   -391.35684   -487.26688   -428.43017   -460.24688   -437.89166   -574.33426   -425.99542   -251.66739    142.82656     389.5409    435.27255    184.34523    -86.82842   -268.31996   -539.87096   -535.93936   -506.11438          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -13.50   -596.43674   -453.53953   -545.17944   -512.86892   -114.92379   -251.03458      -4.6103   -456.85959   -213.65185   -257.30074   -450.00022   -450.58899   -472.24855   -306.97139   -376.61123   -450.53788   -353.87696   -452.84141   -262.85785   -401.90376   -478.23406   -229.20174   -463.32344   -299.45602     12.03956   1146.14844   2528.40705   3539.21215   2550.76333   1022.17851      5.43162   -286.20854   -464.45822   -282.38344   -211.94208   -426.81341    -256.7966   -353.19394   -512.31438   -284.33611   -350.33651   -252.94297   -383.51386   -415.11858   -366.85019   -298.30269    -478.7926   -540.35685   -354.03383     -586.078   -416.39306    -436.2969   -490.70235   -497.56061   -367.58329   -461.23004   -438.97014   -419.57704   -259.57529   -501.84364   -547.82091   -561.49658   -614.42225   -487.73842   -651.38678    -494.4505   -629.93019      -460.03   -375.04437   -201.91573    148.74229    303.00359    643.81543    333.46978     -74.1432    -300.2303   -442.10476   -385.14937    -564.0679   -465.77821   -507.26639   -536.35205   -557.08704          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -13.00   -662.50193   -386.59749   -543.80671   -286.29934    -88.86235   -464.97127      5.27337   -488.58583   -372.45623   -176.39393   -472.92755   -353.22719   -354.20989   -297.70353   -293.02842   -366.76654   -389.10447   -448.15526   -350.61199   -407.79644   -527.27066     -244.106   -486.41751   -369.97243     11.57213   1070.69011   2672.70242   3557.84951   2744.27467   1008.32375     36.71359   -190.13019     -293.467   -367.25915    -229.9391   -367.82175   -477.33284   -398.71128   -346.90602   -415.48782   -391.56293   -298.49673   -563.11977   -399.53711   -405.14932   -354.29921   -396.00998   -478.40945   -307.48761   -298.90686   -427.31622   -355.51954     -686.633   -452.27223   -478.02811   -452.54477    -462.9564   -312.38565   -366.56663   -595.31662   -358.39281   -403.71785   -559.56322   -519.16378   -478.99002   -640.04016   -482.84765   -519.68945   -247.60649   -376.38978    352.45894    696.19405    691.06841    492.87578     58.49953    -192.7039   -389.15706    -343.6286   -466.83107   -732.23528   -550.51738     -409.376   -520.22852   -548.27994   -522.95282   -621.24169   -596.72286          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -12.50   -539.64641   -334.93681   -447.11596   -197.24121   -187.50821   -487.61357    -29.68517   -425.44907   -551.09749   -236.86076   -408.40611   -107.80357   -240.16683   -374.83886    -304.3637    -151.3321   -244.47574   -491.55747   -430.68745   -405.94426   -417.45437    -326.1382   -292.19215   -349.29226    157.65922   1017.46518    2801.1657   3697.91768    2936.0999   1089.68736    -13.98981   -129.47775   -267.99609   -414.29462   -370.49168   -354.31697   -434.57069   -265.27266   -409.47259   -412.46809   -624.63746   -433.71963   -591.05331   -369.05481    -418.0611   -589.03176   -455.81941   -414.80248   -368.86731   -294.14157   -465.83002   -332.82739   -637.22358   -520.36586   -523.83859   -560.82231   -456.72406   -429.59265   -379.49971   -193.45922   -379.43063   -461.28844   -447.97093   -366.59278   -366.48042   -383.06674   -492.72093   -420.35065   -464.48184   -157.02573    137.17638     617.0299    851.78784    553.67068    152.48224      0.95608   -294.56885   -376.26679   -452.24164   -502.67779   -578.56132   -435.53169   -545.18463    -441.4674   -547.96857   -554.98619   -640.58342   -471.03331   -410.06519   -202.52825    239.54014          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -12.00   -439.22327   -308.77364   -359.70109   -338.42674   -242.26283    -357.2031   -145.17081   -365.41669   -397.60269   -272.79324   -257.76272    -14.17524    -65.84964   -347.74563   -288.90531   -329.84708    -84.09927   -337.21403   -405.25171    -406.8227   -438.76929    -392.3246   -470.90008   -280.94304     105.4198    879.78477   2930.99347   3735.01159   2861.86831   1266.74911   -130.58409    -89.65722   -303.17623   -413.32416   -279.64649   -454.80274   -270.16933   -181.90817   -531.17824   -449.43783   -346.25517   -431.01157   -460.62074   -334.35062   -344.88639   -442.22528   -499.55072    -345.1012   -400.53746   -422.17195   -407.36632   -487.45104   -448.57976   -397.79545    -374.2395   -442.36475   -500.23276   -657.62799   -271.86589   -195.14333   -352.85855   -324.35559   -533.05845   -348.74619   -541.83334   -288.53551   -504.71993   -497.12232    -404.7127   -165.98299    130.78695    865.94101   1011.15766      787.964    263.38025     67.60801   -219.09963   -272.29603     -416.183   -516.93877   -431.50221   -524.42474   -463.68752   -405.09283   -490.40729   -408.60438   -587.30696   -399.42427   -306.87916    -56.12847    329.58158    618.14582    509.96618      3.07877   -208.28753   -373.05218          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -11.50   -398.76696   -299.58898    -363.6089   -470.10054   -256.45623   -260.49724   -355.48957    -335.1682   -252.44361   -423.07466   -182.31668   -262.86551    -36.34253   -244.04842   -432.83592   -527.98454   -257.31886   -218.46792   -140.94826    -386.4223   -525.46591   -403.12597   -502.69631   -172.57412    135.02958    732.52766   2688.45672   3609.00873   2958.93962   1407.17143     73.71632   -102.86782   -295.52485   -596.48704   -398.61402   -560.03726   -196.30798   -149.38925   -571.63795   -560.64695   -456.76116   -507.53588   -488.05383    -368.3284   -379.20335   -437.02624     -411.824   -310.76248   -257.85993   -427.56496   -423.27028   -340.87292   -477.33112   -414.99641   -496.08298   -568.08476   -170.87099   -528.24779   -386.08678   -304.77316   -423.30813   -386.53694   -403.33722   -563.77815   -318.27713   -580.33689    -332.3915   -523.11454   -406.00716   -222.60384    262.03106   1033.42111   1285.69381   1003.21813    288.68069     34.40845   -210.53632   -396.99034   -493.20124   -375.18008    -584.6177   -532.00287   -496.83243   -529.62739   -524.50623   -449.78968   -460.40935   -423.96347   -322.91488    -57.63618    594.32068    882.89419    762.27864    285.00464    -13.75007   -344.10105   -623.27954   -570.68863   -515.93863   -510.09458   -551.89684          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -11.00   -462.37265   -308.62189   -418.94806   -441.00608   -280.88942   -316.38209    -448.0153   -297.25747   -310.72808   -571.51033   -316.53172   -401.16693   -175.56855   -310.60135   -587.33078   -272.38924   -318.03274   -248.68797   -144.30533   -330.03232   -569.21067   -383.56814   -188.96478   -365.09898    194.85148    988.23079   2864.81136   3540.48135   2973.36162   1395.80874    234.99801     -166.158   -326.31061   -294.54984   -423.40953   -433.60676   -274.75619   -223.44417   -353.56978    -367.6942   -216.12518   -339.12582   -596.51419   -585.74715   -451.21776   -382.64692   -568.76703   -419.40187   -432.01203   -476.74743    -602.9242     -798.577   -451.99157   -479.06387    -396.2399   -483.21107   -343.44359   -413.01429   -387.80993   -340.58285   -384.46741   -350.65264   -315.48358    -363.9829   -451.56021   -562.15299   -528.42179   -434.94558   -422.55531    -233.3422    465.95496   1170.79631   1170.56276    999.72213     427.6404    205.63316    -20.80913   -142.49715   -459.37668   -560.14741   -564.50167   -634.28505   -387.41427   -406.18323   -478.50157   -414.53053   -451.98231   -403.52387   -285.65101    173.95017    583.86548    985.55193    735.43066    584.11923     66.91394   -213.81998   -483.02509   -419.74917   -385.80905   -394.04995   -304.01216   -325.26563    -390.3391   -396.93582   -488.76923    -530.9485   -595.83239          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -10.50   -541.63432   -337.72594   -490.66413   -355.59599   -336.65758   -392.79606   -332.63531   -261.60285    -389.3182     -450.283   -375.30397    -397.2283   -307.55362   -364.41052   -430.48335   -336.67082   -165.42702   -276.61665   -140.72457   -250.55206   -522.95784   -351.67349   -229.38071   -391.12608    239.75103    810.85899   3135.50582   3801.33619   3052.87668   1310.53093     75.10188   -207.86697   -284.30076   -396.23531   -314.64331   -526.23277   -330.27946   -256.54404   -428.29205   -407.73255   -322.91728   -581.35566   -527.73098   -575.00112   -426.18523   -421.26065   -640.83489    -287.3244   -377.29585   -424.34171   -553.78856   -510.58827   -488.76502   -353.52403   -299.69916   -354.65018   -455.47912   -325.38108   -217.73685   -378.65844     -344.778   -381.27506   -290.41206   -366.47943   -391.01734   -445.69906   -473.92104   -495.08711      -369.19    -62.22253    390.24963   1179.61594   1335.33727   1065.16663    569.67914    170.36553    -67.02344    -279.9228   -472.49663   -609.46636   -622.31303   -612.55156   -456.31892   -442.78245   -486.00086   -364.13622   -564.80435   -413.72506   -281.78088    121.60011    882.75586   1245.96314   1189.84072    610.07903    146.16584   -276.16612   -386.27177   -478.70176   -441.82384   -518.57199   -298.43316   -232.94172   -247.26981   -288.48734   -363.30384   -425.02474   -451.53397   -509.18171   -598.10657   -616.05994   -570.39926   -676.53154    -585.8089          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
      -10.00   -637.66038   -370.78613   -477.15502   -275.95943   -387.92935   -348.07827   -279.45811   -242.92229   -325.20496   -293.31874   -217.70263   -432.19986   -435.86209   -473.98885   -368.31183   -584.50662   -506.82396   -270.16934   -152.20903   -288.72612   -441.74044   -463.20146   -342.15009   -156.49202    277.12597     843.3279    2989.5484   4147.23531   3151.39701   1227.33807     160.9589   -178.26835   -163.05487   -426.20029   -207.33987   -282.33875   -405.20949   -386.29892   -220.23662   -405.42897   -392.53286   -495.78292   -411.52037   -457.96269   -223.54878   -406.53762    -478.4923   -270.13598   -423.05937   -392.69331   -327.13544   -318.62912   -507.20666   -433.14745   -406.50838   -497.28685   -533.34001   -167.08046   -311.10923   -403.66001   -456.59547   -422.25535   -290.81968   -407.89275   -541.70666   -530.55609   -468.26979   -313.66089   -249.95871    -60.49743    352.00559    957.70256   1694.38619   1268.11363    707.77105    218.06381   -105.06466   -233.82031   -456.39959   -469.60052   -545.66548   -319.49922   -448.92457   -407.78724   -380.43041   -369.56443     -474.254   -332.30443   -136.37969    288.89801    945.48409   1400.04614   1326.35691    913.90159    100.43401   -273.97884   -356.13419   -404.12509   -528.42327   -432.74589   -344.84952   -336.47992    -98.49879   -152.46604    -306.4479   -348.20291   -561.20261   -542.81455   -512.73562   -516.54831   -582.89399   -475.66001   -452.69381    -382.8401   -533.61748   -559.29617   -541.76275   -572.61012   -461.70105   -478.02462   -484.07772          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -9.50   -724.22385   -406.19165   -431.16843   -244.20856   -383.75221   -271.43685   -231.00503   -273.55148   -204.50808    -272.9182   -146.54319   -506.40319   -465.71113   -506.61051   -401.12947   -555.44011   -623.52146   -211.58086   -108.86104   -338.49928    -313.5772   -377.64217   -322.09596    -52.19344    339.06784   1088.12623   2584.80983    4102.1832    3320.6924   1125.67772    182.48785    -99.64406   -274.70195   -337.95587   -304.37527   -225.84767   -421.99733   -353.37993   -459.84124   -313.37732   -434.00296   -628.89607   -425.93787   -454.60877   -467.74904   -457.41711   -371.76783   -472.08434   -417.30389   -316.87895   -385.94525   -227.00339   -487.69165    -355.9449   -585.20577   -409.54383    -291.1575   -269.41128    -270.7004   -251.23238   -383.91934   -381.89801   -307.18066   -300.34179   -353.43589    -443.6969   -331.57833   -392.07914   -190.48539   -113.33318    454.26232   1212.21051   1615.58739   1338.86416    727.91218     60.62674    -71.77775   -284.07356   -414.38354   -531.40148   -441.96833   -542.76764   -428.12997   -307.75846   -265.71085   -292.27827   -479.98904    -353.2771   -212.12039    215.13528    966.45503   1642.03347   1463.86126   1036.99139    438.92071    -26.13971   -278.11459   -419.55217   -396.65672    -458.5914    -405.6838   -244.29823    -73.92649    -177.2597   -433.24885   -245.32282   -523.58923   -498.93611   -289.03714   -519.41088   -632.21711   -476.12122   -471.90442   -632.51218    -615.9222   -564.05519   -355.52177   -485.67906   -400.36291   -492.21908   -451.52042    -501.7416   -620.06338   -415.01601   -473.69568   -123.05216      8.47486   -236.44078   -445.69018          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -9.00   -788.38547   -424.40378   -404.69359   -223.32704   -302.44936   -276.04554   -112.80563   -367.50251   -161.79656   -262.11213   -227.04044   -353.40019    -447.7693   -370.51923   -357.38559   -507.50874   -361.78815   -289.71998    -93.68197   -325.12845   -397.46304   -350.83388   -166.19645   -185.53481    256.57182   1087.32654   2952.15103   4056.46883   3313.10252   1508.53182     54.15918   -356.78884   -243.00071   -242.58872   -294.35241    -92.82553   -257.74672   -499.05544    -308.1674   -436.42812   -357.03803   -195.96081   -431.63914   -323.15523   -548.88853   -491.81675   -441.06986    -524.3356   -422.80946   -380.56727   -500.90233   -274.65035   -363.35676   -298.42696   -486.67011   -355.07378   -393.43622   -349.53356    -372.8348    -244.1862    -345.7099   -441.04982   -274.28017   -314.57075   -354.70905   -466.64349   -423.32486   -439.66503   -490.31988   -148.04559    444.66941   1080.44071   1563.10553   1264.32934    746.33339    132.97131      2.89301    -54.42772    -85.85059   -430.35003   -474.85736   -483.37722    -183.3647    -314.3902   -563.58031   -422.56616   -516.84959   -495.54472    -92.98081    389.07358   1050.18067   1513.49052   1882.85712    1234.5303       447.13     39.86232   -301.28291   -434.95531   -360.93423   -359.25266    -171.0187   -138.52612   -221.42931   -195.36746   -303.79664   -386.93482     -480.011   -509.74216   -456.72443   -448.90262   -553.28479   -544.64574   -607.03466   -495.32023   -500.76715   -414.05082   -264.17645   -494.37822   -414.37702   -593.58418   -453.61674   -566.85553   -288.20841   -311.15634    -215.6862    -57.37254     49.24781    -38.27203   -164.52636   -271.74223   -305.34954   -611.91504   -542.04889    -464.5921   -517.15587   -311.47218   -334.66353    272.23775          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -8.50   -664.72189   -420.94875    -422.1859     -89.8534   -214.69064   -346.08966   -159.45178   -410.36121   -159.91363   -252.10636   -271.53825   -113.96943    -434.3519   -317.30154   -312.53693   -353.98443   -332.36437   -332.39066    -62.70839   -277.34539   -442.18883   -471.81606      -138.98   -224.93942     19.33526   1092.15899   2996.04948   4218.36855   3179.77168   1405.33605    -42.74927    -291.8933   -384.83857   -308.21389    -12.73515   -350.27912   -306.39346    -395.0095   -365.49983   -472.29174   -319.57907   -220.21891    -660.3791   -285.57181   -609.01384   -545.28465   -444.60931   -473.98889   -416.75878   -278.03846   -486.63066   -560.84685   -504.15906   -402.16708   -360.32336   -355.41977   -309.37377   -165.91152   -316.85108   -349.32985   -250.22381   -307.60441   -419.63615   -280.44406   -467.47176   -282.26372   -281.49703   -218.89509   -331.30078   -154.52927    332.74219   1193.35745   1728.15226   1276.33806    745.37171    236.92673     -3.44484   -128.62201   -212.61215   -474.81964   -377.23829   -377.17669   -248.34111   -293.24725    -420.5336   -349.02191   -452.26685   -117.91414   -180.09393    419.92527   1319.10678   1836.79613   2076.56183   1352.59025    604.51999     152.0467   -282.50844   -251.86409    -262.6361    -330.2043   -226.37109    -27.07259   -236.92791    -33.62316   -401.27621    -318.9621   -367.67762   -294.81074   -494.25983   -600.34216   -564.14321   -480.26161   -428.68653   -528.73121   -425.76355   -508.89419   -410.58437   -481.75722   -465.88432   -377.67946   -461.01505   -534.32185   -420.95898   -405.83395      -3.7218     14.43596     84.52004    -23.75832    -26.73785   -223.77783   -378.25129   -481.82365   -470.40289   -408.49624   -486.17355   -315.14139    -54.45409    190.79174    789.49686    738.78611    774.92299    507.78008    162.31171   -269.84435    -195.7805   -301.18978   -454.61743   -463.25684          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -8.00   -383.35512   -365.51641   -450.00434    123.86341   -286.75136   -402.31696   -258.44724   -310.27726   -176.86667   -262.36442   -317.60873   -314.52799    -444.2116   -347.64011   -341.05656   -401.86612   -320.18285   -168.13568   -139.46613   -297.11856   -393.53782   -346.97927    -147.0587   -205.12939    116.34503    986.53802   3030.17478   4285.34145   3476.59342   1395.91875      -18.722   -103.53266   -258.03322   -479.94334   -110.28573   -116.18398   -441.44327   -138.00977   -523.42215   -373.72832   -538.49727   -274.93104    -459.4781   -275.18616   -195.61281   -361.36175   -432.24348   -389.72506   -520.05453   -240.81305   -498.67051   -501.28342   -327.69579   -327.26893   -480.65069   -551.99736   -387.39042   -258.65474   -329.39865   -198.55718   -442.68221   -279.06916   -497.78731   -354.73649   -161.93928   -524.90682   -488.93209   -305.08955   -261.99045   -136.82965    626.89724   1363.22528   1661.30366   1429.93352    914.53197    268.74581      -54.413   -104.78057   -190.41482   -403.79362   -291.86755   -382.84198   -363.39233   -160.43617   -305.36066   -320.38232   -336.99164   -415.23203    -63.12649    428.94979   1321.05403   2007.59987   2079.86846   1456.89114    631.93331    -53.60518   -360.20121   -291.67645   -353.92494   -401.33984   -247.81723    -45.97147   -262.97495   -138.83083   -277.33406   -356.52431   -383.26365   -496.37649   -506.80022    -634.4546   -461.69389   -422.18935   -383.14725   -563.29876     -412.724   -386.42946   -448.61618     -524.759   -491.22969   -482.41249   -537.51483   -521.53276   -246.50771    -249.0557    -16.21068     94.38845     66.90528     37.54835   -180.97278   -310.05879   -331.50322   -408.25684   -602.14857   -500.54163   -380.35575   -369.75909     -1.47019    318.16966    859.12751   1248.40937   1009.66239     829.4369    342.33076    118.56919    -184.9825   -298.81479   -302.41655   -293.24299   -370.98414   -399.29304   -496.52553   -498.61333   -572.55645   -458.22123   -507.71173   -640.56262   -563.73675   -532.83713   -580.01428   -521.43772          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -7.50    -99.98236   -307.66524   -371.22912    297.77142   -404.39309   -411.42404   -301.08144   -196.52247   -203.43397   -331.83079   -403.16385   -624.97467   -437.21014   -383.09539   -362.49105   -533.83129   -179.09797   -129.60489   -196.14157    -432.8911   -257.37009   -356.96919   -205.80165   -198.24009    -39.75391    944.12314   3207.99368   4334.71951    3521.4352   1537.49315    314.99059   -315.30826   -252.40149   -501.28287    -238.7404   -238.11259   -358.30019   -311.66525   -418.12298   -443.16636   -484.60654   -286.67049   -352.96807   -344.68171    -283.9049   -369.58264   -450.13603     -450.169   -419.31151   -372.26437   -273.57736   -501.44076   -371.71969   -347.46519   -454.73595   -476.72801   -286.14111   -347.23476   -527.51111   -113.69226   -385.56162   -357.18876   -403.16107   -479.15412   -398.90209   -380.73535   -232.87464   -525.69992   -295.02716    -54.93213    456.48876    1369.6552   1711.46256   1591.68787    921.71927    246.11828     -38.6554    -68.14739   -164.86234    -214.7112   -322.00593   -417.65786   -294.20363   -365.94664   -320.79238   -388.01595   -245.74426   -299.13849   -168.97941    356.72614   1182.43764   1895.70903   2054.61429   1348.30821    869.45473     85.29073   -239.15391   -321.27817   -271.03316   -428.51282     -215.071    -55.21834    -78.98101   -113.94685    -234.7267   -284.87409   -313.53941   -510.49784   -489.58613   -542.17555   -549.05618    -471.4043   -456.43651   -377.98057   -526.79231   -509.52988   -329.56819   -406.08744   -367.85945   -350.72816   -399.50418   -477.71319   -319.40519   -481.01902     77.44582     96.57639    129.10805    176.73347     67.55609   -233.90571   -320.32896   -319.16641   -473.20225   -342.48941   -488.72379   -307.82236     42.46883    460.14796    864.00043   1289.46655   1121.13959   1129.48028    392.19841    203.59352    -80.88281   -119.05365   -300.59833   -370.51579   -382.13878   -488.58996   -455.38468   -427.85331   -666.32549   -555.92253   -757.59017   -489.48097   -471.18553   -592.19872   -418.51471   -645.98856   -484.82707   -528.49568   -533.67849   -517.67925   -303.68255   -542.59308   -437.57966   -349.29711   -405.16787    -537.2779   -649.71195   -619.22065   -711.59899   -527.04638          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -7.00   -173.52587   -266.45646   -277.15682    207.86617   -412.23387   -412.31958   -307.39869   -158.34428   -278.88292   -417.99121   -531.72101   -303.44379   -431.05751   -449.98359   -396.13707   -426.81953   -115.28836   -219.46576   -246.49513   -238.14252   -166.38329   -428.01579   -329.32473   -189.90637   -108.30635    986.67385    3302.6944   4258.44642   3594.66021   1643.42212    219.92107   -283.91866   -331.57195   -374.02979    -271.8581   -416.49235   -216.81278   -254.09503   -388.86046   -353.96065   -423.83427   -348.38715   -134.30752   -373.98681   -365.57726   -260.09017   -468.57391   -344.34712    -316.7928   -479.62911   -392.31926   -392.43116   -361.98991   -468.31039   -424.25802   -491.43563   -252.89846   -356.98034   -306.30183   -404.45411   -291.66093   -378.44798   -285.01164   -468.33102   -454.56299   -404.65012   -360.89613   -426.38282    -455.0396    166.07589    606.84317   1390.83447   1717.89191   1817.32086    998.86791    404.24149     70.58971    -45.75089      20.0149    -85.85726   -426.23775   -263.39943   -437.19989   -307.26294   -403.32501   -664.13903   -296.34746   -128.13062     81.71712    444.25074    1589.7925    2134.4295    2344.4452   1681.60945    776.88988      96.5539   -300.77373   -329.97558   -347.69773   -285.49165   -106.85538    -197.8469     71.45255   -179.49717   -261.25802   -383.39015    -407.1198   -452.54228   -392.50429    -509.6053   -352.72956   -355.78515   -535.80932   -474.38169   -460.60708   -432.38538   -445.03124   -353.82593   -354.38701   -415.77695    -460.5871   -362.15134   -413.91223   -232.23955     89.65409     197.1335    263.58967    228.48958    122.79289   -187.63394   -375.92056   -332.97099   -505.32363   -455.71667   -495.89647   -277.52812     21.56164    433.39118   1048.35726   1423.86373   1456.99051    1068.1494     425.4528     133.4382   -252.65791   -316.53514   -350.95673   -237.64955   -353.72868   -173.18017   -519.77112   -591.34822   -415.23841   -399.22398   -407.07625   -609.70782   -581.68679   -485.66591   -601.20651   -493.17281   -553.49329   -507.18477   -505.84873   -401.17289   -488.51427   -404.72886   -369.09941   -300.57089   -547.52241   -365.26979   -398.86147   -474.57717   -629.22722   -557.59124   -309.97943   -346.67516   -235.99697    -311.8246   -473.57004   -300.91344   -475.62161   -530.77229   -518.08341   -595.33845     -501.029   -447.72946   -505.70217   -648.87648   -660.06098   -637.40379   -601.80479          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -6.50   -444.64928   -290.38244   -233.45391     98.08723   -297.62068   -396.34988   -266.14775   -131.25122   -397.70801   -391.21623   -506.97839     -1.20085   -459.35009    -361.7116   -447.88582    -297.9878    -28.01511   -337.26006   -285.79014    -81.37505    -90.38714   -272.59581   -414.56628   -174.89849     69.66816   1347.26354   3225.83348   4055.92319   3741.94779    1493.8164    198.21538   -211.11798   -353.80709   -317.48761   -318.56892   -323.85158    -293.5385    -357.9456    -155.2939   -397.59389   -391.86369   -349.08606   -343.16204   -319.09009   -318.89948   -370.42122   -333.62996   -475.31355   -394.55079   -382.94615   -363.85367   -274.40976   -342.06282   -452.98856   -365.38902   -409.26098   -303.94368   -345.39625   -260.02181   -276.29057   -257.97649   -634.47576   -425.63662   -492.29939   -329.70706   -519.76111   -335.12294   -396.74802   -250.01876   -112.47343    539.28651   1332.73371   1833.48594   1590.57012   1017.35384    492.50715    128.73861    -15.74629   -142.10234    -49.64739   -306.83689   -426.18926   -176.29993   -500.55248   -287.11382   -455.34799   -305.68388   -126.96122    167.29887    566.77932   1561.68399   2428.76053    2551.5355   1642.41199    889.69292    271.00075    -177.7313   -415.75147   -441.06025   -305.17392   -293.74655     70.86961    -28.82058    -33.86609   -238.56869   -272.74643   -333.75854   -475.17137   -369.30451   -465.60337   -389.00649   -525.71231   -591.11881   -529.34632   -450.77634    -359.0127   -341.92964   -509.81475   -336.24244   -456.90273   -398.48498   -443.41903   -392.47908   -316.30995      4.87224     209.1711     261.8997    396.63093     70.79923    -49.55472   -224.37368   -256.19857   -418.42181    -511.3099    -301.5525   -205.81439      2.01304     510.2234    887.09887   1298.29196   1361.41238   1201.69404    504.05644    203.18171     36.35426   -153.33625   -358.04487   -402.56623    -211.3478   -268.76471   -340.83914   -475.68429   -554.14637   -431.33688   -546.64752   -580.70046   -477.33795   -538.88679    -594.9162   -617.16844   -477.15256   -492.97842   -455.96682   -353.56908    -320.9057   -347.23656   -347.89731   -330.84685   -295.42346   -392.54254   -553.85781   -475.80914   -515.19826   -394.49295   -422.58824   -143.33526   -222.42958   -204.99187   -390.48179   -405.10743   -328.12075     -363.682   -519.01061   -442.30749   -465.01312   -534.71362   -612.46672   -480.57736   -389.91586   -351.68838     -618.901   -563.21394   -572.72674   -467.32473   -608.54186   -576.76888   -567.98458   -558.78407   -470.28308   -284.64572    -457.7702    -468.5868   -426.95867   -465.29347   -497.75312   -654.94834    -631.2763   -614.09574   -584.40648   -444.06179   -457.35625          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -6.00   -690.80901   -306.57217   -317.16018      85.3239   -213.64982   -398.30271   -172.99896   -300.58002   -354.75745   -334.34475   -370.80676   -106.90562   -482.69388   -330.99286    -471.4313   -177.48104   -240.01806   -377.72437   -302.74151   -126.37407   -331.73344      -257.36   -502.68531   -112.83968     18.01099   1198.82764   3264.08201   4147.96742   3858.59314   1521.18667    381.17698   -180.31878   -246.96207   -157.38229    -297.3421    -199.9148   -395.77778   -200.56677   -567.13845   -466.47523   -349.20406   -397.68725   -451.47521    -200.2418   -339.08095   -333.28335   -403.18365   -407.41942    -283.4303   -363.16466   -346.51511   -374.23288   -501.42584   -395.41587   -361.38435   -402.21265   -265.88401   -156.27174   -288.17306   -252.74149   -126.76859   -317.12931   -294.10063   -337.32681   -260.52366    -401.1203   -229.56717   -324.79741   -353.34773    -19.54646    475.73531   1398.10973   2000.96871   1900.12999    948.93976    394.02183    352.49465    179.67833   -294.03993   -365.86327    -371.1031   -313.68734   -317.91605   -390.98131   -233.59019   -349.28842   -220.76057   -229.66611     80.61388    609.09383   1465.31734   2492.54091   2414.13316   1626.24696    666.99168    154.48673    -234.9686   -440.67187   -168.79488   -215.81514   -131.12378   -117.24863    111.26232   -112.83873   -336.26458    -136.0444    -392.1322   -481.73654   -406.81993   -508.58888   -440.06482    -451.5551   -446.39078   -392.09536   -588.55052   -441.30416     -352.469   -342.26635   -435.94432   -397.12757   -435.33361   -426.43487   -255.19448   -152.37653    -37.61491     54.32275    489.27611    331.18155    156.86106   -142.66939   -262.79573   -471.48166   -316.79982   -227.03569   -377.01454   -229.84377    179.64449    763.77043    1063.0224   1433.24866   1453.43454   1119.97311    565.56221     91.09337   -179.84245   -308.34676    -70.67112    -70.20987   -288.44047   -241.38172   -453.48747   -262.10695   -532.02217   -413.28984   -463.10171   -544.25877   -497.18168   -602.93275   -409.14444   -527.36064    -418.1799   -415.03979     -446.688   -527.20173   -340.17359   -338.93326   -226.18493   -297.02867   -337.92725   -445.37183    -523.1664   -383.40872   -572.43463   -427.94829    -337.8322   -276.50484   -261.74501   -129.00488   -207.07836   -265.78201   -291.01595   -440.40052   -169.20024   -449.27077   -388.86085   -456.94746   -451.84729   -570.69811   -490.45523    -566.6862   -510.00845   -612.29715   -580.89872   -619.87069   -505.35135   -364.09586   -447.06711   -330.08233   -240.79821   -241.84341   -258.17065   -498.14462   -313.81943   -522.97624    -356.8337   -527.63767   -395.12266   -460.00287   -461.70971   -428.79594   -361.81387   -427.98596   -587.47735   -493.10844   -595.02335    -604.4385   -473.85841   -618.94628   -708.81842   -516.97858   -638.88163   -676.62022   -477.00093   -725.58052   -514.15365    -529.4784   -516.95767   -455.40827   -472.25708   -197.27508   -324.97298   -335.29878   -336.67063   -541.20605   -485.86734   -277.17172   -341.37757          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -5.50   -693.02989   -325.89354   -402.00735      97.6481   -353.51217    -372.9289   -146.26569   -484.09415   -143.70315   -298.78362   -357.91232   -193.02002   -511.45562   -519.64705   -402.84667   -146.38708   -480.69102   -335.67734   -312.68179   -283.69337   -431.55621   -252.09357   -597.12846   -280.64096    -71.68373   1008.09794   3282.23519   4723.97822   3910.60137    1665.2509    325.03904    -207.3788   -299.42239   -453.79264    -331.1273   -237.57779   -347.44774   -311.86083   -418.73311    -449.9655   -379.28521   -353.13217   -336.49722   -442.18735    -278.7925   -350.90991   -324.51999   -263.36406   -221.61682   -408.41255   -413.50707   -542.94826   -410.04581   -356.85246   -442.05516   -452.06721   -262.20649   -299.70635   -183.08512   -232.39617   -325.38549     -428.302   -232.33071   -309.41621   -372.96024   -303.74663   -261.09829   -278.32506   -278.46973    114.93448    783.87241   1212.18659    1934.1591   2029.79288   1049.78781    341.59829      96.3508    -165.4236   -184.36817    -209.7711   -246.38988   -471.58004   -372.28751   -369.00066   -332.88664   -359.88358   -241.55123   -404.88957    -65.73382    490.71928    1683.1587   2680.32704   2946.69506   1936.81207     644.9237    297.97511   -204.58592   -316.19173   -379.25296   -408.64943   -107.98309   -111.12272    -65.64046    -37.94058   -188.43674   -177.25691   -458.82752   -418.94688   -349.25022   -434.29432   -394.52276   -475.15841   -376.66855   -391.06411   -364.09263    -400.8773   -388.01416   -302.84171   -284.29925   -360.97878   -473.94969   -252.07328   -358.25383    -53.62302    193.98424    361.56162    409.89798    191.10147    279.81163     93.40165   -168.28564   -331.98871   -352.08052   -274.33463   -353.98607    -81.71361    206.02544    827.53453   1151.08835   1448.77525   1760.01673   1259.52927    767.18072    308.87989   -162.14681    -35.55583   -185.83113   -203.93735   -193.16232   -233.13525   -364.09993   -400.40223   -317.83871   -396.65336   -493.37206   -423.28798   -361.84123   -422.85275   -509.22914   -414.30642   -485.19081   -424.35152   -463.85556   -532.63839   -420.51932   -398.64663   -303.10488   -373.89001   -348.32217   -459.90484   -701.76245   -491.88014    -522.7157    -405.2599   -335.27834   -326.84967   -201.34348     31.88653    -90.32705     -39.1968   -234.30818   -326.45681   -341.57569   -329.64636   -371.18157    -502.7968   -363.64551   -391.50019   -518.93451   -404.65727   -577.50933    -526.0167    -619.9802   -457.68107   -401.82291   -530.49415   -352.47119   -313.62236   -450.85997   -318.27072   -166.58084   -334.87098   -301.74206   -390.76352   -242.43404    -313.0378   -244.99842   -450.57553   -140.60349    -317.6902   -368.67941   -140.62311   -101.01319   -508.59462   -348.45911   -672.41425   -407.47312   -497.73004     -554.679   -409.25716    -481.6245   -548.46204   -580.04391   -658.81567   -563.17983   -406.56817   -460.17714   -464.61211   -414.95392   -413.42554   -384.53689   -137.35813   -148.48242   -311.58442   -267.41604   -312.74905   -332.19569   -151.20313    -319.3937     -3.58674   -174.81728   -176.87636   -387.04194   -538.61529   -546.96523   -577.48668    -758.8419   -744.49438   -644.87094   -568.45335   -506.55082   -466.28787   -581.51209   -439.54222   -410.30557    -403.4499   -536.91737   -461.38876    -421.3569   -338.57048   -537.63878   -411.69826   -439.45853   -108.19175    -349.4975   -260.78947   -320.84589   -427.00346   -404.97387   -435.10978   -384.16587   -594.38942          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -5.00   -646.42732   -341.24329   -393.50366     65.75465   -488.93456    -359.9344   -279.47134   -522.13745   -103.62681   -278.45087   -378.33813   -240.82162   -488.90169   -489.67841   -376.22352   -174.57547   -657.19569   -408.52733   -173.85423    -317.3681   -504.73693   -107.58912   -486.61609   -575.55424    -73.13803    813.21755   3138.09936   4304.21726   3184.13779    1638.1983    220.55833   -293.98124   -186.08904   -282.27639    -337.8892   -208.03885    -217.9411   -357.96056   -329.18427   -484.34036   -311.08823   -319.15791   -437.93622   -350.44664   -199.36924   -389.63707   -330.99744    -508.0869   -349.89858   -450.30347   -371.48947   -481.37087   -409.18181   -320.52352    -449.8424    -386.0871   -296.14965   -370.98259   -369.86985    -68.80335    -237.3715   -390.26408   -435.48115   -344.79725   -381.44972   -593.87492   -481.20422   -291.16635   -312.01907    -94.07345    687.20558   1439.26355   2092.25816   1851.91786   1202.12953    442.99773     103.9272     38.45882    -35.41219   -156.23315   -327.31486   -483.96696   -413.07318   -484.43568   -248.85985   -365.18622   -371.61084    -350.7603    -56.27274    556.77617   1563.29812   2406.72395   2798.40646    1761.6526    929.20528    233.61038   -162.67963   -177.51055   -424.77016   -272.05433     13.33062    111.47049    163.67406     41.60578   -256.30895   -328.85922   -352.82327   -552.68049   -249.90059   -232.62965   -499.14644   -388.59516   -285.89057   -333.67748   -595.94547   -366.47331   -220.34338   -373.64214   -281.82882   -288.08642   -419.96828   -345.65298   -166.59157   -235.98224    228.73314    281.72241    442.80005    327.42347    147.79172    -48.55077      -3.3748   -327.04739   -296.90418   -302.34719   -171.93601    -76.35535    -20.21751    682.67078   1576.68873   1791.10322   1796.94336   1503.87065    830.67822    306.53262    -59.97897   -141.19115    -106.8708    -73.61305    -86.55543   -118.07527   -283.46962   -469.17636    -373.7325   -409.32874   -521.72611   -490.03844   -557.43846   -374.52736    -403.9028   -387.86686   -438.26783   -464.74407   -348.28921   -354.25002    -75.08929   -229.27325    -60.39475   -195.45272   -330.07957   -367.62727   -380.45842   -562.26877   -484.33462   -258.64362   -336.69495    -67.93272     33.66916   -118.21738    -10.48512   -151.24169   -201.00702   -145.50889   -310.44834   -287.15551   -332.58005   -471.18876   -573.39851   -519.83141   -418.75404   -523.30743   -443.22199   -425.94654   -418.47505   -343.56598    -630.6216   -368.78622   -193.52486   -108.89421   -123.28863    -65.51706    -72.70084     37.18261   -263.84231   -392.17388   -444.71095   -253.06002   -330.29115   -361.53147    -55.57782   -287.02044   -140.34387   -205.41634   -324.77265   -400.48675   -366.96778   -458.33247   -591.62957   -358.64392   -499.42098   -497.70181   -374.73519   -596.93767   -458.27585   -561.26186   -503.98353    -400.0452   -209.94228    -33.23996   -223.90763   -187.94694   -267.32644   -314.01115   -226.69819   -172.15619   -205.79782    -57.24781    -22.35769   -184.33276    -79.96111    -16.47274   -262.11018    -212.2311   -175.75937   -358.63426   -482.27807   -562.37483   -348.21478   -571.87653   -556.88013   -668.29157   -609.61666   -615.97245   -478.95883   -637.18415   -629.60212   -391.75702   -422.27319   -414.09518   -429.06302   -364.32618   -275.84454   -347.87451   -130.69897   -106.94727    -44.15551   -129.71208    -34.33457     -1.31608    -101.7761   -360.33266   -242.46876   -348.01475   -451.04757   -440.28404   -629.07299      -611.69   -462.76953   -593.52304    -762.6836   -542.51919   -478.11806   -585.56376   -548.92924   -547.09503   -551.49689   -559.23653   -556.94602   -651.47636   -682.93438   -701.23946   -754.04448   -698.44984   -680.48438   -765.41234   -971.80429   -656.51386   -704.08365   -940.11847   -765.72266   -851.44249   -838.93125   -933.97189   -625.06392   -747.02452   -873.99636   -674.32835    -651.2257   -696.44441   -645.66973   -823.44144   -766.34547   -713.88717   -675.46923    -716.1789   -785.54294    -660.2767   -626.87404   -641.73399   -717.92456   -727.86837   -806.54369   -727.65123   -717.25662   -762.41263   -739.96941   -811.52147   -590.09764   -613.46985          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -4.50   -615.81542   -354.84687   -339.35665    -85.02776   -360.26085   -404.78689   -393.48666   -532.83417    -238.3169   -251.92891   -324.29387   -318.62112   -458.10599   -294.75638   -488.19047   -305.55904    -389.8627   -459.59165    -14.94812   -250.42359   -593.64598   -161.26758   -389.10279   -533.24822     -4.69755    790.22228   3072.28545   4500.95634   3580.65523   1636.28361    179.03206   -248.85708   -248.82526   -475.29219   -289.56988   -196.00715    -39.16719   -251.62692   -339.67747   -436.33996   -245.14209   -342.50789   -357.56102     -504.089   -444.05636   -415.66787   -298.58911   -372.25679   -457.05521   -294.79349   -261.10473   -578.99973   -369.07752   -167.38009   -156.91254   -325.36299   -354.61908   -304.16849     -81.1012   -388.35552   -186.16388   -394.23898   -186.67454   -319.36462   -387.17134   -258.57187   -355.81582   -374.23683    -260.2539     26.67385    513.23809   1486.20792   2268.43872   1880.28804   1096.19802    410.31861    186.97155    -53.48332   -151.57235   -326.82733   -369.24121   -376.13185   -411.13437   -413.59124   -359.64357   -287.69189   -231.95495   -211.85253    -32.49903    587.93277   1396.76024   2492.65761    2577.0624   1747.15139    970.18047    350.33398   -222.94414   -402.09656   -325.82288   -314.19907   -219.68826    -55.85285      82.3338     -14.7732    -205.4925    -85.97598   -253.77313   -355.12994   -482.30987   -422.04884   -439.21257   -360.82458   -418.12197   -356.46644   -423.78594   -329.00404   -385.38342   -366.52531   -267.20699   -439.44421   -246.44769   -371.52525   -289.03899    -68.40705     76.30357    680.83509    592.87057    617.01316    219.23958    100.88765   -155.75322   -145.05878   -315.40514   -426.81916   -254.50466     -4.77607    273.41075    998.30682   1334.41179   1846.93644   1987.36023   1616.83408    996.01628    272.69408     27.98075   -192.21865   -229.68878       -69.57   -144.46196   -248.38446   -226.18558   -395.12773   -341.02322   -407.81329    -466.8064   -408.13452    -331.0147   -361.45422   -415.25438   -397.32428   -467.71121   -406.14722   -351.04894   -446.01469   -301.35939    -93.93327   -274.66964   -181.35801   -226.83137   -352.76846   -384.09273   -431.52285   -398.22801   -388.47077   -145.00344     -6.07373     -2.87487     -6.16084    -95.73903     46.59926     -7.25564   -268.52948   -238.21856   -280.99756   -397.95679   -279.15254   -434.66388    -372.1111   -511.08279   -430.10651   -396.69927   -466.55244   -498.17201   -341.87252   -406.29335   -257.42507   -238.07078    -50.85167   -208.70687      28.1973    -57.50162    -32.47723   -139.28855   -226.85789   -226.00572   -178.50294   -272.99273    -88.10595    -68.60038    -97.02635    -58.03235   -165.66045   -173.17524    -439.5921   -272.50477   -357.23175   -506.35625   -589.25453   -615.91326   -452.70673   -525.81266    -544.9358   -444.58393   -486.24769   -507.98503   -416.14116   -281.69787   -205.15207   -171.71637   -230.83178   -117.62884   -216.83886   -326.58735   -176.53535    -190.4828   -127.86836   -257.35793     80.97939     83.88854     58.35704      9.25719   -143.26162   -231.60008   -325.97973   -343.35953     -324.854   -529.00699     -541.122   -462.88448   -456.75824   -382.62045   -410.27778   -617.66276   -449.06893   -453.06504   -509.62602   -440.97447   -245.33663   -400.32412   -325.31751    -140.6203   -176.98663     47.69827      2.23832    -73.67334    -51.81453       53.334   -174.92325   -191.50167   -225.49633   -210.05791    -292.6613   -388.08329   -389.65917   -437.44836   -548.76158   -576.97369   -538.95576   -585.51695   -403.54241   -444.21989   -394.73969   -576.68625   -471.23037   -502.14213   -548.86697   -489.77956   -620.05708   -617.06137   -549.09049    -657.2876   -687.18808   -876.60303   -666.34484   -649.31844   -585.95579   -595.72666   -709.70102   -677.88523   -692.79259   -737.68833   -550.98749   -723.31101   -633.83985   -713.58402   -582.26758   -696.38304   -630.36235   -690.81636    -699.5209   -627.16078   -646.17262   -518.34476   -660.42307    -601.8315   -579.60502   -549.18634    -524.5329   -645.15703   -716.66606   -704.07502   -376.30557   -580.52696   -502.15534   -506.79686    -674.4895   -736.69807   -750.52178   -559.93179   -614.31943   -627.18329   -446.43583   -660.14302   -628.21078   -563.92975   -617.56444   -397.52101   -535.29731   -574.33404   -415.54608   -772.70961    -637.1318   -559.03426   -647.94246   -622.60042   -591.59393   -574.45905   -712.70501   -728.38439   -564.77364   -498.14036   -473.33321   -414.52073   -387.66316   -511.94609   -522.84493   -456.77181   -567.35643   -372.95423   -220.28455   -480.97295   -575.71457   -488.43595   -215.64348   -292.80543   -384.14713   -383.68359   -698.08057   -705.71604   -392.33154   -479.88547   -673.77436   -564.80378   -643.98694   -595.85609   -681.21457   -909.68955   -643.71324   -506.70868   -694.50579   -651.31292    -264.4382   -975.22709   -823.92283   -753.10848   -921.02206   -716.23655   -713.11688   -776.19729   -759.12602   -721.65204   -769.78064   -837.12042   -892.85768   -832.33126   -874.39505   -891.04046    -484.9546   -799.89793   -807.74858   -936.88162   -653.51692   -809.02991   -923.86351   -908.11624   -861.58121  -1030.64325   -770.96168   -743.26025   -783.63716  -1049.19956   -649.14377   -817.62155   -966.39252  -1084.92945   -815.15343  -1002.11205  -1174.51411   -971.92816    -797.3829   -1105.9816  -1138.75831  -1041.66081  -1223.38618  -1035.35848  -1170.40858   -957.95838  -1041.21317  -1121.12859  -1306.72161   -996.30283  -1218.64689  -1158.90095  -1038.23174  -1242.73796  -1062.20447  -1410.47048  -1062.47618  -1205.35752    -1232.964  -1014.59642  -1504.83835  -1286.69022  -1290.20451  -1259.27744  -1393.26273  -1102.07346   -984.21422  -1355.55314  -1254.85539  -1403.32974  -1554.06026  -1581.02309  -1064.43894  -1193.95444  -1633.63822   -1433.0084  -1961.79169  -1549.89967  -1290.31054  -1609.89534  -1315.77968  -1524.33631  -1732.04665  -1324.02189  -1581.91894  -1818.18005  -1421.34307  -1124.30414  -1444.99812   -1653.6598   -1529.8281  -1543.55248  -1666.42103  -1840.31439  -1494.67141  -1253.84009  -1479.70529  -1223.51092  -1528.43394  -1440.16053   -925.40929  -1751.35604  -1655.00796  -1374.86439   -596.39664  -1567.38263  -1724.94212  -1219.43618  -1886.82106  -1176.31887          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -4.00   -397.82097    -348.1117   -297.07028   -221.44477    -173.7025   -499.19348   -384.07064   -539.56729   -341.82115   -233.50933   -253.91012   -437.51304    -419.3442   -320.51111   -483.44138   -355.21874     -92.0644   -509.82846      7.44784   -195.14847   -392.51696   -271.78577   -319.27474   -158.71872    223.59727    906.93677   3251.70652   4396.60902   3941.15094   1652.54895    -72.83012   -230.60741   -213.14746   -482.14843   -215.98253   -281.94641   -214.58774     29.64403   -231.07066    -439.1662   -332.46853   -389.93764   -268.35173   -327.60319   -432.52124    -398.1022   -495.25336   -490.33473   -355.85023   -356.37333    -338.5175   -416.66445   -471.89451   -423.02206   -130.62495   -300.93811   -207.88048   -262.73366   -320.25571   -304.15895   -377.74887    -33.74576   -285.48982   -488.74275     -310.609   -373.03894   -384.01311   -392.73569   -130.50732     -47.7527    659.26424   1712.51473   2117.48908   1979.53519   1100.28504     397.9552     245.7665    -25.29764   -213.42323   -218.64542    -312.9377   -406.61709   -354.72818   -349.37075   -246.53136   -215.37499   -271.87501    -82.57427     -8.40027    375.73351   1213.38296   2190.87974   2342.50726   1930.27381   1091.27664    313.77048    -91.72214    -332.4113   -105.58463   -445.12076    -220.1409     131.4715    140.09282     67.96899    -31.87317   -271.56414   -321.47709   -344.99202    -543.9777   -317.20043    -368.8544   -379.91826   -412.87133   -385.63409   -389.79809   -391.82272   -424.42026   -331.85223   -359.39357   -267.14597   -284.94508   -314.32572   -188.19769   -200.52749    263.11818    401.61796    629.79646    481.38941    347.12029      -10.099    -84.01726   -117.24832    -436.6763   -332.12247   -284.75705   -118.38289     276.9886    812.94178   1460.40067   1914.79602   1911.20062   1562.71169    889.61952    408.75098     76.75093   -120.16416   -100.65549    -23.92589      6.80433   -112.17429   -285.14643    -300.9949   -389.33371   -437.48688   -417.27188   -355.20215   -211.66228   -341.18295   -340.39864   -374.16558   -418.93722    -295.1926   -388.67798   -318.27211   -214.16138   -307.12147   -162.20868   -256.88722   -220.33909   -383.92456   -231.67544    -213.3264   -475.61357   -246.04478   -115.05798   -191.43517     28.53675      117.636    -74.36708    -48.51035    -23.22724    -86.98014    -319.5847   -445.05392   -319.63951   -294.49292   -267.27404   -468.35368   -404.51525   -447.85073    -478.2609   -375.39085   -205.36761   -424.05822   -243.35692   -223.48192   -305.16671     29.90242     -23.3139    160.06632    -61.74253    -16.25425     -137.967   -160.78205   -270.81381    -176.8308    -72.49066   -137.48773     39.18449    142.49184    110.36367    179.77991    -77.90731   -201.80352    -307.7168   -501.20607   -579.64958   -450.06601    -446.5204   -551.65963   -457.32987   -621.17166   -352.37607   -524.77004   -282.62377   -402.51831   -307.94344   -282.73507    -24.03811   -156.06646   -104.61606   -153.58824   -232.59125   -292.03743    -41.94973     -82.2644   -120.35556    135.05475     66.34347     -8.30838    -28.23608   -170.99962   -181.92529   -251.64098   -395.87314   -276.92526   -569.88712   -347.86834   -447.47911   -332.67866   -592.70203    -389.3992   -451.46316   -360.73874   -271.38131   -258.38639   -337.87776   -355.62952   -309.69534    -65.00176   -116.27383    -61.72221    -32.28145     10.94749    -61.78541    105.04528    165.84137    -101.6501   -113.90762    -253.7717   -378.06239   -261.94053   -483.25292   -365.94046     -573.878   -562.91582   -450.42855   -477.03599   -425.28445   -428.96444   -382.67271   -480.90138   -207.30485   -316.90598   -453.85248   -420.66905    -472.5552   -421.70536   -548.02023   -579.20284   -569.31531   -466.91389   -589.03828   -583.41833   -630.58059   -754.91033    -676.5267   -459.69267   -577.12668   -663.58345   -583.72437   -651.36985   -600.34696   -766.10673   -735.07661   -465.61134   -588.79255   -632.16464   -456.57365   -465.95232   -574.17094   -565.18374   -485.87354   -651.72523   -587.25537   -457.65205   -483.18156   -569.40801   -504.15563   -610.96519   -573.32322    -542.3965   -600.33887   -606.38227   -470.67016   -552.20178   -603.79145   -542.82497   -374.64773   -488.20413   -478.98057   -581.24729   -730.21602   -449.98321   -404.07125    -397.3083   -511.96188    -393.0354   -579.01842   -474.67414   -346.28591   -477.64407   -473.07454   -593.38726   -505.57255   -671.91071   -527.04689   -515.12361   -448.21039    -671.7173   -364.25761   -380.01013   -420.47148   -503.26483   -298.15173   -502.15865    -113.0846   -463.56799   -195.16858   -157.65007   -316.65637    -93.67722   -273.12841   -354.86283   -255.20476   -195.82467   -214.67917   -377.55837     -540.222   -394.52814   -281.54371   -473.12039   -309.38365   -531.45563   -366.08531   -428.84059   -325.78667   -306.24568    -290.3876   -464.35215   -732.61015   -528.50281   -357.90281   -688.81837    -643.0174    -692.0711   -633.93277   -576.84537   -568.34204   -906.80506   -709.12487   -641.93306   -748.53727   -719.30483   -659.74486   -806.17869   -810.23425   -251.16116    -504.7047   -778.13675   -618.38807   -866.33558   -787.38555   -522.54777   -673.57343   -861.38689   -672.49488   -644.77044   -192.89741   -522.82705   -759.99812   -551.67971   -982.00313   -780.41892   -530.15174   -604.91693   -559.93397   -830.20465   -745.62565   -750.78771   -942.78883   -844.50883   -709.98134   -829.60025    -875.7632   -817.92439   -800.20398   -687.43972  -1052.33311  -1049.24106   -868.99545  -1053.17361  -1054.33978   -831.51092  -1045.78452  -1125.38171  -1055.88153  -1328.16834  -1159.27249  -1150.14898  -1357.95248  -1216.23304  -1504.75313   -1229.9496  -1048.30062  -1294.15664  -1721.36585  -1591.02061  -1290.30231  -1351.57426  -1179.41205  -1354.97568  -1374.43914  -1477.19553   -1304.5938  -1193.77739  -1238.83243  -1383.90392  -1281.40788  -1719.69314  -1403.33386  -1678.39471  -1409.25474   -1313.7943  -1510.76165  -1529.18002  -1382.92046  -1623.05171  -1410.17815  -1343.87615  -1277.71693  -1702.43152  -1690.17746   -995.54075  -1965.77371  -1385.85093  -1600.46228  -1647.96094  -1202.33228  -2135.96438  -1795.05324  -1315.34337  -1382.42228  -1417.30577  -1638.68414  -1639.59268  -1643.22569   -422.79037  -1106.57832  -1021.18201  -1325.40099          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -3.50   -169.45775    -321.5222   -412.55023   -386.78812    -32.34399    -577.4976   -379.91296   -542.29283   -423.32569   -309.45244   -264.98382   -501.22108   -413.34097   -360.16084   -396.08416     -300.715   -307.44349   -262.27021   -236.38921   -230.71074   -277.35744   -374.76163   -286.36714   -263.74536    166.37517    938.03063    3195.2693   4293.47621   3781.91849    1528.2786    198.88861    207.46533   -259.27384   -440.31023   -284.29358   -332.59092   -219.13731    -69.26328   -257.52275   -470.38606   -275.40812   -303.14588    -345.4215   -241.96022   -385.04716   -403.63526   -269.96643   -542.80664   -438.77313   -441.39324   -291.98769    -401.0542   -332.96888    -357.2602    -51.75829   -171.89788   -462.99233   -203.94665   -101.92111   -187.22624    -84.76747   -277.32262   -411.78904   -351.98934   -364.99345   -383.04042    -184.1458   -520.66419   -251.67786   -157.35627    687.40195   1550.00823   2396.37348   2000.16462   1117.97242    783.31895    223.21743     41.08143   -156.86477   -137.53208   -270.48575   -416.28269   -327.76183   -293.19455   -235.51648   -396.14729   -315.02069    -95.08841    -13.55583    300.49972   1472.22084    2273.4009     2426.152   1862.80006    874.77234     95.90607   -128.47038   -217.09979   -272.35086   -147.77734   -195.07264     52.89989    272.41895     62.69482    -20.85257    -60.98598   -244.45028   -630.07123   -313.60505   -292.76652   -245.90246   -472.57909   -267.28827   -415.00427   -418.98378   -283.18781   -303.76049    -337.2663   -325.22912   -241.12344   -263.34021   -319.44378   -255.05948     43.84043    171.21159    576.80955     663.0993    460.17077    319.62092    237.22895   -137.05161   -282.46086   -174.90717   -316.12437    -88.00005     44.19462    200.57732    904.33269   1571.85526   2060.56718   2024.41299   1787.35298   1107.37266      646.919    143.50445     60.59116    -47.87927    -50.73889     -118.679   -245.37775   -244.19243   -412.51083   -240.02343   -381.72384    -328.2832   -362.95128   -421.67438   -427.81658   -363.38614   -320.34601   -320.15209   -397.33086    -246.8058   -281.47306   -112.13311    -15.03464    -52.47892   -208.76074   -256.11079   -218.13662   -394.24525   -381.02735   -135.41863   -170.25674   -240.75252    -72.17735     64.74589     11.85696    109.47865    148.68939    -57.95532      -188.64   -169.77567   -308.25978   -286.15548   -277.72247   -295.04153   -380.74244    -463.1622    -480.6862   -392.47922   -480.53468   -293.78598   -237.86724   -279.94283   -337.75463   -287.30289    -25.88365     56.61408    156.21673     96.84741     62.99225     25.52323    -24.07313   -161.97383   -240.74038    -15.33111     81.56139     -51.1779    338.06925     60.15491    -77.89925   -113.32735   -128.62603   -316.90001   -355.42165   -495.01599   -551.33233   -328.97386   -506.53464   -398.49233   -327.62377   -416.52431   -307.55797   -343.68617   -258.57864   -329.48181   -131.02437   -148.11476   -284.98656   -213.50267   -201.27834     65.60043   -138.45826    -87.05621    126.11172     59.50813    137.60309    -79.31083    -65.21577      -2.9889   -108.51676   -131.38676   -151.98455   -525.95041    -61.57549   -239.49197   -499.79479   -360.22801   -479.81744   -435.32023   -465.79543   -444.64873   -371.09244   -419.15172   -250.18568   -281.87125     -93.8544   -193.74481     55.31288      3.92822     63.62433    179.73169     -6.32695    436.90115    123.57962    290.79542    171.30435     64.20017     -6.12552    -88.46247    -67.40532     -330.946    -405.2625    -374.8411   -322.41866   -532.30741   -459.33359   -251.88219   -361.37743   -274.74653   -310.23383   -263.49241    -316.1791    -350.3101   -444.54193   -692.31695    -543.6122   -581.94012   -595.94575    -826.8963   -472.46316   -490.86645    -585.1457   -710.76345   -451.30944   -726.09089   -594.85282   -732.92506   -612.88429   -593.62169   -596.34802   -668.91563   -447.34457   -717.92432   -624.04824   -436.98137    -633.6284   -316.30437   -363.54632   -404.83657   -534.91661    -501.9593    -403.7506   -290.34196   -491.56048    -476.4686   -495.80915   -371.54438   -368.94443    -379.9497   -484.90529   -551.07146   -450.25639   -661.62182    -527.9661   -635.54796   -557.47741   -707.59358   -455.38467   -137.22934   -636.01787   -357.39102   -622.12973    -293.5734   -443.76358   -352.91077   -422.02643   -256.80742   -466.92296    -563.8595   -316.19019   -407.66108   -539.22086   -429.88606   -357.37537   -408.13033   -289.32142   -338.66135   -194.51013    -540.4001   -525.88763   -246.04936   -516.41957   -407.12031   -366.10503    -50.71148   -174.39467     -31.4176   -175.57748   -279.32384   -339.44695   -173.93863    -115.3974     -1.30071    -84.89066   -260.50869   -338.66921   -361.56184    -292.4099   -197.99642   -372.43681   -469.44097   -483.83638   -334.15884   -519.86088   -305.28889   -338.49944    -411.6063   -380.06385    -402.2972   -586.30262    -442.8394   -383.47833   -706.38121   -291.83144   -744.51621   -309.07836   -318.41085   -674.48551   -482.63128   -461.10755   -375.91928   -550.55753   -335.63349   -703.52263   -729.98786   -794.02667   -453.40782   -484.51426   -450.02273   -361.42629   -699.20985   -739.23786   -770.08102   -362.21559    -474.4792   -511.92507   -678.48668    -637.1924   -495.59281   -582.83927    -734.0834   -448.47102    -454.2021   -405.99933   -554.73422   -811.42902   -675.52909    -541.0072   -794.58606  -1037.76065   -702.96448   -407.40892   -637.64204   -663.45315    -817.1585   -714.85922    -785.0431   -862.07934    -990.2017   -821.08713   -879.06912  -1095.74465  -1032.42426   -893.93791   -975.13043  -1028.45877  -1061.68316    -1145.009  -1369.40139  -1192.50073  -1200.68816   -1119.3678  -1500.02866  -1356.73074  -1339.32278   -1202.6552   -987.34984  -1310.05242  -1517.54592  -1277.06888  -1286.24334   -1261.9906  -1397.05229  -1070.29856  -1001.99531  -1475.17959  -1193.72707  -1333.49465  -1047.66743  -1318.25435   -956.39182  -1392.52826  -1582.03208    -1164.924  -1066.54748  -1364.39429  -1268.93326   -521.45999  -1528.38434  -1175.10793  -1404.63962  -1424.85394  -1330.40376  -1499.39353  -1890.88553  -1723.67733  -1450.44308  -1661.55038  -1385.91751  -1480.74847   -983.14259  -1536.21065  -1274.66708  -1428.30953  -1456.80215  -2026.81878   -930.99477  -1750.72634   -970.04541          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -3.00     27.31091   -294.13809   -538.34659   -552.51542     48.81398    -596.6634   -480.14688   -469.41116   -453.35515   -366.05923   -293.04226   -532.86943   -422.25628   -313.41645   -289.44088   -291.81053   -474.54653   -157.71844   -471.10945   -362.70299   -454.27916   -276.89484   -153.27605   -176.79145     67.67814    805.35171   3095.15628   4404.11162   3855.67233   1651.41453    199.29006   -251.83955   -191.96207   -335.07858   -356.99798   -313.44561   -131.32751   -438.67781   -280.18766   -240.47518   -518.76572   -317.05882   -296.85781   -336.99114   -342.23443   -530.19558   -341.65625   -510.97249    -528.5246   -273.65773   -499.41472     -473.145   -398.73702   -389.68542   -385.15245   -332.19498    -63.08429   -240.09146     -8.09986     -2.78078   -261.15332   -298.35529   -317.28737   -253.51688   -411.45521   -499.52735    -259.9305   -374.21796   -213.78795    -54.94209    507.97879   1402.11721     2326.953   2091.05649   1337.53939    447.43825    227.42454    -73.86674   -140.78929   -341.28993   -401.39205    -230.5646    -337.1475   -180.71412   -390.85568   -410.05781   -282.82223   -137.21792   -134.93442    493.22095    1429.6818   2373.67544   2825.13867   2016.25703    939.93407     213.7967    -45.44376   -179.38409   -214.01066    159.97843    -87.33539    244.58955    233.05429     61.64924     83.05392   -246.39827   -154.88927   -261.97346   -383.48677   -292.07846   -333.01415   -464.18678   -347.31998   -343.73033   -314.74284   -416.39447   -395.93996   -252.97998    -259.7075    -409.9074   -313.82587   -173.62723   -261.77851     -2.49742    370.15638    722.97216     689.7593    438.85279    352.35415     17.64984     60.30738   -274.88713   -201.07657   -301.83568    -311.2598   -185.00496    175.29938    953.11977   1527.85298   2081.38659   2282.85847   1966.52082   1190.32948    745.20907    278.60804      9.76079    -81.84498     47.08148    -92.58394   -193.04326   -150.99899    -224.4338   -377.77923    -405.0595   -396.09891   -396.25399   -461.09426   -165.71993   -247.24925   -333.76246   -256.92531    -388.6403   -328.70786   -216.01209   -195.96503    -91.98758    153.37328   -148.02097   -122.64951    -19.96706   -323.01252    -383.9914   -174.37478   -355.04733   -123.02718    133.79384      45.4678    -48.99263     44.00933    -42.71187     85.02225   -229.54028   -160.49817   -153.09032   -313.83799    -213.6994   -325.19871   -278.10522   -254.34776   -283.07228   -531.62407   -403.29669   -406.08314   -213.50968   -275.64494   -154.15161    -97.22151     -40.0992     78.04303    -10.68397    -13.46579     73.72393    -39.92039   -182.28439    -77.22057     71.54475    -47.24656     43.07856    -47.76358     77.46848    119.75869    -137.8894    -34.95257   -155.17021   -278.08583   -352.60264   -369.94687    -260.3606   -374.65523   -332.88621   -442.05586   -240.25986   -495.71383    -324.9465   -334.98829   -465.72341   -229.14949   -200.51093    -61.34874   -303.40554   -101.57415     15.56508   -227.48582    -52.12636    -67.15165     62.38973     11.74666     29.03881    -32.35985     45.24126   -124.00475   -161.34576   -224.19856   -186.05958   -249.79423   -348.47542   -594.55398   -301.27221   -517.03824   -342.17057   -372.00601   -394.24914   -354.98544   -325.24717   -220.94848   -227.32828    -237.3784   -106.07868     20.62048   -122.39584    244.54814     22.33358    395.34427    495.94938    283.93799    193.94583    305.62996    143.05419    165.80426    203.04384   -246.49453   -104.14604   -217.36332     -269.324   -298.48591   -519.02226   -481.15701   -227.14604   -240.37097   -486.29961   -293.92911    -454.2138   -245.23575     -195.411   -530.27846   -299.87935   -402.38317   -379.81797    -565.0178   -423.84101   -346.13113   -570.20205   -551.75678   -414.85862   -479.55199   -465.63808   -580.19578   -588.50086   -605.20161   -517.34605   -555.12199    -394.1107   -647.67424   -654.95709   -326.56197   -536.58004   -469.99134   -643.32274   -483.09245   -525.88192    -234.9611   -383.29554    -418.5827   -357.25206   -320.30103   -262.05793   -370.42579   -274.52884   -407.60423   -452.40928   -324.50466   -414.04615   -686.11706   -635.25068   -688.21496   -454.37498   -378.37035   -595.78822   -348.09384   -360.88054   -504.93009   -312.06137   -422.54316     -384.123   -432.82496   -399.61426   -317.56398   -425.77596   -392.32101   -421.94375    -385.5778   -427.91704    -401.3817   -501.27975    -566.6629   -442.13438   -392.06182   -574.49471   -277.48292   -276.06928    -335.9901   -182.46177   -238.29404    -396.0872   -497.54072     26.64036   -169.72353    -396.3363   -288.52192    -27.05054   -111.21626   -188.64694     -2.33175   -224.52264   -137.03452   -268.67203    -52.35573   -381.98702   -249.04592   -208.88287   -249.02376    -412.8105   -315.01904   -359.44479   -358.42745   -365.70193   -298.10252   -349.81416   -368.81298   -397.18115   -127.19273   -501.72804   -296.88887    -183.6802   -439.34903   -478.82357    -416.1187   -443.66422    -424.6248   -517.54183   -604.20538   -468.49245   -609.27661   -517.64032    -493.9391   -581.51417   -399.85847   -582.82558   -680.75359   -434.12059   -653.89484   -556.98776   -849.07616   -611.40181   -582.84177   -526.28114   -485.51599    -675.8333   -201.34009    -379.0391   -738.12182   -285.57718   -719.89059    -691.1199   -527.36449   -517.28707   -700.66809    -84.58439   -489.56421   -418.53173   -787.55882    -536.9712   -594.07215   -472.23662   -847.59355   -731.75479   -529.88318   -635.02813    -993.7823  -1013.67568   -828.67567  -1026.96446  -1025.19033   -992.69409    -943.7685  -1048.68041   -931.21556  -1018.69831   -1129.3923    -853.2988  -1239.54195  -1117.46424  -1106.69018    -982.2456  -1059.99792  -1138.86848   -1198.1555  -1293.54743  -1333.84561  -1084.59751  -1068.52376  -1295.46417  -1357.88135  -1112.79145  -1202.49465  -1022.25793  -1396.45177  -1415.92015  -1319.20674  -1324.43564  -1541.46426  -1175.72395  -1387.87513   -1188.7434  -1322.01664  -1421.33977  -1319.64983    -922.1077  -1512.88301  -1451.38271   -1335.0997  -1213.99431  -1787.07163  -1107.16307  -1394.45032  -1665.60004  -1419.62005  -1214.47553  -1377.47404  -1595.15492    -727.6599   -540.70324  -1095.63746  -1153.85003  -1519.66402  -1480.25482   -505.47681  -1311.46073   -828.21457  -1116.60901  -1513.62003          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -2.50   -124.26159    -378.0484   -540.68711    -629.6652    108.55281   -603.34714   -600.84038   -358.61232   -383.30551   -354.63053   -240.15016   -409.88324   -382.75153   -308.82741   -220.64902   -297.71721    -597.5064    -296.2907   -394.73666   -439.82442   -291.48307   -179.17399   -108.22181    -84.55118     35.44998     724.8443   3176.93109   4580.90235    4076.7805   1512.17692    330.45426   -313.62641   -274.26824   -350.65377   -358.51246   -180.37815   -225.66111   -215.80759   -417.16258   -372.98491   -201.92715   -228.52594   -334.03378   -357.77051   -293.50972   -397.02033   -294.98076   -314.24324   -237.96803   -435.65692   -368.21341   -360.50922   -556.15312   -421.25101   -472.76766    -230.2185   -269.73203   -343.74857   -154.01713   -169.90993   -183.08132    -72.71543   -207.62992   -219.33099   -282.59717   -278.02408   -222.30978   -251.04412   -201.50163   -125.62522    793.85168   1614.84912    2204.0108   2152.86352   1173.50251    553.79987    258.95556        -3.66   -328.86863     -2.38192    -234.8838   -137.77237   -334.09504   -184.66715   -307.70291    -314.6134   -180.96734    119.95419     20.23711    341.86205   1429.32783   2597.35896   2321.81427   2216.87073   1063.39745    323.64265    -89.03617   -107.22774   -358.04313   -220.20721    -81.74987    -36.76298    115.24114      -28.622     76.92957   -180.64242   -360.57419    -337.6913   -326.48164    -502.7057   -413.74474   -424.72696   -362.55526   -371.30775   -278.37083   -339.55523   -353.53899   -365.91679   -304.59242   -250.47088   -236.84227   -391.43927   -133.27327     18.79964    190.44112    527.59294    466.56276    609.64935    441.28781    102.22376    -62.90664   -208.00593   -344.29264   -334.21761   -326.61487   -113.01709    272.63401    942.44049   1572.99273   2169.99264   2388.94571   2146.77516    1453.1156    986.61921    306.93939    244.43777     37.13964     52.00066    178.85016    -92.68041   -178.59415   -201.06637   -353.09716   -389.48759   -364.21814   -393.48296    -314.4181   -368.52345   -340.50837    -188.8178   -231.94018   -345.56562   -231.41317   -397.67005    159.92823    -26.64539    -97.77143    -37.87832    -52.32639   -323.86284   -247.08751   -182.20708    -418.6248   -292.43441    -43.83064     49.77687    115.09007    301.47144    253.70644     77.34168     66.40896    -76.96098   -164.24251   -158.52208   -314.81535   -338.47734    -77.62759   -228.11115    -355.3272   -357.98312    -413.7825   -323.34127   -322.16272   -150.16673     -76.9345   -192.22999   -113.35729    -39.12074    105.03735     167.1855    144.88894    199.81547     26.03356    -11.02423    -90.42926   -211.54264    -73.95911    -55.30279    -92.41523     10.48307   -282.24671   -203.65178   -235.89995    -137.1946   -107.28521   -251.10326    -339.5073    -289.8636   -344.29037   -368.40055    -343.3262   -323.75247   -553.72116   -319.40359   -185.44133   -265.43826    -389.9957   -410.05212   -102.54458   -143.41076    -39.93699     14.26998    -28.24729   -183.06853    -33.82975   -111.35794    162.78781     15.57152     16.13816    337.31013    199.75584     -4.32434    -49.85178   -202.98068   -188.84669   -196.13884    -64.95472   -181.49801   -297.28716   -409.63962   -386.03249   -479.91195    -319.6726   -189.24682   -206.56455     -245.983   -160.87434    -32.39832    -30.98132    -84.00496     98.62062    135.51156    443.39745    443.02587     456.7251    346.50805    500.37729    372.26267     47.10414    174.31737     56.07238   -242.19153   -129.99878    -332.7712   -255.15032   -285.33665   -409.38332   -287.25998   -295.73138   -345.21484   -340.06108   -267.69078   -107.99461   -480.19773   -189.03415   -156.03578   -349.68291   -125.47203   -342.81186    -574.6878   -349.29913   -470.28846   -336.88301    -530.0039   -557.44116   -639.73423   -433.75205   -684.25968   -518.67038   -620.03311   -435.93091   -460.76483   -474.03511   -370.59719   -411.97653   -376.52398   -361.69578   -465.70593   -446.45994   -506.72044   -497.19962   -383.72037   -208.27345   -180.12963   -296.23328    -370.3413   -159.56489    -182.5371    -431.2189    -69.76756   -261.67376   -322.51256   -258.28104   -233.13917   -502.78435   -392.24693   -367.58171   -363.87777   -440.83203   -541.06865   -383.12691   -348.75233   -300.77144   -385.02842   -375.24213   -391.55046   -333.94682   -393.96793   -311.49708   -340.39277   -311.76616   -237.23791   -309.32136   -386.34559   -282.85139   -382.19964   -490.05632   -499.29876   -231.52535   -213.07438   -441.30318   -414.51658   -290.08156   -286.71756      -34.569    -180.7378   -113.92955    -45.31742     151.6432    -89.49764      19.5422     59.95682     42.64523    -96.23055    -225.8116   -191.79668     -27.5752   -150.59926   -134.74071   -137.03345   -115.11381   -164.53985   -144.81915   -419.57795   -392.45247   -268.41522   -188.19508   -391.71582   -224.42954   -112.22678   -180.38284   -297.43542   -245.24328    -169.4427   -392.82832   -298.56624    -229.5916   -267.67919   -110.18999   -582.17432   -557.16783    -418.4106   -384.80495   -508.16704   -410.31961   -366.21291   -626.50345   -399.58855   -337.94559   -377.89197   -426.92901   -390.68693   -529.93951   -310.90867   -313.08854   -566.47032   -589.09843   -612.67562   -555.81733    -309.2085    -385.7071   -509.68624   -212.73593   -449.90427   -476.20987   -494.92691   -220.82012   -649.82248   -428.87174   -205.27006   -625.21087   -491.87234   -859.30983   -793.87991   -641.84257   -826.50465    -625.1482   -644.31015   -457.40559    -708.4456   -892.15819   -849.06018   -954.56098   -871.05798   -852.10078  -1123.22769  -1051.38593  -1106.66159   -807.02054   -706.61001  -1001.04427  -1295.47618  -1139.91282  -1151.22372   -852.29599  -1325.11735  -1255.25881  -1141.64576  -1115.73502  -1317.04246  -1230.93587   -831.55142  -1231.52336  -1279.72719   -884.37105  -1391.91254  -1355.08465  -1296.33858  -1316.67497  -1194.49459  -1385.42907   -960.41117  -1064.41661  -1531.54462  -1318.11803  -1079.16788  -1270.01847   -957.63808   -831.27447  -1179.20864  -1570.45159  -1419.94312  -1461.34884   -843.81804   -917.97017   -1011.0548  -1261.97749  -1558.37788   -997.18507  -1533.70202  -1052.29718  -1195.40952  -1025.37822  -1203.27723  -1258.74449   -948.18804  -1389.31718  -1362.12306  -2085.81525  -1876.67477  -1138.32338          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -2.00   -272.16486   -493.35681   -420.94706   -508.88955   -115.39689   -547.41333   -543.32768   -294.15707   -303.83189   -353.26661   -187.25442   -246.99443   -313.83963   -358.15839   -249.39964    -379.2866    -535.8358   -374.17833   -359.35933   -413.70721   -195.18715   -210.62547    -123.2168    -46.39396      94.2178   1112.19316    3553.3468   4615.67319   3634.16394   1538.00521    237.53429   -265.62365    -201.4635   -346.92971   -363.62338   -108.83398   -430.57342   -289.44539   -101.95138   -136.91669   -617.97986   -338.21809   -462.96326   -356.22252   -344.02155   -346.95878   -189.00496   -347.71376   -300.65632   -341.17093   -205.69449   -476.35719   -380.89188   -262.89608   -277.44694   -218.39168   -183.13103   -253.05011   -215.87777   -173.56542    -297.6937   -165.31118   -278.78518   -352.35653   -323.28026   -277.88518   -268.23347    -299.6159   -118.43221     35.03139    720.30217   1438.10895   2410.89127   2095.48739   1207.12902    495.46023    134.63771    -95.05859    -112.0435   -292.95367   -171.15189   -169.20455   -314.48305   -193.61421   -131.05267     -98.6054   -281.95996   -230.92041   -116.64843     663.6182   1532.92043   2472.64203   2626.05728   2167.60844   1509.04211    321.86047   -159.28665   -125.53415    -457.7554    -50.78325   -202.01135    106.33581     248.5697     55.40424    -88.95449    -68.66921   -188.41809   -255.84937   -410.37859   -370.89288   -382.62248   -383.94148   -404.87868   -238.93864   -326.44342   -164.41166    -218.9248   -255.25401   -219.29549   -228.78755   -305.02021   -256.26598   -194.59949   -184.46608    167.91951     703.5396    846.00818    632.70671    410.50698    -65.97574     53.27538   -367.91443   -267.08751   -223.71647    -374.3459   -112.48102    337.25938   1046.74616   1758.76435      2195.37   2408.96612   1817.44994    1328.6708    840.60104    191.98789     50.25805     70.20536    -34.65063    117.14101     94.73597    -198.6971   -139.56892   -312.23351   -205.32533   -299.98401   -268.89638   -370.43438    -373.5083   -397.57738   -303.13807   -322.25445   -470.67367   -227.97827    -62.37637   -119.75694   -250.32267    113.52226   -180.40878   -114.58439   -131.74102   -275.53599   -382.08631   -358.46232   -125.98401      12.6252     80.59163     95.20879    172.09845    239.46293     15.01303     125.6076    -153.8583   -353.67526   -266.51137   -139.39575   -393.89711   -248.65436   -449.38857   -368.62495   -476.68694   -272.16291   -364.83119   -293.03686   -258.86435   -300.36698   -176.35444    -13.66037    -83.04228    214.17105     14.05178    166.86827    240.92721    341.73975     35.50426    -72.99448    -36.32557    -20.91178   -110.43415     37.86418    119.22411     44.20315     62.71463    -140.1135      3.41837   -276.37001   -327.45646   -263.11644   -295.89237   -517.86492   -526.85684   -272.16513   -396.11698   -133.02539   -363.52182   -321.07608   -164.26028   -123.70209    -55.25596    -40.26877    -12.79259    -11.83158   -150.98866     21.31111    -22.36791     68.12698     83.16247    -11.77029    133.96576     292.2111    120.23498     54.79577    -22.59654    105.88008    180.73593   -118.62764   -147.95029   -360.66003   -134.21887   -442.47979   -388.38888   -220.82357   -129.25696   -350.52451   -313.32914    -93.36223   -236.93404   -154.16947    -46.12021   -110.67359     -21.9409    184.10547    307.19256    281.35112    536.34373    449.19249    667.82607    537.21686    497.03241    478.09323    111.41306     23.46469    101.46645    -196.2517    -95.53499   -294.85748   -274.05055   -243.60843   -429.51504   -415.63011    -212.7038   -282.43578   -140.20373    -45.80205   -192.88802   -109.37714   -209.58217   -251.54856   -280.20627   -279.47322   -206.60466   -340.86694   -382.95064   -448.68432   -541.84281   -457.45977   -421.09538   -542.42043   -447.72642   -326.23392   -513.56604   -273.96925   -475.29297    -446.9816   -362.39567   -452.01069   -532.56116   -429.00991   -528.49382   -324.12754   -447.47696   -186.35823   -267.80481   -267.80287   -274.22227   -172.37446   -271.22691   -243.16403   -189.44263   -264.67476   -265.88132   -179.04311   -269.38407   -457.18265   -373.20281   -384.45506   -284.72409   -421.07087   -380.78704    -441.2126   -252.41365   -288.27488   -488.60679   -334.46764   -234.81816    -15.24866   -357.43985   -134.40506   -322.58829   -356.98128   -170.29978   -464.85736    -84.36673   -331.98178   -366.33289   -455.94849   -334.08946   -499.86866   -287.51158    -350.5826   -404.04931   -269.55768   -394.85259   -222.85047   -205.14173   -282.17072     -25.8767    -74.57781    -96.75438    -21.38269     41.27203   -191.08452    -52.70855     62.08955     69.50585    -73.74848   -187.35209     57.27548   -115.94565     -49.7424   -219.83459   -382.80281   -195.07811   -346.08123     -53.5594    -152.7383    -299.7981    -42.66288     -57.4735   -291.29747    -218.5622    -87.74719   -397.69368    -402.4456   -332.23013   -281.93523   -251.62671   -352.04038   -273.11229   -537.05815   -238.91877   -260.61369    -70.80553   -444.08361   -357.02953    -123.2507   -423.12198   -523.56449   -544.22506   -487.62655   -566.45429    -319.8353   -181.33181   -543.92618    -67.83962   -197.93556   -497.13975   -241.56177   -435.61831   -468.68189   -518.88523   -280.20139   -394.10001    -431.3471   -520.21859   -287.35719   -559.90251   -657.01626   -366.95738   -409.54459   -733.25044   -480.00393   -714.03961   -525.20348   -388.84348    -617.6525   -602.27341   -373.02172   -775.64274   -326.53051   -633.21972   -741.79134   -699.46449  -1023.83241   -397.69085   -841.37898  -1062.12936   -833.91743   -798.60866   -579.04263   -666.25948  -1207.54375  -1344.87306   -842.89708  -1151.96274   -975.28033  -1112.92092  -1218.15605  -1189.87738  -1494.26699  -1008.52244  -1460.31277   -833.31178  -1346.55382  -1113.92899  -1449.69654   -1258.2361  -1152.55347   -827.36235  -1246.77962  -1101.69622  -1478.82032   -1373.0453  -1220.58007  -1136.60643  -1300.31327  -1286.87319  -1556.98734   -889.98932  -1523.38143  -1466.73114  -1333.07811  -1176.34151  -1505.24767  -1206.38567  -1432.36156  -1244.21087    -761.7343  -1554.71858  -1346.58935  -1640.80537  -1357.74396  -1505.09363   -846.10159  -1176.72081  -1206.92054   -627.75034  -1100.01678  -1795.30809   -1061.8495  -1370.87044   -850.40467          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -1.50   -365.50074   -589.79663   -298.42114   -395.80958   -336.77826   -489.61178   -394.05707   -274.03742   -217.94847    -361.1698   -159.12329   -194.83807   -336.96917   -271.82677   -247.27831   -392.40088   -371.14985   -385.49116   -356.46599   -344.92494   -219.65523   -422.74758   -218.46015   -195.87757    -62.59538   1161.00164   3419.51188   4429.93526   3665.86136   1616.43584    209.24425   -221.00292   -101.00707   -285.34267   -399.18853   -108.26233   -408.04762   -393.16871   -338.37624   -457.48969    -282.6061   -336.55591   -304.85335   -486.59083   -473.15257   -247.05028   -342.27817   -450.73971    -354.0662   -354.07391   -374.57447   -453.80688    -421.0606   -377.75104   -318.90389   -348.78384   -409.95543   -313.78634   -391.12493   -261.33002   -277.35169   -165.22824   -345.92574   -206.69158   -378.02988   -307.76421   -307.10407   -301.17804   -295.98599     19.21913    565.03464   1769.92024   2507.86073   2051.12186   1370.51375    514.78972    142.61704     157.8414    -65.20154   -173.28576   -212.75991   -115.50401   -236.88342   -209.94692   -303.82966   -282.38918   -180.08776    -116.6351    -93.28256    630.84392   1461.21181    2561.4596   2771.97428   2230.90374   1173.51669    439.89774     72.31787   -112.37884   -378.10817   -213.89738   -171.66712    427.28227    267.26278    257.39307    -79.63592   -144.16346   -271.44736   -372.54444   -185.68739    -374.8233   -468.82162   -416.55554   -272.52091   -404.80245   -355.29682   -271.04795   -242.84171   -263.22201   -369.27563    -131.1197   -295.47036   -160.75606   -235.29463     -3.05314    279.39539    584.02027    820.82208    668.35328    325.74862    263.33408      2.01971   -195.20443   -167.85167   -305.67361    -11.25317    -21.49978    423.71392    1049.8861   1851.75517   2725.92619   2646.20017   2232.10486   1479.71571    741.01153    394.27099    157.30009      4.80626    109.62367   -111.82421    -57.01851     -106.574   -256.69007   -198.03322   -331.48668   -304.22805   -412.15241   -387.05088   -348.82189    -362.2531   -386.23407   -235.57269   -233.57482   -229.94299    -276.7538     50.25157    117.08919    147.68452      2.61209    -92.86146    -319.8066   -315.18948   -335.44536   -109.18678   -333.36743    -49.13123     12.65488     55.01904    203.84075      238.294    170.37215    -37.99797    -13.05754    -57.84247   -166.11557    -94.42012   -174.74817    -59.52905    -284.6354   -386.45179   -338.90387    -426.6806   -198.78685   -359.14313   -302.77177   -291.16264   -112.49405    -92.05375      2.26396    160.74682    103.03556    179.09412     208.7551     66.21945      6.16284     26.78669     50.86396    -66.33593     -9.22163    -44.95909     43.20236    179.29675     11.66016      8.44796    -70.03055    -49.73799   -367.43079    -368.4226   -476.67084   -291.63661   -405.46956    -341.3273   -301.71871   -169.00982   -406.25144   -255.46095   -222.34318   -129.19996   -126.29104     31.61292     77.58363     -18.8402      33.6001     76.20403    -90.69407    -52.88644    225.48486     216.9212     77.51292    368.17042    280.26557    176.48051     58.35978    181.08155   -123.31845   -144.88086    -231.3087   -396.15526   -262.15217   -235.00763   -397.52475   -202.86566   -343.34014   -376.38816   -182.91576    -242.9528   -315.28108   -144.96056   -267.75058    -112.1124     -8.56658    162.35976    210.73964    211.17225    494.44967    521.58294    497.77244    480.14656    507.88878    486.99856    247.38634       9.0789     60.83324     -3.49581   -192.72764   -229.35354   -261.93925   -300.75161   -399.90387   -186.93367    -226.9459   -109.90305    -290.4734   -225.36691    -72.46861   -124.94905   -362.54858   -260.96713   -112.10952   -232.35085   -203.69291   -348.37504   -431.33771   -232.02387   -355.97879   -357.66194    -450.5347   -412.77107   -400.77336   -608.38408   -432.82839   -377.39262   -341.91723   -420.16131   -468.68392   -310.31863    -396.9846   -328.38026   -221.58242   -322.10363   -263.42696   -329.23423   -184.79837   -191.87113    -70.75435    -29.18755   -337.17511   -123.88767   -178.06028   -173.19987   -227.76899   -110.14154    -34.21296   -388.55519   -257.83236   -351.25198   -254.65619   -487.56498   -378.03453   -429.12856   -354.03562   -318.83959   -292.15695   -210.00088   -133.97423   -118.31005   -226.79431    -11.49879   -132.95164   -308.30191   -168.58433   -157.41536   -291.66141    -264.4004    -293.9042   -428.64375   -278.50935   -173.44744   -411.28822   -477.12158   -183.99496   -245.60841    -23.95947    -55.42201    -91.86441   -118.49977   -194.24384    -32.63412     64.87737     218.7698     54.70257       5.2484     -5.03683     -31.6408    -80.69353     164.6106     91.77647    -57.03145   -128.21653    -65.97534    -45.72746    -27.86276   -206.58855    -47.10824    -23.48694    -134.6604   -291.80548   -238.62498    -353.9629   -185.01221   -223.30107    -194.8648   -246.28359   -263.12283     -314.303   -297.87772   -495.14111    -10.89382   -121.32437    -243.0058   -162.29269   -461.95566   -258.71184   -443.96494   -499.95819   -462.94646   -322.94855   -250.26528   -476.51093   -387.34579   -342.41377    -370.3381   -231.87366   -340.94041   -550.07818   -401.62237   -326.65207   -344.00419   -318.37407   -407.76018   -414.08617    -346.6291   -268.51563   -301.95841   -411.84316   -602.58095   -244.11829   -612.20973   -501.93608   -502.23116   -432.14536   -443.83033   -590.91671    -392.5919   -810.85723   -323.97441   -527.89085   -575.37451   -891.99137   -328.22943   -507.85659   -640.69683   -761.50931   -773.56168   -617.50937   -324.39712  -1056.31235   -757.23261   -662.18842   -999.32495  -1003.25799   -554.35866   -920.18154  -1093.02622   -1387.1896  -1116.00895  -1050.96671    -769.2854   -1226.8233  -1142.96502  -1180.84274  -1141.10457  -1299.60178   -892.51902  -1128.34082  -1163.06453  -1216.56554   -1104.1635  -1170.76844  -1338.29805  -1437.69907   -755.09721   -989.71602  -1234.73431  -1223.47492  -1206.44248   -905.35267  -1108.87732  -1059.18956  -1167.05212  -1186.87377  -1072.21722  -1548.04065  -1157.86514  -1041.76677   -1392.3177  -1533.88141   -755.25638  -1450.62079   -918.28125  -1508.30054  -1299.05233   -529.24974   -659.89337    -1415.104  -1460.30589  -1720.89876  -1349.73262   -1098.7281   -831.46517  -1467.56792   -1418.3975          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -1.00   -275.88118   -427.91241   -211.05558   -349.57116   -325.35499   -358.32529    -312.9737   -282.23702   -188.43223   -365.26191   -140.39857   -168.00678     -380.839   -130.58997    -227.9045    -333.5464    -45.19707   -228.43048   -417.60469   -382.58274   -268.70418   -290.40054   -294.07743   -225.09364      3.28538   1307.34918   3569.37304   4389.09881   3573.18458   1551.46232    218.58226   -190.16573   -158.68257   -393.89428   -378.23144   -156.47108   -451.89527   -409.83111   -252.05857     -304.327   -452.00603   -550.76221    -327.7924   -365.94889   -359.05278   -296.17791   -308.68146   -369.77258   -286.45196    -149.0679   -421.95769    -381.5794    -298.5119   -110.59963   -316.91498   -349.93885   -327.93527   -310.43275   -128.58959   -222.38661   -336.99904   -199.32403   -410.48353   -382.06722   -352.44266   -397.56237   -225.17164   -334.85079   -187.67541     26.10805    796.73465   1735.99366   2450.31108   2120.33407   1405.58054    633.36668    363.36841     89.29045   -195.56506    -97.61091   -203.65356   -162.96112     15.39368   -187.28436   -243.12647   -301.09328   -205.66123   -199.50044    -54.48295    493.71221   1448.69888   2647.51677   3029.73319   2311.17244   1294.68125    416.35927   -129.77471   -491.67542   -475.85639   -322.52966     37.87818    393.82323    292.40272    158.93237     54.17525      40.7602   -296.18191   -283.65137   -373.91502   -133.93872   -251.97967   -445.28607   -385.67775   -381.18146   -364.68108   -271.50009    -246.7074    -58.44699   -241.67445   -304.11293   -187.66527   -302.30164   -143.92281     82.01899    306.07409    679.62297    854.99998    826.93601    595.80317    267.08003      200.779   -204.53479    -37.26692    -199.6173   -127.52105    -55.58596    531.58065   1383.38175   1870.36331   2642.75016   2775.82001   2313.14614   1662.97507    855.87122    385.75818    266.70762     38.88366     26.30547      42.6424     21.57953     -6.05553   -299.60327   -289.32993   -362.49447   -412.68268   -224.13598    -324.8298   -326.46496   -160.66258   -234.08534   -238.86292   -232.53085   -202.05344   -224.18913   -129.07854     -4.49272    217.48046     31.56401   -162.91246    -66.21122   -154.85882   -152.07818   -323.60416   -152.01875      3.96981    -25.81982    221.03224    293.58566     71.10058    122.01806     18.18989    -82.03223   -154.60194    -60.60936   -145.83407   -192.26506    -60.61531   -295.10686   -418.73497   -401.76307   -253.89928   -397.02296   -197.58651   -181.87509   -210.80987    -96.87483    124.85048    274.17097    184.14026    179.95254    229.63887    229.64857     359.0514   -115.77689     -0.93733     39.52164    151.82454     66.79106    -38.02708     36.31823     148.3885    152.83749    130.27937    -90.80573     -36.5953   -313.34398   -312.87063   -208.46345    -230.3341   -401.33393   -262.96445   -487.82247   -359.83553   -255.10866    -93.87575   -114.90883   -219.38485    -70.07272    -18.46087    101.45236     67.12025    118.65199     76.71949     68.98295    -15.23284     65.24746    198.73851    271.54276    211.78888    102.36377    112.16131    130.42901     228.6458    263.31734   -206.03359   -179.50545   -348.52589   -221.04632   -297.97627   -242.63709   -509.97339    -296.5014   -314.44389   -256.07526   -156.64741    -52.70902     -30.8461    -63.94475     22.62988     65.08599    220.81327    288.70168    277.32333    562.58875     575.8098    487.55717    547.81028    611.52479    248.33994    338.22752    152.13412      20.9431    -34.94921   -137.87725   -122.22584   -169.58268   -338.46669   -127.83811    -68.45383   -329.69936    -72.30088     33.38468   -158.77316   -209.98983      3.88738   -133.54633   -159.59047   -241.62714   -252.63593   -412.28825   -127.31236   -289.55609   -328.53884   -384.07422   -360.14196   -588.24773   -377.58034   -345.98309   -406.06631   -365.84643   -413.35772   -366.87128   -345.54052   -376.04547   -412.44115   -159.81637    -312.5923   -236.05476   -350.29245   -366.90645    -258.4656   -109.06468    -39.12235   -111.21528   -228.31635    -94.66492   -101.07741   -155.77523    -25.18223   -214.97001   -198.76695   -242.44246   -316.59544   -502.20143   -354.51589   -223.35397   -314.87725   -348.81057   -287.93579    -174.0812   -111.46138    -16.59472    -60.29278   -168.55243   -226.12319      1.25776   -183.47436   -157.48335   -190.16095   -188.10667   -161.89772   -294.42943   -206.89091    -194.6196     19.24377   -215.95504    -98.84239    -63.73304   -151.47041   -167.98521   -126.18531     29.91427   -140.18384   -233.99249     -3.97056     98.88053    -96.22725    138.05623      57.5786     33.26005    373.14848    -34.53737     75.01967     118.2092    -39.20963     -8.73857    -80.66258    -18.41878      4.59933   -211.03273     88.49201   -148.83469     13.03355    -415.5051    -26.95011   -151.72516     48.11921   -133.36532   -271.93225   -284.78718    -33.93891   -202.01846   -204.88219     -38.8935   -269.75377   -183.49168   -511.49722   -325.52955   -136.64398   -210.95773   -335.67017   -452.94454   -242.10063   -367.10614   -200.10412   -476.86968    -15.82242   -181.29912   -415.83204   -406.29447    -450.4825   -207.72937   -189.16937   -621.36692   -517.57286   -229.01469   -528.96058    -154.4713   -132.59903     34.68446   -238.70081   -428.30874   -335.62879   -348.60333   -267.59726   -725.48923   -399.25247   -364.66542   -442.73096   -553.28165   -314.91417   -333.18568   -329.90178   -515.10511    -492.0484   -490.67186   -407.73463   -260.91837   -320.42749    -583.0267   -744.97455   -725.34432   -795.68053   -801.58127   -659.72229   -934.73905   -966.76675  -1132.17187   -857.32175  -1204.47004   -696.49638  -1046.05976   -706.38786  -1126.04266  -1074.89757   -770.58626   -771.59927  -1375.69906   -907.57634  -1073.92712  -1259.09669  -1415.27612  -1526.01993  -1625.68202  -1067.21968   -1299.2859   -826.95298   -923.81748  -1502.41181  -1259.57162  -1278.28677   -984.21174  -1172.99972  -1098.94953   -1025.4389   -910.72917  -1497.39576  -1054.58396  -1234.86319  -1024.83219  -1384.85507  -1549.22237  -1105.44219   -948.15904  -1632.54758   -732.09382  -1327.25512  -1316.42423  -1294.02299  -1136.51264   -935.91342  -1430.39147  -1040.82807   -951.84054  -1424.96535   -958.98853   -998.51695   -754.70535   -362.83413  -1137.31469   -392.52038          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       -0.50   -185.04851    -265.0281   -127.92038   -319.29108   -208.92209   -173.13495    -308.5591   -326.09367   -279.70412   -365.68653   -193.57811   -277.14752   -245.50738   -318.54857   -362.94451   -394.33306   -169.06453   -383.27847   -352.43698   -323.68184   -350.28079   -278.41179   -261.72574   -185.59266    -43.02225   1328.68406   3659.05278   4444.43398    3497.0109   1334.42046    212.41862   -171.42435   -152.25041   -466.17783   -290.92927    -87.47273   -309.46224    -219.9801   -281.35598   -220.49705   -282.57868   -236.67261   -306.57372   -265.50859   -333.77058   -473.44416    -599.7105   -136.32561   -319.54852   -422.19617   -254.27577   -401.70343   -346.02617   -315.89995   -309.44821   -367.16104    -240.4972   -304.39054   -382.39634   -251.87925   -238.55425   -302.16252   -281.38135   -440.97519   -452.05859   -245.02913    -324.1976   -420.55304   -303.43954     36.71878    726.32311   1761.12229   2534.56616   2143.44902   1350.52021    597.71673       71.845     51.17399     24.50251   -131.76836   -323.22096   -254.87969     -243.005   -224.10032   -228.96206   -216.44708   -306.23109    -97.56589     51.03753    604.49024   1454.86705   2650.96876   2946.53875   2344.81526   1279.17587    265.17052   -152.24658   -387.32247   -321.79537   -150.36811    -40.75447    141.03479    354.32208    157.02873    204.59271    -90.97652   -324.03783   -229.71923    -184.4659   -294.73104   -319.95215   -183.50621   -403.96807   -339.83162   -120.39594   -405.82525   -214.93723   -176.79682   -217.33429   -232.63031   -170.13597   -276.44045   -136.93171      35.5975      390.069     667.4127    938.65351    729.16852    609.88928    190.80141    -53.81666   -121.55269    -333.9885   -112.41327    -31.95955     35.28527    538.25943   1332.07768   2096.04314   2838.44533   2759.34104   2470.14195   1605.74279    963.41831    507.13183    354.97571    114.41549    144.68374     -0.72243    -64.73252   -126.93914   -333.86369   -282.88901   -334.87015   -309.09017   -275.35596   -300.47263   -375.43723   -106.36589   -285.68802   -397.04138   -147.97928   -133.33744   -303.58501    -48.13049     -10.8491    132.08187     55.70945     89.16463   -219.34595    -235.1162   -218.71097   -277.25956   -258.96021    -42.30497    121.37915    260.21522    382.36029    262.31405    302.01893    137.08033      41.1675   -125.57936    -73.36622   -131.31538   -130.75869   -245.82685   -218.86401   -263.04262   -431.67085   -300.14898   -308.19364    -387.3269   -204.91256   -166.79618   -236.87121    187.28051    118.54199    200.94935    244.59629    185.54669    215.18815     138.0707     24.91681     22.00689    -79.42626    -21.62091    108.90499    -26.25658    125.56343    213.82179    144.66113      30.4983     36.98498    -32.97543   -162.78979   -345.17841   -270.64321   -316.37743   -328.09817   -318.59167   -309.92595    -440.4831   -256.36739   -127.65897    -169.9589    -74.97173    -70.44557     55.75682     -73.3983     58.73953    180.22697     72.55519    127.97729    179.86203     76.95032    111.50995    302.86344    221.97159    425.93711    230.90477    303.06715     56.52591    -53.00133    -23.17363   -242.23962   -139.21471   -208.25273   -180.47915   -291.82921     25.59596   -231.86459   -222.82493   -300.98024     20.25456     94.92927     -4.27425    -23.30492     292.1488    144.50301     199.1884    548.37646    326.02467    665.36317     378.2761    758.92278    502.61655    524.34798    280.85402    236.95487    113.82934    102.54489    -67.70574    -78.15037   -221.92444   -136.16139   -223.26621    -93.10652   -178.86311    -50.05952    -161.1324      -87.462     -0.90873      -63.158   -101.43775   -115.82592    -204.5906   -198.85214   -187.75946   -277.17003   -377.17001   -342.14723   -535.03821   -246.11405   -422.32544   -335.97539   -414.51869    -371.5156   -360.24257   -357.66367   -442.57077   -359.13764   -388.61955   -530.17601    -379.2479   -424.60657   -315.83451   -398.38877   -229.90043   -209.77371   -178.46802   -203.46466   -143.33367    -87.10185   -151.75782    -179.8757    -59.42266    -48.98288   -135.38875   -152.64882   -148.76111   -207.71278   -120.52628   -361.34703   -272.81628   -269.15847   -168.53927   -187.81503   -217.99114   -185.94331   -165.39583   -231.91403   -191.07586   -111.15916    -81.42683    -91.20108   -186.56442    -72.11534   -286.14559    -95.42026    -65.96795    -36.41666   -164.90608   -109.38439   -154.91237    -307.3118   -176.13196   -274.07824    -73.13506   -360.40241   -114.73019   -234.72835   -115.53063     15.26787    -53.16587      7.17885    -41.36927      3.19476      2.78412     87.43766    121.74214     28.37224     23.90629    143.46607     90.87747     59.93759    -36.69913     -4.33982    -38.01596    -46.02503   -143.47807   -263.95882     -26.3233    -46.20069   -211.61669    -64.50096   -132.91417   -114.62729   -184.60397   -136.70566   -146.30935    -403.3447   -150.88446   -167.47024   -132.17072       7.2711    -78.11661   -242.12983   -282.51273   -488.67022   -387.96614   -265.51152     -61.3871   -178.44073    -156.0162   -363.71926   -225.08164   -448.87007   -562.15771   -428.57958   -341.99588   -266.00631   -196.82388     28.48356   -502.95093   -272.48685    -15.17729   -107.48817   -476.99965    -205.0812   -450.34398   -421.89958   -361.20315   -377.83993   -409.54263   -304.86716   -488.43881   -220.96424   -625.85777   -431.67041   -417.31917   -572.54141   -308.34922   -449.36306   -487.13728   -520.70005   -696.26088   -398.67324   -467.45104   -651.01702   -739.88116   -787.79881   -827.30671   -655.26226   -591.97758   -492.33868   -676.22731   -869.67479  -1066.24946   -874.61975   -838.01959   -932.51515  -1318.01321   -752.08607  -1207.66959   -901.36434   -992.36919   -927.45446  -1109.27879  -1244.73047   -876.31001   -915.99041  -1181.21246  -1004.27708  -1186.33607  -1233.13283  -1143.37672   -978.16946   -945.80984   -823.47389   -1510.6512  -1088.21506  -1088.12077  -1448.16134  -1114.74215   -814.41957  -1239.75127  -1231.30908  -1515.42081   -627.28991  -1152.34302  -1035.19643   -1205.9403   -905.01609  -1167.62275  -1283.06322  -1197.90717  -1147.09436   -737.06299   -1505.8402  -1179.71395  -1644.27692  -1127.02592  -1188.25474   -854.01656   -547.32073   -700.51398   -963.77147   -872.18354   -210.69891     -588.816          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        0.00   -181.81366   -186.03683   -111.89463   -323.41287   -168.36268   -101.33639   -310.66994   -357.57937    -353.2843   -342.46357   -234.01086   -347.56363   -214.06063   -455.28626   -435.02022   -435.92646   -358.37536   -586.62894   -239.69887   -245.41324   -428.19062   -323.32801   -162.18518    -89.57789   -161.95834   1148.26874   3442.17064   4476.76731   3853.07549   1235.47597    332.51538   -108.14073   -227.10929   -281.85776   -351.38684   -400.48486   -361.95304   -403.49045   -493.17021   -422.01689   -232.83857    -479.9557   -286.82534   -224.00706   -355.43573   -344.93285   -303.35797   -282.40994    -473.7121   -243.83432     -326.312   -271.25571   -462.89042   -457.71068   -513.10737    -201.2595   -385.03908   -269.41488   -239.30423   -151.16682   -246.84734   -240.87973    -293.6492   -200.83028   -266.53598   -242.96942   -271.72804   -307.95688   -101.98423    -53.09309    613.77114   1622.90301   2384.39955   2214.30618   1371.87053     510.8246    483.26855     20.60033     -153.546   -335.37851   -324.48404   -374.30622   -134.77598   -456.48733   -267.05218    -131.9575   -140.16455   -158.80439      82.3483    586.45079   1608.57685   2707.87219   3183.60589   2383.22612   1502.31391    418.20954   -120.77738   -308.07036   -148.98971   -417.07076   -210.44399    165.64498    334.08877    195.93613     60.92905   -137.52814   -253.82424   -338.43939   -284.67904   -248.21072   -181.60645   -167.89859   -177.69859   -327.89173   -409.44385   -229.45446   -286.93869   -222.11357   -182.54811   -250.24409   -311.09907   -454.22776      -125.97     58.89515    496.64571    831.32351    959.63958    779.50777    590.58127    355.62284    -18.65418     -60.7671   -131.28084   -200.49189    -73.37587     -0.78904    487.01215   1199.44938   2202.43617   2754.03738   2850.18282   2389.02736   1649.09742    919.13535    497.22468    230.64575     28.43224     47.48823    169.98552    170.82118      7.64978     -6.43374   -169.32518   -262.10618   -316.14519    -276.3891   -283.80053   -204.81378   -191.20614   -247.84069   -166.97732   -220.85981   -185.30924   -213.09367   -152.60273    162.25911    -30.96358     19.31719    -66.20969   -182.47299   -216.51063   -247.33611   -422.85788   -241.79104   -204.48918    103.82803    221.56913     331.4732     276.4028     58.67237    105.33027    -150.6673   -196.52619   -180.68011   -228.01343   -333.87563   -201.41397    -184.4474   -360.85073    -367.7039   -266.66227    -331.0691   -334.96744   -257.95103   -280.18034    -82.05698     92.37378    -69.61794    202.91394    228.19627    205.67648    258.84669    271.89053     12.16278     -78.5393     82.51963     55.89458    -57.35043     41.85867     213.5864    -79.19119    150.96249      -54.931    -12.81392   -197.85639   -238.68398   -236.40126   -356.78708   -277.45274   -245.20273   -420.21284   -379.56231   -410.56919   -119.71614    -58.89682    -82.23761    -19.18989    -88.88153    134.52579    -75.79538     18.55547    -68.25975    114.56108   -146.57813     36.17231    202.39987    308.78548    355.82378    428.89707    275.70761    214.07199    146.56564    108.86753   -110.48536   -171.12976     -51.2298   -189.22902   -234.73221   -153.75472   -255.49946   -208.25174   -408.84389   -190.25494   -184.70642   -132.67325    -37.15522    -69.47447    -34.86007     39.05546     63.75384     244.7792    654.70203    515.11353    510.31211    424.69152    584.71093    786.75946       640.39    629.50429     433.3996    196.26005    162.39232      98.3238     -5.51026    -84.84684     50.62692   -144.61619   -141.59046    -28.84302    -65.64652     11.48181    -37.75803   -180.88946     78.35299     52.90865    -66.67362   -120.70418   -181.01952   -120.34201   -218.19779   -409.51201   -250.78344   -230.88556   -385.40957   -451.78994   -331.28999    -483.7353   -428.63118   -513.41934   -574.37983   -293.49398   -434.54353   -450.89232   -197.29214   -277.69591   -157.83739   -216.75883    -273.4341    -209.5109    -67.38457   -226.92449    -79.77582    -52.54872    -91.81763   -103.86401   -250.87749    -85.33355   -129.27617     -1.74738    -41.35941   -164.11564   -113.25517   -200.63062    125.24665   -159.80688   -205.85461   -284.42724   -190.51024   -126.65516    -164.4606   -219.30537   -345.61216    -10.26071   -128.35971   -222.16176   -157.46334     -37.5561   -410.31157      2.39151    -67.70306     -4.68643   -199.78804   -124.91372     -4.52411   -162.31304   -192.71708    -194.6141    -243.3963   -118.29806   -160.18392    -53.26642    105.12134   -105.23164     -9.61797   -311.81127     74.94587     -9.96631     26.12606     73.05362    224.70249    254.09935     80.05281    205.18228    182.83819       -9.818    -38.44585    -30.78184    -30.19513     28.68884     70.72149   -183.19309    -26.47958   -161.19947   -301.62527   -169.75603    -73.16756     49.40132   -141.32741   -242.51497   -250.94662     50.22254   -207.15878   -209.77771   -151.82689   -123.64556   -208.16218   -233.09231    -115.4272   -244.80424   -271.08439   -286.43176   -200.61069   -420.24598   -260.56216   -265.01759   -402.71111   -289.32962   -434.35864   -435.67173   -139.13405   -198.21113   -348.24787   -229.88434   -360.64041   -424.54175   -105.78054   -602.51251   -415.12761   -366.52071   -297.51391   -236.99588   -204.66741   -273.98077   -224.28042   -197.02988   -156.28137    -469.6874   -265.73923    -25.08245   -358.97711   -371.76716   -138.38424   -626.77991   -335.29992   -657.20391    -252.9697    -705.6214   -930.17151   -692.39396   -404.40738   -979.44916   -494.16861   -731.98733   -602.77639   -856.28988   -723.70448   -835.96076  -1048.25338   -734.10903   -794.04525   -849.36082  -1100.78166   -942.31192   -796.60492  -1131.87724    -736.2588  -1165.06913    -748.0727   -936.04523   -993.34711   -752.37447  -1091.00719   -1090.1662  -1352.44976  -1189.26923  -1020.64934    -1283.284   -968.95305   -902.57765  -1038.79749   -930.14486   -816.92813   -1297.0029   -1094.2767  -1107.40094   -1078.1568   -807.18708  -1021.60455   -1213.8578  -1283.73279   -764.94825   -1320.5639  -1744.06937  -1159.62479  -1294.86926  -1166.01557   -932.43533  -1311.73498  -1095.54453  -1276.22638  -1028.25051  -1688.29712   -615.73359   -1462.5673  -1529.55214  -1329.21872  -1037.80766  -1448.81332   -1479.9963   -1288.8543  -1026.80976          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        0.50   -325.12151   -258.55938   -225.18556   -399.11666   -293.64479   -290.42273   -329.11688   -363.70398   -383.59031   -246.81534   -235.06511   -305.41227    -516.2964   -383.44952   -234.12864   -336.02801   -361.00107   -561.23509   -155.61895   -283.91793   -388.05574    -207.6387    -171.8573     82.51731     342.0198   1107.94097   3396.73776   4761.05094   3658.09997   1453.60798    260.97914   -281.45232   -113.81721   -135.82648    -330.5935   -244.84264    -53.71775   -313.08443   -434.12338   -373.82999   -157.79927   -305.60716   -311.26549   -384.89243     -383.191   -533.45827   -259.84749   -230.65309   -381.58279   -303.84782   -404.81901   -289.25492   -385.28303   -402.83734   -460.87077   -383.84437   -386.97132   -222.37638   -155.87548   -225.25207   -261.69113   -221.82826   -351.31608   -360.33512   -312.07579   -302.30631   -363.79832    -208.4811   -186.08754      67.2184    735.84324   1603.07863   2560.00717   2043.79733   1478.01192    750.98378    333.68663    188.80075    -96.37916   -224.48811   -308.77188   -289.54428    -59.45945    -391.5976   -388.39576   -135.95602   -303.66076   -347.09183    129.06536    479.02805   1768.21107   2765.44407   3154.68466   2294.22999   1272.09204    551.92018     25.26827   -331.24414   -382.55192   -212.30087     98.31673     44.65866    293.05487    206.96442     80.24152   -193.52919   -224.68333   -247.48704   -390.38415   -416.76587   -438.19891   -290.76497   -450.23244   -467.37927   -252.66197   -223.74377   -258.57656   -292.90191   -160.31238    -253.4177   -195.73468   -185.53923    -73.36673    131.65768    457.16423    730.24165    718.88724    755.57707    520.74615    429.50984      7.29257   -116.87805   -220.48026   -274.84678     -90.1625    -55.07065     467.4153   1236.05877   2195.82446   2918.88078   3030.08606   2401.01132   1722.71279    810.88354    271.40827    123.94042    128.41412    448.67922     130.3853    159.35057    -159.3689   -168.18849   -142.13349   -445.36536   -229.23281   -356.34994   -428.86595   -344.65685   -378.07025   -119.97741    -60.86082   -301.41416    -54.96219   -200.05318   -184.06624    -87.63658    113.05486    -26.69577    -213.7294     -109.467   -202.68508   -266.18507   -211.14982    -239.8126    -92.54443    243.02381     87.21322    250.52269     119.5874    237.60755    138.97646     45.13097   -158.45132    -76.40316   -129.21312   -223.28811   -172.15726    -254.5506    -296.9005   -267.45636   -236.51251    -244.5125   -309.48065   -228.65037   -214.70735   -196.24473     -8.18159    119.55922     116.7813    275.47717    148.42095     242.9238     61.77127     72.75421    -77.57212    -58.03853   -118.58743    -42.55357     90.13752    191.59432    234.30497    -43.48298     -5.77866     173.4103   -151.47552   -294.88698   -230.07119   -298.98647   -154.04883   -464.06997     -366.259   -360.41629   -350.41574   -344.18781   -118.72973   -103.44875    -71.79538   -101.88759   -103.10133    220.80933    149.23656    125.67625    -10.64354    127.84226      52.1755     131.4076    299.27283    257.01182    312.77117    390.56115    259.58044    154.33033     94.85729    145.40683    -37.18537   -254.90927    -190.8982   -329.78048    -321.3766   -337.61028   -244.61027   -256.84128   -102.95104    -123.4469   -281.73051      44.2655     68.77093    143.67395    184.50819    170.53551    318.24514    469.10905    519.47611    677.38778    646.06212    672.39566    615.23698    579.29057    477.56799    414.48514    238.79686     277.4738    -106.0561    -24.74544   -212.86926   -188.09172    -16.04721   -141.97711    -12.62046   -122.29405     76.72388     20.83876    -58.69837    -26.74764    -55.24091   -104.34031   -107.54576    -68.20622   -235.51614   -227.54977   -194.11905   -235.12257   -248.96869   -331.64651   -305.14652   -443.17214   -517.39779   -419.40333   -468.46058    -326.8523   -411.40292   -284.22156   -285.73592   -456.96018   -215.71928   -178.12297   -322.78564   -185.94659    -97.79375   -220.92915   -204.22636     -28.3857   -334.74117    -81.32157   -156.71239      -99.871   -129.82044    -41.62771    -54.04211    -56.77464   -131.77574    -80.79032    -36.57791   -107.99993   -285.68925   -135.86326    -50.22108   -149.72761   -211.63612   -217.76821   -218.03438    -88.91149     41.12365    -180.5806      3.86715    -97.20403   -155.49201    -60.09574   -260.59615    -41.95778   -269.39509   -230.00867    -49.02457    -69.15429     19.22205   -308.16964   -289.64796   -167.97794   -256.19626    -88.17998    -98.94959    115.39481    -70.65036     54.65181    -63.64937      9.33474    209.12522     39.19317     448.1265     59.12761    441.14655     233.5769    105.44158      9.53685    127.34474     66.76152   -151.13414     53.43447    -97.37112    238.29509    -77.15932    -56.10506   -341.25971    -23.59959   -227.15861    -42.50887    -75.42123    -24.32086   -154.27928   -121.11273   -198.62284    -119.4129    -17.12506    -79.45771   -125.73591   -442.63391   -627.60584     -1.65097    -170.1804   -184.26062   -213.67044   -340.46821   -305.55053   -403.48074   -178.57778   -442.26253   -452.88098   -125.11008   -380.10421    -58.88783   -162.62337   -157.89017   -137.30161   -309.44545   -338.87265   -141.88739   -315.24784   -360.55048   -220.07907   -349.93806   -204.95439   -405.10366    -361.4504     68.99553   -419.83638   -391.94561   -250.64186   -232.19344   -449.60269   -120.73152   -444.39323   -259.32303   -380.85549   -770.49155   -729.87866   -501.78881   -472.27999   -618.46072    -339.8666   -567.44866   -615.96952   -566.66964   -711.00882   -776.81784   -859.46767   -931.65544  -1038.12954   -777.50578   -864.62901    -579.6147   -896.24585   -806.03126   -739.99585   -746.96224   -695.33651  -1059.20514  -1032.93536   -538.35618   -952.28325  -1126.16221  -1262.41329  -1087.23347  -1144.68572   -973.32785  -1207.93516  -1162.85802     -894.586   -950.49994  -1211.76926  -1079.90431    -892.7802  -1122.48615  -1314.44325   -1039.9176   -891.18198  -1433.80476   -622.27045  -1115.53439   -883.49656  -1169.39182   -778.32391   -981.22165  -1196.32315  -1180.42744  -1207.84024  -1557.50506   -994.89819  -1072.99213  -1208.61903   -902.97682  -1167.22626  -1271.50551  -1015.68057   -922.77163  -1037.05934   -608.99806   -963.94137   -648.52975    -342.0032  -1116.64619   -293.85918          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        1.00   -468.04991   -330.97256   -339.96856   -478.33738   -419.52344   -474.62113   -338.91999   -365.62828   -392.77007    -251.3234    -271.8932   -296.71147   -582.39288   -333.00622   -175.75043   -270.73953   -346.31644    -338.8432   -142.69848   -265.33189   -209.02058   -134.46482   -231.26153    107.22271    149.33245   1309.42874   3242.79482   4935.25058   3785.46184   1631.04421    369.34838   -245.53392   -155.85516    -67.19484   -193.99428   -134.75141    -221.5859   -203.16027   -279.15411   -226.35767   -283.81643   -513.92096   -349.90643   -245.37021    -509.0392   -369.93008   -331.05117   -372.99098   -352.60341   -228.08431   -326.98954   -391.80057   -368.08535   -227.34563   -391.86859   -165.19597   -394.41935   -433.28559    -43.68951    -143.9968   -212.57766   -365.13421   -276.69182   -299.15024   -313.97445    -341.5279   -365.79001    -158.0064   -243.26179    -32.27366    784.03831    1619.2712   2411.48468   2186.63764   1384.52319    530.77836    246.38955   -144.75797   -349.66618   -383.82011   -428.39625   -519.32154   -356.45363   -302.20719   -296.60926   -292.95334   -191.51314   -116.57823      96.9129    515.86333   1704.52526   2767.47598    2860.8087   2614.51074    1420.6385    705.98738   -287.94556   -197.17936   -454.67331   -208.50787   -144.05217    134.50049    379.15815    120.23826       49.765   -234.22646   -256.21402   -196.38001   -281.67236    -302.3118   -247.02433   -286.87373   -335.59065   -347.34662   -358.73473   -306.57917   -192.22432    -113.1147   -228.45028    -129.8746   -272.94889   -226.97781   -218.18828     79.28835    433.65645    594.18424    842.43665    944.32708    664.90892    517.34562    122.74136     35.68458   -317.92154    -56.01387     -107.093    111.13018    391.17366    1354.3962   1969.87013   2673.61723   2972.86005   2535.28527   1519.10799    866.29329    285.67802    191.46089    116.28177    101.15442      82.9733    174.41557   -238.18316   -169.13656   -253.69962   -432.21024   -287.66848   -207.74232   -147.66433   -248.06396   -272.12244   -212.57101   -300.91135   -199.97467    -78.99349   -170.73907   -154.62876     77.84604    -33.40021      36.5381      5.99171   -146.89977   -256.99057   -304.75436   -283.20732   -172.43942   -104.38136    183.97643    271.57452    259.57063     243.0067    218.50857    164.75869     25.00177    -58.54098   -188.08574   -208.02082   -150.26706   -245.91405   -245.50098     -104.498   -280.62501   -339.52667    -256.7623   -322.03426   -293.02169   -297.55005    -157.7277     97.71947     -10.6471    234.47887    342.15788    304.50888    121.80226    213.38567    187.90708     35.21239     95.85424       1.9194     86.65121     87.15164    212.30851    -61.98746    185.01148    110.68363     54.28267    -96.73262   -194.57755   -439.94214   -141.13342   -333.34675   -397.58511   -277.70297   -341.64182   -317.31693   -239.13376   -232.61148   -239.29283   -100.09887     19.43443    -66.83828     30.24265    102.39432     32.39613    191.70012     55.42401      5.23604    -32.61625    248.71627    316.53399     299.8954    420.58497    251.75281    141.60335    -17.39327     10.33809   -144.49127   -370.92514   -215.27568   -298.78369   -331.30623   -214.86051   -135.37011   -274.15928   -174.03418   -162.56455    -80.27716   -184.58873     28.10264    164.45759     34.13581    164.22492    251.88013    330.85038    554.54838    588.02567    595.72491    718.99665    675.12376    680.57238    541.08762    426.93133    332.43317    182.19081     70.45761     -73.3918   -244.19779   -206.02897    -49.65439   -200.96184      22.4011   -127.32261     -8.36606     41.72648   -118.63024    -50.79832     -32.9846     39.51914      3.13299    -40.91784     -8.16499    -117.3585   -364.11458   -360.03811   -146.53237    -283.8064    -344.5297    -343.4503   -357.62123   -450.49896    -478.3436   -222.83402   -224.45435   -265.38265   -339.65747   -215.45223    -183.6381   -275.28239   -217.50704   -220.25064   -277.22973   -168.66158    -81.96659     27.02364     -73.4954    -18.65631    -85.93061     57.03139    -12.50786     28.11317    -88.97852     -42.3294   -221.02151   -166.05082   -241.46923   -230.93209   -154.01291   -193.67971    -222.9143   -158.45187   -206.72305   -136.59433   -119.40097   -131.75135   -129.09252    -96.10688     88.54639   -115.61858   -138.43331   -239.40739    -25.00492    -28.57926    -84.80817      9.06164   -249.06154    -160.8392    -204.6972   -245.35401   -143.49491    -95.09258   -362.42399   -197.12241    -84.12583    108.93553   -141.41611   -207.79844    100.25526    -44.92573      91.8854      196.042     13.92054    241.27294     114.8074     64.39264    168.04754     308.4121    -86.20579    -50.90083   -142.07078     89.78511    -18.65161   -179.46589    -318.0858     44.01614    175.22915   -113.19022    137.86233   -119.74256    100.31791   -168.22042    -73.05274   -102.46402    -75.75387    -40.68133      50.5265   -236.43602   -162.89392   -120.77309   -233.38565    -29.80515   -181.97356   -241.38847   -331.47484    -99.45781   -393.21259   -173.86889   -166.68603   -251.27495   -150.48283   -354.48025   -173.86647   -318.37145   -303.79238   -156.70723   -403.47382    -140.5192   -332.17385   -163.03573   -245.07793   -377.72288   -288.02805   -271.97274   -264.52763   -300.28328    -180.8877   -528.22939   -174.32767   -229.92872   -322.96872   -252.54703   -182.27664   -226.53709   -353.96131     -320.468   -362.04315   -469.26768   -664.45783   -339.29783   -583.08984   -661.50093   -596.81072    -529.2589    -625.7682   -805.54122   -789.45907   -646.97156   -777.93975   -824.11951   -852.52721   -804.95828   -498.34773   -816.79366   -728.38122  -1096.27172   -837.89325   -914.94843   -880.99631  -1194.16218   -995.98985   -861.98623   -979.78328  -1241.91533     -976.098  -1080.43748   -897.89843   -750.27634  -1031.14854  -1084.72224   -937.65977  -1308.71331   -744.02158   -794.51124  -1045.74466  -1048.56399  -1231.17208   -1036.2377  -1521.61826  -1141.82117    -489.5142   -821.48482   -992.42147   -865.56484  -1423.07894   -941.25184   -820.93631  -1100.28306   -810.41104  -1169.98252   -830.27091   -883.56274    -1299.215  -1058.17032  -1712.32739   -994.81526  -1033.01653   -809.41544   -634.23927   -807.31941  -1288.50996   -171.51976  -1261.20192  -1405.21052   -1448.8061          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        1.50   -406.21967   -334.87912   -394.97295   -379.33985   -306.37986   -446.42861    -245.4133   -347.70642   -333.75593   -496.48367   -378.58542   -341.46629   -362.72052   -307.41613   -242.48514   -225.16959   -329.63968    -70.24805   -147.59475   -232.44639   -142.55184   -176.50628   -285.54607      1.43019     83.59396   1354.99447   3355.64997   4720.49666   3876.60311   1573.54287    232.07554   -106.40031   -245.67068   -173.71991   -406.83051   -346.42365    -166.2698   -142.96816   -495.15235   -447.41075   -304.38251   -395.16799   -429.27994   -315.89358   -276.60823   -502.96309   -376.80953   -192.19835   -122.51397   -503.05504   -390.25637   -433.06713   -281.09565   -357.65737    -350.4987   -437.21155     -265.842   -211.90879   -211.01927    -99.96587   -169.41794   -263.55307   -272.10746   -333.58596   -288.06852   -357.34176   -194.51272   -233.16447   -115.65161    -56.42821    557.23852   1771.78262   2565.11605   1994.32547   1191.82707    445.34918    206.74948    230.89363   -202.02051   -494.90557   -489.49433   -649.36206    -256.9483    -205.8725   -320.10522   -325.19745   -318.51299     -84.3437    101.15256    738.68853   1697.12433   2975.00105   2958.96599    2389.0912   1041.20605    489.29718   -131.69836   -115.12601   -266.85009   -165.85932   -142.20331    235.35625    418.03157    222.17494    193.69864    -89.61871   -422.00487   -288.13226   -319.11067   -347.22631   -303.99213   -532.43282   -512.81669   -299.17768   -360.61406   -259.46711    -186.9418    -94.80833   -133.87278   -332.13544     -51.7391   -128.57487   -135.10613    112.79903     309.7182    599.46126    1028.9204   1017.12882    604.55003    365.84944    219.21703   -221.79291   -151.54873   -221.51272   -219.11214     41.40108    497.62592   1176.52838   2236.74158   2468.87614   2788.93389    2538.4625   1909.06735    917.61002    484.41934    298.88903    215.44531    180.88362     63.03497    -133.4256    -40.27661   -158.91707   -202.56877   -191.54354   -334.15386   -319.98944   -109.34461   -432.15306   -205.06309   -378.43373   -142.75476   -419.68143   -229.77016   -151.83664   -154.96638    -84.14463     17.09495    119.54886     62.23291   -176.17174   -180.26813   -101.70912   -129.33079   -131.70447    -18.26504     15.57336    185.99397    419.55113     144.0255    226.21904    -98.39816     -3.47522     -51.2098      8.32328    -110.9169   -154.25695   -191.51182   -188.59984   -456.48277   -337.55426   -350.25671   -346.44635   -247.72347   -200.16723   -186.41856    -61.80234    130.11162     14.90751       76.573    231.83676    228.42543    339.40251    177.47885      83.6458     -42.5874     72.16533    -20.45939     98.81553    154.31241     219.0849    258.46208      34.3771     44.02374   -123.93504   -286.79734   -223.24218   -296.72992   -311.78784   -252.71907   -394.93768    -403.4944   -302.71083   -227.80445   -193.88589   -234.76056   -159.51892    -84.97634    -22.13519    104.70437     72.08402    160.40207     140.7809    167.11367     43.37178    117.78765    114.43026    142.49694    188.95455    290.89917      249.634    333.28726    236.26398    151.95814    -17.88699    127.04555   -199.73055    -193.2826   -209.72701     15.85754   -223.99805   -215.46832   -294.76382   -221.64589   -146.71007     -18.4097    -67.95907    -11.43971     14.05977      71.4858     31.85474    192.38172    484.16575    423.02723    698.55443    558.91084     684.4103    639.41057    634.82672    598.27453    454.09584     343.4532     35.54101    287.36038     12.89618    127.80597   -136.78296     43.83939     26.94324    -69.74841    -35.46497     130.8537     74.56112    -86.00842    -17.21056    -57.55894   -173.71229     74.19593   -179.30037    -79.20496    -96.55334   -333.81065    -240.3807   -421.60456    -179.4838   -343.48701   -421.47645   -391.25862   -251.66281   -410.82031   -393.09999   -262.67552    -316.0288   -327.10609   -149.21161   -334.00096   -315.14165   -189.40355   -143.92829   -284.86643   -259.84324   -184.08907    -76.61984     61.59418    -22.40231    151.21662   -161.90782     68.87441    -10.33555   -144.85363   -257.60037    110.82599   -148.00266   -241.07218   -139.35702   -177.24414    -321.8018    -93.18284   -209.53826   -200.85242   -204.11459   -221.09326    -153.9391   -117.76932   -164.86654    -50.65599   -166.92082   -205.65646    -29.32645     44.02028   -103.11077     -7.15946   -247.04216   -108.77474   -216.47183    -60.05127   -177.67998   -124.93413   -188.87284     34.26075   -101.34469     -82.2045    -190.9475     -14.2529    109.48235    -67.28765    104.41952    282.86366    232.72505    206.21261    250.69697    219.75645    226.25464    218.15695    172.75108    223.60003     166.0553    -20.36686   -214.26855     19.11196     -2.06278   -127.77488    -122.2423    188.66189    -13.16874    -83.11859     45.51118   -261.00322   -157.60326   -241.68765   -210.62355     -8.15502   -102.20824    -206.6048      -19.821   -144.00085   -155.54845     78.20483   -226.43662    -85.43289   -207.01404   -513.69229   -215.13824   -254.94816   -353.37693   -344.06015   -484.76499   -311.62666   -297.51917   -469.95213   -489.40483   -500.12328   -389.83962   -466.65193    -244.2622   -287.25946   -181.57836   -262.82444    -398.6915   -252.99852   -292.00464    -97.35726   -282.94643   -340.20406     42.76324   -183.51643   -431.15838   -200.34574   -191.96798   -472.03605   -186.35738   -347.62694   -407.46052   -434.81417   -317.09406    -247.9477   -538.04833   -518.91405   -454.22462   -445.18446   -326.00262   -567.84824    -647.8474   -713.91414   -651.81709   -715.41294   -774.20342   -535.67957  -1016.72468   -734.79067   -868.17625   -683.12639   -798.20512   -846.43519   -765.30579   -725.97523  -1138.46371  -1045.68392  -1021.78012  -1153.10447  -1008.14966   -721.79436   -1112.2859   -832.59102  -1043.15042   -742.61104  -1110.04221   -1028.1273  -1055.20403   -916.06104  -1155.63207   -836.45132  -1071.12238  -1108.47539   -942.83708   -939.98145    -1286.134  -1167.57671  -1153.54966  -1049.24363   -944.61422   -947.23877  -1128.07976   -668.67533   -1253.5822    -844.2663   -993.32845  -1435.67589  -1189.75617  -1434.16963  -1870.79002  -1092.43565   -998.50487     -818.236  -1438.89918   -813.29737    -455.5648   -1037.1879  -1186.10212  -1302.93096   -852.75098   -877.77102          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        2.00   -158.19075   -299.75646   -426.27261   -241.97828    -179.3015   -425.47347    -140.5034   -328.47413   -292.71961   -630.63766   -364.70868   -389.19556   -254.20998   -291.20197   -248.76368   -129.27712   -387.69143   -233.99054    -90.35465   -218.01869   -395.95115   -383.34911    -312.5056   -162.63518     127.7333   1253.41182    3526.7923   4349.73332   3779.97873   1617.82562    213.23946   -108.89836   -274.21932   -217.74259    -292.7108   -182.53233   -237.48173    -52.31106   -490.36804   -450.21234   -417.61378   -282.89187   -302.17878   -341.00999   -271.64267   -475.08709   -486.62619   -342.45589   -410.83959   -405.21484   -304.89777   -382.81038   -327.39199   -303.29603   -258.39534   -177.15535   -199.77588    -301.8527   -180.58799    -74.61521   -188.12968   -271.15981   -444.77807   -264.91688   -223.38132    -88.93626   -354.94068   -228.18612   -300.86799    -61.61211    682.20214   1754.45152   2381.50872   2095.43028   1412.35716    619.17644    -29.96125    102.51193    -80.21851   -358.90429   -362.36923   -275.22197   -492.69123   -209.77122   -313.82951    -86.10202   -188.30577     53.58367     28.95749    535.50006   1685.08679   2791.85451   2760.53172   2147.00561    825.70602      140.105     61.23036    -176.4562   -311.29977   -265.92709   -173.79742    202.08651    402.56729     104.8656    -33.54666   -202.91286   -198.86801   -369.97982   -357.99247   -359.54265   -257.65968   -469.29757   -320.18599   -325.37958   -289.10112   -303.09525   -251.38383   -153.26697   -170.15848   -208.46844   -234.62002   -304.25532     -96.9419     55.55093    351.42635    782.66223    793.84116    835.74122    604.49098    360.12155     74.39721     -8.28732   -170.89413   -157.44211    -98.14726     99.77855    428.68267   1245.89722   2135.32417   2774.03363   2868.90309   2504.15868   1551.64649   1137.10075    578.95482     331.5358    144.60765    130.06943      90.8761     73.29218     -9.13162   -241.64239   -317.26034   -283.02714   -286.71644    -228.2053   -359.30754    -343.0704   -395.25885   -177.88897   -384.98903   -246.35212    -51.27235      -190.99    -17.61964     65.75553    116.62073    145.64201   -130.52911    -110.8845   -170.01481   -287.74411   -232.86443   -198.49077   -116.80498     49.17895    199.67741     98.87303    323.52411    165.93282    268.80382     81.39218   -129.08418   -187.59239   -151.77558   -156.42528   -210.12805   -261.54042   -266.58332    -231.9076   -215.65105   -191.48147   -167.93874   -211.62195    -231.1515    -34.99584    -36.46506     95.18562      47.7224    220.10262    166.55561    217.93789     -31.8498    122.99803    -43.38477    -200.1576    -46.44776      7.27841    145.56476    221.00113    152.84799     78.55136    -15.59262     -90.7993    -32.75739    -200.6735   -388.28513   -480.43235     -6.99322   -314.09801    -189.2851   -239.23261   -311.94797   -302.10495   -307.40513   -290.86893    -11.61567     29.40685    -43.73544     -38.2551     67.32985    133.23482     141.5469     83.60914    145.88076    217.89168    226.39184    452.67924    355.13533     367.7157    238.57532    209.20831    243.32169    -40.30534     -44.9977    -62.65376    -256.3645   -150.27392   -141.09684   -184.75243   -174.24074     -187.258    -77.14361   -159.32697     -9.44283    -60.90069     38.33241     19.91101    381.68506    100.11977     34.70697    489.12315    478.15001     744.7094    730.71873    852.27137   1003.83057    901.89897    562.62763    340.18275     420.6006     36.44077     86.39297     -4.75611    -94.37335   -123.60816      4.85176    -33.16258   -114.19173     76.19388    107.15505    142.26553     72.68512     39.68005     35.96332   -136.93121     82.65284   -123.84635    -131.5805    -155.2029   -339.00882   -278.88845   -384.39134    -81.90325   -250.41203   -248.06456   -335.55137   -444.81396   -334.45628    -400.9394    -352.2958     -184.291   -146.83979   -407.90416   -329.84292   -197.11011   -125.51836   -275.97605   -236.75278    -71.48271     -69.5782   -108.15934    -59.48629    -68.66108     92.22803     -48.2693     16.63946     83.82134     31.75784   -118.71221     23.32455   -224.94964   -311.74944   -304.52381   -208.80519   -253.12393   -142.53905   -359.62701   -387.04472   -369.04252   -107.49958   -168.69968     -61.6819    102.74288    -37.20475    192.07039     23.01304   -129.65189   -152.69589    -92.22855    -173.7902     64.31623   -106.43386    -29.52484    -86.77162   -218.83198    -85.83488   -248.28986     -98.4873   -295.09645    -77.97483     88.18643    -69.77509     73.54251    -61.35452    -12.49439     -5.51414      -4.0297    266.32025    184.14218    308.41062    202.56041    156.74712    155.89803      58.3736     61.68368     14.98164     39.07389     96.47793     43.94106    -97.76851     137.1711     26.52878     68.44558     50.86187    101.10033   -325.37378      83.9929     -63.6181    216.50705   -221.19973     98.73997   -162.06343   -213.96775     -9.69375     17.73252     114.3167      53.2597   -355.30967   -354.68951   -172.54509   -235.12928   -156.84315   -103.44117   -108.40655   -272.76058   -389.71948   -292.50096   -186.62311   -188.19752   -170.63709      -321.77   -290.67075   -261.38505   -212.48538   -343.01664   -339.38089   -241.89181     -76.3359   -229.74666    -92.95273    -87.25185   -258.70069   -130.44545   -212.76615    -269.1956   -112.30612   -380.80602     -90.2575    -278.3486   -290.06952   -331.49799   -233.69795   -361.31485   -209.20758   -596.16676   -616.21612   -506.77527   -427.91945   -708.44265   -462.60382   -635.14219   -753.90606   -631.93283   -982.97498   -820.91224   -744.54371   -815.49279   -472.89436   -869.98702   -737.52434   -891.23785  -1079.59731   -944.66225   -815.72636  -1099.51104  -1100.06731  -1173.75716   -990.73489   -939.66932   -913.34136    -783.2398  -1012.81115  -1018.81759   -944.88445  -1122.72623   -754.89686   -825.37717   -882.29395  -1131.05146  -1193.85806  -1183.71195  -1177.83525   -785.61246   -928.44317   -724.92257   -794.08583   -1074.1995    -914.7615   -771.75072  -1060.45547  -1149.60549  -1102.28278   -839.78963  -1035.56988  -1304.20283  -1029.36082   -643.47709   -653.89971  -1142.72618   -179.77176  -1055.50445   -978.94497   -421.76439   -983.06969   -994.95485  -1048.15405  -1624.75653   -368.30038  -1052.31745    -617.2519          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        2.50     96.96423   -261.92267   -443.50997   -166.59813   -206.26045   -443.00874    -365.1154   -260.96217   -324.87889   -531.96584   -193.78057   -432.60782    -192.0143   -277.77764    -277.2263    -54.39788    -396.7762   -348.00769   -118.50805   -312.49755   -347.48792   -347.40793   -316.77174    -128.1382    -26.43776   1090.02825   3589.03703   4235.79719    3664.7291   1549.52977    199.12477    -85.73128   -219.73331    -91.44447   -557.24546   -203.30283   -411.11829   -372.96094    -298.8241   -330.12957   -307.13335   -250.28434   -247.97261   -345.11504   -341.76523   -358.54875   -461.43522   -304.76096   -217.02087    -432.0459   -332.45247   -356.28597   -469.15745   -381.77745    -315.6373   -263.17153   -248.68903   -212.37807   -292.19163   -262.65179   -417.54413   -179.64332   -197.08369   -301.22736   -285.40133   -307.99307   -331.04782   -320.58147   -168.72271   -108.67309    876.02167   1808.81535   2310.97397   2123.20968   1463.91603    666.32842    204.30496     10.23553   -127.47214   -379.17494   -370.39292   -434.51876    -151.8625   -177.87731   -315.95735   -261.54795     -97.9642   -162.91614    152.13348    645.83828   1499.53984   2594.96171   3012.37813   2194.78468   1084.02807    323.86054    105.06972   -261.85805     31.31428   -368.93953     -43.1467    276.80386    220.60356    312.13703     22.61014   -115.87104   -200.47003   -312.91523   -164.85527   -486.97484   -300.17036   -439.00432   -327.46923   -239.65764   -288.46332   -255.63166   -166.51348   -256.85328    -74.00068    -191.3624   -331.03765   -573.90472    -81.01456     58.55414    446.26205    786.54117    864.82774    737.66046    589.13822    321.88875     55.92302    -50.00802   -226.82867   -289.28503     -25.3637    -84.17986     564.2806   1241.42834   2166.21433   2627.28092   2918.35254   2365.85436   1602.38237   1112.27956    407.35237    226.95833    107.75444    198.12403    284.65988    140.06882    -162.4388   -103.41723   -332.86014   -248.90056   -254.94893   -256.63398   -397.80392   -303.64089   -183.13255   -299.86055    -31.23471   -256.32959     -79.0616     32.77095   -262.67604    -22.20317     150.9404    -45.59306     63.12297     26.12417   -309.57243    -304.4126   -223.44984    -38.86282   -199.70015     90.34611    214.82339    294.35826    116.72505    353.78733     70.89743      2.33532   -138.60407    -236.7396   -191.92238   -116.47322   -256.61094   -123.33671    -290.2175   -574.67202   -314.20631   -376.96825   -263.53346   -278.63094   -308.73777   -149.32856    -99.15198    -26.56792    111.98931    302.34387    138.02174    361.50754     10.41676     36.87092     -7.91583    -23.55789   -125.75166    102.43038    161.01597    239.18263    102.53643    115.43112     18.26868     12.84085      0.71575    -30.94604   -324.71895   -261.72012   -341.75935    -373.8419   -380.07087   -373.39282   -491.18074   -378.12367   -235.77753   -192.60035      0.69147     12.56873      8.66677    289.08427     31.58802     26.31095    250.44445    115.71698    308.85491    176.61115    333.50658    282.43541    292.44876    282.61991    167.87958    198.54591     98.71924     72.46494     -91.0192   -128.93206   -336.41011   -179.86221   -397.36789   -290.40397   -336.33137   -263.44531     -85.9582     23.37648      0.65217      9.86055    168.25278    121.34952     206.3034    288.94323    220.48921    244.80057      550.216    634.06726    766.88204    737.10481    635.58369    862.32559    445.69521    475.81139    393.79383    203.35233    123.44771     -9.94636    -42.54853   -110.93126    113.26794     40.10221    -49.06489     66.74024    -83.48149    327.05177     80.73526    147.83268    -41.06154    125.77524    201.32253    -19.95508   -128.70949    -190.7484   -210.77273   -116.26667   -190.03797   -397.17418   -427.89082   -337.33058   -171.05515   -213.67922   -434.30291   -331.24806   -424.46359   -405.79966   -375.09554   -237.32142   -338.83715   -375.41662    -269.9364   -184.04317   -208.93522   -163.16574      82.1931   -243.65997    -74.79076     48.88039    -47.17674    -35.16792    223.11481      4.04735    -36.59648    134.74297    100.56612   -211.47741    -246.0954   -136.52673    -90.21181   -123.00127   -123.38056    -28.58661   -265.36213     66.03817    -31.03365   -201.24454     -0.06118    -46.85776    -200.2701    -78.26757   -148.55026     33.75804    -27.24792    -73.48609    -133.5182    -64.21137   -339.37927    -61.26706   -288.52835   -361.10295    -124.1248   -201.96652     -65.5506   -115.27388    -87.16821    170.48998      64.1425     19.61696     13.76951     34.93111     58.45503     16.06135    150.91997    267.38299    209.94357      95.8921    225.44814    176.47788     -11.0899     41.16308     98.25488     33.94617     -111.905   -227.47702   -128.77915    -14.45599      7.47527     17.79717      6.71626    -17.07856   -141.33479   -288.01637    -81.16593   -161.73889    -41.24654    -41.68963    104.37594    184.09745   -174.67916   -241.85192    -115.5631    -47.21641   -121.54427   -295.00292   -309.61687   -119.63856   -433.60436    -49.62828   -294.27783   -159.49106     -0.33741    -56.80269   -508.99395   -227.06834   -189.13505   -238.87887   -215.54327    -101.0958   -247.35917   -351.04235   -331.09836    -85.29238   -348.63112    -48.99757    -302.6689   -452.97737   -215.90792   -287.41876   -223.34471    -316.1938   -395.34562   -391.38528   -147.29808   -186.98129   -411.29537     -298.333   -455.89154   -489.74421    -276.9565   -378.79372   -604.21787   -469.25731   -386.68663   -661.46447   -426.24773   -383.79802   -709.16219   -712.76995    -810.1415   -612.73644   -802.62797   -785.39849   -581.30049   -808.34197   -620.70584  -1151.05739   -626.85912  -1070.51321   -970.16825   -867.82949   -847.89539   -893.11228   -789.35358  -1229.51475   -889.92694  -1034.20562  -1161.85128  -1049.23289   -1062.4468   -997.33401   -711.92221   -755.79961    -767.2078   -990.57593   -807.72338   -721.65285  -1184.09411  -1169.42105   -891.98195  -1469.02345   -865.22872   -853.73522  -1163.99079  -1018.19235  -1074.62615  -1387.14141   -847.53962  -1609.95347  -1056.85741  -1395.36186   -668.96744   -659.20966  -1145.83506   -597.02606   -727.49411  -1117.15674  -1285.65402  -1460.91112   -780.05381   -1309.1499   -174.23984  -1130.52751     -35.7439   -400.52416   -909.05011          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        3.00    146.28065   -214.98188   -413.50725   -211.42506    -352.9257   -464.73545   -640.90555    -196.4997   -346.47352   -450.45779   -198.05491    -220.0988   -121.84855   -392.75903   -431.34802     -3.58072   -328.94508   -421.47504   -160.17251   -408.66238   -307.10999   -285.29831   -237.21533     -16.2153    203.53824    947.59423   3606.57604   4764.00575   3676.00384   1412.75351    245.99993   -229.17915   -248.02365     -293.464   -487.17866    -163.6488   -269.35073   -595.79584   -191.56521   -215.85632   -291.89735   -257.51457   -466.78983   -312.14209   -281.31547   -366.55218   -311.36053   -616.23471   -340.09233   -476.33783   -407.21939   -252.95824   -251.11439   -317.69069   -231.28475   -205.25256   -310.34534    -140.4891   -216.69096    -71.58915      -360.06   -258.57095   -168.29846   -245.32185   -365.48411   -259.26603   -351.30388   -101.45287    -150.8092     28.27831    685.38791   1794.46985   2541.51542   2238.20143    992.81871    762.21341    222.30763    -12.68262   -339.49516   -225.20039    -292.3383   -323.15399   -275.88516   -249.96408   -338.79822   -120.05559   -146.53578    -167.6552    135.40472    558.02209   1832.59221   2844.27269   3193.14713   2407.48139   1389.38487    350.36093    -12.48923    -129.9323    -91.35893   -235.78015    -16.93093     280.3289    416.44344     79.02029    177.34329    -77.22356   -254.46469   -370.15732   -416.34954   -270.48383   -265.67827   -288.38106   -361.63585   -315.52603   -190.65776   -358.78485   -186.80209   -140.11489    -79.99916   -301.43432    -302.3734   -226.69126    -78.57481     97.62921    437.97838    672.61607    579.34761    809.39432    420.73539     355.3309    149.71553   -215.26778   -239.36556   -104.91462   -157.04233     25.83368      617.652   1108.03496   1901.06508   2752.90962   2674.90305   2385.20578   1738.28191   1218.88845    740.35124    172.22166    209.71242       8.2292    217.53284     107.5583    -44.02836   -176.60523   -398.69008    -236.8717   -320.64966   -330.00861   -223.26826   -274.31396   -333.12441   -232.87898   -323.36007    -293.5117   -206.88448    -13.66821     -6.30133     33.38557     73.82452     -19.6478      -16.998   -168.99395   -156.10974   -268.71222   -373.35694   -106.50114   -113.88431    262.03681    347.86516    261.90093     38.56929    139.86536    -57.84372      9.54687   -100.63064   -145.38678   -207.23943   -238.55146   -229.31812   -175.87067   -304.81211   -274.81327   -251.04666   -306.76988   -230.86934    -84.54558   -162.89988   -258.38252    155.07611     51.07579    364.89285    459.98743    424.42233    190.49149     57.97184      5.81329    -52.97654     60.76772    -54.72228    197.21102    297.14263    207.55161    -31.70685     286.1681      1.08676    -235.2911   -211.66222   -395.16246   -216.08353   -299.79426   -173.21357   -354.25086   -308.19557   -270.47346   -376.44306   -211.31883   -271.64591    -99.15406   -178.00092   -105.96246     139.9207     74.05562     65.11225     91.10547     97.40588     72.10967     71.07635    366.12507    268.94192    430.60435    323.24037    478.33475    317.41519     323.6328    119.84016     54.91496    -42.52664    -147.5385   -114.19387   -303.00803    -143.5692   -312.83428   -232.16755   -209.43926   -237.49539    -77.69224    -35.58589    -90.58718   -315.50693    -10.86153      89.4341    160.76453     372.6057    437.16676    535.29572    819.32602    644.83593    659.53341    706.76679    708.06379    682.46686    616.00369    366.06016    217.25275    106.99348   -227.58546   -194.65718     60.38519    -61.75974    -79.95116     99.13076     -2.90808    -29.41333     40.39113    156.52719    102.90226    -66.50581    -43.24622    -44.19689   -228.56435    -45.90588   -136.88974   -129.07724    -77.18378   -385.20891   -496.75759   -283.32724   -323.58993   -392.20738   -192.03819   -304.00212   -406.90688   -289.06873   -314.99184   -323.88445   -270.55346   -294.65768    -91.84838   -326.07827   -166.62503    -34.20181   -169.40478   -106.55049   -122.70634    -80.25913     67.43407     136.5483    334.00264    176.13953    -60.37192     -45.8923   -217.83835   -190.34669   -109.80337   -126.65189   -142.06188   -394.86423   -129.32001   -123.56057   -444.88397   -355.60566    -94.43113    -95.53633    -56.33373    -13.06348    -51.92113    -79.35425   -130.45142    -119.1939     105.6573    -86.40231      7.07751    -287.9946     60.21595     -3.29936   -152.76015   -201.27287      -17.584   -189.88266     161.4023     16.36994   -183.25917    -36.35145   -124.67667   -170.17336    -81.90127     188.1069     96.89217    150.75124    120.41477    267.10741    151.75202    122.40709    132.41527      295.432    237.85862      3.05681      17.8415    103.37866    106.59089     26.18779    -12.46763    -50.51994    207.21069   -224.11534    182.01001   -234.90823   -107.91785    -34.81354   -168.41998     58.70248    -15.05209    138.93732   -235.56203     47.69749    -31.00451    -114.0956   -148.06477      1.80621   -164.96931   -220.10736   -421.41536   -338.97245   -483.22275    -486.4007   -456.73138   -184.48158    -107.8758   -194.89121   -102.58352   -509.14789   -156.94607   -187.80922   -102.28246     36.62553   -324.97977    -185.5032   -139.59894    -236.1955     -206.623   -263.33289   -209.77219   -259.05591   -341.41923    -41.07763   -324.38787   -400.48567   -350.38972   -340.15041   -342.48933   -401.90382   -183.31635   -154.65841   -368.18921   -123.56631   -484.03004    -452.5636   -426.15298   -575.30003   -531.74951   -298.90815   -461.41771   -754.37054   -624.75569   -617.71082   -704.95602   -565.29297   -715.50638   -675.60372   -879.93547   -454.34275   -864.43649   -738.62034   -898.15906  -1092.08497   -861.99974   -821.12048  -1023.40633   -804.66722   -1109.7488   -842.54699   -968.16145  -1081.61526  -1067.45279   -854.80409  -1082.37423   -1100.4902  -1133.63296   -719.11377    -1108.012   -879.00173   -824.62628  -1223.38849  -1113.48871  -1129.22637   -897.89484    -772.5596   -734.08198   -738.59659  -1004.55025  -1057.34824    -943.2613   -822.07152    -860.6087   -729.11409  -1185.30727  -1208.36352  -1017.70029  -1540.62959   -1259.9268   -486.52163   -840.65079   -730.71352   -768.41107  -1137.61111   -996.97655   -736.38179   -891.68574   -131.84921  -1064.62427   -821.77972  -1004.82082   -742.96815          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        3.50     96.82127   -169.47014   -385.68956   -260.21815   -446.60862   -410.07554   -532.21851    -349.8257   -291.47598   -404.82943   -353.39375    116.13477    -65.23372   -500.78849   -501.23012    -58.77362   -355.06513   -351.01106    -79.14501   -437.58789   -337.49169    -254.6599   -244.65333    -37.02943    190.39711   1159.35316    3690.5602    4786.0659   3394.90167   1593.73996    404.62425   -314.68382    -155.5841   -385.57106   -315.21794   -395.78431   -271.13034   -347.35208   -390.33288   -457.01622   -303.01624   -342.00158   -540.63808   -197.77628   -431.09135   -452.91531   -432.21941   -167.69901   -341.53577   -400.53989   -447.51941   -494.81812   -208.79661   -453.87501   -258.97313   -377.24816   -393.57666   -238.52973    -88.52575    -33.05702   -533.20159   -455.34951   -353.19852    -431.0128   -375.37474   -429.94366   -262.14636   -400.10317    -269.9782     67.82043    558.97762    1812.4899    2503.7042   2076.57468   1288.81212    689.01936    371.60136    208.02576   -174.72119    -128.8373   -248.56475   -215.91522   -347.88442   -190.50705   -327.08716    -45.88042   -479.22052   -199.72903    193.95207     731.6569   1605.01288   2664.39679   2865.92148   2414.57313   1324.13858    182.63624    -59.92966   -180.80467   -418.74669   -196.85074    -20.36696    245.96511    391.42167    146.65221    170.62488    -33.26488   -181.64952   -197.81887   -161.36109    -452.5616   -319.72733   -339.20909   -339.72797     -351.595    -29.74755   -274.52317    -97.09481   -199.97682   -315.65214   -159.95712   -236.34375   -135.75882   -237.03518   -166.69143    405.70186    804.08272    994.85642    776.11367    683.67173    332.82572    151.40186   -140.05904    -81.86744   -190.55483   -105.29636    -18.76156    481.16665   1260.73634   2136.61628   2526.94889   2746.77968     2343.127   1597.27326    986.64654    294.58552    171.31241      99.7264    144.78709     90.95878    149.38511     33.65784    -97.91179    -173.6097   -309.25583   -352.89218   -300.09076   -251.74804   -460.32552   -205.56423   -303.61146   -259.02703    -213.2582   -153.42293   -179.46579   -100.75116     81.37204     33.26022    -26.84629    -22.43071   -132.75525   -181.00118    -80.15181   -221.80577   -172.72015   -129.21982    127.71877    245.07795    283.30517    304.49544    220.61803    174.98342   -144.10208    -17.95001    -91.60247    -72.59469   -171.42752   -188.53831   -282.42857   -257.12002   -320.82076   -184.61422   -198.81356    -233.9538   -179.11196   -150.91306   -113.47219     -56.8702    185.08103     323.7205    264.69517    335.74398    158.92743    175.44591     15.90841    -98.42175     79.14982    -58.05243     -12.8954    102.41175    205.36608    165.64276     230.8064    -48.22735       9.9927   -147.71523   -203.97354   -151.17292   -270.01586   -317.55963   -377.23975   -323.22437    -201.0894   -270.56012   -240.21836   -110.91484   -143.80804   -160.77156    -88.58529     74.28389    -54.29969     82.45753     45.50619     52.20372    176.39682    155.18309    257.83421    396.57184    530.82455    350.50303    267.77668    185.69682    171.15062    147.31168    115.10252     27.47954   -134.67342   -211.61952    -196.6238    -92.41333   -206.02984   -254.29888   -150.11359   -237.74964   -145.36293   -127.69464     79.83198   -147.77759    -11.07085     166.1471    299.52691    225.76844    411.09094    481.11192    674.36707     830.8913    796.63104    779.11858    682.78239    679.29686    581.44971    102.92327    248.55376    206.86061     96.64935     18.79747   -123.52806   -149.84238   -213.78675    -97.94728    -53.79062   -140.79206    129.17703     48.66965    -67.74307    167.06964    102.67277    112.63003   -248.46215    -127.5663   -233.59355     36.08701   -254.46017   -295.27132   -186.61511   -387.26175   -240.81293   -311.34076   -277.79925    -229.2458   -181.17172   -259.91679    -84.95272   -109.85558   -356.38563   -225.69624   -221.35232   -292.87667   -158.02842    -107.6852   -151.52478   -206.30792   -156.93486    -51.57856     73.07699     30.43833    128.23548   -112.32863   -101.68715     84.88335    -82.56262   -148.31112   -242.70245   -156.52036   -282.17777   -258.24366   -169.52902     79.79738   -145.03777   -210.36674   -135.79001   -352.29399   -136.49077    -24.80257   -172.23995     22.39324    -80.51817    121.18707     -23.7777     -47.1882       8.4703    -11.60003     -17.3482   -100.24919     92.22202    -97.67928     -118.013   -266.44904     -92.4616   -195.98644    -20.45699   -137.59868    -69.81876   -174.05147   -193.47362    207.16044    185.14594    -86.55966     -2.30065     92.87012    280.36374    171.10575    288.27992    162.11147     81.60983     95.07202    -29.14048     -5.93367     -36.8122     67.11645    112.56181    -85.18036   -109.35808    114.00076    224.04994   -185.27005     -244.222    212.14056     -8.44709   -252.85456     76.22153     21.92919   -155.37893   -260.21786     66.66992    -82.28442   -227.15935   -104.53105   -301.48104   -177.51601   -311.04316      8.96076   -131.83776   -235.59606   -236.89664   -160.61159   -211.82921   -295.26117    -277.6086   -156.71296   -154.53739     -60.0753   -166.25016    -51.62285   -344.34254   -340.04674     32.32729    -11.60761    -76.11439    -241.5899   -259.60208   -238.32464   -273.08875   -377.97305   -300.50025    -97.25254   -252.12027   -215.94223   -201.16873   -285.37256   -384.82484   -297.75578   -548.28665   -121.55376   -314.86662   -446.49473   -362.81024   -549.97057   -521.52586   -676.09009   -602.77219   -491.31954    -598.6421   -552.27159   -701.07192   -604.54535    -608.5405   -694.13776   -844.16605     -750.659   -554.36373   -729.39568    -664.3215   -828.31769    -710.1279   -975.70406   -731.11473   -911.63094   -664.06134   -759.07189  -1086.07003  -1020.67075  -1196.67354  -1152.87227  -1119.99675   -900.71352   -847.00298  -1009.53145   -794.42374    -813.5904   -705.76976   -1166.0696    -749.1053  -1023.33156   -895.53097   -963.52851  -1147.05571   -1047.0542   -873.95259  -1060.16265   -672.21209  -1096.89668  -1312.38406  -1071.47751  -1014.50488  -1396.23887  -1165.68367   -512.76439  -1095.85458  -1582.98349   -945.09548   -764.32681   -896.97447   -813.98797    -803.1055   -880.73936  -1138.66359    -349.0634   -225.37066   -598.96022   -907.28261   -856.32378          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        4.00     48.44132   -163.45622   -291.57821   -249.98544   -296.96316   -271.77964   -260.68822   -517.10447   -228.82737   -344.92446   -273.75903   -147.35015   -165.04586   -619.66201   -494.84944   -169.00858   -415.57291   -287.59855    -16.08924   -424.37803   -578.29659    -467.1549   -471.12164    -153.9207    122.17537   1215.63855   3466.03953   4848.01904   3548.08557   1489.00808    404.29212   -237.04833   -133.69414   -305.91665    -10.71711   -212.69998   -174.57611   -267.18539   -262.29716   -269.59366   -283.57725    -158.6659   -206.99715   -268.58825   -227.46293     -308.918   -502.61488   -230.39787   -482.01648   -472.69726   -259.31467   -270.43683   -379.84411   -363.03759   -399.22197   -341.49435   -258.33894     -16.3248   -144.14234      6.34293   -271.78016   -259.31496   -257.46778   -392.44414   -373.62688   -234.66747     -308.218   -206.64797   -227.76366    240.68636    745.58999   1683.78971   2332.83565   2217.30877   1358.55425    645.50662    533.31401     33.19253     26.18175   -253.86448    -145.9288   -284.92511   -178.71069   -335.71331   -276.82628   -290.88334   -334.58321   -273.30158     28.96451     631.5946   1650.96075   2749.33783   3273.82466   2457.83483   1320.96145    518.75319     82.31821   -218.23773   -131.74063   -234.38114   -110.38648    251.08994    388.13659    207.72513    133.18285    -141.3713   -243.76065    -212.3271    -244.9447   -424.11797   -315.33262   -237.52207    -344.9672   -399.18436   -334.01755   -249.73414   -215.32137   -103.91232   -277.33054   -173.20872   -309.75785    -185.6345   -101.13759     38.62228    466.06572    836.73353    922.24334    690.15296    432.26305    391.54905     49.99898    -42.68454   -143.08576   -176.60264   -117.09851    110.36253    492.68558   1264.50467   1977.82065   2518.18698   2911.03084   2429.66331   1616.25041    998.28429    508.18366    296.54912    137.08133    259.69727     93.32021     40.09169   -162.38435   -114.54805   -317.63623   -277.81642   -416.56377   -208.76477   -224.39197   -277.89542   -260.20442   -204.12188   -253.40198    -235.8472   -210.04709   -161.31681     59.63662     -38.9922    159.00392     40.45441   -120.71411     -113.185   -295.40829   -123.52127   -104.67526   -225.48421    -46.14701    180.59267    329.46664    126.83375    275.30124    230.66925    320.22298   -139.46361     35.58953     19.50002   -239.48249    -73.32996   -222.34195   -308.58523   -323.65467   -302.08271   -281.06496   -321.07815   -299.95067   -215.75324    -94.30394    -92.92876    -32.95697    129.28191    234.74394    332.08262    253.26158    274.83558    112.13686     74.05683    -57.65768     -97.6281    -80.35717    105.21966    211.63009    178.28524    212.17171     65.92597     88.73406   -205.74318   -186.71888   -169.17423   -250.16355   -350.06013   -265.26402   -329.12292   -292.01026   -246.61947   -334.44846   -202.20673   -185.60735   -106.71312   -113.94123    -33.44403    100.54999     29.84029    175.17384     68.79116    174.14174     41.67428    200.53577    215.57597    325.34217    325.26532    479.76276    426.99663     278.8275    388.79785    132.47955     -5.44931     88.13615    -123.3661   -222.26508   -184.28995   -289.56939   -298.52569   -271.41364    -33.55211   -144.39689    -73.72354      -80.198     -73.8737    182.65186    104.71919    171.25181    194.44739     109.3968    398.43652    523.08625     518.3783    889.28918    830.34443     912.6278    594.05221    415.46551    498.98358    351.22049    200.67227     61.83803    -50.27868   -100.54152   -251.37839   -202.65653    -93.55666   -101.44998   -104.47921     60.42353     61.93531    108.20835     87.50578     54.05994     88.73258      -0.7993    -53.76641   -223.37116   -157.99115   -198.70391   -208.75237   -348.65594   -127.42101   -263.11299   -197.68092   -338.10474   -273.93358   -303.58097   -492.28686    -372.4584   -326.84679   -190.19221   -171.30924    -92.90047   -311.17937    -49.18094   -218.89688    -36.55185   -196.52962      7.00214     47.83024     29.90492    -79.91131    -16.46032    -26.52246    -30.77973    -32.33146    -59.70585     72.58253     113.8675     -57.9197   -176.11132     24.31383   -121.03764    -88.05008   -154.02587   -308.50195     -257.252   -257.57272   -104.67006   -199.94601   -163.93412    119.18009    -17.35696   -126.41638    108.93686   -161.92608   -201.80989    -17.95689    157.65024   -218.87528   -262.97816    -93.96225    -81.85808    -87.22753   -134.60204    -81.54419   -203.08351   -187.83836     95.69922      29.6089    -35.48915    141.35907      6.94219     67.53887    125.52779      373.681    150.86992   -186.52095    128.95111     45.03637    504.52914     64.31175    269.01219    151.68658   -141.78892    -33.21618    -37.78319    -33.83821      0.99737   -259.84432    -33.97278    -24.83566    -40.75417    114.42051   -204.42791   -216.66632   -131.13172     36.21298    -21.69097   -258.19589    132.34581   -134.29709      135.117     86.19063    -111.7473     13.40954   -158.13155    -389.9255   -341.40198    -99.12303   -233.95404   -290.65543   -144.37815   -198.00224   -586.19421   -148.87585   -315.44448   -498.79118   -244.47689   -353.78821   -193.75083    -36.33624    -225.3993   -434.96527    -39.63511   -122.70384   -500.59598   -242.60566   -367.98501    -481.5321   -142.61657    -90.29428    -92.63133   -156.31009     -71.7503   -202.47873   -316.44007    -77.83541    -411.9689   -181.85839   -358.44542   -400.15639   -329.49851   -227.91363   -256.87467   -345.66372   -450.78571   -522.47377   -645.02515   -667.98728   -647.95084   -642.88096   -747.60742   -563.94702   -723.26317   -764.02774   -612.73038   -587.00224   -957.86115   -613.39411   -690.97068    -765.2952   -864.96042  -1008.10787  -1044.69474   -849.96441   -941.13039   -895.18389   -972.88638  -1012.24203  -1165.01883   -801.82039  -1048.12361  -1041.75852   -873.10992   -925.77504   -866.52863   -951.29803   -802.70232   -1021.1865  -1040.58895  -1099.81271   -601.89855  -1102.03872   -908.52732  -1410.96027   -871.09925  -1109.93413   -761.08238   -846.36027  -1069.12954  -1052.21618   -812.88193    -811.5263    -986.4543  -1234.34337   -760.05067   -736.51975   -581.27367  -1184.61785   -955.34342   -570.34264  -1274.21185   -660.31642   -991.34144   -793.95923   -635.83078   -280.08978   -876.29473          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        4.50   -110.35964   -291.47432   -142.00513   -226.14715   -141.47291   -155.88746   -191.31435   -536.46316   -202.38835   -241.14548    -66.07708   -509.85573   -244.70294   -514.09633   -425.94287   -201.96661   -545.18036    -253.8155    -10.60368   -339.70476   -527.40337   -293.20355   -166.90397    -63.10402    177.30722   1118.70278   3317.17417   4534.00605   3758.73859   1457.76985    159.04889   -435.24468   -291.11267   -254.14082   -122.01954   -160.40704   -280.67378    -48.28626   -276.18563   -233.52808   -413.69785   -377.38656   -274.96394   -331.59928   -492.21913   -303.05311   -451.37238   -249.18845   -471.89348   -153.07835   -420.57123   -355.69688   -470.29507   -307.26447   -294.96494   -301.26692   -278.99007   -406.44082   -176.87628    -187.8383   -208.82664   -269.12998    -340.0689   -279.29629   -254.21396   -324.49284     -318.245     -234.967    -51.57884     151.1469    611.51318   1712.88736   2570.41233   2053.19136   1323.68688    293.80305    284.36058     24.48718   -178.63029    -193.8088   -166.80019   -178.47058   -110.28033   -263.76422   -396.82014   -297.85532   -181.44082   -293.58877    -95.57192    512.60982     1704.245   2781.71988    3287.9229   2589.45879   1262.72128    541.18703    -47.78305   -256.60558   -311.04438   -198.50037     37.04584    285.04925    341.26268     49.54498     74.68632    -58.45908   -262.33454   -286.61528   -270.95066   -344.26454   -429.13924   -320.85203   -287.82199   -263.62656   -298.34221   -307.89464   -252.13659   -281.67184   -328.96732    -304.3536   -355.88473   -194.99092   -214.41641     85.94305    453.70106     594.6568    954.20846    905.83579    630.11374    248.15579     54.23837    -48.75187   -271.12786   -233.11647    -83.71284     94.55831    466.07809   1277.47922   2069.95704   2545.95404   2924.32644   2444.67873   1544.49971    911.43443     457.0805     230.0317    141.06573    299.35855    257.75169      20.0521   -131.93082    -97.18578   -155.33943   -324.48653   -323.41376   -170.46677   -170.26835   -244.59216   -292.02892   -311.14322   -288.59518   -170.56301    -54.72397   -189.70281   -148.35284     84.22385     -16.0214     41.93398    116.19444   -109.75955   -256.43887   -139.87485   -144.93323   -103.62032    -91.27176    114.53907    284.45438    432.83636    190.22479    399.27461     82.03657    -59.36235    -53.28308   -189.59357   -124.95287   -292.47554   -122.37739   -306.46797     -392.061   -317.54152   -224.51193   -184.87888   -381.10588   -283.16939    -80.43639    100.84591     18.35624    -109.9782    247.80185    182.19063    281.02153    137.40833    133.61878    133.13302     34.07902    111.81262     -9.18633    123.85683     94.40769    152.27963    235.66888     69.03432     15.04658   -108.77061   -124.36871   -216.42814   -183.62531   -305.27739   -217.69128   -321.02692   -264.17417    -302.5832   -344.18682   -139.59532    -59.98886    -68.57845    -81.84155     88.80743     -39.7065     158.0178     52.17674      41.3449     37.86992     74.20284    217.95117    198.11134    228.59533    365.81805    295.11713    391.30813    332.57139    255.03984   -128.93875    316.18818    -22.25663   -161.59361   -234.64259   -310.97054   -215.11589   -281.66056   -306.83191   -310.50089   -192.24785   -139.30833     -10.6433    -85.29408     72.96677     68.26264    140.30196    202.79696    409.22559    400.26131    399.23216    599.17728    772.14753    908.05816    883.96182    648.81264    533.49028    471.77097    332.24765    294.07762     32.82449   -122.49597    -88.83295   -176.54968     -35.9731    -54.46893   -133.23988     33.39189      39.6584     62.42061    105.63263    128.56999     99.75664     -1.60205    -91.07262     -83.7912   -162.12056    -28.99628   -176.83214    -28.40434   -341.99328   -233.35316   -344.44384   -365.89489   -336.99316   -362.09392   -275.48918   -238.99077   -281.46514   -324.02733   -137.92158   -105.20311    -65.83674   -249.60855   -232.25364   -175.03123    -70.58658    -80.38004   -106.39624     16.75811    -29.92076     98.11137      34.9986     69.31139    202.52751      75.1299      7.70709     25.34697    -82.00443     21.31819   -167.44075   -132.73437   -119.80411   -273.52244    -50.41763   -116.88629   -136.15863   -191.73326    -82.23126   -195.74997   -261.47291      1.60257   -137.50906    -10.56276    -30.68024   -125.86814    -79.94876      53.8513    -18.32541      15.4642   -147.44212    -66.33613    -98.08608   -258.19026    -99.63096   -125.14867    -77.20359   -123.47226    -53.17878     57.48566    -91.50068      -7.4767    229.59758     86.60517    -17.02761    339.13345    215.13208    369.31703    151.86128    133.74943    441.01244    288.52251    226.31668     56.46447      255.753    -36.93016     139.0203    -63.38388     39.56481     44.61651   -250.19474    -29.87192      8.29228     88.74133   -173.40792     30.24121    -86.07023     40.72032    -69.01919    200.49586     60.60586   -197.97305    -253.5174   -144.29926   -206.77479    -80.12902   -438.09991   -243.36542   -227.97034    -348.2735   -223.29743   -213.35945    -78.35874   -243.32286   -252.51028   -332.43083   -132.67766   -496.94224    -21.92534   -375.17802   -349.38443   -268.22311   -122.70725   -193.70841   -375.15547   -103.29705   -377.86337   -428.96392    -72.88425   -139.35343   -131.10444   -448.33142   -306.48869    -55.03452   -378.44577   -110.75589   -195.92879   -205.12694   -318.16244   -297.40464   -365.94239   -359.44649   -635.28149   -322.85759   -568.63675   -461.68519   -458.55226    -348.3679     -473.946   -544.94932   -770.74186   -550.90635   -651.85678   -551.92034   -801.90642   -615.43942    -678.9123   -894.12028   -717.62861   -633.17502   -848.26973  -1028.33826   -961.90951   -802.44087   -892.93558   -692.40828   -833.66203   -928.89502   -961.41096  -1122.09754   -890.59326   -895.31649   -896.47788   -879.44415   -1062.7413  -1175.25559   -1015.8912   -780.60838  -1143.80463   -938.69854   -956.15727   -983.99028   -590.70663   -966.82472   -755.07905   -577.27967    -792.7409  -1061.77462   -938.88867   -698.32536  -1038.07962  -1316.79542  -1315.76426   -1112.5321  -1101.91007   -996.84355  -1036.54372  -1173.14559    -519.0958   -402.43577   -764.93689   -959.32673   -1324.2412    -71.77629    -673.9487  -1455.43198   -745.95586   -839.19471   -954.94578          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        5.00   -298.19594   -418.83773     13.40871   -241.24341   -120.57349   -174.51784   -314.14669   -523.13499   -197.14092   -230.80433     -97.0439   -291.04845   -220.27037   -203.06923   -332.21811   -214.51567   -370.51408   -231.57554   -171.54883    -143.2373   -353.51924   -201.79503    -90.75596   -257.93223     205.1896   1378.59185   3322.59747   4324.85341   3624.72167   1454.27926    107.93253    -78.96112   -335.82354   -181.02003   -292.89191   -246.84975   -187.75894   -515.79996   -278.52917   -458.94501   -289.68054   -355.92339   -382.01566   -237.26357   -237.04875   -268.45728   -382.92414   -326.44755   -106.88673   -301.38465   -484.71013   -211.17004   -331.90282   -310.99595   -397.36663   -321.37187    -246.0442   -200.16421   -197.89118   -296.48173   -217.60614   -174.58246   -368.39321   -257.96241   -197.24083   -370.33856   -380.96588   -106.36343   -183.69963     98.99069    782.38735   1782.90118   2336.69017   2292.77745   1355.22649    492.87096    175.91776      70.8751    -85.05004   -234.70269   -292.65157   -211.60369   -231.55818   -338.02243   -250.58028   -311.69462   -241.57696   -118.72286     61.04742    675.49099   1886.99691   3025.72935   3473.25604   2544.68945   1575.05682    413.06122     24.52711   -134.08961      -88.436   -173.20055    -16.05339     71.37349    432.31228     267.9088    167.76139   -152.83815   -324.93615   -196.63458   -292.64398   -377.75653   -343.14275   -178.97151   -384.52788   -326.50194   -318.43962   -234.46569   -108.81977    -95.51408   -162.40708   -370.68249   -117.70942   -158.62854    -50.56263     31.89039     306.4009    671.28284    886.64749     899.7178     662.3829    365.86526     -28.3497    -79.69851   -153.96081   -218.91337    -62.69595     97.62106    561.36938   1176.66134   2014.83653   2722.59593   3020.35034   2447.46225   1831.10424    927.98259    454.49054    251.20741     93.94421     93.54365    247.13889     14.89677     41.15795   -142.88527   -431.50162   -209.02778    -198.6584   -244.67128   -189.15654   -250.71607   -177.68587    -243.6235   -151.67163   -218.38299   -257.41488   -147.68699      2.56567    -71.95673    -42.77278    110.97583   -172.63559   -102.08173    -332.6463    -181.5822   -248.11108    -56.74958     -6.25296     95.12231    294.04687    175.45865    242.16407    247.21592    -39.74123      5.51651    145.31022     33.61113   -281.23365   -134.51297   -188.20285   -211.20085   -248.52444   -282.95332   -324.59188   -314.20074   -106.75042   -302.66164   -166.00818    -64.30941     90.00863     43.88843    161.64379    113.14502    500.68787    130.64151    189.10024     107.1807    104.91746    -75.05913     28.85322    221.45591    176.39513    307.96106    144.82886    169.08942     -0.22016    -34.06252    -90.36608   -222.98921   -279.21508   -355.71466   -157.82684   -247.08734   -254.17423    -341.8283   -327.69863   -221.85089    -158.6899    -97.81642   -209.41969     -7.83157    182.97851    156.17501     47.87016    -46.50498     78.52223     47.51939    124.16612    300.87231    212.31876    360.14261    380.92978     198.4305     387.3724    182.74802    175.91238     27.69045     -7.23306   -172.72606    -66.93871   -201.31844   -361.53653   -313.20613   -257.83144   -118.52844   -170.14869     16.64383     97.97947   -172.99654    -114.8386      37.8098     53.80847     34.81264    505.88158    504.18791     695.9244    644.11463     846.8165    849.05929    813.49357    710.50179    608.64502     555.2717    295.10017     90.32939     62.67573     23.39368   -130.96283    -30.37518   -101.26957     -86.5711    -87.49065     -12.3922     12.03419      14.2691    172.23677    156.13918   -102.75253     234.1112     23.58427    -51.06483      -63.034   -214.81265   -299.78065   -192.73383   -330.18555   -296.28566   -203.78261     -269.877   -454.73064   -350.39723   -197.87684   -302.38117   -209.80429   -138.85516   -304.48681   -210.92489   -278.83364    -297.5334   -153.27716   -149.58941   -277.62993    -99.60615     -249.474    -61.78494     -9.95632       3.5189    133.35293     78.21819     87.49056     98.15335    -11.33801   -133.51819    -34.21142   -199.91262   -118.54827     -68.2691   -123.79041    -62.06062    -23.81582    -175.4057    -30.06975   -258.02085     60.99227    -19.12657   -130.98931   -122.20649    -58.39825      0.73165    -32.22927     55.15743    -99.29713     -90.6083    -99.67603     73.31386   -221.36945   -155.79837   -109.26758    -118.6877   -199.24463    -76.23146    -35.27854   -206.45749   -130.57599   -142.72094   -214.25784   -170.89768    129.71475     -78.9668    109.35665    224.74509      35.2743    240.78516     80.82195    354.14157    167.22177    167.80832    195.76017    172.17802     54.28522     -2.10419     103.0778     36.70073   -127.64625    -99.67574     37.21428    -64.09788    -18.89646     32.21555      8.28106     63.50558   -397.90572    -91.98914    100.12686    -42.01428    -89.43767    -29.71611     29.95813     15.19866       18.835       6.4558   -119.76865   -189.76566   -316.83914   -404.43457    -43.89569   -179.17334   -324.67114   -378.02182     14.75603   -321.90713   -365.68672   -244.98005   -218.79094   -298.53143   -199.50902   -134.72893   -243.57303       0.7656   -387.68061    -340.4257   -355.65672   -159.02664   -135.63926   -427.15421   -207.28678     -82.4926   -115.04237   -439.80118   -334.99195    -202.7007   -369.49721   -309.61675    -472.2885   -446.11491   -623.94752   -416.53781   -523.78583   -279.08095   -323.20989   -431.67028   -379.03761    -528.3504   -533.67598   -541.15836   -507.64005   -772.58119     -742.001   -417.34267   -498.92316  -1084.80016   -726.22841   -758.09102   -566.42953   -809.07292   -732.99882   -841.47715   -765.43063    -796.4136   -952.70631  -1169.77258  -1139.79637   -990.90677  -1135.45175   -946.55414   -938.98635  -1085.99265  -1041.86279   -785.24151   -789.85125   -765.51819   -1185.6879   -857.21853   -920.55038  -1073.70142  -1247.60718   -931.87062   -968.97251  -1254.54834   -1344.1512   -824.25276    -960.8387   -873.42173  -1182.78624  -1376.41633  -1242.73763   -668.53846   -637.76275   -857.94891  -1079.98017    -537.5393   -680.38156   -902.95529   -1152.3281   -1117.5357   -707.23666  -1053.86326   -1176.8976   -418.78058  -1087.34458   -876.02773   -802.00161  -1094.35924   -411.49892          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        5.50   -493.76279   -421.54067   -175.28937   -322.63211   -120.05204   -207.14206    -391.4627   -483.77648   -318.14995    -389.8355    -187.5503   -149.14357   -245.26966     -264.361   -263.89304    -229.6239    -95.52909   -264.90804   -227.15371    -281.8091   -363.59402   -349.10104   -153.55076   -392.07895     29.11335   1010.21738   3208.31428   4561.12468    3477.9798   1644.14797     274.3587   -105.29841   -482.93048    -181.7414   -268.36022   -260.15105   -330.05966   -195.45344   -408.55113   -341.00132   -303.66062   -140.05758    -429.8377   -327.11305   -175.26927   -247.31367   -503.59349   -291.18626   -209.66431   -366.28166   -387.17207   -169.38097   -344.95364   -395.66557   -196.75582   -185.37645   -336.78512   -326.15839    -66.74287   -230.43436   -159.74406    -319.0566   -361.33424    -162.2388   -140.11585   -428.05696   -281.30956    -258.9425   -228.82565     68.45934    625.13357    1783.6724   2390.92923   2250.99798   1169.86617    505.08393    194.92005    143.07476     21.73144   -149.05594    -85.77339   -117.41345   -341.30188   -354.22204   -206.26159   -255.54825   -307.98081    -120.9141     32.62075    659.95126   1576.63218   2772.98503    3304.4426    2662.1335   1489.85085    679.01497      83.4878   -264.13377   -292.50243    -36.14397     -32.2722    260.75144    404.19486    450.15281     -0.54272   -128.13609   -142.13444   -229.50846   -172.34516   -183.15562   -427.70202   -308.74531   -287.02036   -505.31374   -220.46265    -77.90551   -328.29858   -155.64447   -186.34485   -131.68962   -160.12779   -369.01701   -148.72734     -6.30437    239.11975    706.75472    778.58023    980.85003     500.5212    267.30045     68.67737   -130.35075   -105.61832    -205.6589    -78.72165    100.50943     385.1529   1224.62667    2413.1482   2774.86153   2880.70044   2392.48043   1601.92737     755.0248     302.4934    226.41907     135.5932    184.85462    210.90378    261.92465     37.51217   -115.08997   -106.96281   -233.34763   -277.94904    -349.0035   -241.06784   -219.57497   -243.13749    -215.8532   -310.20982   -189.62794   -164.86193   -214.41017   -112.74992     -5.46352    103.46194    -51.20102    -49.57286   -142.77794   -140.08873   -283.37081    -333.1614   -132.41811   -209.27869     95.42746    231.71907    206.28908    -22.68179     65.77432     59.54113    -94.57025      5.19852   -139.51996   -273.33837   -342.53429   -226.80516   -173.89471   -329.04656   -266.28732   -357.42331   -280.07592   -240.75533   -173.31482    -62.39972     92.98014     79.35671    163.48992     28.42657    231.85039    322.94253    218.50101    201.86662    164.86458     74.90634    109.62374     93.68908    -33.10442     252.8566     142.9224    282.44767     129.6276     83.80214     95.17334   -156.71761   -260.65559    -93.32041   -366.63058   -120.81074   -221.51502   -345.91244   -234.94492   -273.95529    -96.53744   -145.81107    -115.7644    -11.29364     -2.45595     -4.10254     60.19009      214.829    111.44562     33.98523    126.73709    231.04559    155.69002    250.79739    249.47898    271.06479    207.01257    376.50145     28.46098    472.99857    -17.58392    -120.6916    -46.61577   -209.05007   -405.14647   -402.36921   -356.89094   -264.66958   -258.94253     -192.824   -156.17406      33.1303     68.64669     49.29946    162.93524      81.1933    171.37101    362.86584    330.79436    506.66109    881.64936    631.25196    635.06446    526.60872    838.42384    531.00909    444.19541    404.75973     32.76346     229.4689   -110.02753      -99.947    -162.5317     43.35336    -47.19068     -24.5546   -138.32974    138.09782    179.10825     57.02851     129.2866   -170.34052     39.65307     -17.1329    -57.50056   -275.98351    104.85123   -225.74966    -343.5061   -130.08617    -416.6207   -377.14417   -297.48964   -335.03029   -240.37777   -282.85151    -248.9051   -310.17844   -215.48112   -261.27002   -108.97583   -279.93063   -172.41304    -268.1778    -74.90509   -217.60453   -391.05854   -177.98335   -110.91375    -85.56311     126.8483     61.93064    -83.27353     23.60732      48.2492    -85.12809    -34.74085    -74.96887   -121.17425     61.27402   -197.58818   -134.01576   -101.62166   -127.31339    -94.57387   -159.96481    -78.14877    -94.70956   -141.10088    -83.96394    -60.50147     27.61798     10.29561     -6.01215    -96.43493    126.51446    -29.10423    -58.54449    -91.54668    -95.80693     24.01718   -140.61868   -227.18501   -114.24691   -130.37448     -8.80701   -174.39844      -67.845    -21.23766     46.86708     25.52538     99.75437     79.85197    199.52722    117.84337    377.39711    317.45008    241.14518    104.79615    187.54139    156.92299    126.87555     73.18826     27.92288   -127.89762    128.08131     66.82143    -73.21395    121.60601    -87.28336   -156.69082   -117.23467     -49.0443     35.37122    125.91234     45.48592     -0.04394     -62.0243   -161.18927    -45.17419   -211.59565    227.49221   -441.96347    -37.39049   -133.50809   -189.91716    -97.01625    -72.62166    -334.1841     67.17683   -175.12577   -297.66462    -87.99472   -203.63202    -33.30537    -79.11245   -312.15561   -428.73151   -194.66816   -316.54532   -205.22763   -152.81687    -70.63963   -240.96107   -238.01087   -150.25443   -393.67729   -278.08348   -270.37349   -425.48225    -97.59122   -236.31157   -449.93809   -301.28701   -373.51736     16.84986   -344.15539   -221.92397     -7.69835   -425.02397   -228.10623   -363.81308   -209.41527   -335.63759   -396.12576   -604.97618   -675.69163   -457.04938   -677.63156   -614.13503   -574.69673   -645.58494   -764.83248   -788.80737   -631.57328   -755.23321   -713.25312   -722.36183   -722.52955   -907.06155  -1084.03557   -827.38884   -863.21958   -813.24571   -944.53797  -1103.49588    -835.3887   -775.34412   -919.58084   -730.51655   -878.45575  -1134.46904   -766.18758    -935.0351    -713.6444   -883.64269   -957.53872  -1145.92538  -1108.57569   -988.36087    -921.8912  -1009.57403   -997.86262  -1318.07178  -1179.80559  -1118.38664  -1160.95009   -974.48844   -913.39283   -707.25969   -861.91578  -1172.46092  -1098.13305   -928.54268   -924.04584   -959.37933  -1195.46984  -1510.22199   -767.50322  -1322.45699   -895.69139  -1056.05759    -910.2401   -796.41419   -380.75104  -1077.22739   -323.02344  -1014.98176          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        6.00   -458.95534   -299.85417   -389.99925   -406.83595   -106.45377   -225.05082   -364.68034   -421.17676   -436.33422   -423.96735    -236.2346   -341.60027   -328.34113   -396.47945   -291.63159   -268.80177   -171.92195   -351.80401   -230.14515   -357.69578   -372.72075   -184.14311   -240.67181   -414.80173    -32.17959    991.62559   3327.37532   4444.06678   3516.43827   1709.14713    257.82789   -121.95179    -312.3474    -368.0777   -278.40805   -364.69628   -321.94312   -184.89143   -352.28747   -378.40038   -251.21893    -299.2457    -89.31709   -295.77095   -343.49269   -444.95069   -266.72492   -466.39341   -269.71579   -338.18853   -308.80746   -363.93426   -412.95409   -224.75625   -317.03104   -345.45359    -241.6031   -405.11493    -103.4949    -77.66987   -144.09843   -327.95106   -206.54387    -42.05213    -278.2338   -308.82575   -178.27393    -268.6866   -414.39208     66.31534    639.11125   1807.89004   2424.56183   2252.39752   1137.36309    583.87386    118.77142    188.95345    100.24253    -67.88208    -68.20942     38.18663   -202.52452   -164.21659   -305.32933   -140.58978   -125.08167    -61.62842     45.41104    652.79364   1792.90648   2774.84261   3296.85988   2589.72255   1384.38416    416.35846   -157.36429   -310.57446   -136.38033   -310.21934    -15.64573    174.30784    341.72907    334.53575    201.98447   -135.86628    -43.54948   -126.65186   -296.29187   -264.31864   -286.38985   -217.51987   -487.51273   -239.91434   -130.05424   -142.87585   -255.52064   -176.94116   -322.58462   -157.78384   -224.20803   -236.41347   -102.75619    124.53112    391.70742    659.55647    991.69282    911.38701    585.97622    409.76637    156.13531    -47.80116    -93.27229   -196.08045   -154.95596     55.64711     535.6427   1131.75524   2266.63201   2664.57601   2514.97807   2272.78114   1686.37706    1019.0099    405.14276     181.2411    144.85491    173.31175    224.22886     32.29933    -18.67059   -146.22877   -246.46591   -246.15914   -234.77492   -245.92682   -270.83256   -269.98099   -328.93709    -362.4826   -243.31119   -279.14191   -281.67694      -1.2295    -49.37773    -87.33229   -132.45265    174.01927    -77.01162   -165.76633    -199.4465   -351.23615   -307.33092   -196.17474   -189.10045     11.20511     94.57813    223.32544    205.04396      268.115    159.79255    -89.05327    -62.57046   -250.61537    -81.88432   -156.53577   -175.61915   -365.68061   -337.04754   -161.02084   -339.26412   -176.46262   -274.68874   -209.64708   -184.25905    -68.15651     80.20349     57.94383     90.24238    241.70557    391.21079    224.78614    139.80769     73.31209     50.72667    -120.4638    247.08405       18.939    224.83573    168.74463     83.93266    201.68949      71.1248    -76.12628     -204.002   -222.52475   -308.60347   -462.50611    -250.4942   -463.69203   -425.28144   -220.84329   -162.53437   -285.63104   -218.52272   -183.17572    119.02263    -156.9656     43.93835     89.98247     85.00645     84.92299      0.92618    -95.28815    -67.98225     38.07176     284.7149    423.85553     341.7178    405.16478    207.47517      200.098     48.32232    107.71375     46.55256   -124.66731   -231.32159   -253.89524   -412.01072   -278.10054   -139.71288    -221.1814   -194.88268    -87.01451    -43.35186     21.89852    -140.8024   -105.85075     45.60543    373.07168    114.89054    634.69926     692.1168    623.85447    726.08715    836.55783    830.96906    691.17005    230.55102    658.96671    557.63586    185.30397    232.23226     62.22537    -10.13441   -136.21329   -175.57025    -81.19683      4.12332   -121.74307     49.23344    -42.83028     33.69105     21.34214     30.92622      50.9693     72.48285   -175.22043      -189.67   -152.01337   -171.13053   -144.57077   -204.39104   -183.49035   -743.98004    -240.3131   -440.50895   -453.09228   -239.62214   -133.95613    -427.5507   -246.81278   -262.80029   -359.14765   -152.89177   -217.16048   -238.24707   -159.56032    -72.79609    -76.86935   -113.79438    -53.63365   -112.19683   -143.26688    -17.91865     54.50712    135.18319    -174.6005     73.13342     81.89419     83.69107    -18.78603   -182.31741   -174.05848    -66.71128   -101.92718   -125.39208    -78.28273    -47.06972     -8.66382    -12.01595     46.62581    -32.02523     97.14764     35.40152     -7.61658   -121.14546       2.5009    -14.77028     27.97582    -16.93884   -281.44533   -211.02164    -42.56801      -3.5335   -153.06983   -294.45662    -31.30049   -139.49954   -177.07067    -21.78455     35.20744    -120.6355    -16.58168    126.51298     63.72411    287.33585     98.12963    298.08882    326.61229    304.91581    117.51619    261.44128     53.69076     63.82436     42.58646     166.5005     92.47305    124.70757     16.90293   -106.28357     -1.96503    116.71872       15.356    -179.0635    107.42374     86.84038    -13.91155    -55.71189    -42.58324     -5.48279     -21.8042    -86.58349     41.69236     64.86172   -172.49822    112.74692    -79.65087    -152.7906     13.33722   -378.01098   -394.74312   -259.72454    -185.3199      -263.46   -220.83528   -494.79918      77.1375   -160.58522   -240.59684   -471.55923   -373.04259   -240.83213   -375.37241   -163.40576   -266.63504   -403.18678    -77.33031   -335.98635   -368.01853    -415.1825   -233.25109   -220.39545   -120.49076   -481.06003   -173.31952    -15.70534   -267.28833   -322.19858   -383.30682   -317.39073   -393.08144   -304.80583   -463.84906   -454.43795   -493.24291   -318.34018   -384.51002   -426.70269   -495.18312    -642.5371    -632.4194   -551.16476   -518.21271   -693.86677   -654.33175    -544.1368   -659.06695   -785.18942   -443.25937   -684.28814   -899.12565   -861.75391   -717.30367    -683.6122   -569.80288  -1041.02808  -1116.77145  -1150.82047  -1131.11778   -835.76716   -927.74165     -948.924  -1046.22773  -1124.33773  -1124.32308    -956.4517   -1033.2266   -923.02561  -1127.99778   -793.02336     -672.013   -843.76802  -1322.73239  -1190.89908  -1365.59127   -836.55498   -975.98118  -1070.06818  -1086.58803   -756.82881   -771.62194  -1075.43075    -754.5185  -1005.45342  -1332.57071   -872.96296   -978.08882  -1170.33482   -568.42858  -1149.08552   -811.91907  -1234.78525   -718.73719  -1153.44374   -120.21896   -903.55337   -821.09031   -754.14482   -583.06902   -1120.2142          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        6.50   -424.04167   -180.46693   -441.16379   -340.64511   -118.83865   -228.19171   -319.19217   -361.15056   -450.98121   -271.69026   -282.21991   -367.55202   -258.20747   -413.88296   -438.47031    -329.9103   -235.89351   -303.19842   -247.76839   -372.55525   -349.54447   -135.30595   -104.44491   -308.29516     59.45953   1028.88472   3368.86902   4593.61596   3564.53926   1527.24748    197.96424   -136.65907   -484.84784   -204.75295   -365.59461   -306.32159    -265.7994   -212.71728   -268.19802   -423.44802   -353.47654    -537.3523   -351.28879   -291.99412   -395.51504   -182.14526   -422.65145   -336.18284   -247.53503   -385.33028   -234.60686   -295.15392   -367.44659   -425.29295   -355.98063   -275.43537   -176.70157   -271.58976   -135.88238   -201.40125   -244.29579   -218.42897   -290.16261     -2.04352    -340.9683   -342.48938   -413.93447   -238.95097   -419.12798     244.6573    760.84018   1736.90884   2452.21245   1974.04747   1177.53473    525.79919    312.23553     52.15192     80.73064   -169.35321   -200.27617   -234.53363   -174.16043    -294.5851   -166.40056   -219.96861   -378.08133    -50.36295    175.47118    801.06458   1748.00703    2833.0993   2726.73822   2404.86705   1352.76714    496.68297    -19.39011   -344.06469   -157.53773   -114.72411    -23.03271    581.32734    569.56273    129.76878    101.75291   -137.90668   -216.65291   -350.27247   -261.16662   -332.99909     -240.973   -287.85078   -372.39625   -341.35386   -362.36063   -291.25481    -240.2644   -103.10438   -134.04402   -151.32024   -249.07946   -254.96195      -72.889     38.42787    398.88567      584.719   1225.39616    946.39763    516.59751    340.77818     95.40004     22.06385   -131.84547   -203.84479    -79.29187    -13.27476    419.96908   1193.21726   2124.79058   2636.69016   3097.04043   2369.35848   1748.79501    836.16879    548.26077    449.54718    146.04266    211.02783     73.04389      67.5293    -54.40436    -66.11224   -331.77244   -341.98753   -208.10741   -271.10084   -243.21222    -230.9161   -219.64942   -325.29535   -142.99051   -210.56744   -154.35724    -112.4503    -93.24482     61.47036     75.74683     69.25625    100.20097    -91.21926   -251.76017   -312.79341   -241.64458   -258.38622     75.52961    236.97382    222.49803    274.43622    118.83202    263.19645      6.43608    -54.43999    -52.18865   -206.17172   -168.00628   -228.49656   -215.18321   -227.20259   -246.00828   -208.87868    -227.9886   -107.22571   -216.88335   -170.64624    -42.73677   -111.70224      6.08579     60.36134    206.05799    247.59613      263.218    152.81082    400.92835    147.49898    -56.45402   -100.31792     30.10363     33.67953    131.46884    233.50379    191.04277     94.91385      3.92108   -155.60022   -182.84851    -93.70284      -305.25   -237.78753   -277.74092   -354.00774   -264.39842   -130.29577   -398.62689   -154.79261   -262.20883   -131.87135   -130.24862     45.65562     12.91778      96.8543    212.03846     92.50527     70.05346     97.12666    267.17985    232.93639    390.46516    402.21113    180.90516    454.39522    308.66493    237.82919     82.09154    193.14399    -61.86609   -144.25603   -186.07519   -117.15898   -213.20962   -243.56271   -281.47379   -329.64775   -124.39216   -117.79821    -87.46929    -13.82208    134.72953    132.21913    -32.35883     169.2778    288.23562    345.70923    519.37204     586.2068    805.07991    749.18021    787.68788    678.76414    519.21707    475.77089    267.53121    313.47859    237.36856    -42.44477    -91.23586     -19.9376   -213.33638    -35.35354    -47.28983     39.26483     40.31001     -4.60967    152.50975     46.37783    186.27153     84.21543    -54.91482    -16.22501    -56.03221   -283.19653   -200.71614   -160.07126    -185.4607   -225.04694   -180.86094   -298.38579   -332.48105   -299.37049   -236.44437   -287.11776   -311.75771   -161.54701   -339.29951   -483.35418   -230.81832    -83.49276   -239.62448   -171.88722   -169.83187   -190.92759    -10.43501   -177.43587       85.607     80.32517      4.88592     19.91139     27.86726    -35.09972     31.53134    175.09721    -57.88606   -107.68858   -155.80473    -61.08542   -201.08214    -91.90203    -64.24166    -31.23219    -83.96593   -223.34224    -32.06438   -201.26795     -5.51427    -18.27822     -179.564     64.17417   -245.32659   -108.69666    -65.43258     52.64841    -45.89777     -49.9194    -32.15682    -74.87375   -181.05882   -158.81712   -200.54466     37.85407   -140.74342   -192.06199   -148.99881     17.59959    -59.52594    117.49502    -14.11571    151.51919    161.26487     149.2456    265.67702    114.72201    368.28487    183.64967    247.13109    209.14013     78.22065    161.04556     75.99273      0.15714     264.3897    -51.42797    -82.66238     93.59158     90.65436     27.18712     22.03726    -52.26856    -49.93918    -11.95022     -12.5117   -222.50549    -49.71537     -12.8266    -90.78134     62.75854   -128.75178   -266.17809   -163.73319   -102.78507   -315.14632   -214.88929   -113.38274   -325.51736   -422.31389   -290.80509   -682.73068    -46.45736    -17.35987   -162.66168   -243.04601    -23.17759     64.83731    -67.35973   -162.22823   -357.63502   -184.13774   -503.95341     23.59669   -326.92026   -184.62632   -144.39044   -320.53181   -155.50758    -392.9852    -32.51212   -299.62992   -397.14544    -36.64016   -206.43137   -526.32377   -466.24001    -83.16058   -489.31563   -252.00936   -352.03489   -250.04071   -576.80226   -349.69122   -548.31797   -584.15719   -516.08453   -395.13107   -531.08427   -604.91818   -752.30938   -595.86938   -718.14611   -635.63983   -696.48987   -596.53809   -965.24502   -836.23455  -1071.63542    -900.4279   -617.46622   -897.38879   -938.30469  -1029.27006   -803.18495   -980.96734   -771.99038  -1131.67814   -954.06138   -961.12042   -967.32451  -1065.11232   -913.74569   -934.22694   -1021.5381    -770.3313   -702.36041  -1166.19485  -1043.28696   -759.38584   -997.06757  -1481.17158   -808.21759   -555.77132   -885.52903   -906.62398   -944.14631   -1313.6833   -740.78759   -696.45699    -915.0623   -824.10457   -443.74502   -724.81171   -775.90297  -1368.44628   -962.72879   -847.93425  -1446.21742  -1226.38735   -808.99225   -761.19335  -1241.51495   -401.65551   -620.48988   -694.20261   -252.26707          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        7.00    -402.7282   -143.93025   -194.67306   -266.80024   -148.31299   -207.98436   -195.39964   -320.37917   -442.73628    -209.0288   -266.75851   -185.01357   -139.03608   -383.09622   -390.21948   -431.13331   -304.51075   -249.65127   -313.77219   -358.24063   -198.49903   -118.88431   -217.32253   -243.54176    103.52156    989.85833   3277.15345    4468.8008    3331.5473   1241.52908     145.1761   -136.36418   -135.62256     -111.688   -331.41144   -301.45447    -63.25167   -236.61903    -373.6211   -352.03122   -242.71799   -119.77495   -340.90168    -284.2886   -316.66103    -348.5677   -472.70324   -257.68593   -362.88464   -186.52837   -206.23771   -415.62864   -351.87424   -556.32504   -224.83743    -390.6889   -149.47869   -296.36495   -307.71271   -206.14503    -36.97376   -286.37877   -523.22452    -63.98244   -120.94039   -334.79624   -484.30871   -214.43137     -95.9729     84.50898    651.44543   1985.31759   2504.01174    2329.3318   1118.41844    537.92775    295.34723    205.97696   -119.50384   -246.55765    -73.78877   -311.51875    -64.88534    -251.5465   -432.33205   -180.02531   -274.20543   -200.10296    -26.47958    733.51844   1897.70241    2829.3156    3203.0629   2714.98543   1270.31075    465.70909     124.8649    -170.0547   -181.04319    -89.96992     -57.7951    280.72162    260.58833    214.10636     11.61307     -48.7909    -53.50885   -291.85531   -327.39692   -277.08525   -335.61732   -253.93389   -229.20059   -273.17848   -329.09807   -352.21055   -407.26939   -166.20845   -175.10341   -243.38851   -268.82537   -168.16862    -69.45552    -31.26577    437.43146    818.24954    945.93654    719.74604     675.9242    163.52868     -0.50805    -39.25402     -90.6351   -234.40707    -31.19377     86.50439    481.82302   1137.48034   2221.01132    2789.3311   2793.04877   2192.10417   1533.32874    984.74333    494.38731    223.28881    155.32299     42.94481    276.58054      5.10796   -117.86908   -206.98695    -271.6624   -353.93011   -230.93273   -307.90359   -391.17888   -294.95121   -330.19695   -275.90927   -109.45925   -137.18392   -297.78092    -56.09554    -52.15862     -27.1047    -20.06069      22.9493    121.62489     -234.996    -189.8835   -157.69793   -245.60229   -165.72393   -178.86132     54.10281    282.24825    286.27852    204.60355     67.92163      1.58886    -72.22768    -23.16874     67.89914    -21.01847   -250.24927   -159.18412   -373.95129   -227.54313   -251.79232   -231.17646   -284.01322   -351.30313    -60.51814   -126.89208     20.40141     96.39228     86.83138    142.57084    322.80832    334.09241    255.92798      56.9373      -3.9914     96.85099     10.69472    -21.26985     24.21306    140.79002    221.18596    320.92471    259.98663     65.71811    -70.15022    -51.28325   -218.76467   -447.92101   -231.38742   -365.80116   -411.59625   -229.31986   -350.78082   -278.08292   -176.13819   -236.80634   -128.41806    -68.18094    -81.39131    136.46291    227.93984    270.38321    113.09573     74.94974      14.7986     129.0258    263.52152     239.1271    278.88542    271.39996     75.52091     220.1174    200.38373    196.94627     41.12536   -211.23682   -121.36051   -238.67074   -290.99316   -349.07215   -256.40315   -243.67059    -85.69111    -137.9977   -187.53917     92.37228   -118.57663    188.61132    222.23736     52.69146    214.62153    292.20229    555.50347    473.58226    733.97966    795.49449    662.87603    677.15511    695.04987    660.10204    412.41155    490.58136    244.09823      6.46206   -165.01525   -104.13721     -42.6073    -109.2203     -3.68704    116.05736      5.67403     13.43437    200.68905     82.03129     20.93114     25.69291    -36.47321    103.10806   -175.90688   -234.77899    -25.32146   -183.53148   -209.96568   -322.75701   -239.19262   -162.26874   -294.66152   -243.45992   -346.77684   -247.47589    -209.6383   -305.78046   -305.32761   -295.95383   -311.32043   -401.05034   -125.23678   -224.64157    -38.46779   -114.93657   -137.45383     -11.2968     -2.43494    -37.35908    -55.17238    -39.76408    139.41494    116.05592     -9.69109   -112.81866   -159.20167    -81.20484    -23.93451    -15.43201    -69.50763   -130.89065   -173.83974   -157.72267     41.67544   -211.18884    -82.26085   -174.39291    -66.42669   -277.73114   -173.81854   -175.39614    109.43764    -72.34991    174.72177      43.2355      34.7259   -222.55066    -71.99802    -35.65241     -180.379   -119.87545    -78.21689    -21.03301    -15.40556   -189.78623   -273.65921   -464.84533    -17.76813   -119.73824   -281.11885    169.89219    -80.12953     78.67721    283.68073    120.60576    199.33367    267.87257    312.87806    263.79467    321.35087      2.80152     70.97035    -23.43576     -0.99495     17.83362    233.74123    221.77807      12.7786     17.98463     27.30425     -6.41802   -104.65949     71.29827     86.46203     -69.6607    117.45749     -55.7815     -9.25315    -21.45142      16.5722     -8.72566   -227.62736   -110.55044   -236.87616   -477.29352     62.47621   -174.54768   -282.36875   -376.97115   -259.08959   -122.86662     -8.50714   -298.16056    -73.34057   -259.64308   -284.76076   -306.04975    -297.0032   -383.45356   -358.91169   -240.61393   -244.86461    -488.7611   -124.03183   -326.41035   -253.55478   -226.21676    -44.95402    105.53548   -251.70624   -119.38041    -215.6936   -262.55584   -215.43872    -67.34214   -334.59716   -255.85573   -296.95272     -38.4196   -328.12518   -268.11577   -521.76386   -593.11552   -389.39004   -498.83253     -497.865   -767.55582   -692.86937   -656.43158   -623.60244   -697.77257   -575.39362   -762.73522   -633.68616   -645.03577   -681.27632  -1145.92892  -1009.39234    -950.5289   -942.88233   -711.83284   -967.06179   -854.87794   -798.79396   -657.34348   -845.94686   -768.24674   -876.56563   -837.98808  -1066.85767  -1084.81608   -928.22649  -1134.73303  -1129.61753   -747.19211   -719.26929  -1121.66708   -852.54563  -1026.62888   -608.51872   -1068.3423   -943.86937  -1458.15648   -713.10638   -961.67981  -1004.64143  -1332.81814  -1055.31337   -288.18363    -830.1539  -1023.09474  -1148.59615   -799.44519  -1138.36661  -1210.57649  -1705.30803  -1418.31447   -839.00296  -1169.68455  -1100.57408  -1018.74503   -743.41685   -524.91044   -248.22407   -400.35391   -986.64657          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        7.50   -500.25141   -119.36656     24.07533   -210.32386   -390.47298   -179.37069   -100.62502   -303.19043    -471.6029   -249.06122   -265.80716    -92.44788   -181.77387   -355.21662   -305.93079   -330.22101   -365.23583   -165.64674   -373.49994   -291.66081   -290.47465   -156.79942   -376.83538   -156.38518     -34.3832      1076.79    3172.5913   4482.46326   3547.52263   1500.90318    150.63952    -57.02934   -225.02412   -384.23649   -207.79712   -369.64941   -223.21777   -171.18728   -368.94725   -403.06701   -320.42859   -354.72243   -347.08408   -359.01395   -209.04955   -391.25128   -413.82579    -313.5022   -350.80318   -373.83254   -402.34235   -396.92319    -452.0262   -308.55336   -354.48461   -388.94091    -255.0536   -470.23427    -79.76468   -267.82423   -284.86554   -285.69365   -190.48385   -169.06713   -115.47834   -311.07729   -347.58987   -283.46558    -174.2556    139.64515    879.54705   1725.50665   2363.18011   2313.27465   1312.99507    650.57584    146.87666    148.85385   -146.29405    -66.96463    -468.5245   -111.08276   -276.61444   -219.57982   -220.20652   -343.83383    -241.7328   -217.65834    249.25365    854.11051   1709.30617   2906.08937   3214.16352   2537.79889   1481.44434     424.1133    -60.21126   -183.44816   -275.71129   -183.93842    202.93996    209.77703    269.75803    170.68236     98.16809    -90.66355   -402.48677   -251.19351   -273.11799   -263.03323   -254.70101   -333.15557   -397.39222   -323.37724   -133.11695   -148.09306   -196.60871   -125.89511   -167.69102   -181.13891   -335.72581   -201.80575     80.08389     26.75856     398.8479    845.87564    921.94086    903.81611     686.6844    182.08826     59.80068     41.04675   -248.86225   -170.50404   -206.26248     21.92186    467.51161   1202.81408   2299.63291   2808.88465   2603.93551   2487.37906   1578.47223   1049.68055    483.23764    362.60806     48.61936     59.70721    128.42333    -68.66903     77.46892   -201.70086    -256.9704   -186.27717    -263.8165   -267.10274   -281.86577   -226.90737   -241.35674   -334.81084    -172.3469   -321.06217   -313.73864   -267.83416    -59.46446     24.91829     14.56276   -197.90515      -69.739   -125.16166     -50.4506   -312.99876    -242.9006   -312.13194    -59.13011    -53.46727    279.48301    155.44107    139.72573     115.7205    125.64785    260.54973    -67.62227      3.13789   -205.76305   -175.95055   -333.48998   -299.07385   -366.83456   -263.57516   -393.64887   -331.43387   -198.67438   -345.05078    -97.62924    -93.47569     55.69214     35.77912    120.73478    177.92529    430.62791    288.53473    295.57485     100.0601     -7.10591     62.65785    -32.40995    121.48422    271.04338    128.75159    194.51603    112.80522     31.06433    -94.25136   -232.20641   -259.51556   -286.00243   -307.04362   -271.12242   -295.62117   -251.92389   -249.06808   -267.71523   -324.66207    -48.96658     -1.63886    -56.65709     -1.15895     90.30193    -31.25572    153.51268      6.23396    173.33424      1.97772    135.73359     -18.5505    345.53113    213.52043    433.16405     234.8408    150.64827    154.52048    160.58855     76.54713   -104.38665   -217.98579   -191.95365   -102.66688   -160.49629   -110.54358   -350.92233   -265.85269   -152.90767     22.75424    206.71043    161.40166    124.31814    224.33423    -61.51934    320.34018    285.95889    187.84576    660.91333    644.64629    653.60136    819.27803    733.16676     632.5879    538.36828    559.15447    243.35752    268.32675     18.61516     42.77213     10.68871    -94.68601   -144.85736   -193.98385   -162.91084    -47.01638   -137.01534    -80.72534      53.1979    224.63732    -29.53939     66.32443    -93.35492     -44.2134   -159.65684      0.85059    -86.53328   -280.54034   -484.63008   -126.20989   -291.83348    -346.1234   -384.35115   -448.61886   -196.91276   -309.53199   -215.12689   -391.64872   -409.58571   -212.47071   -413.28799   -124.75515   -165.17422   -119.43744   -193.17797   -278.37768    -30.26486   -115.37934     -2.94523    -78.45667    -17.22299    -71.46592    -133.6955   -120.49223    -77.85186    109.72709      -2.9576   -129.90414   -221.63759   -229.78226   -157.79504   -119.96184    -64.17171   -294.63293    -52.95135   -159.50255    -47.23714    -13.24362    -138.7256   -101.50524    -48.79838     -71.5103     -0.36617   -103.13686    -14.81195     68.56816     82.10195    -53.46473   -199.71165   -229.62568   -156.50217   -200.52707   -267.37285   -146.87788   -214.43289    -85.87834    -62.96191   -203.15667    -123.0196     59.68784    -40.81306    199.65335    237.13474      155.721    235.88105    248.62563    279.78429    275.42893     96.17095     81.90065      2.62637     91.28571    179.76796     92.98526    -23.55805    -35.09029    -84.89546    -54.23345   -248.88905      1.56801    -93.36981     37.90826   -108.69897   -168.04665        42.84   -141.97423    -109.5418    -83.64588     13.28505    -66.79526    -82.93435   -195.85441     36.13471   -182.91135   -314.54961   -210.18226   -223.62574   -115.00569   -377.56987   -354.58203   -204.16135   -163.49725   -226.34931   -378.63784   -206.08166   -264.49709   -196.62278   -227.92922   -266.06817   -144.59472     -65.4875    -32.46508   -319.57075   -331.89455   -333.46284   -187.23883   -399.47136   -353.05175     -267.776    -87.37479   -129.02652   -387.69941    -348.8085   -334.21266   -575.50393   -118.91226    -348.7362   -254.88102    -365.7289   -353.86229   -674.70953   -546.78204   -435.92765   -673.27802   -598.60873   -515.17794   -626.35156   -641.87529   -752.21815   -431.91374   -951.37505   -781.95998   -603.49757   -671.31177   -805.01945   -833.79956   -863.26538   -754.79132   -788.96513   -938.82692   -590.74191  -1339.91069   -944.37722   -980.12466   -955.57595   -982.61326   -801.90103  -1033.65582   -955.17689  -1063.41323  -1012.70598   -907.31023   -609.67794   -981.52559   -806.28615   -590.05815    -807.7559   -468.46556  -1351.93732   -917.05942   -936.14269  -1358.99165   -898.79412   -764.88632   -754.37403   -851.99818   -703.85151  -1217.46868   -780.00812   -834.44387   -763.68174  -1315.91393   -809.03074   -1170.5556   -941.44002   -742.88142  -1037.73768  -1130.09635    -912.4337   -998.82543  -1059.14731   -674.57201   -526.95261   -773.36491   -922.35421    -795.3163          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        8.00   -587.93382    -90.77862   -146.68641   -187.52501   -586.82829   -183.02223   -327.13853   -273.07475   -514.25078    -275.6044   -307.53015    -77.11564   -242.02881   -227.21362   -561.45911    -53.69854   -357.80081   -205.78495    -299.7628   -195.43747   -379.23592   -165.83498   -101.70284   -171.50583    -13.87445   1235.25077   3188.47686   4641.53173   3450.60638   1242.90632    380.23157      3.17009   -458.36167   -227.63667   -260.72406   -419.48811    -435.2235   -367.12932   -342.88273   -371.42621   -263.86977   -398.25493   -297.70381   -540.18135   -359.02775    -316.1626    -473.5026   -289.61796   -380.89394   -472.00348   -375.87715   -453.30212   -474.15115   -381.18301   -326.18505   -384.29133   -139.27987   -145.57485   -181.11097   -293.96614   -284.67136   -405.25168   -345.87992   -249.23227   -366.87566   -235.40835   -422.00916   -173.21025   -183.81692    240.83143    843.45274   1869.75523   2248.51834   2288.01345   1264.99821    440.29432    368.98099     78.83371    162.94217    -19.97277   -279.36675   -146.10219    -281.3015    -92.10755   -244.27202   -385.09273   -298.10959   -159.60359     142.8619    730.33519   1760.22795   2803.00776   3243.19869   2505.45698   1746.80772    421.64211      2.02121    -95.39734   -278.86631   -284.64101    -22.57079     273.7938     304.4225     186.8871    178.20033    -98.57739   -221.42651   -243.17238   -394.52409   -251.39076   -339.76126   -450.50957   -374.73373   -326.12013   -454.62249    -279.8647   -272.07187   -276.51325   -124.47009   -140.03473    -260.4204   -342.73634   -140.18585    125.59436    409.71501    851.58188    850.96548    753.08463    728.07146    226.69692    264.98197   -110.27011   -234.00816   -101.89161   -123.72885    -62.29588    490.48778   1088.68065    2187.8212   2747.83186   2701.37484   2615.52724    1891.7977    938.88637    474.88185    408.44102    212.22737    255.12754     84.61614     22.42669   -158.44234   -287.17544   -146.80064   -250.70348   -219.25507   -357.17355   -149.30339    -229.9465   -248.95371   -179.29235    -258.6309   -298.94003   -307.33808   -126.68045   -121.05196    -46.29581     24.89074     50.03212     35.40729   -133.97613   -231.48881   -244.60581   -315.44547   -105.25792       61.638     -74.4544     111.7156     201.3848    194.19543     77.89137    207.40657    101.77648    -93.18195   -107.57245   -229.24361    -187.5123   -123.76151   -294.33709   -235.02563   -211.46931   -360.71312   -249.91257   -327.14627   -300.62663   -160.70568    -42.06572    -38.94131      -93.696    110.26025    161.79501       7.1408    321.34362    222.07105     70.42046     26.35282    -17.08092    -30.86739     -2.49144     30.67564    170.64568    149.75928    133.56052    -14.12545    -69.59298   -109.22489    -242.4574   -340.54113   -333.99283   -294.23352   -243.67219   -350.94564   -172.83196   -217.75146   -226.78276   -178.28446    -65.88522     13.17093     31.78899    -34.55786     74.92268     61.64956     55.48059     34.81572    103.29223    218.56967    129.38221    106.62942    311.67533    382.62153    276.80159    295.03625     256.1645    150.44239    -18.37145   -104.12753    -12.01711   -139.21898   -144.44661   -175.76844   -139.93392   -214.45655    -126.7045   -189.17004    -96.98208    -60.26397   -154.24801     22.55674      76.7612     27.29799     64.88654    364.71879    467.26044    550.57626    659.49117     855.4938    850.42668    709.79052     701.3748    754.38396    486.79268     514.4824    177.22155    176.29038     99.40821    -87.76986   -217.24971    -41.73993   -164.67465   -104.47349     79.36515      4.63005     56.11043    -21.56688     236.1892     47.30162    114.73566    -28.52614      7.29805    -66.07429   -345.43209   -259.88336   -265.75381   -164.87673   -438.75592    -75.71039    -406.0112   -380.70754   -138.26524   -472.68439   -331.37734   -164.79791   -197.99561   -223.31767   -132.76543    -79.61678    -209.5233   -231.91805   -208.97538    -96.33518   -148.08416    -26.30069    -42.27723     67.10028     31.20905     -30.1679    -25.87311      3.14663    -16.90959     54.57132     -69.3207    -73.40548   -243.66058    -84.88978    -71.22166   -161.84813   -169.41187   -202.27899   -229.19064   -115.91042   -123.58666   -206.79777   -168.33728    -76.42224     34.71561    -61.15061    -79.80691     46.42271   -112.92772       4.0278    -58.79466     31.14458     -12.3845   -252.18664    211.46362   -170.07532   -148.63264    -96.04579    -134.0337   -161.45561    -37.57268    -14.22067    -75.97157     -18.6954    -86.60865     57.14216    281.83339    233.01464     97.17987    263.55895    250.94172    626.36646     81.97621    231.68666    172.78782    187.55797     53.38133    167.48504    132.75521     10.52207   -197.29075     -88.5018   -108.74206    213.45033    218.56345    -61.27764     56.69402    -51.92371     -81.2449   -165.34054   -144.88149    119.06915    -71.79607    -124.0028    -90.25601   -111.51828   -101.33088   -228.65865   -231.29294    -74.93107    -86.14293   -178.13274    -17.76277    -157.1999   -294.12983   -233.23634    -30.35074   -398.00104   -167.39766   -259.26735   -154.74689   -309.90928   -480.00924   -103.22984    -124.5691   -199.93735   -320.55953   -252.79494   -161.25717   -185.35274   -256.46338   -277.87571   -230.59979   -368.98362   -500.21229   -304.50701   -397.24964   -345.33552   -264.13014   -393.36509   -447.31329   -103.49743   -337.74849   -316.30055   -209.39651   -713.73646   -318.39227   -403.37751   -353.20782   -429.73104   -375.24558   -294.18139   -525.18483   -566.49745   -594.05281   -768.33121    -465.5807   -779.17378   -674.49415   -812.90635   -889.54824   -942.07388   -784.61468   -850.78537   -848.59398   -887.20747  -1076.28552   -837.41741   -683.11684  -1112.69138   -813.45703   -791.19274   -772.30798  -1012.70925    -792.4472   -830.89445  -1082.74098  -1078.63792   -936.86061   -853.65777   -991.87795   -934.66942   -941.50753   -1078.3569   -974.50893  -1068.32061   -891.47191   -843.14338   -787.38032  -1120.67411   -502.65596   -987.63616  -1218.12697   -854.21212  -1320.10684   -770.61832   -793.59552    -938.5761  -1035.92202  -1347.20995   -960.71978   -963.85239   -985.46135   -614.22162  -1233.67923  -1205.40466   -398.50472    -791.3183   -787.36054   -449.51977   -945.61778          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        8.50       -597.1   -295.87163   -413.53669   -190.30031   -538.81569   -286.05207   -562.90885   -225.47984   -410.00697   -335.63393   -303.73155    -56.18739   -189.98199    -40.55108   -609.19592    -37.31691   -225.53223   -269.00853   -276.66448   -242.74635   -379.37026   -187.33772   -162.08955   -324.73568    168.60604   1259.31999   3177.89963   4532.48446   3276.50355   1315.99719    152.52537   -218.94264   -441.07924   -333.72129   -503.09634   -431.33948   -416.04107   -347.81232   -314.89747   -339.78983   -591.53809    -424.1639   -291.52766   -427.68459   -504.62619   -394.40899   -438.09652   -342.29591   -336.09799   -471.67653   -503.20552   -595.58995   -337.12129   -506.46561   -335.38309   -274.55122   -334.94569   -288.30414   -143.68095   -106.83365   -262.27446   -450.49364   -377.65335   -341.67723    -367.5336   -314.78767    -337.3202    -236.1397   -245.68627      68.0621     696.4566   1831.86687   2540.08322   2128.15445   1161.60488    489.23889    268.64591    -32.74781     18.32908    -336.2383   -228.17147   -131.55512    -168.9661   -353.39458   -296.57273   -379.22416   -126.96807     50.01931     23.77704    897.63643   2003.59499   2922.37409   3523.96737   2699.19057   1492.03019    427.58055    -88.53215    -74.27712   -160.01765   -240.60964    -12.63701    349.34048    295.89647    333.15593    -54.64115   -164.16977    -304.5569    -337.6084   -310.91124    -201.4944   -302.15788   -372.58904   -199.43079   -372.77879   -226.40036   -268.07549   -193.74791   -106.36033    -94.44136   -282.93702    -224.4509   -315.26638    -98.84536     15.72728    426.61565    752.91366    981.37978    897.24152    548.90947    338.51537       9.4959     31.12054   -166.27465     -192.619   -105.70699   -193.24808    466.13945   1193.38949   1974.78335   2784.20725   2878.72009   2256.93139   1723.03175    859.84907    556.75121    344.65383    173.36769    139.59554    228.55742     -5.97604    112.40064   -240.51031   -215.58688   -259.32527   -308.97121   -212.29998   -147.71788   -218.90528   -301.40342   -306.43481    -264.8628   -114.29027   -196.60007    -85.67766    -65.35897    -98.40538     18.00563      1.65506   -109.00933   -200.32211    -91.45113   -163.24013   -138.49632   -163.95989   -113.22635    203.28571     187.3849    106.92671    211.03956    199.31051    -68.32718     68.42056     20.00632    -67.00757    -43.91988   -215.13146   -215.28431   -247.74442   -471.07808   -253.45034   -194.85372   -394.60789   -155.69815   -191.22748   -132.99524      -81.899     74.14507     234.6769     -30.4503    293.41893    235.38231     98.51817    143.37569    184.97244     66.89585    -60.81842     -8.07412     -0.17461    129.19662    213.01145    102.72605     81.80427    -36.44424   -296.54901    -47.04146   -236.45789   -274.04612   -281.06374   -339.71686   -383.51428   -351.68168     -340.011   -146.74535   -406.26596   -196.87491   -195.02078   -209.19596    147.54764     55.11633   -153.81332    136.95426    142.14128    173.92985    125.33054    201.71718    152.07741    220.75285    428.46147    421.06519    444.81219    222.77313    283.24175    -38.72715     52.39625   -149.08692    -31.08351    -212.5887   -209.72211   -232.91805   -360.46987   -237.90054   -160.27638   -123.75793    -89.29272      32.8475    105.20408    125.49412    182.01987    111.66847    306.75634    453.84205    298.44174    668.24352    630.78978    757.12634    603.95479    551.43396    660.73952    544.13144    449.55144    246.74847    152.72763     145.3553    -33.91883    -47.63251   -104.61845    -45.89074     -0.59565    -70.91279    -75.61191    -74.11309     45.29528    118.55986     62.22631     29.07478     11.93788    -71.35235     11.74164     17.91007   -129.56822   -129.16285    -71.31036   -199.27764   -294.96429   -237.06187   -364.24723    -326.0742   -335.90016   -199.61315   -241.91017   -260.08694    -307.0955   -170.51666   -219.30136   -288.18012    -64.30394   -158.22716   -388.57304   -260.90009   -178.83543   -215.80196    -46.71845    -85.46475     90.06219     64.06387     74.53161     89.65271     181.2336    -99.09025    -86.79616   -124.11187     -4.84405   -260.90089    -187.8664   -165.72698   -427.74031   -260.25424     30.94432    -15.57455   -164.35394   -107.68047      5.86457    -47.62616   -139.62142    -43.70611    121.42217   -167.44011     94.41591    -121.8003     -46.7093     13.87751    -53.13635    -28.87723   -163.14099    -58.82553    -97.85249    -78.87927    -69.92742   -224.14352   -134.80354    -34.66896     12.01943     125.9174    138.66501     70.70158     34.85805    180.84364    189.01123    171.17055     97.67106     63.14171    216.76218    235.90362    257.35604     67.98754     90.58287     138.3426    341.88528    275.94539    -29.24492    -20.61139     -0.97878    -17.13309    140.32588    135.55449   -199.27815    -60.87979    -12.40319   -177.69855     52.03713   -172.11996     -81.7259     98.03717    135.98675   -168.04135   -296.34194    -72.76126    -21.78051    -62.70181   -178.15324     30.55028   -121.66544    -198.6208   -427.01497    -214.3963   -170.26872   -251.80052   -387.92387   -253.30732   -203.74589    -13.34853   -461.68138   -103.22602    -165.1897   -323.62423   -278.50137    -84.60241   -148.57276   -332.62445     -265.432    -197.2118   -259.04662   -409.59912   -252.82698    -190.5699   -188.65373    -66.00835     -444.476   -114.25335   -169.55616   -620.59832   -246.51117   -238.68623   -418.32789   -443.58277   -483.84571   -398.89021   -304.96286   -541.79692   -447.40636   -738.33299   -587.10182   -431.75546    -705.5383   -729.88998   -520.18709   -535.87736   -766.98503   -585.58797   -660.76484   -765.82643   -739.44864   -733.16033   -754.99553   -980.11089   -724.13926   -802.13136   -994.17253   -971.02484   -630.92732   -962.60375   -690.37148  -1136.96272   -957.66208   -922.61955  -1118.14591  -1027.47329   -699.81633  -1017.41239   -854.60393  -1021.19516   -738.70364   -671.10585  -1104.35926  -1473.78458  -1168.64133  -1001.29987   -751.84666   -257.86656  -1019.04367  -1103.85605   -1227.6159  -1042.48496  -1106.31773   -664.73838   -868.49188  -1036.92026   -750.73026  -1164.56058   -687.42972   -897.42224   -872.64445   -1246.8326  -1091.85167   -696.75299  -1112.26201   -572.10541   -697.22954  -1111.82358   -924.56041          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        9.00    -401.4474   -472.38057   -600.62235   -241.18606   -398.60923   -429.09755   -555.35529   -231.93852   -318.94381   -351.93288   -242.69558     -49.8945   -171.78944   -179.64807   -358.82043   -108.57254   -152.23378   -180.96794   -269.24183   -381.83663   -341.14463   -295.78977   -311.90341   -194.80706    310.36413   1241.49164   3015.52172    4529.3105   3310.47226   1444.38838    320.26922    -231.8257   -267.02778   -194.35731   -430.80757    -375.5817   -337.85771   -243.09843   -271.12794   -302.08512   -359.27561   -297.98851   -238.98056   -340.56701   -489.51989   -291.89764   -486.85616   -507.10395   -216.91342     -449.806   -268.54223   -289.58677   -359.40601   -184.69539   -417.31056   -234.38059   -251.81483   -265.08246   -154.60003    -170.2278   -186.43641   -366.02059   -400.89699   -269.72338   -318.86253   -290.63197    -430.2675   -297.70653   -359.15813    -33.87531    579.30218   1742.89021    2352.7397   1866.42526   1144.33342    590.96114    173.80892     19.54121   -138.33146   -330.37966   -168.90789   -243.00248    -183.5738      1.94761   -524.75057   -328.11426   -228.88032   -113.16611     86.87788    643.35403   1621.25059   3018.15371   3290.67783   2371.53281   1202.44929    352.65007    113.76785   -161.49539   -275.45428    -83.97518     87.09216    117.45167    250.51919    262.17952     12.64607   -236.66983   -203.12037   -283.32851    -459.4134   -340.38878   -339.35687    -302.3042   -328.68687   -326.32003   -328.83471   -231.35369   -311.35072    -214.7905   -199.95729   -178.12542   -218.04359   -241.74484   -186.37401     127.2649    425.99486    891.35496    926.49596    836.83676    665.93992    287.60499    -30.17665     -4.34493   -243.02173    -74.57303   -230.69321     23.51631    417.33201   1280.66076   2001.30582   2743.41657   2757.40767   2426.32974    1875.9177    856.37794    376.83353    136.46228    139.37787    113.21436     62.87328    -75.66991   -107.32432   -185.56673    -73.49639   -301.68188   -264.08617   -202.68975   -336.47443   -385.74009   -330.31927   -204.77009   -366.89479   -245.08417   -275.85433    -43.98742    -45.08458   -172.57401     66.85276      1.64292      -87.688   -100.67412    -96.91696   -327.51342   -327.77822    -55.19712    -29.78803     31.20842    246.47114    223.10562    224.89748     28.53267    -16.90745    -49.10083   -148.67928   -125.73478   -207.26716    -78.16722   -281.91102   -244.15504   -246.51407   -207.35179   -218.27897   -330.38697   -298.04169   -170.39583   -186.66078     13.68095     89.77177     24.84972    238.46662     235.9316    387.44311    361.61497    149.95014     17.51945    140.47162   -102.94041    121.79768     39.09716    148.39371      5.30906     52.70475     131.3557    113.23547     42.74888   -147.79568   -341.49386   -200.38136   -213.66834   -377.21605   -382.36406   -276.22266   -343.17041   -319.21492    -327.1727   -253.66742    -53.89804    -88.71781     69.03641    145.06231     -0.21133    109.23973     50.64232   -101.75904     152.5254    184.03037     91.12991    258.95034    304.32101    540.49183    322.79219    382.49785     262.8773    137.42547     29.39622    131.61428    -288.6805   -125.32004   -313.26452    -37.65995    -283.6717   -204.91332   -158.04992    -255.4457   -194.55252    164.61777    -23.63276    116.44559    264.19759    -19.00678     23.33415    427.09111    354.69295    655.26589    673.09342    622.99639    742.06589    772.28816    717.21793    645.50527    394.92326    138.76651    155.44151    123.40048     78.69993    -77.60131   -175.22645   -177.56157    -10.59921    241.25948    -42.42575     -0.28516    -17.47527     50.73857    160.96989     47.32296    -50.70692     -9.24027    -67.27091   -102.97435   -206.08627    -91.29433   -114.19223   -182.70709   -331.92532   -362.26725   -348.03399   -398.72086   -425.00601    -318.2241   -210.69271    -219.7998   -183.20858   -189.51885   -194.56597   -204.28868    -91.89562   -194.06791   -152.86163    -82.46428      5.92441    -211.2607    102.00782      65.3882   -101.99878     58.38401      1.09035      6.43143     24.17233     64.47427     41.83796     -81.0126    -64.72025   -121.53746   -233.14062   -257.99263    -148.9395   -159.16596    -96.49871     57.72604   -174.67048    -78.09992   -161.74033      44.2164    145.41226   -165.77783     -37.3212     22.29168    -50.55462   -142.17006    -74.36618    -13.95364    -35.30177   -111.05906     20.53147   -137.74027   -107.51217   -213.83447   -187.54384     -6.75656     11.91225    -73.89728    -246.5911    -21.31441    111.31265    114.05662     77.29415    115.56113    229.65239    290.05546     51.98245    379.34674    283.91398    261.79977     72.66954    140.02163    133.52604    105.57697     55.64816     70.45386     53.81031    174.71012      74.6859     35.49009     14.46166    -54.30056     10.99662     -6.97811     43.47647   -146.79319      7.45212   -185.15152   -176.94861   -141.55065    -37.08834    -94.10285   -198.91483    -324.3132   -151.18594   -189.19687   -181.07293   -158.05393      6.69033   -238.58954   -215.27104     58.09198   -315.15763    -64.95877   -277.80057   -195.35957   -185.59474   -135.14341   -443.01675     -77.3525   -263.42444   -276.07888   -164.06711   -278.06046    -200.8057   -288.09431   -306.97433    -55.47883    -254.8122   -370.39609   -212.39281   -309.35089   -210.53023   -370.60636   -222.53973     78.19348   -139.20812    -163.2123     -1.15939   -343.99675   -381.54023   -187.31682   -402.37809   -160.99989   -159.92223   -468.27124   -423.13417   -475.68767   -662.21374   -556.53077   -841.70957   -639.35778   -809.93493   -796.97276   -751.38259   -620.44424   -695.15252   -630.10617   -714.66204   -763.29118  -1023.35833   -885.35016   -968.29775  -1001.11182   -580.43078  -1102.71077   -769.76048   -918.35609  -1025.53732  -1060.45393   -1237.9229   -876.52228    -734.9818  -1131.51743  -1134.32953   -648.43242   -826.25406  -1243.79657   -811.20811   -908.47549  -1141.47933   -951.94305   -559.08021   -678.64488  -1451.24386  -1098.90561   -830.88837   -817.62626   -813.95824   -970.41622   -1072.5898   -886.90583   -783.85049  -1049.08385   -604.23398   -833.30035   -776.09691   -319.43322   -914.28268   -484.00443   -686.70696   -679.39644   -829.48505   -497.72332   -781.95352    -837.5836   -900.14956          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
        9.50   -242.71322   -532.79096   -453.71921   -277.32867   -298.47993    -423.9231   -460.08784   -300.87322    -291.0424   -279.34718     -246.701   -217.00433   -182.98472   -350.27499   -402.46226    -409.0935   -128.76576   -207.91398   -331.24999   -493.44962    -325.1963   -190.26234   -475.96031   -104.30166    323.03888   1244.37474   3038.78835   4482.38476    3488.3668   1487.91459    321.13965   -209.64478   -189.80922   -295.85082   -250.97682   -251.53609   -304.99301   -450.37093    -189.9767   -309.34374   -425.30432   -406.15832   -284.17876   -358.04456   -487.92128    -349.1688   -344.23897   -280.68373   -223.55375   -230.23839   -257.81757   -349.51854   -387.05848   -254.38262   -415.95229     -94.6962   -307.24799    -90.31026   -258.38825   -221.00821   -427.02146   -392.23724   -137.80084   -240.04004   -324.94163   -233.10109   -338.47092   -121.10034   -233.37442     29.00353    668.92786   1685.59055   2162.69857   2167.69543   1326.94842    624.61545    268.25174    111.44041      41.2536    -215.8832   -314.45487   -174.07988   -147.52488   -335.05044   -224.61977   -234.15386   -219.90319    -58.96085     85.29841     668.1717   1936.62162   2857.13767   3175.97391   2583.55652   1205.45835    360.17724     39.79868    -162.4721   -122.32975    -120.3961    136.53151    231.23607    255.55803    193.30777    110.34299   -207.20505    -213.0809   -310.98364   -254.89046   -464.85863   -448.33985   -366.88797    -401.1303   -284.74228    -329.1718   -190.36306    -245.0835   -123.72547     39.10081   -230.76898    -232.7048   -295.22094    -58.47014     70.90791    365.89668    634.94316    882.38029    640.74873    562.35178    230.33132      23.7057     23.56409   -164.65955    -66.36813    -60.78816     46.67156    499.84113   1428.18289   1996.30904    2908.5491   2872.54481   2394.77778    1589.4709    971.99948     472.5712    292.26303    179.45796    178.27911    153.60421    -89.73875    -72.89945    -64.87669    -268.0577   -311.84062   -209.08742   -227.96622   -224.42153   -221.46129   -277.61301   -157.70034   -197.55364   -173.24382   -172.17946   -191.17245   -109.26061     50.42474     51.24669    117.06998    -62.39192   -198.15749   -135.93018   -207.12324   -295.89521   -254.04163     -6.12057    131.93608    196.76344    281.64497     172.5394    269.99605    182.00089    -42.05753     -0.66439   -120.70271    -97.34239   -233.72618    -194.5268   -317.82466   -361.38167   -281.59784   -218.07076   -237.48033   -263.99563   -238.36851     40.65666    -84.47265    -72.08894     44.32922    172.00488     222.3199    181.97056    245.88951    188.10585     17.46203    -83.43339    -47.43708    -12.58546    110.83081     91.07448    282.66034    208.64563    249.35604     99.65292     36.97313   -208.38394   -261.85273    -290.2661   -345.10795    -361.9028   -373.72548   -271.23114   -382.85962   -282.64276   -235.18318   -150.81594   -169.25591    -11.72585    -43.68897    111.73093     65.41826    205.89659    213.67874     60.15784     96.58004    131.04495    270.83079    158.45877    203.69868    358.62045    245.10191    226.86639     222.2994    214.87294    -27.86869    -13.39262    -73.83734   -144.20847   -133.37966   -154.56357   -224.00425   -218.40768   -282.12918   -158.61673    -236.9934     50.50243     32.48019     15.59373    153.05164     46.64858    157.47424    353.21495    491.24644    636.02438    569.29441    595.59226    740.56418    690.41814     787.2442    554.93289     466.4576    243.45435    290.36481     92.07743    -53.55017    -54.59147   -184.92391    -16.01318    -25.42386   -165.96586    -58.81669     95.51787     16.56205    -32.57953    186.50526     67.33709    181.56377     13.54391    -65.14807   -275.30754    -208.0116   -134.17506   -148.80603    -74.64179   -393.95826   -463.11856   -307.55077   -247.81292   -238.45739    -294.6636   -133.72442   -476.50035   -249.57069   -347.71821    -90.35455    -323.0274   -206.09485   -135.08708   -119.87008   -237.27311   -184.26024    -23.48408     18.58838       60.102     150.9699     48.60283      53.1574     -7.71416     52.52933     83.18528    -60.76013   -145.91496   -181.94017     34.71404   -137.79948   -187.93219    -97.87502   -107.93176   -260.24886    -62.29726     72.01099   -244.83583    -64.55016    -75.97405    107.52473     -1.28912     -6.97618    -52.76443    -56.67347     84.77049    185.01645   -150.78731   -181.86456   -137.45694    -43.40862   -119.35412   -125.91652   -216.40949    -15.46935    -65.23051     28.12414     -65.0938    -75.79069    -32.40304    -75.11171     64.41983     76.63167    175.32242    261.56437     111.2294    226.50348    319.93363    209.72525     151.2828      319.115     52.03024    232.55574    169.14019    157.18118    -15.14049    -40.17032     80.83369     71.67988    -39.73678   -227.07941    162.05996     -2.49505      5.95102    -32.76646     24.02071     -0.05974    -237.6283    -92.08644      79.1618   -170.13818   -282.65836   -300.63756    -98.06349    -92.54027    -20.66248     -219.116   -124.13557   -185.59288   -276.12594   -233.96733   -245.65838     -304.074    -232.8967   -230.91715    -34.35319   -304.68041   -380.13313    -32.78028    -81.74675   -226.75116    -13.77814    -60.59502   -175.68415    -225.8895    -343.2856   -132.99117   -158.38577     -184.585   -131.49894   -275.09745    -96.33708   -248.39952   -193.21931   -178.64257    -33.49683    -76.18627    -289.0105   -401.59597   -109.48658   -346.15766   -440.93146   -675.76169   -504.97529    -417.6229   -343.80689   -669.71601   -581.54037   -469.10567   -765.36379   -531.34208   -546.16454   -606.92988   -724.25917   -866.92424   -708.68315   -765.92507   -764.83117   -858.24432   -811.43039   -881.92946    -616.7728   -736.04735    -846.3265   -835.77156   -826.57878   -1326.3177   -985.97356   -649.02415  -1031.54061   -549.44243   -959.74368  -1058.14775   -980.37551  -1045.08894    -819.8359   -976.06765   -771.18265    -907.3494   -800.01415  -1027.03866  -1212.39939   -870.78423   -816.84978  -1102.31934   -820.02214   -973.04438    -1361.748  -1036.09383  -1044.44455  -1360.09179   -887.04083   -834.95843  -1160.54811   -843.80125  -1096.73912   -828.44646   -695.51223   -798.17438  -1199.74921    -777.3263   -730.24565   -345.81041   -614.86759   -373.31971   -823.96946   -486.44227          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       10.00   -173.87323   -395.07866   -316.26338   -290.29988   -250.39292   -388.88719    -437.0974    -456.5442   -272.94137   -257.80138   -385.24766   -412.05909   -161.65596   -268.49359   -557.57216   -398.58274    -39.35268    -325.0771   -287.40293   -272.42737   -240.76221   -149.62208   -435.77485   -136.15584    187.10376   1145.52805   3313.98884   4411.79218   3406.29263   1470.50881    160.86497   -340.01277   -170.34005   -385.13487   -401.12825   -118.44941   -225.72676   -178.74957   -255.13453   -346.05589   -178.63347   -261.59051   -241.84868   -350.14657   -328.40216   -292.57339   -511.25161   -280.58156   -264.57193   -303.16983   -310.54507   -231.99885   -208.73792   -402.72349   -467.67028    -550.4247   -336.67146    -66.94635    -51.84683   -174.39738   -357.63591   -301.52274   -277.04515   -316.32087   -350.60421   -327.65023   -369.70388   -356.88489    -95.05303    -99.02556    817.86237    1908.2347   2525.15765   2089.85204   1208.45939    484.16024    146.27847    114.51614   -208.82154    -176.7548    -280.1946   -299.14034   -183.03803   -230.38479    -357.6193    -66.10295   -264.88529   -123.47197    -68.40549    654.30924    1794.4761     2878.776   3237.43895   2340.20494   1356.54679    282.72893    -65.11672     14.60494    -45.39154   -251.34913    137.07138     148.9293    367.74223    163.31881   -114.81679   -180.06466    -143.7375   -386.65025   -330.52631   -160.31657   -225.07734   -278.29924   -170.26709   -469.14611   -243.71152   -284.52691    -334.9908   -159.83484   -224.81168   -344.95991   -330.56666   -330.40615   -102.99542    121.85211    420.04889    616.51962     977.5892     960.2708    595.65189    282.38816    -35.85491    -32.96835    -212.2379   -192.59434    -79.96889       26.401    560.75533   1299.20057   2045.30088   2887.51005   2838.30939   2213.76172   1719.01462     792.2315    451.11434    263.85914    192.69794    121.92409     161.1024     52.35614    -25.33414   -120.93621   -336.13109   -282.28263   -385.89435   -190.91132   -391.18027   -286.90522    -379.2978   -162.78655   -301.49039   -260.19044   -163.81007    -97.77537     23.50866     13.82143   -201.60771   -193.53737   -138.12431   -315.25054     -94.5677   -298.61761    -203.5695   -229.56713   -151.48125     97.68346    228.22262    104.84877     270.1212     91.56401     13.48851    -39.32378   -180.08268   -147.19066    -68.22965   -151.34384   -240.11215   -227.12435   -419.31552   -151.49935   -175.93801   -251.58118   -348.02342   -183.39745    -31.16214    -64.70514    105.60466      6.54514    172.34505    230.73344    250.92586    218.95285    177.54869    193.59002    144.35852     -49.2652     53.52583    107.74164    203.29382    219.27498     44.46217    -30.85009    -37.41348    -93.66192   -122.39277   -181.88974   -243.24737   -201.31575    -305.8527   -336.49162   -406.93333   -410.10559   -228.85759     -250.485   -155.82919   -275.56647    -48.05601     96.92703     -42.5739    201.60346    205.86932    113.58533     66.66542     -7.04781    239.07527    346.30649     336.3587    416.91305    306.99954    378.98356    257.81365    517.96057      3.44888     -83.3974   -127.22301    -63.19892   -233.26185   -442.89791   -215.15525   -353.70655   -154.73954       6.6251    -82.65486    170.74216     27.14411    130.21359     207.6157    -39.63915    259.10539    220.97695     288.9371    525.21075    513.90103    537.32208    709.56391    771.26619    766.57175    696.71032    527.11359    411.20354    398.66466    285.66212     46.36453    187.03936      3.57099     29.03439    -35.99853   -187.54978    -60.02919     32.32887      0.34839     53.63828    147.56198     92.54104     79.94974     43.42329    -58.59207     -42.4233   -146.52898    -39.29758    -173.4484   -340.21564   -352.56393   -174.76296   -358.30603   -158.05541   -370.34937   -279.70739   -315.99671   -234.86828   -492.94498   -294.50155   -210.11693   -202.19151   -141.41004   -109.58183    -96.34256   -200.40112    -57.69411     42.76399   -132.83576   -130.32482     92.58331     75.96942      77.2126    126.25856    -80.95773   -104.16005    -18.76952    196.01208    -30.25561    -45.31039   -151.39146     26.83527   -248.21206   -252.15387   -164.24959    -54.45806    -34.96819     -5.81704    -51.59168       8.1338    -82.29863     -19.1989     -3.81059     84.22003   -118.85708     75.76702    -39.73954     24.51426    -34.85295    -171.8506   -133.40552    -72.41804     -5.75795    -16.32529     -9.94188     -8.70529   -146.44215   -240.07091    167.15796   -243.33736   -266.99252    -88.37334     15.63655    163.75573     40.81874    203.16827     32.62291    132.86013    314.65224    202.84674    103.21591    292.43262    118.22523     89.77428     82.90191     44.19791       66.945     159.2328    -52.90566     44.92733    175.79904     31.33095    -55.64592   -160.44183     66.28228     40.29476   -210.26623    -69.12036    -19.84271   -291.45888     -224.403     56.53529    -16.35234    -194.4334    -99.57429    -55.20761   -125.32651   -508.35717    -61.81012   -373.97178   -482.56649   -217.47985     21.93328   -226.48721    -181.0971   -344.39741   -241.13544   -428.92418   -322.63588   -171.79557   -194.08563    -73.09593   -255.34389   -232.92911    -61.43719    -89.68433   -106.59104   -249.54162   -332.26039   -271.13399   -232.66915    -42.30504    -18.37188    -90.67815   -300.71072   -541.29678   -324.79825    -596.3658   -151.50768   -414.37923   -484.37923   -217.50853   -379.06972   -419.79641   -417.19941   -204.80738   -330.05416   -559.99002   -550.28668   -471.89616    -634.2922   -540.32136   -515.47552   -456.47629   -666.74869   -671.37108   -647.05209   -624.06276   -801.40663   -593.01409   -768.78505   -898.69959   -980.12786    -784.2179   -879.50901   -970.90274   -820.92839    -931.0315  -1006.42081   -977.16064    -757.7304  -1042.14057   -896.34239   -761.01064  -1199.78445   -839.05876   -1117.1294   -783.53068   -945.41731  -1257.40889   -757.47581     -522.527    -940.1548   -844.52061   -753.43609    -780.3527   -924.55044   -618.06098  -1249.59984   -837.13012   -916.77456  -1094.77327  -1022.99279   -680.38088  -1102.02409    -830.4523  -1021.95479  -1149.26922  -1009.83519   -783.94191  -1288.99271  -1265.11012   -876.06415  -1047.97434   -642.46853   -648.82508   -489.24762   -311.56577          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       10.50   -221.75523   -287.14725   -325.81437   -291.48832   -224.63331   -335.64564   -472.22187   -611.57289   -205.54203   -316.20969   -459.26841   -440.78743   -119.27053   -247.80686   -330.73538     -87.0865    -20.42611   -176.54577    -88.97677   -260.93713   -394.54373   -233.24938   -294.92685   -260.67135     92.68538   1185.05073   3189.08005   4457.54408   3415.73499   1351.08069     73.61506   -353.84004   -297.54016   -302.32992   -291.62747   -409.17399    -247.1541   -287.32916   -166.22533   -418.35694   -434.59317   -260.94146   -188.73232   -213.07418    -282.0501   -420.57228   -384.64216   -368.55454   -417.49846   -405.16534   -133.59899   -390.40114    -255.5857   -475.40133   -252.25755   -378.64943   -296.54291   -165.46297   -154.12181   -294.84824   -329.78432   -222.02791   -355.67976   -169.44651   -398.76071   -368.31589   -445.95649   -317.82864   -196.35836     68.86302    732.33957   1626.00693   2298.69471   1945.60408   1035.49084    387.18826    248.67098     21.98189    -93.78355   -329.67521   -450.54122   -375.97729   -395.87761   -215.97564    -114.9026   -358.38561    -50.06906   -152.89914     280.8562    803.69739   2029.12755   2865.36793   3081.13304   2373.25998   1182.94472    555.17871     17.85059   -271.78637   -242.38913   -146.40803    -134.0201    364.60391    216.21165    262.72367     50.95085    -91.21583   -149.77391   -327.59886   -288.97556   -164.73643   -270.65941   -336.98287   -438.71132   -227.47805   -252.68884   -159.01624    -224.2294   -140.81179   -184.34403   -162.52149    -208.9046   -144.04692    -61.68321     66.17528    444.47639    729.73456     949.9631    783.17201    660.16061    274.67549    -66.98028   -147.79345   -215.52328   -139.55256    -41.08044     15.70486    510.60984   1465.26974   1915.30704   2691.63026   2751.99092   2199.69932   1624.37396    921.50265    355.97221    118.91946    247.93142    169.76587    250.22718    234.27059    -42.13316   -119.86975   -134.64166   -216.55862   -453.79404   -165.89949   -387.56685    -162.9705   -215.10617   -169.06921   -340.01051    -141.2437   -261.74472    -25.14989   -140.48076    -244.3115    -55.79601     -6.46329     21.86136   -109.56891   -279.34671   -295.89734   -369.07852    -310.2467   -244.04436     80.98845    314.57262    136.61286    195.70852    221.63131     20.23577    -70.30206    -89.69197   -192.93491   -121.23068   -283.89361   -328.49797     -334.966   -315.35428   -252.21894   -301.84175    -345.1203   -283.97994   -226.74497   -148.18725   -152.57226    -74.83587     64.18128    115.22901    350.65361      333.723    348.64561    121.85256    165.29401    -18.68765      -2.2856      0.59777     44.15261    117.80437    181.75955     96.46821    125.77458    -64.55915     -1.05442   -138.27325   -233.15542   -302.51011   -337.02556   -180.89353   -298.71258   -182.70136   -337.68432   -400.91391   -324.36991   -131.87428    -98.38132   -185.54089    -37.49105     60.57919    -15.43199    -74.89802    187.21186     30.72998     87.15297    256.78973    230.97003    229.89097     302.0692    298.67575    390.51919    237.03892    191.93848    171.64227    116.76322     71.83303   -122.79213   -209.83722     43.17561   -279.93823   -285.18217   -218.86159    -168.2843   -194.32014    -66.25425      6.51093     34.16247    -32.59813     79.05061    138.89603    201.15689    386.10285    554.64309    609.31735    630.44589    855.60761    861.40785    767.06498    625.37254    446.32909    484.85393    353.54128    420.84518    212.08344    -66.63383     18.33766   -199.96109   -184.87412   -122.63166   -131.90706     38.27675    169.39684     73.22527     -7.34887    160.93368     80.02946     14.21854       -84.24   -142.36999   -144.03718   -197.04101   -225.33683   -282.14659   -192.29042   -357.15821   -458.22628   -429.49025   -145.81126   -329.84332   -194.79006   -331.40286   -394.28568   -215.62371   -179.16064   -268.85394   -280.90066    -44.18932    -54.38585   -107.45976   -255.11099   -158.70393    -24.43464    -54.87972    -283.7909     27.24193      39.9232    -33.43423    -42.43849    -35.48065      7.49225     39.66023   -127.65938    -41.11791   -265.34104    -52.27065   -133.81759    -19.85854   -249.52068    -168.7326    -85.49432     63.85855    -32.38846    -76.10337   -116.56343     42.16776   -181.06768    131.81317    -65.11031     91.93745   -138.71541    -77.41953   -193.95888     31.86887   -285.30669    -78.01035    -53.78863   -221.51765   -139.89444    -120.7473     58.45177   -197.31886   -101.00997     35.85781     12.46143     -6.14627     -7.77393     95.47709    -43.54947    311.63033     67.99502    195.46736    112.82606    232.43426    205.88113    283.39315    117.68662     42.24806     32.27831     18.29798     32.77594      6.63092     23.89813    -73.57866    -111.4071    -83.14216   -164.29064      5.84367     -7.81734     95.81654   -191.27781      0.25166     37.30077   -329.58879       4.6284     29.47711      4.60534   -181.33867     10.12714   -161.27441   -247.29779   -164.37624   -129.33001   -112.56853   -465.26884   -192.91193      5.73242   -315.59048   -123.82258    -91.99038    -61.74285   -154.29906      48.6249    -54.81269   -238.58115   -212.97902   -129.29645   -183.85394   -188.06425   -193.32919   -264.11719   -297.62662   -128.01904    -92.98889   -174.42217   -310.72273   -336.07688   -265.89964   -250.08713   -223.40126   -284.68809   -278.57317   -375.91028   -194.11025    -408.9336   -367.01736   -520.08567   -563.53083   -333.76546   -485.49578    -473.3186   -764.42582   -543.05061   -621.76001   -643.54027   -435.68909   -841.41172   -814.09712   -801.96881   -691.77998   -791.17021   -553.00339   -749.44343    -841.4246   -624.36162   -684.32994   -872.16604   -828.30488   -870.43701   -996.41547   -923.30594   -915.12084  -1179.44661   -709.38584   -758.20897   -817.09934   -726.87264   -989.86572   -720.73134   -695.04288   -855.79273   -927.96021  -1038.71656   -482.61434   -918.35456  -1207.26442    -632.7516  -1015.66581  -1095.17992   -826.12056  -1284.11435   -1157.2529  -1169.01161  -1025.57854   -617.40474   -734.95134  -1153.00178  -1112.00261  -1078.40329  -1306.24031    -998.3754   -712.40196   -856.53565  -1197.78619  -1169.69618  -1523.41372   -568.70049   -562.01212  -1034.34418   -546.87343   -185.40589   -577.43768          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       11.00   -286.50909   -235.13555   -443.35499   -291.47846    -277.1096   -311.33067    -480.1424   -498.15066   -102.55561   -260.88123   -351.73615    -469.2172   -177.44814   -324.89075    -95.59989   -242.12047   -257.50177    -44.33669   -141.44155   -361.07804   -430.35607   -223.81734   -217.46703   -277.15743    200.65304   1171.61864    3352.9553   4644.32524   3456.52648   1348.88664     44.16161   -308.97697   -301.59935   -199.85188    -316.5503   -395.43753   -316.80618   -292.52566   -363.71081   -291.41081   -407.14274   -462.91873   -476.06303   -340.17012   -496.29862    -248.5565   -581.83192   -349.74331    -385.4566   -369.85472   -346.11011   -384.04627   -291.27663   -415.74092   -245.34998   -364.85053   -221.13859   -198.01038    -93.25333    -42.51167      -255.32   -340.11406   -124.89182   -367.06587   -260.03528   -374.36578   -292.95871   -187.05667   -160.66841      6.29092     734.4008   1741.64009   2401.53953    2150.4676   1124.86278    419.74945    309.64583    325.64281      0.12667   -503.27163     -435.873   -367.27869   -425.97453   -302.58845   -258.89588   -320.76638   -501.20694   -260.50578    200.42998    623.79572   1885.84311   2783.33097    2942.1498   2203.13677   1167.13825     397.8862     19.14913   -239.84526   -380.62635   -125.81917    153.94747    203.41222    279.56449     196.1232     11.24341   -108.94512   -210.14917    -183.8643   -281.84625   -362.18487   -259.11269    -166.1907   -207.18592   -221.37871   -322.19091   -194.55836   -200.03391   -108.99597   -348.11808   -242.37995   -379.87816   -112.26978    -194.3033    128.51927    358.49474    772.30639    826.17008    830.60696    700.09876    196.66678    -14.21455    -132.6801   -234.17376   -223.83174   -139.53149    107.41379    677.54026   1288.32832   2271.61223   2633.06068    2758.3464   2216.07394   1653.76201    887.18715    497.67731    346.25737    223.98882    146.72577     27.47635    -61.46062    -57.63176   -135.90193   -212.88788   -290.46859   -365.76984   -154.63272    -289.9181    -243.1404   -286.45751   -357.88672   -201.00894   -212.50249   -160.58537   -222.54043     21.83623    -13.22226    129.86199    109.45081     -52.9944    -44.95546   -103.21975    -340.2368   -244.49254    -82.81018    -85.43943     48.46824    226.63992    285.41274    309.40694    221.84945     161.7151   -102.88311     76.92239    155.95746   -286.86777   -208.68896   -435.35624    -249.9333    -360.0341     -318.393   -289.46766   -267.24811   -105.92315   -284.65387    -15.62548     -121.307   -168.59685    230.07418     124.7798    223.94443     14.61768    393.95921    193.95461     96.79181    -60.11108   -136.09965    131.19864   -238.97122    146.84261    131.74071     82.03377     90.93574    121.25954     -3.98906   -124.23471   -204.69553   -400.46243   -335.49047   -449.68637   -224.12024   -237.74619   -281.30842   -212.79919     -98.0499   -347.36057   -223.25256    -70.35458     41.65391     39.63506     11.00531    142.12465     56.83999    125.67042     -9.57142    -50.56807      311.066    264.15819    250.23199    248.77684    243.96581    292.73343     249.9003     148.5425     97.34612     96.07263    -16.41318   -200.19871   -189.91644   -240.92156    -259.4097   -197.69033   -349.15979     -31.3972    -107.4426    -56.60639    -74.99307    197.38262    -82.25034    188.60741    244.37591    186.58639    398.84967    658.96924    643.77717     550.0535    720.83758    773.13887    707.12887    672.48497    429.83148    306.77225    309.91455    141.88216    -46.07869   -126.02832     -22.6459   -137.69846    -44.64522     73.94404     69.19614     34.26821    151.79458    112.38423     98.22047    112.72866   -113.90152    -92.13714     59.82371   -218.78314   -166.06263    -99.54299   -312.15379   -284.39458   -218.08506   -179.80637   -185.51421   -204.23491   -285.10631    -289.7944   -257.30568   -151.19433    -231.4187    -245.5981   -319.45284   -203.81058   -146.27706   -202.30212   -212.90548    -25.18893   -236.67846     14.34254    -18.18252     -3.77733    -61.43498    -70.44258    120.47512     28.74613     22.34056      4.20353   -164.51873     -76.3358    -33.46341     48.49472   -216.93488    -74.30597    -92.99542    -39.14226   -132.52848    -69.17937   -304.09639     61.19365    -53.75745    -35.69224   -112.46763   -101.64258   -136.71751   -100.20666     96.71042    172.98278    -138.2736     73.65117    -62.50528    -77.30164   -229.67356   -232.96174    -69.90345    -82.45252     -8.64813    -156.0742     -6.67572    -153.3247   -164.81381   -111.19768     90.21301     64.80287     23.61923     123.1224     191.7847    127.27518    365.31559     100.8716     13.49091     100.0048    206.00742    158.25121    209.00305      9.71942    -23.04355     129.5719     21.90372     76.12081     42.49797     76.52522   -141.50427    138.02195   -245.80477   -256.64584    -37.27607     18.33101      8.77333    -57.84792   -130.80555   -183.60685    -78.35153     -1.84386   -117.61984     40.72519   -256.22109     -83.5885    -89.48846   -244.46521   -248.49837    -14.72856   -239.51339   -620.30272   -253.00785   -302.11184   -502.28525   -245.38582    -146.6683   -240.95557   -282.51411   -251.87414    -19.52886   -247.35022   -505.64343   -369.14586   -562.58916   -221.98029   -336.29788   -284.11209   -137.76036   -116.37375   -145.52696   -133.80363    -93.18009   -389.70779   -321.40735   -200.07114   -492.80208   -437.76089    -90.62929   -321.28242   -496.61816   -409.33267   -289.04656    -576.2171   -474.24702   -834.71069   -462.18846   -542.77128    -452.9733   -700.46181   -871.71519   -971.20975   -560.73411    -566.9918   -512.89376   -819.07065   -592.11483   -634.15671   -915.79995   -828.81093   -720.40589   -953.25893   -838.98122   -965.99661   -701.99757   -970.15353   -910.81783  -1007.03327   -712.73843   -950.99657   -804.04227   -805.02575  -1061.02508   -994.44288   -779.18875   -831.10387   -907.88295  -1049.44775   -693.44712  -1128.93257  -1081.53042   -632.64273  -1236.20162   -695.19156  -1259.86008   -988.83833   -921.98449   -915.84291  -1106.83494  -1134.71073  -1200.07333   -913.71153   -912.93609   -1186.7301   -893.60832   -864.58161  -1353.33898  -1029.87843   -526.51582   -988.55277   -610.52072   -627.00463  -1057.69404  -1053.27129  -1177.89794   -652.53712   -890.62075          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan
       11.50   -389.77225     -218.358   -535.17584   -333.53465   -338.38457   -300.96008    -433.1486   -377.77749   -169.31549    -29.88632   -296.94817   -429.91586   -363.19564   -377.77702   -215.47495   -333.78047   -312.55416     13.80413   -279.25061   -425.69342   -403.63841   -324.06135   -264.00175   -310.73554    171.46227   1020.05442    3299.5504   4207.50174    3420.6709   1513.27394     119.2358   -202.36587   -102.30409   -219.75624   -248.89964   -125.19267   -307.34379    -27.26797   -194.70997    -207.1701   -359.69097   -337.84994   -264.35993   -382.64881    -478.6734   -253.18156   -408.64856   -268.47567   -268.92265   -405.99543   -494.64255   -459.19404   -371.55108   -425.36249   -341.68407   -342.15434   -481.23291    -165.6373    -87.50164   -139.33705   -255.89279   -292.63036   -360.84993   -241.53045   -195.68652    -119.0599   -377.86629   -388.32058   -298.01953     72.36299    597.90274   1984.89824   2535.41095    1875.8356   1282.01239    474.75079    281.99968    -20.51682   -343.06795   -587.90053   -421.36056   -305.45407   -205.55687   -408.66176   -412.34148   -148.60017   -166.33793    -84.84358     46.25275    705.80125   1761.85619   2772.03961   2979.32168    2164.1103    980.19069    472.57608    -60.01247   -158.05333   -296.17866   -128.54237     60.26363    167.34545    207.20676    118.36363    -11.53746   -161.20112   -267.11169   -313.79275   -195.54471   -358.77424   -277.75243   -229.04898   -363.73727   -252.91397   -300.83536   -285.41924   -214.09984    -253.1936   -190.56581   -121.67352   -201.12542   -294.65969    -58.64777      3.71051    451.48684    808.64836    931.93253    852.34845    630.57044    245.50564    -47.13155   -193.28947   -132.23629   -106.44812    -74.85909     52.30625    449.23995   1391.02968   2149.69295   2907.68519   2912.79994   2334.16805   1682.66137    906.37339    475.30266     179.7508    174.93476    201.25854     33.38375   -125.94558    -25.52169    -85.28783   -205.15898   -266.25255   -374.02043   -233.96948   -341.54562   -233.14525   -352.48819   -250.42672   -178.35262   -360.29865   -294.60811   -158.02713    -79.89815      -5.8001    127.01473     13.67651    -27.15639   -192.15494   -280.62089   -145.72186   -159.76819   -194.61461     -69.5388    -57.70195    356.67662    240.88104     139.6458    180.75734      35.1487    -85.93276    -25.35761   -128.48606   -245.98665   -242.65531   -251.82302    -376.5718   -277.53884   -345.91039   -266.10773   -239.12116   -237.95041   -193.91417   -197.34387      3.68781   -142.79706     39.82553    315.21804    407.09393     82.32103    250.02602    351.57701     31.12582    -51.30988     79.04674    -17.38608    100.11712    157.01894    187.82812     225.6166    251.95729     -9.46851   -100.51042   -118.49789    -211.8871   -319.39385   -290.77029   -378.19419   -266.43282   -149.06078   -344.48551   -235.37353    -99.18294   -117.43779   -148.35352    -35.80079     61.16136    143.47871     130.5943     57.27415     29.46499    151.65783     77.95938     96.92765    316.16458    192.04143    316.02045     410.1983     97.65141    272.42437     63.13307    254.43677    138.39398    -11.17754   -223.98244     17.98155    -97.22352   -327.01911   -338.82453   -336.73148   -316.55665   -233.93862    -47.34465     -1.12877    131.90215     -6.04904    123.05722    132.66423    166.35857    380.75703    349.69865    476.73913    488.75836    655.35576    822.94933    833.77478    726.20516    491.38428    196.98225    210.98472     179.4083    176.85877    144.85321     35.79061   -183.24413   -203.85456    -66.35923     23.91766    111.66566     55.29964   -136.16424    225.32383    129.84253     -32.3075     50.33979    -15.11681     56.83539    -30.59391   -152.01779    -189.1247   -218.59521   -134.27794    -311.1417   -327.29758   -361.35072   -225.72606   -273.77156   -143.44933   -274.54396   -345.61789   -223.11424   -300.69807   -297.93956   -274.78272   -210.75342    -89.43694     -80.6583   -116.65413   -200.26989    -12.85825   -185.29393     10.72555    -13.21105    210.58596    220.16386   -143.36607   -154.78101    -87.63215    -16.95647   -102.75401    -125.2248   -156.74603    -45.50586   -162.57539   -268.53437   -109.61722    -79.77123   -192.05948    117.72917   -265.24503   -173.19917   -135.42266    -88.26484   -119.28029     -0.50927   -126.53991    -86.99275    -78.68335     106.6922   -150.54335     -9.59332    -59.82287   -113.56715   -301.46927      -32.163     57.20197     -10.7974    -35.91721   -111.45299   -164.28465     74.49741     21.36368     13.59273    -89.87952     34.95574    172.01544    133.55929     59.72712     275.5457    249.90176    304.91986     224.8467    314.02233    195.33732     -0.25138    -49.05691    -37.79309     12.85519    -20.52996   -198.59434    -95.69901    -38.71216     -17.5848   -182.43918    -122.5559     12.80578    -16.55984    -62.98531   -305.86616     32.41528    -271.5528     -89.9078    -129.2151    -58.54027   -106.51609   -158.87215   -188.77573    -87.83215   -337.07804   -174.36167   -174.44771    -17.51642   -152.84537     -77.6077   -235.07193   -472.42576    -176.2564     24.28039    -42.86558   -202.49528   -187.74633   -295.10461    -74.94942   -229.37062   -194.41523   -318.34531    -86.83077    -86.65058    -140.2343   -163.06281   -244.30345   -218.63754   -280.27876   -244.86435   -162.46828    -457.2776   -171.61457      0.03314   -293.18743   -524.73525    -29.40577   -230.78849   -155.98083   -453.87879   -279.47151   -481.84575   -142.47008   -510.97007   -369.27911   -544.00807   -374.76445   -499.43213   -532.97729   -525.89025   -580.70954   -721.75091   -601.58416   -533.55013   -809.45354   -655.11129   -839.71631   -831.90353   -401.47586   -832.95041    -839.8408   -723.16142  -1011.15955  -1077.98467   -821.10618   -888.31018   -866.45231   -664.18483   -979.90223   -967.29622  -1047.70461   -753.18683   -800.39787   -752.19671   -906.01916   -837.63713  -1092.12784  -1134.55018  -1057.85462  -1073.01128   -921.97108  -1060.15313  -1139.50263   -636.95748   -849.66658   -760.78743  -1127.50388  -1502.04678  -1309.89732  -1147.18842   -918.89048   -951.76373    -778.5591  -1073.21145    -502.0334    -913.5374   -630.28998  -1640.82616   -648.17252   -334.98793   -677.51984   -1033.3279   -948.99896  -1520.93264   -678.82764          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan          nan     