# -*- coding: utf-8 -*-

import re
from oncall_slackbot.bot import respond_to
from oncall_slackbot.bot import listen_to


@respond_to('hello$', re.IGNORECASE)
def hello_reply(message):
    message.reply('hello sender!')


@respond_to('^reply_webapi$')
def hello_webapi(message):
    message.reply_webapi('hello there!', attachments=[{
        'fallback': 'test attachment',
        'fields': [
            {
                'title': 'test table field',
                'value': 'test table value',
                'short': True
            }
        ]
    }])


@respond_to('^reply_webapi_not_as_user$')
def hello_webapi_not_as_user(message):
    message.reply_webapi('hi!', as_user=False)


@respond_to('hello_formatting')
def hello_reply_formatting(message):
    # Format message with italic style
    message.reply('_hello_ sender!')


@listen_to('hello$')
def hello_send(message):
    message.send('hello channel!')


@listen_to('hello_decorators')
@respond_to('hello_decorators')
def hello_decorators(message):
    message.send('hello!')


@listen_to('hey!')
def hey(message):
    message.react('eggplant')


@respond_to('你好')
def hello_unicode_message(message):
    message.reply('你好!')


@listen_to('start a thread')
def start_thread(message):
    message.reply('I started a thread', in_thread=True)


@respond_to('say hi to me')
def direct_hello(message):
    message.direct_reply("Here you are")
