# MAT-model: Model Classes for Multiple Aspect Trajectory Data Mining \[MAT-Tools Framework\]
---

\[[Publication](#)\] \[[citation.bib](citation.bib)\] \[[GitHub](https://github.com/ttportela/mat-model)\] \[[PyPi](https://pypi.org/project/mat-model/)\]


The present package offers a tool, to support the user in the task of modeling multiple aspect trajectories. It integrates into a unique framework for multiple aspects trajectories and in general for multidimensional sequence data mining methods.

Created on Apr, 2024
Copyright (C) 2023, License GPL Version 3 or superior (see LICENSE file)

** UNDER DEVELOPMENT **


### Installation

Install directly from PyPi repository, or, download from github. (python >= 3.7 required)

```bash
    pip install mat-model
```

### Getting Started

On how to use this package, see [MAT-model-Tutorial.ipynb](https://github.com/ttportela/mat-data/blob/main/MAT-model-Tutorial.ipynb) (or the HTML [MAT-model-Tutorial.html](https://github.com/ttportela/mat-data/blob/main/MAT-model-Tutorial.html))

### Citing

If you use `mat-model` please cite the following paper (this package is fragmented from `automatize` realease):

    Portela, Tarlis Tortelli; Bogorny, Vania; Bernasconi, Anna; Renso, Chiara. AutoMATise: Multiple Aspect Trajectory Data Mining Tool Library. 2022 23rd IEEE International Conference on Mobile Data Management (MDM), 2022, pp. 282-285, doi: 10.1109/MDM55031.2022.00060.

Bibtex:
```bash
@inproceedings{Portela2022automatise,
    title={AutoMATise: Multiple Aspect Trajectory Data Mining Tool Library},
    author={Portela, Tarlis Tortelli and Bogorny, Vania and Bernasconi, Anna and Renso, Chiara},
    booktitle = {2022 23rd IEEE International Conference on Mobile Data Management (MDM)},
    volume={},
    number={},
    address = {Online},
    year={2022},
    pages = {282--285},
    doi={10.1109/MDM55031.2022.00060}
}
```

### Collaborate with us

Any contribution is welcome. This is an active project and if you would like to include your code, feel free to fork the project, open an issue and contact us.

Feel free to contribute in any form, such as scientific publications referencing this package, teaching material and workshop videos.

### Related packages

This package is part of _MAT-Tools Framework_ for Multiple Aspect Trajectory Data Mining:

- [automatize](https://github.com/ttportela/automatize): automatize for experimental evaluation of MAT classification
- [movelets](https://github.com/ttportela/movelets): movelets for MAT classification methods (based on movelets)
- [mat-tools](https://github.com/ttportela/mat-tools): mat-tools is a entrypont to find all librareis for MAT data

### Change Log

This is a package under construction, see [CHANGELOG.md](./CHANGELOG.md)
