"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.serviceAccountName = (_b = options === null || options === void 0 ? void 0 : options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.createServiceAccount = (_d = options === null || options === void 0 ? void 0 : options.createServiceAccount) !== null && _d !== void 0 ? _d : true;
        this.certManager = (_e = options === null || options === void 0 ? void 0 : options.certManager) !== null && _e !== void 0 ? _e : true;
        if (this.certManager === true) {
            new cdk8s.Include(this, 'certificate-manager', {
                url: 'https://github.com/jetstack/cert-manager/releases/download/v1.1.1/cert-manager.yaml',
            });
        }
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-crd', {
            apiVersion: 'apiextensions.k8s.io/v1beta1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.4.0',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                additionalPrinterColumns: [
                    {
                        JSONPath: '.spec.serviceRef.name',
                        description: "The Kubernetes Service's name",
                        name: 'SERVICE-NAME',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.serviceRef.port',
                        description: "The Kubernetes Service's port",
                        name: 'SERVICE-PORT',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetType',
                        description: "The AWS TargetGroup's TargetType",
                        name: 'TARGET-TYPE',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetGroupARN',
                        description: "The AWS TargetGroup's Amazon Resource Name",
                        name: 'ARN',
                        priority: 1,
                        type: 'string',
                    },
                    {
                        JSONPath: '.metadata.creationTimestamp',
                        name: 'AGE',
                        type: 'date',
                    },
                ],
                group: 'elbv2.k8s.aws',
                names: {
                    categories: [
                        'all',
                    ],
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                subresources: {
                    status: {},
                },
                validation: {
                    openAPIV3Schema: {
                        description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                        properties: {
                            apiVersion: {
                                description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                type: 'string',
                            },
                            kind: {
                                description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                type: 'string',
                            },
                            metadata: {
                                type: 'object',
                            },
                            spec: {
                                description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                properties: {
                                    networking: {
                                        description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                        properties: {
                                            ingress: {
                                                description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                items: {
                                                    properties: {
                                                        from: {
                                                            description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                            items: {
                                                                description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                properties: {
                                                                    ipBlock: {
                                                                        description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            cidr: {
                                                                                description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'cidr',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                    securityGroup: {
                                                                        description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            groupID: {
                                                                                description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'groupID',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                        ports: {
                                                            description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                            items: {
                                                                properties: {
                                                                    port: {
                                                                        'anyOf': [
                                                                            {
                                                                                type: 'integer',
                                                                            },
                                                                            {
                                                                                type: 'string',
                                                                            },
                                                                        ],
                                                                        'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                        'x-kubernetes-int-or-string': true,
                                                                    },
                                                                    protocol: {
                                                                        description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                        enum: [
                                                                            'TCP',
                                                                            'UDP',
                                                                        ],
                                                                        type: 'string',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                    },
                                                    required: [
                                                        'from',
                                                        'ports',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                    serviceRef: {
                                        description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                        properties: {
                                            name: {
                                                description: 'Name is the name of the Service.',
                                                type: 'string',
                                            },
                                            port: {
                                                'anyOf': [
                                                    {
                                                        type: 'integer',
                                                    },
                                                    {
                                                        type: 'string',
                                                    },
                                                ],
                                                'description': 'Port is the port of the ServicePort.',
                                                'x-kubernetes-int-or-string': true,
                                            },
                                        },
                                        required: [
                                            'name',
                                            'port',
                                        ],
                                        type: 'object',
                                    },
                                    targetGroupARN: {
                                        description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                        type: 'string',
                                    },
                                    targetType: {
                                        description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                        enum: [
                                            'instance',
                                            'ip',
                                        ],
                                        type: 'string',
                                    },
                                },
                                required: [
                                    'serviceRef',
                                    'targetGroupARN',
                                ],
                                type: 'object',
                            },
                            status: {
                                description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                properties: {
                                    observedGeneration: {
                                        description: 'The generation observed by the TargetGroupBinding controller.',
                                        format: 'int64',
                                        type: 'integer',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        type: 'object',
                    },
                },
                version: 'v1alpha1',
                versions: [
                    {
                        name: 'v1alpha1',
                        served: true,
                        storage: false,
                    },
                    {
                        name: 'v1beta1',
                        served: true,
                        storage: true,
                    },
                ],
            },
            status: {
                acceptedNames: {
                    kind: '',
                    plural: '',
                },
                conditions: [],
                storedVersions: [],
            },
        });
        new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-v1-pod',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mpod.elbv2.k8s.aws',
                    namespaceSelector: {
                        matchExpressions: [
                            {
                                key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                operator: 'In',
                                values: ['enabled'],
                            },
                        ],
                    },
                    rules: [{
                            apiGroups: [''],
                            apiVersions: ['v1'],
                            operations: [
                                'CREATE',
                            ],
                            resources: ['pods'],
                        }],
                    sideEffects: 'None',
                },
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
        if (options.createServiceAccount === true) {
            new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new k8s.KubeClusterRole(this, 'aws-load-balancer-controller-cluster-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: ['create', 'patch'],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: ['create', 'delete', 'get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
        new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_f = options === null || options === void 0 ? void 0 : options.replicas) !== null && _f !== void 0 ? _f : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'controller',
                                image: (_g = options === null || options === void 0 ? void 0 : options.image) !== null && _g !== void 0 ? _g : 'amazon/aws-alb-ingress-controller:v2.1.3',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                                livenessProbe: {
                                    failureThreshold: 2,
                                    httpGet: {
                                        path: '/healthz',
                                        port: 61779,
                                        scheme: 'HTTP',
                                    },
                                    initialDelaySeconds: 30,
                                    timeoutSeconds: 10,
                                },
                                ports: [
                                    {
                                        containerPort: 9443,
                                        name: 'webhook-server',
                                        protocol: 'TCP',
                                    },
                                ],
                                resources: {
                                    limits: {
                                        cpu: '200m',
                                        memory: '500Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '200Mi',
                                    },
                                },
                                securityContext: {
                                    allowPrivilegeEscalation: false,
                                    readOnlyRootFilesystem: true,
                                    runAsNonRoot: true,
                                },
                                volumeMounts: [
                                    {
                                        mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                        name: 'cert',
                                        readOnly: true,
                                    },
                                ],
                            }],
                        securityContext: {
                            fsGroup: 1337,
                        },
                        serviceAccountName: `${this.serviceAccountName}`,
                        terminationGracePeriodSeconds: 10,
                        volumes: [{
                                name: 'cert',
                                secret: {
                                    defaultMode: 420,
                                    secretName: 'aws-load-balancer-webhook-tls',
                                },
                            }],
                    },
                },
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Certificate',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-serving-cert',
                namespace: this.namespace,
            },
            spec: {
                dnsNames: [
                    'aws-load-balancer-webhook-service.kube-system.svc',
                    'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                ],
                issuerRef: {
                    kind: 'Issuer',
                    name: 'aws-load-balancer-selfsigned-issuer',
                },
                secretName: 'aws-load-balancer-webhook-tls',
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Issuer',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-selfsigned-issuer',
                namespace: this.namespace,
            },
            spec: {
                selfSigned: {},
            },
        });
        new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'vtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQStCO0FBQy9CLDJDQUF1QztBQUN2QyxxQ0FBcUM7Ozs7Ozs7O0FBNEVyQyxNQUFhLHlCQUEwQixTQUFRLHNCQUFTOzs7O0lBOEJ0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE9BQXlDOztRQUNqRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxrQkFBa0IsU0FBRyxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsa0JBQWtCLG1DQUFJLDhCQUE4QixDQUFDO1FBQ3hGLElBQUksQ0FBQyxjQUFjLEdBQUcsOEJBQThCLENBQUM7UUFDckQsSUFBSSxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxTQUFTLFNBQUcsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFNBQVMsbUNBQUksYUFBYSxDQUFDO1FBQ3JELElBQUksQ0FBQyxvQkFBb0IsU0FBRyxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsb0JBQW9CLG1DQUFJLElBQUksQ0FBQztRQUNsRSxJQUFJLENBQUMsV0FBVyxTQUFHLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxXQUFXLG1DQUFJLElBQUksQ0FBQztRQUVoRCxJQUFJLElBQUksQ0FBQyxXQUFXLEtBQUssSUFBSSxFQUFFO1lBQzdCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7Z0JBQzdDLEdBQUcsRUFBRSxxRkFBcUY7YUFDM0YsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxJQUFJLEtBQUssQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLGtDQUFrQyxFQUFFO1lBQzVELFVBQVUsRUFBRSw4QkFBOEI7WUFDMUMsSUFBSSxFQUFFLDBCQUEwQjtZQUNoQyxRQUFRLEVBQUU7Z0JBQ1IsV0FBVyxFQUFFO29CQUNYLHVDQUF1QyxFQUFFLFFBQVE7aUJBQ2xEO2dCQUNELE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO2lCQUNsRDtnQkFDRCxJQUFJLEVBQUUsbUNBQW1DO2FBQzFDO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHdCQUF3QixFQUFFO29CQUN4Qjt3QkFDRSxRQUFRLEVBQUUsdUJBQXVCO3dCQUNqQyxXQUFXLEVBQUUsK0JBQStCO3dCQUM1QyxJQUFJLEVBQUUsY0FBYzt3QkFDcEIsSUFBSSxFQUFFLFFBQVE7cUJBQ2Y7b0JBQ0Q7d0JBQ0UsUUFBUSxFQUFFLHVCQUF1Qjt3QkFDakMsV0FBVyxFQUFFLCtCQUErQjt3QkFDNUMsSUFBSSxFQUFFLGNBQWM7d0JBQ3BCLElBQUksRUFBRSxRQUFRO3FCQUNmO29CQUNEO3dCQUNFLFFBQVEsRUFBRSxrQkFBa0I7d0JBQzVCLFdBQVcsRUFBRSxrQ0FBa0M7d0JBQy9DLElBQUksRUFBRSxhQUFhO3dCQUNuQixJQUFJLEVBQUUsUUFBUTtxQkFDZjtvQkFDRDt3QkFDRSxRQUFRLEVBQUUsc0JBQXNCO3dCQUNoQyxXQUFXLEVBQUUsNENBQTRDO3dCQUN6RCxJQUFJLEVBQUUsS0FBSzt3QkFDWCxRQUFRLEVBQUUsQ0FBQzt3QkFDWCxJQUFJLEVBQUUsUUFBUTtxQkFDZjtvQkFDRDt3QkFDRSxRQUFRLEVBQUUsNkJBQTZCO3dCQUN2QyxJQUFJLEVBQUUsS0FBSzt3QkFDWCxJQUFJLEVBQUUsTUFBTTtxQkFDYjtpQkFDRjtnQkFDRCxLQUFLLEVBQUUsZUFBZTtnQkFDdEIsS0FBSyxFQUFFO29CQUNMLFVBQVUsRUFBRTt3QkFDVixLQUFLO3FCQUNOO29CQUNELElBQUksRUFBRSxvQkFBb0I7b0JBQzFCLFFBQVEsRUFBRSx3QkFBd0I7b0JBQ2xDLE1BQU0sRUFBRSxxQkFBcUI7b0JBQzdCLFFBQVEsRUFBRSxvQkFBb0I7aUJBQy9CO2dCQUNELEtBQUssRUFBRSxZQUFZO2dCQUNuQixZQUFZLEVBQUU7b0JBQ1osTUFBTSxFQUFFLEVBQ1A7aUJBQ0Y7Z0JBQ0QsVUFBVSxFQUFFO29CQUNWLGVBQWUsRUFBRTt3QkFDZixXQUFXLEVBQUUsaUVBQWlFO3dCQUM5RSxVQUFVLEVBQUU7NEJBQ1YsVUFBVSxFQUFFO2dDQUNWLFdBQVcsRUFBRSxtU0FBbVM7Z0NBQ2hULElBQUksRUFBRSxRQUFROzZCQUNmOzRCQUNELElBQUksRUFBRTtnQ0FDSixXQUFXLEVBQUUsb1NBQW9TO2dDQUNqVCxJQUFJLEVBQUUsUUFBUTs2QkFDZjs0QkFDRCxRQUFRLEVBQUU7Z0NBQ1IsSUFBSSxFQUFFLFFBQVE7NkJBQ2Y7NEJBQ0QsSUFBSSxFQUFFO2dDQUNKLFdBQVcsRUFBRSx3RUFBd0U7Z0NBQ3JGLFVBQVUsRUFBRTtvQ0FDVixVQUFVLEVBQUU7d0NBQ1YsV0FBVyxFQUFFLG1HQUFtRzt3Q0FDaEgsVUFBVSxFQUFFOzRDQUNWLE9BQU8sRUFBRTtnREFDUCxXQUFXLEVBQUUscUZBQXFGO2dEQUNsRyxLQUFLLEVBQUU7b0RBQ0wsVUFBVSxFQUFFO3dEQUNWLElBQUksRUFBRTs0REFDSixXQUFXLEVBQUUsMkhBQTJIOzREQUN4SSxLQUFLLEVBQUU7Z0VBQ0wsV0FBVyxFQUFFLDBFQUEwRTtnRUFDdkYsVUFBVSxFQUFFO29FQUNWLE9BQU8sRUFBRTt3RUFDUCxXQUFXLEVBQUUscUZBQXFGO3dFQUNsRyxVQUFVLEVBQUU7NEVBQ1YsSUFBSSxFQUFFO2dGQUNKLFdBQVcsRUFBRSxnRUFBZ0U7Z0ZBQzdFLElBQUksRUFBRSxRQUFROzZFQUNmO3lFQUNGO3dFQUNELFFBQVEsRUFBRTs0RUFDUixNQUFNO3lFQUNQO3dFQUNELElBQUksRUFBRSxRQUFRO3FFQUNmO29FQUNELGFBQWEsRUFBRTt3RUFDYixXQUFXLEVBQUUsZ0dBQWdHO3dFQUM3RyxVQUFVLEVBQUU7NEVBQ1YsT0FBTyxFQUFFO2dGQUNQLFdBQVcsRUFBRSxxQ0FBcUM7Z0ZBQ2xELElBQUksRUFBRSxRQUFROzZFQUNmO3lFQUNGO3dFQUNELFFBQVEsRUFBRTs0RUFDUixTQUFTO3lFQUNWO3dFQUNELElBQUksRUFBRSxRQUFRO3FFQUNmO2lFQUNGO2dFQUNELElBQUksRUFBRSxRQUFROzZEQUNmOzREQUNELElBQUksRUFBRSxPQUFPO3lEQUNkO3dEQUNELEtBQUssRUFBRTs0REFDTCxXQUFXLEVBQUUsbUpBQW1KOzREQUNoSyxLQUFLLEVBQUU7Z0VBQ0wsVUFBVSxFQUFFO29FQUNWLElBQUksRUFBRTt3RUFDSixPQUFPLEVBQUU7NEVBQ1A7Z0ZBQ0UsSUFBSSxFQUFFLFNBQVM7NkVBQ2hCOzRFQUNEO2dGQUNFLElBQUksRUFBRSxRQUFROzZFQUNmO3lFQUNGO3dFQUNELGFBQWEsRUFBRSwyUUFBMlE7d0VBQzFSLDRCQUE0QixFQUFFLElBQUk7cUVBQ25DO29FQUNELFFBQVEsRUFBRTt3RUFDUixXQUFXLEVBQUUsd0ZBQXdGO3dFQUNyRyxJQUFJLEVBQUU7NEVBQ0osS0FBSzs0RUFDTCxLQUFLO3lFQUNOO3dFQUNELElBQUksRUFBRSxRQUFRO3FFQUNmO2lFQUNGO2dFQUNELElBQUksRUFBRSxRQUFROzZEQUNmOzREQUNELElBQUksRUFBRSxPQUFPO3lEQUNkO3FEQUNGO29EQUNELFFBQVEsRUFBRTt3REFDUixNQUFNO3dEQUNOLE9BQU87cURBQ1I7b0RBQ0QsSUFBSSxFQUFFLFFBQVE7aURBQ2Y7Z0RBQ0QsSUFBSSxFQUFFLE9BQU87NkNBQ2Q7eUNBQ0Y7d0NBQ0QsSUFBSSxFQUFFLFFBQVE7cUNBQ2Y7b0NBQ0QsVUFBVSxFQUFFO3dDQUNWLFdBQVcsRUFBRSxvRUFBb0U7d0NBQ2pGLFVBQVUsRUFBRTs0Q0FDVixJQUFJLEVBQUU7Z0RBQ0osV0FBVyxFQUFFLGtDQUFrQztnREFDL0MsSUFBSSxFQUFFLFFBQVE7NkNBQ2Y7NENBQ0QsSUFBSSxFQUFFO2dEQUNKLE9BQU8sRUFBRTtvREFDUDt3REFDRSxJQUFJLEVBQUUsU0FBUztxREFDaEI7b0RBQ0Q7d0RBQ0UsSUFBSSxFQUFFLFFBQVE7cURBQ2Y7aURBQ0Y7Z0RBQ0QsYUFBYSxFQUFFLHNDQUFzQztnREFDckQsNEJBQTRCLEVBQUUsSUFBSTs2Q0FDbkM7eUNBQ0Y7d0NBQ0QsUUFBUSxFQUFFOzRDQUNSLE1BQU07NENBQ04sTUFBTTt5Q0FDUDt3Q0FDRCxJQUFJLEVBQUUsUUFBUTtxQ0FDZjtvQ0FDRCxjQUFjLEVBQUU7d0NBQ2QsV0FBVyxFQUFFLHVFQUF1RTt3Q0FDcEYsSUFBSSxFQUFFLFFBQVE7cUNBQ2Y7b0NBQ0QsVUFBVSxFQUFFO3dDQUNWLFdBQVcsRUFBRSxpR0FBaUc7d0NBQzlHLElBQUksRUFBRTs0Q0FDSixVQUFVOzRDQUNWLElBQUk7eUNBQ0w7d0NBQ0QsSUFBSSxFQUFFLFFBQVE7cUNBQ2Y7aUNBQ0Y7Z0NBQ0QsUUFBUSxFQUFFO29DQUNSLFlBQVk7b0NBQ1osZ0JBQWdCO2lDQUNqQjtnQ0FDRCxJQUFJLEVBQUUsUUFBUTs2QkFDZjs0QkFDRCxNQUFNLEVBQUU7Z0NBQ04sV0FBVyxFQUFFLDJFQUEyRTtnQ0FDeEYsVUFBVSxFQUFFO29DQUNWLGtCQUFrQixFQUFFO3dDQUNsQixXQUFXLEVBQUUsK0RBQStEO3dDQUM1RSxNQUFNLEVBQUUsT0FBTzt3Q0FDZixJQUFJLEVBQUUsU0FBUztxQ0FDaEI7aUNBQ0Y7Z0NBQ0QsSUFBSSxFQUFFLFFBQVE7NkJBQ2Y7eUJBQ0Y7d0JBQ0QsSUFBSSxFQUFFLFFBQVE7cUJBQ2Y7aUJBQ0Y7Z0JBQ0QsT0FBTyxFQUFFLFVBQVU7Z0JBQ25CLFFBQVEsRUFBRTtvQkFDUjt3QkFDRSxJQUFJLEVBQUUsVUFBVTt3QkFDaEIsTUFBTSxFQUFFLElBQUk7d0JBQ1osT0FBTyxFQUFFLEtBQUs7cUJBQ2Y7b0JBQ0Q7d0JBQ0UsSUFBSSxFQUFFLFNBQVM7d0JBQ2YsTUFBTSxFQUFFLElBQUk7d0JBQ1osT0FBTyxFQUFFLElBQUk7cUJBQ2Q7aUJBQ0Y7YUFDRjtZQUNELE1BQU0sRUFBRTtnQkFDTixhQUFhLEVBQUU7b0JBQ2IsSUFBSSxFQUFFLEVBQUU7b0JBQ1IsTUFBTSxFQUFFLEVBQUU7aUJBQ1g7Z0JBQ0QsVUFBVSxFQUFFLEVBQUU7Z0JBQ2QsY0FBYyxFQUFFLEVBQUU7YUFDbkI7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQyx1Q0FBdUMsQ0FBQyxJQUFJLEVBQUUsMkJBQTJCLEVBQUU7WUFDakYsUUFBUSxFQUFFO2dCQUNSLFdBQVcsRUFBRTtvQkFDWCxnQ0FBZ0MsRUFBRSw0Q0FBNEM7aUJBQy9FO2dCQUNELE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUsMkJBQTJCO2FBQ2xDO1lBQ0QsUUFBUSxFQUFFO2dCQUNSO29CQUNFLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUUsTUFBTTt3QkFDaEIsT0FBTyxFQUFFOzRCQUNQLElBQUksRUFBRSxtQ0FBbUM7NEJBQ3pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzs0QkFDekIsSUFBSSxFQUFFLGdCQUFnQjt5QkFDdkI7cUJBQ0Y7b0JBQ0QsYUFBYSxFQUFFLE1BQU07b0JBQ3JCLElBQUksRUFBRSxvQkFBb0I7b0JBQzFCLGlCQUFpQixFQUFFO3dCQUNqQixnQkFBZ0IsRUFBRTs0QkFDaEI7Z0NBQ0UsR0FBRyxFQUFFLHlDQUF5QztnQ0FDOUMsUUFBUSxFQUFFLElBQUk7Z0NBQ2QsTUFBTSxFQUFFLENBQUMsU0FBUyxDQUFDOzZCQUNwQjt5QkFDRjtxQkFDRjtvQkFDRCxLQUFLLEVBQUUsQ0FBQzs0QkFDTixTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7NEJBQ2YsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDOzRCQUNuQixVQUFVLEVBQUU7Z0NBQ1YsUUFBUTs2QkFDVDs0QkFDRCxTQUFTLEVBQUUsQ0FBQyxNQUFNLENBQUM7eUJBQ3BCLENBQUM7b0JBQ0YsV0FBVyxFQUFFLE1BQU07aUJBQ3BCO2dCQUNEO29CQUNFLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUUsTUFBTTt3QkFDaEIsT0FBTyxFQUFFOzRCQUNQLElBQUksRUFBRSxtQ0FBbUM7NEJBQ3pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzs0QkFDekIsSUFBSSxFQUFFLGtEQUFrRDt5QkFDekQ7cUJBQ0Y7b0JBQ0QsYUFBYSxFQUFFLE1BQU07b0JBQ3JCLElBQUksRUFBRSxtQ0FBbUM7b0JBQ3pDLEtBQUssRUFBRSxDQUFDOzRCQUNOLFNBQVMsRUFBRSxDQUFDLGVBQWUsQ0FBQzs0QkFDNUIsV0FBVyxFQUFFLENBQUMsU0FBUyxDQUFDOzRCQUN4QixVQUFVLEVBQUU7Z0NBQ1YsUUFBUTtnQ0FDUixRQUFROzZCQUNUOzRCQUNELFNBQVMsRUFBRSxDQUFDLHFCQUFxQixDQUFDO3lCQUNuQyxDQUFDO29CQUNGLFdBQVcsRUFBRSxNQUFNO2lCQUNwQjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxPQUFPLENBQUMsb0JBQW9CLEtBQUssSUFBSSxFQUFFO1lBQ3pDLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxpQ0FBaUMsRUFBRTtnQkFDbEUsUUFBUSxFQUFFO29CQUNSLE1BQU0sRUFBRTt3QkFDTiw2QkFBNkIsRUFBRSxZQUFZO3dCQUMzQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO3dCQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO3FCQUNsQjtvQkFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtvQkFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO2lCQUMxQjthQUNGLENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxHQUFHLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxtREFBbUQsRUFBRTtZQUMxRSxRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSxtREFBbUQ7Z0JBQ3pELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzthQUMxQjtZQUNELEtBQUssRUFBRTtnQkFDTDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsWUFBWSxDQUFDO29CQUN6QixLQUFLLEVBQUUsQ0FBQyxRQUFRLENBQUM7aUJBQ2xCLEVBQUU7b0JBQ0QsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFlBQVksQ0FBQztvQkFDekIsYUFBYSxFQUFFLENBQUMscUNBQXFDLENBQUM7b0JBQ3RELEtBQUssRUFBRSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsT0FBTyxDQUFDO2lCQUNsQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSwyQ0FBMkMsRUFBRTtZQUN6RSxRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsT0FBTzthQUN4QztZQUNELEtBQUssRUFBRTtnQkFDTDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDO29CQUN4QixLQUFLLEVBQUUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLE9BQU8sQ0FBQztpQkFDaEM7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFFBQVEsQ0FBQztvQkFDckIsS0FBSyxFQUFFLENBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQztpQkFDM0I7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFlBQVksQ0FBQztvQkFDekIsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUM7aUJBQ2hDO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxPQUFPLENBQUM7b0JBQ3BCLEtBQUssRUFBRSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsT0FBTyxDQUFDO2lCQUNoQztnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQ2YsU0FBUyxFQUFFLENBQUMsTUFBTSxDQUFDO29CQUNuQixLQUFLLEVBQUUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLE9BQU8sQ0FBQztpQkFDaEM7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLGFBQWEsQ0FBQztvQkFDMUIsS0FBSyxFQUFFLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQztpQkFDM0I7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsRUFBRSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLFNBQVMsQ0FBQztvQkFDdEIsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUM7aUJBQ2hDO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxVQUFVLENBQUM7b0JBQ3ZCLEtBQUssRUFBRSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxPQUFPLENBQUM7aUJBQ25EO2dCQUNEO29CQUNFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDZixTQUFTLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQztvQkFDOUIsS0FBSyxFQUFFLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQztpQkFDM0I7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsZUFBZSxDQUFDO29CQUM1QixTQUFTLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQztvQkFDbEMsS0FBSyxFQUFFLENBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLE9BQU8sRUFBRSxRQUFRLEVBQUUsT0FBTyxDQUFDO2lCQUN2RTtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxlQUFlLENBQUM7b0JBQzVCLFNBQVMsRUFBRSxDQUFDLDRCQUE0QixDQUFDO29CQUN6QyxLQUFLLEVBQUUsQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDO2lCQUMzQjtnQkFDRDtvQkFDRSxTQUFTLEVBQUUsQ0FBQyxZQUFZLENBQUM7b0JBQ3pCLFNBQVMsRUFBRSxDQUFDLFdBQVcsQ0FBQztvQkFDeEIsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQztpQkFDbkQ7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsWUFBWSxDQUFDO29CQUN6QixTQUFTLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQztvQkFDL0IsS0FBSyxFQUFFLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQztpQkFDM0I7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsbUJBQW1CLENBQUM7b0JBQ2hDLFNBQVMsRUFBRSxDQUFDLFdBQVcsQ0FBQztvQkFDeEIsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQztpQkFDbkQ7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsbUJBQW1CLENBQUM7b0JBQ2hDLFNBQVMsRUFBRSxDQUFDLGdCQUFnQixDQUFDO29CQUM3QixLQUFLLEVBQUUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLE9BQU8sQ0FBQztpQkFDaEM7Z0JBQ0Q7b0JBQ0UsU0FBUyxFQUFFLENBQUMsbUJBQW1CLENBQUM7b0JBQ2hDLFNBQVMsRUFBRSxDQUFDLGtCQUFrQixDQUFDO29CQUMvQixLQUFLLEVBQUUsQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDO2lCQUMzQjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSwwREFBMEQsRUFBRTtZQUN4RixRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSwwREFBMEQ7Z0JBQ2hFLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzthQUMxQjtZQUNELE9BQU8sRUFBRTtnQkFDUCxRQUFRLEVBQUUsMkJBQTJCO2dCQUNyQyxJQUFJLEVBQUUsTUFBTTtnQkFDWixJQUFJLEVBQUUsbURBQW1EO2FBQzFEO1lBQ0QsUUFBUSxFQUFFO2dCQUNSO29CQUNFLElBQUksRUFBRSxnQkFBZ0I7b0JBQ3RCLElBQUksRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUM3QixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7aUJBQzFCO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLEVBQUUsMENBQTBDLEVBQUU7WUFDL0UsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUsMENBQTBDO2FBQ2pEO1lBQ0QsT0FBTyxFQUFFO2dCQUNQLFFBQVEsRUFBRSwyQkFBMkI7Z0JBQ3JDLElBQUksRUFBRSxhQUFhO2dCQUNuQixJQUFJLEVBQUUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLE9BQU87YUFDeEM7WUFDRCxRQUFRLEVBQUU7Z0JBQ1I7b0JBQ0UsSUFBSSxFQUFFLGdCQUFnQjtvQkFDdEIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO29CQUN6QixJQUFJLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtpQkFDOUI7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsbUNBQW1DLEVBQUU7WUFDN0QsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUsbUNBQW1DO2dCQUN6QyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7YUFDMUI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFO29CQUNMO3dCQUNFLElBQUksRUFBRSxHQUFHO3dCQUNULFVBQVUsRUFBRSxJQUFJO3FCQUNqQjtpQkFDRjtnQkFDRCxRQUFRLEVBQUU7b0JBQ1IsNkJBQTZCLEVBQUUsWUFBWTtvQkFDM0Msd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtpQkFDbEQ7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUseUNBQXlDLEVBQUU7WUFDdEUsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTiw2QkFBNkIsRUFBRSxZQUFZO29CQUMzQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7Z0JBQ3pCLElBQUksRUFBRSxJQUFJLENBQUMsY0FBYzthQUMxQjtZQUNELElBQUksRUFBRTtnQkFDSixRQUFRLFFBQUUsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFFBQVEsbUNBQUksQ0FBQztnQkFDaEMsUUFBUSxFQUFFO29CQUNSLFdBQVcsRUFBRTt3QkFDWCw2QkFBNkIsRUFBRSxZQUFZO3dCQUMzQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO3dCQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO3FCQUNsQjtpQkFDRjtnQkFDRCxRQUFRLEVBQUU7b0JBQ1IsUUFBUSxFQUFFO3dCQUNSLE1BQU0sRUFBRTs0QkFDTiw2QkFBNkIsRUFBRSxZQUFZOzRCQUMzQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCOzRCQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO3lCQUNsQjtxQkFDRjtvQkFDRCxJQUFJLEVBQUU7d0JBQ0osVUFBVSxFQUFFLENBQUM7Z0NBQ1gsSUFBSSxFQUFFLFlBQVk7Z0NBQ2xCLEtBQUssUUFBRSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsS0FBSyxtQ0FBSSwwQ0FBMEM7Z0NBQ25FLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUM7Z0NBQ2pDLEdBQUcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUM7Z0NBQzlCLGFBQWEsRUFBRTtvQ0FDYixnQkFBZ0IsRUFBRSxDQUFDO29DQUNuQixPQUFPLEVBQUU7d0NBQ1AsSUFBSSxFQUFFLFVBQVU7d0NBQ2hCLElBQUksRUFBRSxLQUFLO3dDQUNYLE1BQU0sRUFBRSxNQUFNO3FDQUNmO29DQUNELG1CQUFtQixFQUFFLEVBQUU7b0NBQ3ZCLGNBQWMsRUFBRSxFQUFFO2lDQUNuQjtnQ0FDRCxLQUFLLEVBQUU7b0NBQ0w7d0NBQ0UsYUFBYSxFQUFFLElBQUk7d0NBQ25CLElBQUksRUFBRSxnQkFBZ0I7d0NBQ3RCLFFBQVEsRUFBRSxLQUFLO3FDQUNoQjtpQ0FDRjtnQ0FDRCxTQUFTLEVBQUU7b0NBQ1QsTUFBTSxFQUFFO3dDQUNOLEdBQUcsRUFBRSxNQUFNO3dDQUNYLE1BQU0sRUFBRSxPQUFPO3FDQUNoQjtvQ0FDRCxRQUFRLEVBQUU7d0NBQ1IsR0FBRyxFQUFFLE1BQU07d0NBQ1gsTUFBTSxFQUFFLE9BQU87cUNBQ2hCO2lDQUNGO2dDQUNELGVBQWUsRUFBRTtvQ0FDZix3QkFBd0IsRUFBRSxLQUFLO29DQUMvQixzQkFBc0IsRUFBRSxJQUFJO29DQUM1QixZQUFZLEVBQUUsSUFBSTtpQ0FDbkI7Z0NBQ0QsWUFBWSxFQUFFO29DQUNaO3dDQUNFLFNBQVMsRUFBRSx1Q0FBdUM7d0NBQ2xELElBQUksRUFBRSxNQUFNO3dDQUNaLFFBQVEsRUFBRSxJQUFJO3FDQUNmO2lDQUNGOzZCQUNGLENBQUM7d0JBQ0YsZUFBZSxFQUFFOzRCQUNmLE9BQU8sRUFBRSxJQUFJO3lCQUNkO3dCQUNELGtCQUFrQixFQUFFLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixFQUFFO3dCQUNoRCw2QkFBNkIsRUFBRSxFQUFFO3dCQUNqQyxPQUFPLEVBQUUsQ0FBQztnQ0FDUixJQUFJLEVBQUUsTUFBTTtnQ0FDWixNQUFNLEVBQUU7b0NBQ04sV0FBVyxFQUFFLEdBQUc7b0NBQ2hCLFVBQVUsRUFBRSwrQkFBK0I7aUNBQzVDOzZCQUNGLENBQUM7cUJBQ0g7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsZ0NBQWdDLEVBQUU7WUFDMUQsVUFBVSxFQUFFLDBCQUEwQjtZQUN0QyxJQUFJLEVBQUUsYUFBYTtZQUNuQixRQUFRLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSxnQ0FBZ0M7Z0JBQ3RDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUzthQUMxQjtZQUNELElBQUksRUFBRTtnQkFDSixRQUFRLEVBQUU7b0JBQ1IsbURBQW1EO29CQUNuRCxpRUFBaUU7aUJBQ2xFO2dCQUNELFNBQVMsRUFBRTtvQkFDVCxJQUFJLEVBQUUsUUFBUTtvQkFDZCxJQUFJLEVBQUUscUNBQXFDO2lCQUM1QztnQkFDRCxVQUFVLEVBQUUsK0JBQStCO2FBQzVDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxxQ0FBcUMsRUFBRTtZQUMvRCxVQUFVLEVBQUUsMEJBQTBCO1lBQ3RDLElBQUksRUFBRSxRQUFRO1lBQ2QsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO29CQUNqRCxHQUFHLE9BQU8sQ0FBQyxNQUFNO2lCQUNsQjtnQkFDRCxJQUFJLEVBQUUscUNBQXFDO2dCQUMzQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7YUFDMUI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osVUFBVSxFQUFFLEVBQUU7YUFDZjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLHlDQUF5QyxDQUFDLElBQUksRUFBRSwyQ0FBMkMsRUFBRTtZQUNuRyxRQUFRLEVBQUU7Z0JBQ1IsV0FBVyxFQUFFO29CQUNYLGdDQUFnQyxFQUFFLDRDQUE0QztpQkFDL0U7Z0JBQ0QsTUFBTSxFQUFFO29CQUNOLHdCQUF3QixFQUFFLElBQUksQ0FBQyxrQkFBa0I7b0JBQ2pELEdBQUcsT0FBTyxDQUFDLE1BQU07aUJBQ2xCO2dCQUNELElBQUksRUFBRSwyQkFBMkI7YUFDbEM7WUFDRCxRQUFRLEVBQUU7Z0JBQ1I7b0JBQ0UsWUFBWSxFQUFFO3dCQUNaLFFBQVEsRUFBRSxNQUFNO3dCQUNoQixPQUFPLEVBQUU7NEJBQ1AsSUFBSSxFQUFFLG1DQUFtQzs0QkFDekMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTOzRCQUN6QixJQUFJLEVBQUUsb0RBQW9EO3lCQUMzRDtxQkFDRjtvQkFDRCxhQUFhLEVBQUUsTUFBTTtvQkFDckIsSUFBSSxFQUFFLG1DQUFtQztvQkFDekMsS0FBSyxFQUFFLENBQUM7NEJBQ04sU0FBUyxFQUFFLENBQUMsZUFBZSxDQUFDOzRCQUM1QixXQUFXLEVBQUUsQ0FBQyxTQUFTLENBQUM7NEJBQ3hCLFVBQVUsRUFBRTtnQ0FDVixRQUFRO2dDQUNSLFFBQVE7NkJBQ1Q7NEJBQ0QsU0FBUyxFQUFFLENBQUMscUJBQXFCLENBQUM7eUJBQ25DLENBQUM7b0JBQ0YsV0FBVyxFQUFFLE1BQU07aUJBQ3BCO2FBQ0Y7U0FDRixDQUFDLENBQUM7SUFFTCxDQUFDO0lBQ08sUUFBUSxDQUFDLElBQWU7UUFDOUIsTUFBTSxXQUFXLEdBQUcsQ0FBQyxxQkFBcUIsRUFBRSxrQkFBa0IsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDbEYsSUFBSSxJQUFJLEVBQUU7WUFDUixJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3hDO1FBQ0QsT0FBTyxXQUFXLENBQUM7SUFDckIsQ0FBQztJQUNPLE9BQU8sQ0FBQyxNQUE2QjtRQUMzQyxPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDOztBQTN0QkgsOERBNHRCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkazhzIGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgazhzIGZyb20gJy4vaW1wb3J0cy9rOHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEVudlZhciB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZhbHVlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2VydE1hbmFnZXI/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsYWJlbHM/OiB7IFtuYW1lOiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuYW1lc3BhY2U/OiBzdHJpbmcgO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZyA7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjcmVhdGVTZXJ2aWNlQWNjb3VudD86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZXJ2aWNlQWNjb3VudE5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGltYWdlPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFyZ3M/OiBzdHJpbmdbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbnY/OiBFbnZWYXJbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlcGxpY2FzPzogbnVtYmVyO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXdzTG9hZEJhbGFuY2VyQ29udHJvbGxlciBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNlcnRNYW5hZ2VyPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjcmVhdGVTZXJ2aWNlQWNjb3VudD86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZUFjY291bnROYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkZXBsb3ltZW50TmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbmFtZXNwYWNlOiBzdHJpbmcgO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBvcHRpb25zOiBBd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyT3B0aW9ucykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUgPSBvcHRpb25zPy5zZXJ2aWNlQWNjb3VudE5hbWUgPz8gJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXInO1xuICAgIHRoaXMuZGVwbG95bWVudE5hbWUgPSAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlcic7XG4gICAgdGhpcy5jbHVzdGVyTmFtZSA9IG9wdGlvbnMuY2x1c3Rlck5hbWU7XG4gICAgdGhpcy5uYW1lc3BhY2UgPSBvcHRpb25zPy5uYW1lc3BhY2UgPz8gJ2t1YmUtc3lzdGVtJztcbiAgICB0aGlzLmNyZWF0ZVNlcnZpY2VBY2NvdW50ID0gb3B0aW9ucz8uY3JlYXRlU2VydmljZUFjY291bnQgPz8gdHJ1ZTtcbiAgICB0aGlzLmNlcnRNYW5hZ2VyID0gb3B0aW9ucz8uY2VydE1hbmFnZXIgPz8gdHJ1ZTtcblxuICAgIGlmICh0aGlzLmNlcnRNYW5hZ2VyID09PSB0cnVlKSB7XG4gICAgICBuZXcgY2RrOHMuSW5jbHVkZSh0aGlzLCAnY2VydGlmaWNhdGUtbWFuYWdlcicsIHtcbiAgICAgICAgdXJsOiAnaHR0cHM6Ly9naXRodWIuY29tL2pldHN0YWNrL2NlcnQtbWFuYWdlci9yZWxlYXNlcy9kb3dubG9hZC92MS4xLjEvY2VydC1tYW5hZ2VyLnlhbWwnLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgbmV3IGNkazhzLkFwaU9iamVjdCh0aGlzLCAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1jcmQnLCB7XG4gICAgICBhcGlWZXJzaW9uOiAnYXBpZXh0ZW5zaW9ucy5rOHMuaW8vdjFiZXRhMScsXG4gICAgICBraW5kOiAnQ3VzdG9tUmVzb3VyY2VEZWZpbml0aW9uJyxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIGFubm90YXRpb25zOiB7XG4gICAgICAgICAgJ2NvbnRyb2xsZXItZ2VuLmt1YmVidWlsZGVyLmlvL3ZlcnNpb24nOiAndjAuNC4wJyxcbiAgICAgICAgfSxcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ3RhcmdldGdyb3VwYmluZGluZ3MuZWxidjIuazhzLmF3cycsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBhZGRpdGlvbmFsUHJpbnRlckNvbHVtbnM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBKU09OUGF0aDogJy5zcGVjLnNlcnZpY2VSZWYubmFtZScsXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogXCJUaGUgS3ViZXJuZXRlcyBTZXJ2aWNlJ3MgbmFtZVwiLFxuICAgICAgICAgICAgbmFtZTogJ1NFUlZJQ0UtTkFNRScsXG4gICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHtcbiAgICAgICAgICAgIEpTT05QYXRoOiAnLnNwZWMuc2VydmljZVJlZi5wb3J0JyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBcIlRoZSBLdWJlcm5ldGVzIFNlcnZpY2UncyBwb3J0XCIsXG4gICAgICAgICAgICBuYW1lOiAnU0VSVklDRS1QT1JUJyxcbiAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAge1xuICAgICAgICAgICAgSlNPTlBhdGg6ICcuc3BlYy50YXJnZXRUeXBlJyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBcIlRoZSBBV1MgVGFyZ2V0R3JvdXAncyBUYXJnZXRUeXBlXCIsXG4gICAgICAgICAgICBuYW1lOiAnVEFSR0VULVRZUEUnLFxuICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgfSxcbiAgICAgICAgICB7XG4gICAgICAgICAgICBKU09OUGF0aDogJy5zcGVjLnRhcmdldEdyb3VwQVJOJyxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBcIlRoZSBBV1MgVGFyZ2V0R3JvdXAncyBBbWF6b24gUmVzb3VyY2UgTmFtZVwiLFxuICAgICAgICAgICAgbmFtZTogJ0FSTicsXG4gICAgICAgICAgICBwcmlvcml0eTogMSxcbiAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAge1xuICAgICAgICAgICAgSlNPTlBhdGg6ICcubWV0YWRhdGEuY3JlYXRpb25UaW1lc3RhbXAnLFxuICAgICAgICAgICAgbmFtZTogJ0FHRScsXG4gICAgICAgICAgICB0eXBlOiAnZGF0ZScsXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgZ3JvdXA6ICdlbGJ2Mi5rOHMuYXdzJyxcbiAgICAgICAgbmFtZXM6IHtcbiAgICAgICAgICBjYXRlZ29yaWVzOiBbXG4gICAgICAgICAgICAnYWxsJyxcbiAgICAgICAgICBdLFxuICAgICAgICAgIGtpbmQ6ICdUYXJnZXRHcm91cEJpbmRpbmcnLFxuICAgICAgICAgIGxpc3RLaW5kOiAnVGFyZ2V0R3JvdXBCaW5kaW5nTGlzdCcsXG4gICAgICAgICAgcGx1cmFsOiAndGFyZ2V0Z3JvdXBiaW5kaW5ncycsXG4gICAgICAgICAgc2luZ3VsYXI6ICd0YXJnZXRncm91cGJpbmRpbmcnLFxuICAgICAgICB9LFxuICAgICAgICBzY29wZTogJ05hbWVzcGFjZWQnLFxuICAgICAgICBzdWJyZXNvdXJjZXM6IHtcbiAgICAgICAgICBzdGF0dXM6IHtcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgICB2YWxpZGF0aW9uOiB7XG4gICAgICAgICAgb3BlbkFQSVYzU2NoZW1hOiB7XG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogJ1RhcmdldEdyb3VwQmluZGluZyBpcyB0aGUgU2NoZW1hIGZvciB0aGUgVGFyZ2V0R3JvdXBCaW5kaW5nIEFQSScsXG4gICAgICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgICAgIGFwaVZlcnNpb246IHtcbiAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ0FQSVZlcnNpb24gZGVmaW5lcyB0aGUgdmVyc2lvbmVkIHNjaGVtYSBvZiB0aGlzIHJlcHJlc2VudGF0aW9uIG9mIGFuIG9iamVjdC4gU2VydmVycyBzaG91bGQgY29udmVydCByZWNvZ25pemVkIHNjaGVtYXMgdG8gdGhlIGxhdGVzdCBpbnRlcm5hbCB2YWx1ZSwgYW5kIG1heSByZWplY3QgdW5yZWNvZ25pemVkIHZhbHVlcy4gTW9yZSBpbmZvOiBodHRwczovL2dpdC5rOHMuaW8vY29tbXVuaXR5L2NvbnRyaWJ1dG9ycy9kZXZlbC9zaWctYXJjaGl0ZWN0dXJlL2FwaS1jb252ZW50aW9ucy5tZCNyZXNvdXJjZXMnLFxuICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBraW5kOiB7XG4gICAgICAgICAgICAgICAgZGVzY3JpcHRpb246ICdLaW5kIGlzIGEgc3RyaW5nIHZhbHVlIHJlcHJlc2VudGluZyB0aGUgUkVTVCByZXNvdXJjZSB0aGlzIG9iamVjdCByZXByZXNlbnRzLiBTZXJ2ZXJzIG1heSBpbmZlciB0aGlzIGZyb20gdGhlIGVuZHBvaW50IHRoZSBjbGllbnQgc3VibWl0cyByZXF1ZXN0cyB0by4gQ2Fubm90IGJlIHVwZGF0ZWQuIEluIENhbWVsQ2FzZS4gTW9yZSBpbmZvOiBodHRwczovL2dpdC5rOHMuaW8vY29tbXVuaXR5L2NvbnRyaWJ1dG9ycy9kZXZlbC9zaWctYXJjaGl0ZWN0dXJlL2FwaS1jb252ZW50aW9ucy5tZCN0eXBlcy1raW5kcycsXG4gICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgICAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHNwZWM6IHtcbiAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ1RhcmdldEdyb3VwQmluZGluZ1NwZWMgZGVmaW5lcyB0aGUgZGVzaXJlZCBzdGF0ZSBvZiBUYXJnZXRHcm91cEJpbmRpbmcnLFxuICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAgIG5ldHdvcmtpbmc6IHtcbiAgICAgICAgICAgICAgICAgICAgZGVzY3JpcHRpb246ICduZXR3b3JraW5nIHByb3ZpZGVzIHRoZSBuZXR3b3JraW5nIHNldHVwIGZvciBFTEJWMiBMb2FkQmFsYW5jZXIgdG8gYWNjZXNzIHRhcmdldHMgaW4gVGFyZ2V0R3JvdXAuJyxcbiAgICAgICAgICAgICAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgICAgICAgICAgICAgIGluZ3Jlc3M6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnTGlzdCBvZiBpbmdyZXNzIHJ1bGVzIHRvIGFsbG93IEVMQlYyIExvYWRCYWxhbmNlciB0byBhY2Nlc3MgdGFyZ2V0cyBpbiBUYXJnZXRHcm91cC4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgaXRlbXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZyb206IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnTGlzdCBvZiBwZWVycyB3aGljaCBzaG91bGQgYmUgYWJsZSB0byBhY2Nlc3MgdGhlIHRhcmdldHMgaW4gVGFyZ2V0R3JvdXAuIEF0IGxlYXN0IG9uZSBOZXR3b3JraW5nUGVlciBzaG91bGQgYmUgc3BlY2lmaWVkLicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpdGVtczoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ05ldHdvcmtpbmdQZWVyIGRlZmluZXMgdGhlIHNvdXJjZS9kZXN0aW5hdGlvbiBwZWVyIGZvciBuZXR3b3JraW5nIHJ1bGVzLicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpcEJsb2NrOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ0lQQmxvY2sgZGVmaW5lcyBhbiBJUEJsb2NrIHBlZXIuIElmIHNwZWNpZmllZCwgbm9uZSBvZiB0aGUgb3RoZXIgZmllbGRzIGNhbiBiZSBzZXQuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY2lkcjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnQ0lEUiBpcyB0aGUgbmV0d29yayBDSURSLiBCb3RoIElQVjQgb3IgSVBWNiBDSURSIGFyZSBhY2NlcHRlZC4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlcXVpcmVkOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdjaWRyJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHNlY3VyaXR5R3JvdXA6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAnU2VjdXJpdHlHcm91cCBkZWZpbmVzIGEgU2VjdXJpdHlHcm91cCBwZWVyLiBJZiBzcGVjaWZpZWQsIG5vbmUgb2YgdGhlIG90aGVyIGZpZWxkcyBjYW4gYmUgc2V0LicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGdyb3VwSUQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ0dyb3VwSUQgaXMgdGhlIEVDMiBTZWN1cml0eUdyb3VwSUQuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXF1aXJlZDogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAnZ3JvdXBJRCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ2FycmF5JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBvcnRzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ0xpc3Qgb2YgcG9ydHMgd2hpY2ggc2hvdWxkIGJlIG1hZGUgYWNjZXNzaWJsZSBvbiB0aGUgdGFyZ2V0cyBpbiBUYXJnZXRHcm91cC4gSWYgcG9ydHMgaXMgZW1wdHkgb3IgdW5zcGVjaWZpZWQsIGl0IGRlZmF1bHRzIHRvIGFsbCBwb3J0cyB3aXRoIFRDUC4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaXRlbXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBvcnQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdhbnlPZic6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdpbnRlZ2VyJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdkZXNjcmlwdGlvbic6ICdUaGUgcG9ydCB3aGljaCB0cmFmZmljIG11c3QgbWF0Y2guIFdoZW4gTm9kZVBvcnQgZW5kcG9pbnRzKGluc3RhbmNlIFRhcmdldFR5cGUpIGlzIHVzZWQsIHRoaXMgbXVzdCBiZSBhIG51bWVyaWNhbCBwb3J0LiBXaGVuIFBvcnQgZW5kcG9pbnRzKGlwIFRhcmdldFR5cGUpIGlzIHVzZWQsIHRoaXMgY2FuIGJlIGVpdGhlciBudW1lcmljYWwgb3IgbmFtZWQgcG9ydCBvbiBwb2RzLiBpZiBwb3J0IGlzIHVuc3BlY2lmaWVkLCBpdCBkZWZhdWx0cyB0byBhbGwgcG9ydHMuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICd4LWt1YmVybmV0ZXMtaW50LW9yLXN0cmluZyc6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm90b2NvbDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGVzY3JpcHRpb246ICdUaGUgcHJvdG9jb2wgd2hpY2ggdHJhZmZpYyBtdXN0IG1hdGNoLiBJZiBwcm90b2NvbCBpcyB1bnNwZWNpZmllZCwgaXQgZGVmYXVsdHMgdG8gVENQLicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBlbnVtOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdUQ1AnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAnVURQJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnYXJyYXknLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHJlcXVpcmVkOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ2Zyb20nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICdwb3J0cycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdvYmplY3QnLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdhcnJheScsXG4gICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgc2VydmljZVJlZjoge1xuICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ3NlcnZpY2VSZWYgaXMgYSByZWZlcmVuY2UgdG8gYSBLdWJlcm5ldGVzIFNlcnZpY2UgYW5kIFNlcnZpY2VQb3J0LicsXG4gICAgICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICBuYW1lOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ05hbWUgaXMgdGhlIG5hbWUgb2YgdGhlIFNlcnZpY2UuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgcG9ydDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgJ2FueU9mJzogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ2ludGVnZXInLFxuICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgICAgICAgICAgJ2Rlc2NyaXB0aW9uJzogJ1BvcnQgaXMgdGhlIHBvcnQgb2YgdGhlIFNlcnZpY2VQb3J0LicsXG4gICAgICAgICAgICAgICAgICAgICAgICAneC1rdWJlcm5ldGVzLWludC1vci1zdHJpbmcnOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIHJlcXVpcmVkOiBbXG4gICAgICAgICAgICAgICAgICAgICAgJ25hbWUnLFxuICAgICAgICAgICAgICAgICAgICAgICdwb3J0JyxcbiAgICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgdGFyZ2V0R3JvdXBBUk46IHtcbiAgICAgICAgICAgICAgICAgICAgZGVzY3JpcHRpb246ICd0YXJnZXRHcm91cEFSTiBpcyB0aGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgZm9yIHRoZSBUYXJnZXRHcm91cC4nLFxuICAgICAgICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB0YXJnZXRUeXBlOiB7XG4gICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uOiAndGFyZ2V0VHlwZSBpcyB0aGUgVGFyZ2V0VHlwZSBvZiBUYXJnZXRHcm91cC4gSWYgdW5zcGVjaWZpZWQsIGl0IHdpbGwgYmUgYXV0b21hdGljYWxseSBpbmZlcnJlZC4nLFxuICAgICAgICAgICAgICAgICAgICBlbnVtOiBbXG4gICAgICAgICAgICAgICAgICAgICAgJ2luc3RhbmNlJyxcbiAgICAgICAgICAgICAgICAgICAgICAnaXAnLFxuICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICByZXF1aXJlZDogW1xuICAgICAgICAgICAgICAgICAgJ3NlcnZpY2VSZWYnLFxuICAgICAgICAgICAgICAgICAgJ3RhcmdldEdyb3VwQVJOJyxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgIHR5cGU6ICdvYmplY3QnLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBzdGF0dXM6IHtcbiAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ1RhcmdldEdyb3VwQmluZGluZ1N0YXR1cyBkZWZpbmVzIHRoZSBvYnNlcnZlZCBzdGF0ZSBvZiBUYXJnZXRHcm91cEJpbmRpbmcnLFxuICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgICAgICAgIG9ic2VydmVkR2VuZXJhdGlvbjoge1xuICAgICAgICAgICAgICAgICAgICBkZXNjcmlwdGlvbjogJ1RoZSBnZW5lcmF0aW9uIG9ic2VydmVkIGJ5IHRoZSBUYXJnZXRHcm91cEJpbmRpbmcgY29udHJvbGxlci4nLFxuICAgICAgICAgICAgICAgICAgICBmb3JtYXQ6ICdpbnQ2NCcsXG4gICAgICAgICAgICAgICAgICAgIHR5cGU6ICdpbnRlZ2VyJyxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgICB2ZXJzaW9uOiAndjFhbHBoYTEnLFxuICAgICAgICB2ZXJzaW9uczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIG5hbWU6ICd2MWFscGhhMScsXG4gICAgICAgICAgICBzZXJ2ZWQ6IHRydWUsXG4gICAgICAgICAgICBzdG9yYWdlOiBmYWxzZSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHtcbiAgICAgICAgICAgIG5hbWU6ICd2MWJldGExJyxcbiAgICAgICAgICAgIHNlcnZlZDogdHJ1ZSxcbiAgICAgICAgICAgIHN0b3JhZ2U6IHRydWUsXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgICBzdGF0dXM6IHtcbiAgICAgICAgYWNjZXB0ZWROYW1lczoge1xuICAgICAgICAgIGtpbmQ6ICcnLFxuICAgICAgICAgIHBsdXJhbDogJycsXG4gICAgICAgIH0sXG4gICAgICAgIGNvbmRpdGlvbnM6IFtdLFxuICAgICAgICBzdG9yZWRWZXJzaW9uczogW10sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlTXV0YXRpbmdXZWJob29rQ29uZmlndXJhdGlvblYxQmV0YTEodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2snLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBhbm5vdGF0aW9uczoge1xuICAgICAgICAgICdjZXJ0LW1hbmFnZXIuaW8vaW5qZWN0LWNhLWZyb20nOiAna3ViZS1zeXN0ZW0vYXdzLWxvYWQtYmFsYW5jZXItc2VydmluZy1jZXJ0JyxcbiAgICAgICAgfSxcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2snLFxuICAgICAgfSxcbiAgICAgIHdlYmhvb2tzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBjbGllbnRDb25maWc6IHtcbiAgICAgICAgICAgIGNhQnVuZGxlOiAnQ2c9PScsXG4gICAgICAgICAgICBzZXJ2aWNlOiB7XG4gICAgICAgICAgICAgIG5hbWU6ICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2UnLFxuICAgICAgICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgICAgICAgICBwYXRoOiAnL211dGF0ZS12MS1wb2QnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGZhaWx1cmVQb2xpY3k6ICdGYWlsJyxcbiAgICAgICAgICBuYW1lOiAnbXBvZC5lbGJ2Mi5rOHMuYXdzJyxcbiAgICAgICAgICBuYW1lc3BhY2VTZWxlY3Rvcjoge1xuICAgICAgICAgICAgbWF0Y2hFeHByZXNzaW9uczogW1xuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAga2V5OiAnZWxidjIuazhzLmF3cy9wb2QtcmVhZGluZXNzLWdhdGUtaW5qZWN0JyxcbiAgICAgICAgICAgICAgICBvcGVyYXRvcjogJ0luJyxcbiAgICAgICAgICAgICAgICB2YWx1ZXM6IFsnZW5hYmxlZCddLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHJ1bGVzOiBbe1xuICAgICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgICAgYXBpVmVyc2lvbnM6IFsndjEnXSxcbiAgICAgICAgICAgIG9wZXJhdGlvbnM6IFtcbiAgICAgICAgICAgICAgJ0NSRUFURScsXG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgcmVzb3VyY2VzOiBbJ3BvZHMnXSxcbiAgICAgICAgICB9XSxcbiAgICAgICAgICBzaWRlRWZmZWN0czogJ05vbmUnLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgY2xpZW50Q29uZmlnOiB7XG4gICAgICAgICAgICBjYUJ1bmRsZTogJ0NnPT0nLFxuICAgICAgICAgICAgc2VydmljZToge1xuICAgICAgICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay1zZXJ2aWNlJyxcbiAgICAgICAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgICAgICAgICAgcGF0aDogJy9tdXRhdGUtZWxidjItazhzLWF3cy12MWJldGExLXRhcmdldGdyb3VwYmluZGluZycsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgICAgZmFpbHVyZVBvbGljeTogJ0ZhaWwnLFxuICAgICAgICAgIG5hbWU6ICdtdGFyZ2V0Z3JvdXBiaW5kaW5nLmVsYnYyLms4cy5hd3MnLFxuICAgICAgICAgIHJ1bGVzOiBbe1xuICAgICAgICAgICAgYXBpR3JvdXBzOiBbJ2VsYnYyLms4cy5hd3MnXSxcbiAgICAgICAgICAgIGFwaVZlcnNpb25zOiBbJ3YxYmV0YTEnXSxcbiAgICAgICAgICAgIG9wZXJhdGlvbnM6IFtcbiAgICAgICAgICAgICAgJ0NSRUFURScsXG4gICAgICAgICAgICAgICdVUERBVEUnLFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIHJlc291cmNlczogWyd0YXJnZXRncm91cGJpbmRpbmdzJ10sXG4gICAgICAgICAgfV0sXG4gICAgICAgICAgc2lkZUVmZmVjdHM6ICdOb25lJyxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG4gICAgaWYgKG9wdGlvbnMuY3JlYXRlU2VydmljZUFjY291bnQgPT09IHRydWUpIHtcbiAgICAgIG5ldyBrOHMuS3ViZVNlcnZpY2VBY2NvdW50KHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLXNhJywge1xuICAgICAgICBtZXRhZGF0YToge1xuICAgICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdjb250cm9sbGVyJyxcbiAgICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIG5hbWU6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBuZXcgazhzLkt1YmVSb2xlKHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLWxlYWRlci1lbGVjdGlvbi1yb2xlJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItbGVhZGVyLWVsZWN0aW9uLXJvbGUnLFxuICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgfSxcbiAgICAgIHJ1bGVzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2NvbmZpZ21hcHMnXSxcbiAgICAgICAgICB2ZXJiczogWydjcmVhdGUnXSxcbiAgICAgICAgfSwge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnY29uZmlnbWFwcyddLFxuICAgICAgICAgIHJlc291cmNlTmFtZXM6IFsnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1sZWFkZXInXSxcbiAgICAgICAgICB2ZXJiczogWydnZXQnLCAndXBkYXRlJywgJ3BhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgbmV3IGs4cy5LdWJlQ2x1c3RlclJvbGUodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItY2x1c3Rlci1yb2xlJywge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbGFiZWxzOiB7XG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZTogYCR7dGhpcy5zZXJ2aWNlQWNjb3VudE5hbWV9LXJvbGVgLFxuICAgICAgfSxcbiAgICAgIHJ1bGVzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2VuZHBvaW50cyddLFxuICAgICAgICAgIHZlcmJzOiBbJ2dldCcsICdsaXN0JywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2V2ZW50cyddLFxuICAgICAgICAgIHZlcmJzOiBbJ2NyZWF0ZScsICdwYXRjaCddLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWyduYW1lc3BhY2VzJ10sXG4gICAgICAgICAgdmVyYnM6IFsnZ2V0JywgJ2xpc3QnLCAnd2F0Y2gnXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnbm9kZXMnXSxcbiAgICAgICAgICB2ZXJiczogWydnZXQnLCAnbGlzdCcsICd3YXRjaCddLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyddLFxuICAgICAgICAgIHJlc291cmNlczogWydwb2RzJ10sXG4gICAgICAgICAgdmVyYnM6IFsnZ2V0JywgJ2xpc3QnLCAnd2F0Y2gnXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsncG9kcy9zdGF0dXMnXSxcbiAgICAgICAgICB2ZXJiczogWydwYXRjaCcsICd1cGRhdGUnXSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGFwaUdyb3VwczogWycnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnc2VjcmV0cyddLFxuICAgICAgICAgIHZlcmJzOiBbJ2dldCcsICdsaXN0JywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ3NlcnZpY2VzJ10sXG4gICAgICAgICAgdmVyYnM6IFsnZ2V0JywgJ2xpc3QnLCAncGF0Y2gnLCAndXBkYXRlJywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ3NlcnZpY2VzL3N0YXR1cyddLFxuICAgICAgICAgIHZlcmJzOiBbJ3BhdGNoJywgJ3VwZGF0ZSddLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ2VsYnYyLms4cy5hd3MnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsndGFyZ2V0Z3JvdXBiaW5kaW5ncyddLFxuICAgICAgICAgIHZlcmJzOiBbJ2NyZWF0ZScsICdkZWxldGUnLCAnZ2V0JywgJ2xpc3QnLCAncGF0Y2gnLCAndXBkYXRlJywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnZWxidjIuazhzLmF3cyddLFxuICAgICAgICAgIHJlc291cmNlczogWyd0YXJnZXRncm91cGJpbmRpbmdzL3N0YXR1cyddLFxuICAgICAgICAgIHZlcmJzOiBbJ3BhdGNoJywgJ3VwZGF0ZSddLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ2V4dGVuc2lvbnMnXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2VzJ10sXG4gICAgICAgICAgdmVyYnM6IFsnZ2V0JywgJ2xpc3QnLCAncGF0Y2gnLCAndXBkYXRlJywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnZXh0ZW5zaW9ucyddLFxuICAgICAgICAgIHJlc291cmNlczogWydpbmdyZXNzZXMvc3RhdHVzJ10sXG4gICAgICAgICAgdmVyYnM6IFsncGF0Y2gnLCAndXBkYXRlJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnbmV0d29ya2luZy5rOHMuaW8nXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2VzJ10sXG4gICAgICAgICAgdmVyYnM6IFsnZ2V0JywgJ2xpc3QnLCAncGF0Y2gnLCAndXBkYXRlJywgJ3dhdGNoJ10sXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBhcGlHcm91cHM6IFsnbmV0d29ya2luZy5rOHMuaW8nXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnaW5ncmVzc2NsYXNzZXMnXSxcbiAgICAgICAgICB2ZXJiczogWydnZXQnLCAnbGlzdCcsICd3YXRjaCddLFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgYXBpR3JvdXBzOiBbJ25ldHdvcmtpbmcuazhzLmlvJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJ2luZ3Jlc3Nlcy9zdGF0dXMnXSxcbiAgICAgICAgICB2ZXJiczogWydwYXRjaCcsICd1cGRhdGUnXSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgazhzLkt1YmVSb2xlQmluZGluZyh0aGlzLCAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1sZWFkZXItZWxlY3Rpb24tcm9sZWJpbmRpbmcnLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1sZWFkZXItZWxlY3Rpb24tcm9sZWJpbmRpbmcnLFxuICAgICAgICBuYW1lc3BhY2U6IHRoaXMubmFtZXNwYWNlLFxuICAgICAgfSxcbiAgICAgIHJvbGVSZWY6IHtcbiAgICAgICAgYXBpR3JvdXA6ICdyYmFjLmF1dGhvcml6YXRpb24uazhzLmlvJyxcbiAgICAgICAga2luZDogJ1JvbGUnLFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1sZWFkZXItZWxlY3Rpb24tcm9sZScsXG4gICAgICB9LFxuICAgICAgc3ViamVjdHM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGtpbmQ6ICdTZXJ2aWNlQWNjb3VudCcsXG4gICAgICAgICAgbmFtZTogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgazhzLkt1YmVDbHVzdGVyUm9sZUJpbmRpbmcodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLWNvbnRyb2xsZXItcm9sZWJpbmRpbmcnLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItY29udHJvbGxlci1yb2xlYmluZGluZycsXG4gICAgICB9LFxuICAgICAgcm9sZVJlZjoge1xuICAgICAgICBhcGlHcm91cDogJ3JiYWMuYXV0aG9yaXphdGlvbi5rOHMuaW8nLFxuICAgICAgICBraW5kOiAnQ2x1c3RlclJvbGUnLFxuICAgICAgICBuYW1lOiBgJHt0aGlzLnNlcnZpY2VBY2NvdW50TmFtZX0tcm9sZWAsXG4gICAgICB9LFxuICAgICAgc3ViamVjdHM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGtpbmQ6ICdTZXJ2aWNlQWNjb3VudCcsXG4gICAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgICAgICBuYW1lOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgazhzLkt1YmVTZXJ2aWNlKHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2UnLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay1zZXJ2aWNlJyxcbiAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgIH0sXG4gICAgICBzcGVjOiB7XG4gICAgICAgIHBvcnRzOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgcG9ydDogNDQzLFxuICAgICAgICAgICAgdGFyZ2V0UG9ydDogOTQ0MyxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBzZWxlY3Rvcjoge1xuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9jb21wb25lbnQnOiAnY29udHJvbGxlcicsXG4gICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgazhzLkt1YmVEZXBsb3ltZW50KHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1jb250cm9sbGVyLWRlcGxveW1lbnQnLCB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ2NvbnRyb2xsZXInLFxuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgIH0sXG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgIG5hbWU6IHRoaXMuZGVwbG95bWVudE5hbWUsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICByZXBsaWNhczogb3B0aW9ucz8ucmVwbGljYXMgPz8gMSxcbiAgICAgICAgc2VsZWN0b3I6IHtcbiAgICAgICAgICBtYXRjaExhYmVsczoge1xuICAgICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdjb250cm9sbGVyJyxcbiAgICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgICAuLi5vcHRpb25zLmxhYmVscyxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgICB0ZW1wbGF0ZToge1xuICAgICAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdjb250cm9sbGVyJyxcbiAgICAgICAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiB0aGlzLnNlcnZpY2VBY2NvdW50TmFtZSxcbiAgICAgICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgICAgc3BlYzoge1xuICAgICAgICAgICAgY29udGFpbmVyczogW3tcbiAgICAgICAgICAgICAgbmFtZTogJ2NvbnRyb2xsZXInLFxuICAgICAgICAgICAgICBpbWFnZTogb3B0aW9ucz8uaW1hZ2UgPz8gJ2FtYXpvbi9hd3MtYWxiLWluZ3Jlc3MtY29udHJvbGxlcjp2Mi4xLjMnLFxuICAgICAgICAgICAgICBhcmdzOiB0aGlzLmFyZ3NGdW5jKG9wdGlvbnMuYXJncyksXG4gICAgICAgICAgICAgIGVudjogdGhpcy5lbnZGdW5jKG9wdGlvbnMuZW52KSxcbiAgICAgICAgICAgICAgbGl2ZW5lc3NQcm9iZToge1xuICAgICAgICAgICAgICAgIGZhaWx1cmVUaHJlc2hvbGQ6IDIsXG4gICAgICAgICAgICAgICAgaHR0cEdldDoge1xuICAgICAgICAgICAgICAgICAgcGF0aDogJy9oZWFsdGh6JyxcbiAgICAgICAgICAgICAgICAgIHBvcnQ6IDYxNzc5LFxuICAgICAgICAgICAgICAgICAgc2NoZW1lOiAnSFRUUCcsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBpbml0aWFsRGVsYXlTZWNvbmRzOiAzMCxcbiAgICAgICAgICAgICAgICB0aW1lb3V0U2Vjb25kczogMTAsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHBvcnRzOiBbXG4gICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgY29udGFpbmVyUG9ydDogOTQ0MyxcbiAgICAgICAgICAgICAgICAgIG5hbWU6ICd3ZWJob29rLXNlcnZlcicsXG4gICAgICAgICAgICAgICAgICBwcm90b2NvbDogJ1RDUCcsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgcmVzb3VyY2VzOiB7XG4gICAgICAgICAgICAgICAgbGltaXRzOiB7XG4gICAgICAgICAgICAgICAgICBjcHU6ICcyMDBtJyxcbiAgICAgICAgICAgICAgICAgIG1lbW9yeTogJzUwME1pJyxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIHJlcXVlc3RzOiB7XG4gICAgICAgICAgICAgICAgICBjcHU6ICcxMDBtJyxcbiAgICAgICAgICAgICAgICAgIG1lbW9yeTogJzIwME1pJyxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBzZWN1cml0eUNvbnRleHQ6IHtcbiAgICAgICAgICAgICAgICBhbGxvd1ByaXZpbGVnZUVzY2FsYXRpb246IGZhbHNlLFxuICAgICAgICAgICAgICAgIHJlYWRPbmx5Um9vdEZpbGVzeXN0ZW06IHRydWUsXG4gICAgICAgICAgICAgICAgcnVuQXNOb25Sb290OiB0cnVlLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICB2b2x1bWVNb3VudHM6IFtcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICBtb3VudFBhdGg6ICcvdG1wL2s4cy13ZWJob29rLXNlcnZlci9zZXJ2aW5nLWNlcnRzJyxcbiAgICAgICAgICAgICAgICAgIG5hbWU6ICdjZXJ0JyxcbiAgICAgICAgICAgICAgICAgIHJlYWRPbmx5OiB0cnVlLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICB9XSxcbiAgICAgICAgICAgIHNlY3VyaXR5Q29udGV4dDoge1xuICAgICAgICAgICAgICBmc0dyb3VwOiAxMzM3LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNlcnZpY2VBY2NvdW50TmFtZTogYCR7dGhpcy5zZXJ2aWNlQWNjb3VudE5hbWV9YCxcbiAgICAgICAgICAgIHRlcm1pbmF0aW9uR3JhY2VQZXJpb2RTZWNvbmRzOiAxMCxcbiAgICAgICAgICAgIHZvbHVtZXM6IFt7XG4gICAgICAgICAgICAgIG5hbWU6ICdjZXJ0JyxcbiAgICAgICAgICAgICAgc2VjcmV0OiB7XG4gICAgICAgICAgICAgICAgZGVmYXVsdE1vZGU6IDQyMCxcbiAgICAgICAgICAgICAgICBzZWNyZXROYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay10bHMnLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfV0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgY2RrOHMuQXBpT2JqZWN0KHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1zZXJ2aW5nLWNlcnQnLCB7XG4gICAgICBhcGlWZXJzaW9uOiAnY2VydC1tYW5hZ2VyLmlvL3YxYWxwaGEyJyxcbiAgICAgIGtpbmQ6ICdDZXJ0aWZpY2F0ZScsXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItc2VydmluZy1jZXJ0JyxcbiAgICAgICAgbmFtZXNwYWNlOiB0aGlzLm5hbWVzcGFjZSxcbiAgICAgIH0sXG4gICAgICBzcGVjOiB7XG4gICAgICAgIGRuc05hbWVzOiBbXG4gICAgICAgICAgJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2stc2VydmljZS5rdWJlLXN5c3RlbS5zdmMnLFxuICAgICAgICAgICdhd3MtbG9hZC1iYWxhbmNlci13ZWJob29rLXNlcnZpY2Uua3ViZS1zeXN0ZW0uc3ZjLmNsdXN0ZXIubG9jYWwnLFxuICAgICAgICBdLFxuICAgICAgICBpc3N1ZXJSZWY6IHtcbiAgICAgICAgICBraW5kOiAnSXNzdWVyJyxcbiAgICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItc2VsZnNpZ25lZC1pc3N1ZXInLFxuICAgICAgICB9LFxuICAgICAgICBzZWNyZXROYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vay10bHMnLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIG5ldyBjZGs4cy5BcGlPYmplY3QodGhpcywgJ2F3cy1sb2FkLWJhbGFuY2VyLXNlbGZzaWduZWQtaXNzdWVyJywge1xuICAgICAgYXBpVmVyc2lvbjogJ2NlcnQtbWFuYWdlci5pby92MWFscGhhMicsXG4gICAgICBraW5kOiAnSXNzdWVyJyxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogdGhpcy5zZXJ2aWNlQWNjb3VudE5hbWUsXG4gICAgICAgICAgLi4ub3B0aW9ucy5sYWJlbHMsXG4gICAgICAgIH0sXG4gICAgICAgIG5hbWU6ICdhd3MtbG9hZC1iYWxhbmNlci1zZWxmc2lnbmVkLWlzc3VlcicsXG4gICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBzZWxmU2lnbmVkOiB7fSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgazhzLkt1YmVWYWxpZGF0aW5nV2ViaG9va0NvbmZpZ3VyYXRpb25WMUJldGExKHRoaXMsICdhd3MtbG9hZC1iYWxhbmNlci1zZWxmc2lnbmVkLWlzc3Vlci12YWxpZCcsIHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIGFubm90YXRpb25zOiB7XG4gICAgICAgICAgJ2NlcnQtbWFuYWdlci5pby9pbmplY3QtY2EtZnJvbSc6ICdrdWJlLXN5c3RlbS9hd3MtbG9hZC1iYWxhbmNlci1zZXJ2aW5nLWNlcnQnLFxuICAgICAgICB9LFxuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6IHRoaXMuc2VydmljZUFjY291bnROYW1lLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgICBuYW1lOiAnYXdzLWxvYWQtYmFsYW5jZXItd2ViaG9vaycsXG4gICAgICB9LFxuICAgICAgd2ViaG9va3M6IFtcbiAgICAgICAge1xuICAgICAgICAgIGNsaWVudENvbmZpZzoge1xuICAgICAgICAgICAgY2FCdW5kbGU6ICdDZz09JyxcbiAgICAgICAgICAgIHNlcnZpY2U6IHtcbiAgICAgICAgICAgICAgbmFtZTogJ2F3cy1sb2FkLWJhbGFuY2VyLXdlYmhvb2stc2VydmljZScsXG4gICAgICAgICAgICAgIG5hbWVzcGFjZTogdGhpcy5uYW1lc3BhY2UsXG4gICAgICAgICAgICAgIHBhdGg6ICcvdmFsaWRhdGUtZWxidjItazhzLWF3cy12MWJldGExLXRhcmdldGdyb3VwYmluZGluZycsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgICAgZmFpbHVyZVBvbGljeTogJ0ZhaWwnLFxuICAgICAgICAgIG5hbWU6ICd2dGFyZ2V0Z3JvdXBiaW5kaW5nLmVsYnYyLms4cy5hd3MnLFxuICAgICAgICAgIHJ1bGVzOiBbe1xuICAgICAgICAgICAgYXBpR3JvdXBzOiBbJ2VsYnYyLms4cy5hd3MnXSxcbiAgICAgICAgICAgIGFwaVZlcnNpb25zOiBbJ3YxYmV0YTEnXSxcbiAgICAgICAgICAgIG9wZXJhdGlvbnM6IFtcbiAgICAgICAgICAgICAgJ0NSRUFURScsXG4gICAgICAgICAgICAgICdVUERBVEUnLFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIHJlc291cmNlczogWyd0YXJnZXRncm91cGJpbmRpbmdzJ10sXG4gICAgICAgICAgfV0sXG4gICAgICAgICAgc2lkZUVmZmVjdHM6ICdOb25lJyxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgfVxuICBwcml2YXRlIGFyZ3NGdW5jKGFyZ3M/OiBzdHJpbmdbXSk6c3RyaW5nW10ge1xuICAgIGNvbnN0IGRlZmF1bHRBcmdzID0gWyctLWluZ3Jlc3MtY2xhc3M9YWxiJywgYC0tY2x1c3Rlci1uYW1lPSR7dGhpcy5jbHVzdGVyTmFtZX1gXTtcbiAgICBpZiAoYXJncykge1xuICAgICAgYXJncy5mb3JFYWNoKGUgPT4gZGVmYXVsdEFyZ3MucHVzaChlKSk7XG4gICAgfVxuICAgIHJldHVybiBkZWZhdWx0QXJncztcbiAgfVxuICBwcml2YXRlIGVudkZ1bmMoZW52U2V0PzogRW52VmFyW10gfCB1bmRlZmluZWQpOkVudlZhcltdIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gZW52U2V0O1xuICB9XG59Il19