# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Value(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attempt_response_code': 'str',
        'attempt_reason_code': 'str',
        'challenge_methods': 'ChallengeMethods',
        'credential_validation_results': 'list[CredentialValidationResult]',
        'context': 'Context'
    }

    attribute_map = {
        'attempt_response_code': 'attemptResponseCode',
        'attempt_reason_code': 'attemptReasonCode',
        'challenge_methods': 'challengeMethods',
        'credential_validation_results': 'credentialValidationResults',
        'context': 'context'
    }

    def __init__(self, attempt_response_code=None, attempt_reason_code=None, challenge_methods=None, credential_validation_results=None, context=None):  # noqa: E501
        """Value - a model defined in Swagger"""  # noqa: E501
        self._attempt_response_code = None
        self._attempt_reason_code = None
        self._challenge_methods = None
        self._credential_validation_results = None
        self._context = None
        self.discriminator = None
        if attempt_response_code is not None:
            self.attempt_response_code = attempt_response_code
        if attempt_reason_code is not None:
            self.attempt_reason_code = attempt_reason_code
        if challenge_methods is not None:
            self.challenge_methods = challenge_methods
        if credential_validation_results is not None:
            self.credential_validation_results = credential_validation_results
        if context is not None:
            self.context = context

    @property
    def attempt_response_code(self):
        """Gets the attempt_response_code of this Value.  # noqa: E501


        :return: The attempt_response_code of this Value.  # noqa: E501
        :rtype: str
        """
        return self._attempt_response_code

    @attempt_response_code.setter
    def attempt_response_code(self, attempt_response_code):
        """Sets the attempt_response_code of this Value.


        :param attempt_response_code: The attempt_response_code of this Value.  # noqa: E501
        :type: str
        """

        self._attempt_response_code = attempt_response_code

    @property
    def attempt_reason_code(self):
        """Gets the attempt_reason_code of this Value.  # noqa: E501


        :return: The attempt_reason_code of this Value.  # noqa: E501
        :rtype: str
        """
        return self._attempt_reason_code

    @attempt_reason_code.setter
    def attempt_reason_code(self, attempt_reason_code):
        """Sets the attempt_reason_code of this Value.


        :param attempt_reason_code: The attempt_reason_code of this Value.  # noqa: E501
        :type: str
        """

        self._attempt_reason_code = attempt_reason_code

    @property
    def challenge_methods(self):
        """Gets the challenge_methods of this Value.  # noqa: E501


        :return: The challenge_methods of this Value.  # noqa: E501
        :rtype: ChallengeMethods
        """
        return self._challenge_methods

    @challenge_methods.setter
    def challenge_methods(self, challenge_methods):
        """Sets the challenge_methods of this Value.


        :param challenge_methods: The challenge_methods of this Value.  # noqa: E501
        :type: ChallengeMethods
        """

        self._challenge_methods = challenge_methods

    @property
    def credential_validation_results(self):
        """Gets the credential_validation_results of this Value.  # noqa: E501


        :return: The credential_validation_results of this Value.  # noqa: E501
        :rtype: list[CredentialValidationResult]
        """
        return self._credential_validation_results

    @credential_validation_results.setter
    def credential_validation_results(self, credential_validation_results):
        """Sets the credential_validation_results of this Value.


        :param credential_validation_results: The credential_validation_results of this Value.  # noqa: E501
        :type: list[CredentialValidationResult]
        """

        self._credential_validation_results = credential_validation_results

    @property
    def context(self):
        """Gets the context of this Value.  # noqa: E501


        :return: The context of this Value.  # noqa: E501
        :rtype: Context
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this Value.


        :param context: The context of this Value.  # noqa: E501
        :type: Context
        """

        self._context = context

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Value, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Value):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
