# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ContainerInvite(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'email': 'str',
        'origin_user': 'str',
        'token': 'str',
        'issued': 'str',
        'container': 'Container'
    }

    attribute_map = {
        'id': 'id',
        'email': 'email',
        'origin_user': 'origin_user',
        'token': 'token',
        'issued': 'issued',
        'container': 'container'
    }

    def __init__(self, id=None, email=None, origin_user=None, token=None, issued=None, container=None):  # noqa: E501
        """ContainerInvite - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._email = None
        self._origin_user = None
        self._token = None
        self._issued = None
        self._container = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if email is not None:
            self.email = email
        if origin_user is not None:
            self.origin_user = origin_user
        if token is not None:
            self.token = token
        if issued is not None:
            self.issued = issued
        if container is not None:
            self.container = container

    @property
    def id(self):
        """Gets the id of this ContainerInvite.  # noqa: E501


        :return: The id of this ContainerInvite.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ContainerInvite.


        :param id: The id of this ContainerInvite.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def email(self):
        """Gets the email of this ContainerInvite.  # noqa: E501


        :return: The email of this ContainerInvite.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ContainerInvite.


        :param email: The email of this ContainerInvite.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def origin_user(self):
        """Gets the origin_user of this ContainerInvite.  # noqa: E501


        :return: The origin_user of this ContainerInvite.  # noqa: E501
        :rtype: str
        """
        return self._origin_user

    @origin_user.setter
    def origin_user(self, origin_user):
        """Sets the origin_user of this ContainerInvite.


        :param origin_user: The origin_user of this ContainerInvite.  # noqa: E501
        :type: str
        """

        self._origin_user = origin_user

    @property
    def token(self):
        """Gets the token of this ContainerInvite.  # noqa: E501


        :return: The token of this ContainerInvite.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this ContainerInvite.


        :param token: The token of this ContainerInvite.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def issued(self):
        """Gets the issued of this ContainerInvite.  # noqa: E501


        :return: The issued of this ContainerInvite.  # noqa: E501
        :rtype: str
        """
        return self._issued

    @issued.setter
    def issued(self, issued):
        """Sets the issued of this ContainerInvite.


        :param issued: The issued of this ContainerInvite.  # noqa: E501
        :type: str
        """

        self._issued = issued

    @property
    def container(self):
        """Gets the container of this ContainerInvite.  # noqa: E501


        :return: The container of this ContainerInvite.  # noqa: E501
        :rtype: Container
        """
        return self._container

    @container.setter
    def container(self, container):
        """Sets the container of this ContainerInvite.


        :param container: The container of this ContainerInvite.  # noqa: E501
        :type: Container
        """

        self._container = container

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContainerInvite, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerInvite):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
