# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateEventActionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'container_id': 'str',
        'data_source_id': 'str',
        'event_type': 'str',
        'action_type': 'str',
        'action_config': 'object',
        'destination': 'str',
        'destination_data_source_id': 'str',
        'active': 'bool'
    }

    attribute_map = {
        'container_id': 'container_id',
        'data_source_id': 'data_source_id',
        'event_type': 'event_type',
        'action_type': 'action_type',
        'action_config': 'action_config',
        'destination': 'destination',
        'destination_data_source_id': 'destination_data_source_id',
        'active': 'active'
    }

    def __init__(self, container_id=None, data_source_id=None, event_type=None, action_type=None, action_config=None, destination=None, destination_data_source_id=None, active=None):  # noqa: E501
        """CreateEventActionRequest - a model defined in Swagger"""  # noqa: E501
        self._container_id = None
        self._data_source_id = None
        self._event_type = None
        self._action_type = None
        self._action_config = None
        self._destination = None
        self._destination_data_source_id = None
        self._active = None
        self.discriminator = None
        if container_id is not None:
            self.container_id = container_id
        if data_source_id is not None:
            self.data_source_id = data_source_id
        self.event_type = event_type
        self.action_type = action_type
        if action_config is not None:
            self.action_config = action_config
        if destination is not None:
            self.destination = destination
        if destination_data_source_id is not None:
            self.destination_data_source_id = destination_data_source_id
        if active is not None:
            self.active = active

    @property
    def container_id(self):
        """Gets the container_id of this CreateEventActionRequest.  # noqa: E501


        :return: The container_id of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this CreateEventActionRequest.


        :param container_id: The container_id of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def data_source_id(self):
        """Gets the data_source_id of this CreateEventActionRequest.  # noqa: E501


        :return: The data_source_id of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this CreateEventActionRequest.


        :param data_source_id: The data_source_id of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """

        self._data_source_id = data_source_id

    @property
    def event_type(self):
        """Gets the event_type of this CreateEventActionRequest.  # noqa: E501


        :return: The event_type of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this CreateEventActionRequest.


        :param event_type: The event_type of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """
        if event_type is None:
            raise ValueError("Invalid value for `event_type`, must not be `None`")  # noqa: E501

        self._event_type = event_type

    @property
    def action_type(self):
        """Gets the action_type of this CreateEventActionRequest.  # noqa: E501


        :return: The action_type of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """Sets the action_type of this CreateEventActionRequest.


        :param action_type: The action_type of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """
        if action_type is None:
            raise ValueError("Invalid value for `action_type`, must not be `None`")  # noqa: E501

        self._action_type = action_type

    @property
    def action_config(self):
        """Gets the action_config of this CreateEventActionRequest.  # noqa: E501


        :return: The action_config of this CreateEventActionRequest.  # noqa: E501
        :rtype: object
        """
        return self._action_config

    @action_config.setter
    def action_config(self, action_config):
        """Sets the action_config of this CreateEventActionRequest.


        :param action_config: The action_config of this CreateEventActionRequest.  # noqa: E501
        :type: object
        """

        self._action_config = action_config

    @property
    def destination(self):
        """Gets the destination of this CreateEventActionRequest.  # noqa: E501


        :return: The destination of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """Sets the destination of this CreateEventActionRequest.


        :param destination: The destination of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """

        self._destination = destination

    @property
    def destination_data_source_id(self):
        """Gets the destination_data_source_id of this CreateEventActionRequest.  # noqa: E501


        :return: The destination_data_source_id of this CreateEventActionRequest.  # noqa: E501
        :rtype: str
        """
        return self._destination_data_source_id

    @destination_data_source_id.setter
    def destination_data_source_id(self, destination_data_source_id):
        """Sets the destination_data_source_id of this CreateEventActionRequest.


        :param destination_data_source_id: The destination_data_source_id of this CreateEventActionRequest.  # noqa: E501
        :type: str
        """

        self._destination_data_source_id = destination_data_source_id

    @property
    def active(self):
        """Gets the active of this CreateEventActionRequest.  # noqa: E501


        :return: The active of this CreateEventActionRequest.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this CreateEventActionRequest.


        :param active: The active of this CreateEventActionRequest.  # noqa: E501
        :type: bool
        """

        self._active = active

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateEventActionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateEventActionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
