"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAction = exports.PropsUtil = exports.DeploymentPlan = exports.DeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class DeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.DeploymentPlanStack = DeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
DeploymentPlanStack[_a] = { fqn: "@attini/cdk.DeploymentPlanStack", version: "1.0.0-beta.1" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "1.0.0-beta.1" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_c = JSII_RTTI_SYMBOL_1;
PropsUtil[_c] = { fqn: "@attini/cdk.PropsUtil", version: "1.0.0-beta.1" };
var CfnAction;
(function (CfnAction) {
    CfnAction[CfnAction["DEPLOY"] = 0] = "DEPLOY";
    CfnAction[CfnAction["DELETE"] = 1] = "DELETE";
})(CfnAction = exports.CfnAction || (exports.CfnAction = {}));
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
__exportStar(require("./attini-runner"), exports);
__exportStar(require("./attini-cdk"), exports);
//# sourceMappingURL=data:application/json;base64,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