/******************************************************************************
 *
 * Copyright (c) 2017, the Perspective Authors.
 *
 * This file is part of the Perspective library, distributed under the terms of
 * the Apache License 2.0.  The full license can be found in the LICENSE file.
 *
 */

#pragma once
#include <perspective/first.h>
#include <perspective/base.h>
#include <perspective/raw_types.h>
#include <perspective/exports.h>
#include <perspective/scalar.h>

namespace perspective {

struct PERSPECTIVE_EXPORT t_dense_tnode {
    t_uindex m_idx;
    t_uindex m_pidx;
    t_uindex m_fcidx;
    t_uindex m_nchild;
    t_uindex m_flidx;
    t_uindex m_nleaves;
};

PERSPECTIVE_EXPORT void fill_dense_tnode(t_dense_tnode* node, t_uindex idx, t_uindex pidx,
    t_uindex fcidx, t_uindex nchild, t_uindex flidx, t_uindex nleaves);

} // end namespace perspective

namespace std {
PERSPECTIVE_EXPORT std::ostream& operator<<(
    std::ostream& os, const perspective::t_dense_tnode& s);
}
