/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as kinesisfirehose from '@aws-cdk/aws-kinesisfirehose';
import { Construct } from '@aws-cdk/core';
import * as s3 from '@aws-cdk/aws-s3';
import * as iam from '@aws-cdk/aws-iam';
import * as kinesis from '@aws-cdk/aws-kinesis';
import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as logs from '@aws-cdk/aws-logs';
/**
 * The properties for the KinesisStreamsToKinesisFirehoseToS3 class.
 */
export interface KinesisStreamsToKinesisFirehoseToS3Props {
    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     *
     * @default - Default props are used
     */
    readonly bucketProps?: s3.BucketProps;
    /**
     * Optional whether to create recommended CloudWatch alarms.
     *
     * @default - Alarms are created
     */
    readonly createCloudWatchAlarms?: boolean;
    /**
     * Optional existing instance of S3 Bucket, providing both this and bucketProps will cause an error.
     *
     * Providing both this and bucketProps will cause an error.
     *
     * @default - None
     */
    readonly existingBucketObj?: s3.IBucket;
    /**
     * Optional existing instance of logging S3 Bucket for the S3 Bucket created by the pattern.
     *
     * @default - None
     */
    readonly existingLoggingBucketObj?: s3.IBucket;
    /**
     * Optional existing instance of Kinesis Stream, providing both this and `kinesisStreamProps` will cause an error.
     *
     * @default - None
     */
    readonly existingStreamObj?: kinesis.Stream;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly kinesisFirehoseProps?: kinesisfirehose.CfnDeliveryStreamProps | any;
    /**
     * Optional user-provided props to override the default props for the Kinesis stream.
     *
     * @default - Default props are used.
     */
    readonly kinesisStreamProps?: kinesis.StreamProps;
    /**
     * Optional user provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly loggingBucketProps?: s3.BucketProps;
    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     *
     * Enabling Access Logging is a best practice.
     *
     * @default - true
     */
    readonly logS3AccessLogs?: boolean;
}
export declare class KinesisStreamsToKinesisFirehoseToS3 extends Construct {
    readonly cloudwatchAlarms?: cloudwatch.Alarm[];
    readonly kinesisFirehose: kinesisfirehose.CfnDeliveryStream;
    readonly kinesisFirehoseLogGroup: logs.LogGroup;
    readonly kinesisFirehoseRole: iam.Role;
    readonly kinesisStream: kinesis.Stream;
    readonly kinesisStreamRole: iam.Role;
    readonly s3Bucket?: s3.Bucket;
    readonly s3LoggingBucket?: s3.Bucket;
    readonly s3BucketInterface: s3.IBucket;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the KinesisStreamsToKinesisFirehoseToS3 class.
     * @since 1.68.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: KinesisStreamsToKinesisFirehoseToS3Props);
}
