import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
import { BaseClass } from '../../../common/base-class/base-class';
import { DockerLambdaCustomProps } from '../../../common/props/DockerLambdaCustomProps';
export interface SummarizationAppsyncStepfnProps {
    /**
     * Optional. The construct creates a custom VPC based on vpcProps.
     * Providing both this and existingVpc is an error.
     *
     * @default - none
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Optional. An existing VPC can be used to deploy the construct.
     * Providing both this and vpcProps is an error.
     *
     * @default - none
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Optional. Security group for the lambda function which this construct will use.
     * If no exisiting security group is provided it will create one from the vpc.
     * @default - none
     */
    readonly existingSecurityGroup?: ec2.ISecurityGroup;
    /**
     * Required. Cognito user pool used for authentication.
     *
     * @default - None
     */
    readonly cognitoUserPool: cognito.IUserPool;
    /**
     * Optional. Existing s3 Bucket to store the input document which needs to be summarized.
     * pdf is the supported input document format. If transformed (txt format) file is
     * available then this bucket is optional.
     *
     * @default - None
     */
    readonly existingInputAssetsBucketObj?: s3.IBucket;
    /**
     * Optional. User provided props to override the default props for the S3 Bucket.
     * Providing both this and `existingInputAssetsBucketObj` will cause an error.
     *
     * @default - Default props are used
     */
    readonly bucketInputsAssetsProps?: s3.BucketProps;
    /**
     * Optional. The summary construct transform the input document into txt format. If the
     * transformation is not required then this flag can be set to false. If set to true
     * then a transformed asset bucket is created which transform the input document from
     * input asset bucket to txt format.
     *
     * @default - False
     */
    readonly isFileTransformationRequired?: string;
    /**
     * Optional. This bucket stores the transformed (txt) assets for generating summary.
     * If None is provided then this contruct will create one.
     * @default - None
     */
    readonly existingProcessedAssetsBucketObj?: s3.IBucket;
    /**
     * Optional. User provided props to override the default props for the S3 Bucket.
     * Providing both this and `existingProcessedAssetsBucketObj` will cause an error.
     *
     * @default - Default props are used
     */
    readonly bucketProcessedAssetsProps?: s3.BucketProps;
    /**
     * Optional. Existing instance of EventBus. The summary construct integrate appsync with event bridge'
     * to route the request to step functions.
     *
     * @default - None
     */
    readonly existingBusInterface?: events.IEventBus;
    /**
      * Optional. A new custom EventBus is created with provided props.
      * Providing existingEventBusInterface and eventBusProps both will result in validation error.
      *
      * @default - None
      */
    readonly eventBusProps?: events.EventBusProps;
    /**
     * Optional - Existing merged Appsync GraphQL api.
     *
     * @default - None
     */
    readonly existingMergedApi?: appsync.CfnGraphQLApi;
    /**
     * Optional. User provided Name for summary api on appsync.
     * A graphql api will be created by this construct with this name.
     * @default 'summaryApi'
     */
    readonly summaryApiName?: string;
    /**
     * Enable observability. Warning: associated cost with the services
     * used. Best practice to enable by default.
     *
     * @default - true
     */
    readonly observability?: boolean;
    /**
     * Optional. Chain type defines how to pass the document to LLM.
     * there are three types of chain types.
     * Stuff: Simply "stuff" all your documents into a single prompt.
     * Map-reduce: Summarize each document on it's own in a "map" step and then "reduce" the summaries into a final summary
     * Refine :  This constructs a response by looping over the input documents and iteratively updating its answer
     * @default - Stuff
     */
    readonly summaryChainType?: string;
    /**
     * Value will be appended to resources name.
     *
     * @default - _dev
     */
    readonly stage?: string;
    /**
     * Optional. Allows to provide Embeddings custom lambda code
     * and settings instead of the existing
     */
    readonly customDocumentReaderDockerLambdaProps?: DockerLambdaCustomProps | undefined;
    /**
     * Optional. Allows to provide Input Validation custom lambda code
     * and settings instead of the existing
     */
    readonly customInputValidationDockerLambdaProps?: DockerLambdaCustomProps | undefined;
    /**
     * Optional. Allows to provide File Transformer custom lambda code
     * and settings instead of the existing
     */
    readonly customSummaryGeneratorDockerLambdaProps?: DockerLambdaCustomProps | undefined;
}
export declare class SummarizationAppsyncStepfn extends BaseClass {
    /**
     * Returns an instance of events.IEventBus created by the construct
     */
    readonly eventBridgeBus: events.IEventBus;
    /**
     * Returns an instance of appsync.CfnGraphQLApi for summary created by the construct
     */
    readonly graphqlApi: appsync.IGraphqlApi;
    /**
     * Graphql Api Id value
     */
    readonly graphqlApiId: string;
    /**
     *  Graphql Url value
     */
    readonly graphqlUrl: string;
    /**
     * Returns the instance of ec2.IVpc used by the construct
     */
    readonly vpc: ec2.IVpc;
    /**
     * Returns the instance of ec2.ISecurityGroup used by the construct
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * Returns the instance of s3.IBucket used by the construct
     */
    readonly inputAssetBucket: s3.IBucket;
    /**
     * Returns the instance of s3.IBucket used by the construct
     */
    readonly processedAssetBucket: s3.IBucket;
    /**
     * Step function
     * @default - fieldLogLevel - None
     */
    readonly stateMachine: sfn.StateMachine;
    /**
     * Returns an instance of lambda.DockerImageFunction used for the summary generation job created by the construct
     */
    readonly summaryGeneratorLambdaFunction: lambda.DockerImageFunction;
    /**
     * Returns an instance of lambda.DockerImageFunction used for the document reading job created by the construct
     */
    readonly documentReaderLambdaFunction: lambda.DockerImageFunction;
    /**
     * Returns an instance of lambda.DockerImageFunction used for the input validation job created by the construct
     */
    readonly inputValidationLambdaFunction: lambda.DockerImageFunction;
    /**
       * @summary Constructs a new instance of the SummarizationAppsyncStepfn class.
       * @param {Construct} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {SummarizationAppsyncStepfnProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: SummarizationAppsyncStepfnProps);
}
