import * as cdk from 'aws-cdk-lib';
import { RemovalPolicy } from 'aws-cdk-lib';
import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import { Table } from 'aws-cdk-lib/aws-dynamodb';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as kendra from 'aws-cdk-lib/aws-kendra';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { StateMachine } from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
import { BaseClass } from '../../../common/base-class';
import { KendraConstruct } from '../../../common/helpers/kendra-construct';
import { DockerLambdaCustomProps } from '../../../common/props/DockerLambdaCustomProps';
/**
 * The properties for the RagAppsyncStepfnKendraProps class.
 */
export interface RagAppsyncStepfnKendraProps {
    existingSecurityGroup: any;
    /**
       * Cognito user pool used for authentication.
       *
       * @default - None
       */
    readonly cognitoUserPool: cognito.UserPool;
    observability: boolean;
    stage: any;
    /**
       *
       *
       * @default - Optional user provided props to override the default props for the Kendra index. Is this required?
       */
    readonly kendraIndexProps?: kendra.CfnIndexProps;
    /**
       * A list of data sources that will provide data to the Kendra index. ?At least 1 must be specified. We will do majority of
       * processing for some data sources (S3 crawler initially), but for others the props must be complete (e.g. proper roleArn, etc.)
       *
       * @default - empty list (no data sources)
       */
    readonly kendraDataSourcesProps: Array<kendra.CfnDataSourceProps | any>;
    /**
       * Optional - index permissions to grant to the Lambda function. One or more of the following
       * may be specified: `Read`, `SubmitFeedback` and `Write`. Default is `["Read", "SubmitFeedback"]`. Read is
       * all the operations IAM defines as Read and List. SubmitFeedback is only the SubmitFeedback action. Write is all the
       * operations IAM defines as Write and Tag. This functionality may be overridden by providing a specific role arn in lambdaFunctionProps
       *
       * @default - ["Read", "SubmitFeedback"]
       */
    readonly indexPermissions?: string[];
    /**
       * Existing instance of a Kendra Index. Providing both this and kendraIndexProps will cause an error.
       *
       * @default - None
       */
    readonly existingKendraIndexObj?: kendra.CfnIndex;
    /**
       * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
       *
       * @default - None
       */
    readonly existingLambdaObj?: lambda.Function;
    /**
       * User provided props to override the default props for the Lambda function.
       *
       * @default - Default properties are used.
       */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
       * An existing VPC for the construct to use (construct will NOT create a new VPC in this case)
       */
    readonly existingVpc?: ec2.IVpc;
    /**
       * Properties to override default properties if deployVpc is true
       */
    readonly vpcProps?: ec2.VpcProps;
    /**
       * Whether to deploy a new VPC
       *
       * @default - false
       */
    readonly deployVpc?: boolean;
    /**
       * Optional Name for the Lambda function environment variable set to the index id for the Kendra index.
       *
       * @default - KENDRA_INDEX_ID
       */
    readonly indexIdEnvironmentVariableName?: string;
    /**
     * Optional. Allows to provide Generate Pre-signed Url custom lambda code
     * and settings instead of the existing
     */
    readonly generatePresignedUrlLambdaProps?: DockerLambdaCustomProps | undefined;
    /**
     * Optional. Allows to provide Kendra Start Data Sync Job custom lambda code
     * and settings instead of the existing
     */
    readonly kendraStartDataSyncLambdaProps?: DockerLambdaCustomProps | undefined;
    /**
     * Optional. Allows to provide Check Sync Job Status custom lambda code
     * and settings instead of the existing
     */
    readonly checkJobsStatusLambdaProps?: DockerLambdaCustomProps | undefined;
    /**
     * Optional. Allows to provide Update Kndra Sync Job Status custom lambda code
     * and settings instead of the existing
     */
    readonly updateKendraJobStatusLambdaProps?: DockerLambdaCustomProps | undefined;
}
/**
 * @summary The RagAppsyncStepfnKendra class.
 */
export declare class RagAppsyncStepfnKendra extends BaseClass {
    readonly vpc?: ec2.IVpc;
    readonly kendraIndex: KendraConstruct;
    readonly kendraInputBucket: Bucket;
    readonly graphqlApi: appsync.IGraphqlApi;
    private readonly kendraIndexId;
    private readonly awsRegion;
    private readonly awsAccountId;
    lambdaTracing: lambda.Tracing;
    kendraInputBucketArn: string;
    readonly securityGroup: ec2.ISecurityGroup;
    /**
       * Returns an instance of appsync.IGraphqlApi created by the construct
       */
    docProcessingStateMachine: StateMachine;
    stepFunctionsExecutionHandlerRole: cdk.aws_iam.Role;
    removalPolicy: RemovalPolicy;
    syncRunTable: Table;
    private kendraDataSourceIndexId;
    private stack;
    cognito: cognito.UserPool;
    /**
       * @summary Constructs a new instance of the RagAppsyncStepfnKendra class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a scope-unique id.
       * @param {RagAppsyncStepfnKendraProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
     */
    constructor(scope: Construct, id: string, props: RagAppsyncStepfnKendraProps);
}
