import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as openSearchServerless from 'aws-cdk-lib/aws-opensearchserverless';
import * as opensearchservice from 'aws-cdk-lib/aws-opensearchservice';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as secret from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { BaseClass } from '../../../common/base-class';
import { DockerLambdaCustomProps } from '../../../common/props/DockerLambdaCustomProps';
/**
 * The properties for the QaAppsyncOpensearchProps class.
 */
export interface QaAppsyncOpensearchProps {
    /**
     * Optional custom properties for a VPC the construct will create. This VPC will
     * be used by the Lambda functions the construct creates. Providing
     * both this and existingVpc is an error.
     *
     * @default - none
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Optional An existing VPC in which to deploy the construct. Providing both this and
     * vpcProps is an error.
     *
     * @default - none
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Optional existing security group allowing access to opensearch. Used by the lambda functions
     * built by this construct. If not provided, the construct will create one.
     *
     * @default - none
     */
    readonly existingSecurityGroup?: ec2.ISecurityGroup;
    /**
     * Optional Existing instance of an EventBridge bus. If not provided, the construct will create one.
     *
     * @default - None
     */
    readonly existingBusInterface?: events.IEventBus;
    /**
     * Existing instance of S3 Bucket object, providing both this and `bucketInputsAssetsProps` will cause an error.
     *
     * @default - None
     */
    readonly existingInputAssetsBucketObj?: s3.IBucket;
    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     * Providing both this and `existingInputAssetsBucketObj` will cause an error.
     *
     * @default - Default props are used
     */
    readonly bucketInputsAssetsProps?: s3.BucketProps;
    /**
     * Existing Amazon OpenSearch Service domain.
     *
     * @default - None
     */
    readonly existingOpensearchDomain?: opensearchservice.IDomain;
    /**
     * Existing Amazon Amazon OpenSearch Serverless collection.
     *
     * @default - None
     */
    readonly existingOpensearchServerlessCollection?: openSearchServerless.CfnCollection;
    /**
     * Data Index name for the OpenSearch Service.
     *
     * @default - None
     */
    readonly openSearchIndexName: string;
    /**
     * Optional. SecretsManager secret to authenticate against the OpenSearch Service domain if
     * domain is configured with Username/Password.
     *
     * @default - None
     */
    readonly openSearchSecret?: secret.ISecret;
    /**
     * Existing merged Appsync GraphQL api.
     *
     * @default - None
     */
    readonly existingMergedApi?: appsync.CfnGraphQLApi;
    /**
     * Cognito user pool used for authentication.
     *
     * @default - None
     */
    readonly cognitoUserPool: cognito.IUserPool;
    /**
     * Value will be appended to resources name.
     *
     * @default - _dev
     */
    readonly stage?: string;
    /**
     * Enable observability. Warning: associated cost with the services
     * used. Best practive to enable by default.
     *
     * @default - true
     */
    readonly observability?: boolean;
    /**
     * Optional. Allows a user to configure
     * Lambda provisioned concurrency for consistent performance
     */
    readonly lambdaProvisionedConcurrency?: number | undefined;
    /**
     * Optional. Allows to provide custom lambda code
     * and settings instead of the existing
     */
    readonly customDockerLambdaProps?: DockerLambdaCustomProps | undefined;
}
/**
 * @summary The QaAppsyncOpensearch class.
 */
export declare class QaAppsyncOpensearch extends BaseClass {
    /**
     * Returns the instance of ec2.IVpc used by the construct
     */
    readonly vpc: ec2.IVpc;
    /**
     * Returns the instance of ec2.ISecurityGroup used by the construct
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * Returns the instance of events.IEventBus used by the construct
     */
    readonly qaBus: events.IEventBus;
    /**
     * Returns an instance of s3.IBucket created by the construct
     */
    readonly s3InputAssetsBucketInterface: s3.IBucket;
    /**
     * Returns an instance of s3.Bucket created by the construct.
     * IMPORTANT: If existingInputAssetsBucketObj was provided in Pattern Construct Props,
     * this property will be undefined
     */
    readonly s3InputAssetsBucket?: s3.Bucket;
    /**
     * Returns an instance of appsync.IGraphqlApi created by the construct
     */
    readonly graphqlApi: appsync.IGraphqlApi;
    /**
     * Returns an instance of appsync.IGraphqlApi created by the construct
     */
    readonly qaLambdaFunction: lambda.DockerImageFunction;
    /**
     * @summary Constructs a new instance of the RagAppsyncStepfnOpensearch class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {QaAppsyncOpensearchProps} props - user provided props for the construct.
     * @since 0.0.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: QaAppsyncOpensearchProps);
}
