"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.JumpStartConstants = void 0;
class JumpStartConstants {
}
exports.JumpStartConstants = JumpStartConstants;
/*
https://github.com/aws/sagemaker-python-sdk/blob/8462f1a1975da59304da4441aea956a43deec380/src/sagemaker/jumpstart/constants.py
*/
JumpStartConstants.JUMPSTART_LAUNCHED_REGIONS = {
    'us-west-2': {
        contentBucket: 'jumpstart-cache-prod-us-west-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-west-2',
    },
    'us-east-1': {
        contentBucket: 'jumpstart-cache-prod-us-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-east-1',
    },
    'us-east-2': {
        contentBucket: 'jumpstart-cache-prod-us-east-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-east-2',
    },
    'eu-west-1': {
        contentBucket: 'jumpstart-cache-prod-eu-west-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-1',
    },
    'eu-central-1': {
        contentBucket: 'jumpstart-cache-prod-eu-central-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-central-1',
    },
    'eu-north-1': {
        contentBucket: 'jumpstart-cache-prod-eu-north-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-north-1',
    },
    'me-south-1': {
        contentBucket: 'jumpstart-cache-prod-me-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-me-south-1',
    },
    'ap-south-1': {
        contentBucket: 'jumpstart-cache-prod-ap-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-south-1',
    },
    'eu-west-3': {
        contentBucket: 'jumpstart-cache-prod-eu-west-3',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-3',
    },
    'af-south-1': {
        contentBucket: 'jumpstart-cache-prod-af-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-af-south-1',
    },
    'sa-east-1': {
        contentBucket: 'jumpstart-cache-prod-sa-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-sa-east-1',
    },
    'ap-east-1': {
        contentBucket: 'jumpstart-cache-prod-ap-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-east-1',
    },
    'ap-northeast-2': {
        contentBucket: 'jumpstart-cache-prod-ap-northeast-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-northeast-2',
    },
    'eu-west-2': {
        contentBucket: 'jumpstart-cache-prod-eu-west-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-2',
    },
    'eu-south-1': {
        contentBucket: 'jumpstart-cache-prod-eu-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-south-1',
    },
    'ap-northeast-1': {
        contentBucket: 'jumpstart-cache-prod-ap-northeast-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-northeast-1',
    },
    'us-west-1': {
        contentBucket: 'jumpstart-cache-prod-us-west-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-west-1',
    },
    'ap-southeast-1': {
        contentBucket: 'jumpstart-cache-prod-ap-southeast-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-southeast-1',
    },
    'ap-southeast-2': {
        contentBucket: 'jumpstart-cache-prod-ap-southeast-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-southeast-2',
    },
    'ca-central-1': {
        contentBucket: 'jumpstart-cache-prod-ca-central-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ca-central-1',
    },
    'cn-north-1': {
        contentBucket: 'jumpstart-cache-prod-cn-north-1',
    },
};
JumpStartConstants.JUMPSTART_DEFAULT_MANIFEST_FILE_S3_KEY = 'models_manifest.json';
//# sourceMappingURL=data:application/json;base64,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