import * as iam from 'aws-cdk-lib/aws-iam';
import * as sagemaker from 'aws-cdk-lib/aws-sagemaker';
import { Construct } from 'constructs';
import { JumpStartModel } from './jumpstart-model';
import { SageMakerEndpointBase } from './sagemaker-endpoint-base';
import { SageMakerInstanceType } from './sagemaker-instance-type';
export interface JumpStartSageMakerEndpointProps {
    readonly model: JumpStartModel;
    readonly endpointName: string;
    readonly instanceType?: SageMakerInstanceType;
    readonly instanceCount?: number;
    readonly role?: iam.Role;
    readonly vpcConfig?: sagemaker.CfnModel.VpcConfigProperty | undefined;
    readonly environment?: {
        [key: string]: string;
    };
    readonly startupHealthCheckTimeoutInSeconds?: number;
    readonly acceptEula?: boolean;
}
/**
 * @summary The JumpStartSageMakerEndpoint class.
 */
export declare class JumpStartSageMakerEndpoint extends SageMakerEndpointBase {
    readonly grantPrincipal: iam.IPrincipal;
    readonly endpointArn: string;
    readonly cfnModel: sagemaker.CfnModel;
    readonly cfnEndpoint: sagemaker.CfnEndpoint;
    readonly cfnEndpointConfig: sagemaker.CfnEndpointConfig;
    readonly model: JumpStartModel;
    readonly instanceType?: SageMakerInstanceType;
    readonly instanceCount: number;
    readonly role: iam.Role;
    private readonly acceptEula;
    private readonly region;
    private readonly spec;
    private readonly startupHealthCheckTimeoutInSeconds;
    private readonly environment?;
    constructor(scope: Construct, id: string, props: JumpStartSageMakerEndpointProps);
    addToRolePolicy(statement: iam.PolicyStatement): void;
    grantInvoke(grantee: iam.IGrantable): iam.Grant;
    private verifyInstanceType;
    private buildEnvironment;
    private getModelFromArtifact;
    private getModelFromPackage;
}
