import * as iam from 'aws-cdk-lib/aws-iam';
import * as sagemaker from 'aws-cdk-lib/aws-sagemaker';
import { Construct } from 'constructs';
import { ContainerImage } from './container-image';
import { SageMakerEndpointBase } from './sagemaker-endpoint-base';
import { SageMakerInstanceType } from './sagemaker-instance-type';
export interface CustomSageMakerEndpointProps {
    readonly modelId: string;
    readonly endpointName: string;
    readonly instanceType: SageMakerInstanceType;
    readonly container: ContainerImage;
    readonly instanceCount?: number;
    readonly role?: iam.Role;
    readonly environment?: {
        [key: string]: string;
    };
    readonly startupHealthCheckTimeoutInSeconds?: number;
    readonly modelDataDownloadTimeoutInSeconds?: number;
    readonly volumeSizeInGb?: number | undefined;
    readonly vpcConfig?: sagemaker.CfnModel.VpcConfigProperty | undefined;
    readonly modelDataUrl: string;
}
export declare class CustomSageMakerEndpoint extends SageMakerEndpointBase implements iam.IGrantable {
    readonly grantPrincipal: iam.IPrincipal;
    readonly endpointArn: string;
    readonly cfnModel: sagemaker.CfnModel;
    readonly cfnEndpoint: sagemaker.CfnEndpoint;
    readonly cfnEndpointConfig: sagemaker.CfnEndpointConfig;
    readonly instanceType?: SageMakerInstanceType;
    readonly instanceCount: number;
    readonly role: iam.Role;
    readonly modelDataUrl: string;
    readonly modelId: string;
    readonly modelDataDownloadTimeoutInSeconds: number;
    private readonly startupHealthCheckTimeoutInSeconds;
    private readonly environment?;
    constructor(scope: Construct, id: string, props: CustomSageMakerEndpointProps);
    addToRolePolicy(statement: iam.PolicyStatement): void;
    grantInvoke(grantee: iam.IGrantable): iam.Grant;
}
