"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const assets = require("aws-cdk-lib/aws-ecr-assets");
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
/**
 *
 * https://github.com/aws/deep-learning-containers/blob/master/available_images.md
 */
class ContainerImage {
    static fromEcrRepository(repository, tag = 'latest') {
        return new EcrImage(repository, tag);
    }
    static fromAsset(directory, options = {}) {
        return new AssetImage(directory, options);
    }
}
exports.ContainerImage = ContainerImage;
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.ContainerImage", version: "0.1.198" };
class EcrImage extends ContainerImage {
    constructor(repository, tag) {
        super();
        this.repository = repository;
        this.tag = tag;
    }
    bind(_scope, grantable) {
        this.repository.grantPull(grantable);
        return {
            imageName: this.repository.repositoryUriForTag(this.tag),
        };
    }
}
class AssetImage extends ContainerImage {
    constructor(directory, options = {}) {
        super();
        this.directory = directory;
        this.options = options;
    }
    bind(scope, grantable) {
        // Retain the first instantiation of this asset
        if (!this.asset) {
            this.asset = new assets.DockerImageAsset(scope, `ModelImage${(0, helpers_internal_1.md5hash)(this.directory)}`, {
                directory: this.directory,
                ...this.options,
            });
        }
        this.asset.repository.grantPull(grantable);
        return {
            imageName: this.asset.imageUri,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udGFpbmVyLWltYWdlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3BhdHRlcm5zL2dlbi1haS9hd3MtbW9kZWwtZGVwbG95bWVudC1zYWdlbWFrZXIvY29udGFpbmVyLWltYWdlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBYUEscURBQXFEO0FBRXJELDRFQUFnRTtBQWNoRTs7O0dBR0c7QUFDSCxNQUFzQixjQUFjO0lBQzNCLE1BQU0sQ0FBQyxpQkFBaUIsQ0FDN0IsVUFBMkIsRUFDM0IsTUFBYyxRQUFRO1FBRXRCLE9BQU8sSUFBSSxRQUFRLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFTSxNQUFNLENBQUMsU0FBUyxDQUNyQixTQUFpQixFQUNqQixVQUEwQyxFQUFFO1FBRTVDLE9BQU8sSUFBSSxVQUFVLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQzVDLENBQUM7O0FBYkgsd0NBbUJDOzs7QUFFRCxNQUFNLFFBQVMsU0FBUSxjQUFjO0lBQ25DLFlBQ21CLFVBQTJCLEVBQzNCLEdBQVc7UUFFNUIsS0FBSyxFQUFFLENBQUM7UUFIUyxlQUFVLEdBQVYsVUFBVSxDQUFpQjtRQUMzQixRQUFHLEdBQUgsR0FBRyxDQUFRO0lBRzlCLENBQUM7SUFFTSxJQUFJLENBQ1QsTUFBaUIsRUFDakIsU0FBeUI7UUFFekIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsU0FBUyxDQUFDLENBQUM7UUFFckMsT0FBTztZQUNMLFNBQVMsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7U0FDekQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQUVELE1BQU0sVUFBVyxTQUFRLGNBQWM7SUFHckMsWUFDbUIsU0FBaUIsRUFDakIsVUFBMEMsRUFBRTtRQUU3RCxLQUFLLEVBQUUsQ0FBQztRQUhTLGNBQVMsR0FBVCxTQUFTLENBQVE7UUFDakIsWUFBTyxHQUFQLE9BQU8sQ0FBcUM7SUFHL0QsQ0FBQztJQUVNLElBQUksQ0FDVCxLQUFnQixFQUNoQixTQUF5QjtRQUV6QiwrQ0FBK0M7UUFDL0MsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUNoQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksTUFBTSxDQUFDLGdCQUFnQixDQUN0QyxLQUFLLEVBQ0wsYUFBYSxJQUFBLDBCQUFPLEVBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLEVBQ3RDO2dCQUNFLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztnQkFDekIsR0FBRyxJQUFJLENBQUMsT0FBTzthQUNoQixDQUNGLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRTNDLE9BQU87WUFDTCxTQUFTLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQy9CLENBQUM7SUFDSixDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuaW1wb3J0ICogYXMgZWNyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lY3InO1xuaW1wb3J0ICogYXMgYXNzZXRzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lY3ItYXNzZXRzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IG1kNWhhc2ggfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbnRhaW5lckltYWdlQ29uZmlnIHtcbiAgLyoqXG4gICAqIFRoZSBpbWFnZSBuYW1lLiBJbWFnZXMgaW4gQW1hem9uIEVDUiByZXBvc2l0b3JpZXMgY2FuIGJlIHNwZWNpZmllZCBieSBlaXRoZXIgdXNpbmcgdGhlIGZ1bGwgcmVnaXN0cnkvcmVwb3NpdG9yeTp0YWcgb3JcbiAgICogcmVnaXN0cnkvcmVwb3NpdG9yeUBkaWdlc3QuXG4gICAqXG4gICAqIEZvciBleGFtcGxlLCBgMDEyMzQ1Njc4OTEwLmRrci5lY3IuPHJlZ2lvbi1uYW1lPi5hbWF6b25hd3MuY29tLzxyZXBvc2l0b3J5LW5hbWU+OmxhdGVzdGAgb3JcbiAgICogYDAxMjM0NTY3ODkxMC5ka3IuZWNyLjxyZWdpb24tbmFtZT4uYW1hem9uYXdzLmNvbS88cmVwb3NpdG9yeS1uYW1lPkBzaGEyNTY6OTRhZmQxZjJlNjRkOTA4YmM5MGRiY2EwMDM1YTViNTY3RVhBTVBMRWAuXG4gICAqL1xuICByZWFkb25seSBpbWFnZU5hbWU6IHN0cmluZztcbn1cblxuLyoqXG4gKlxuICogaHR0cHM6Ly9naXRodWIuY29tL2F3cy9kZWVwLWxlYXJuaW5nLWNvbnRhaW5lcnMvYmxvYi9tYXN0ZXIvYXZhaWxhYmxlX2ltYWdlcy5tZFxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQ29udGFpbmVySW1hZ2Uge1xuICBwdWJsaWMgc3RhdGljIGZyb21FY3JSZXBvc2l0b3J5KFxuICAgIHJlcG9zaXRvcnk6IGVjci5JUmVwb3NpdG9yeSxcbiAgICB0YWc6IHN0cmluZyA9ICdsYXRlc3QnLFxuICApOiBDb250YWluZXJJbWFnZSB7XG4gICAgcmV0dXJuIG5ldyBFY3JJbWFnZShyZXBvc2l0b3J5LCB0YWcpO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBmcm9tQXNzZXQoXG4gICAgZGlyZWN0b3J5OiBzdHJpbmcsXG4gICAgb3B0aW9uczogYXNzZXRzLkRvY2tlckltYWdlQXNzZXRPcHRpb25zID0ge30sXG4gICk6IENvbnRhaW5lckltYWdlIHtcbiAgICByZXR1cm4gbmV3IEFzc2V0SW1hZ2UoZGlyZWN0b3J5LCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgZ3JhbnRhYmxlOiBpYW0uSUdyYW50YWJsZSxcbiAgKTogQ29udGFpbmVySW1hZ2VDb25maWc7XG59XG5cbmNsYXNzIEVjckltYWdlIGV4dGVuZHMgQ29udGFpbmVySW1hZ2Uge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IHJlcG9zaXRvcnk6IGVjci5JUmVwb3NpdG9yeSxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHRhZzogc3RyaW5nLFxuICApIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgcHVibGljIGJpbmQoXG4gICAgX3Njb3BlOiBDb25zdHJ1Y3QsXG4gICAgZ3JhbnRhYmxlOiBpYW0uSUdyYW50YWJsZSxcbiAgKTogQ29udGFpbmVySW1hZ2VDb25maWcge1xuICAgIHRoaXMucmVwb3NpdG9yeS5ncmFudFB1bGwoZ3JhbnRhYmxlKTtcblxuICAgIHJldHVybiB7XG4gICAgICBpbWFnZU5hbWU6IHRoaXMucmVwb3NpdG9yeS5yZXBvc2l0b3J5VXJpRm9yVGFnKHRoaXMudGFnKSxcbiAgICB9O1xuICB9XG59XG5cbmNsYXNzIEFzc2V0SW1hZ2UgZXh0ZW5kcyBDb250YWluZXJJbWFnZSB7XG4gIHByaXZhdGUgYXNzZXQ/OiBhc3NldHMuRG9ja2VySW1hZ2VBc3NldDtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IGRpcmVjdG9yeTogc3RyaW5nLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgb3B0aW9uczogYXNzZXRzLkRvY2tlckltYWdlQXNzZXRPcHRpb25zID0ge30sXG4gICkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBwdWJsaWMgYmluZChcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGdyYW50YWJsZTogaWFtLklHcmFudGFibGUsXG4gICk6IENvbnRhaW5lckltYWdlQ29uZmlnIHtcbiAgICAvLyBSZXRhaW4gdGhlIGZpcnN0IGluc3RhbnRpYXRpb24gb2YgdGhpcyBhc3NldFxuICAgIGlmICghdGhpcy5hc3NldCkge1xuICAgICAgdGhpcy5hc3NldCA9IG5ldyBhc3NldHMuRG9ja2VySW1hZ2VBc3NldChcbiAgICAgICAgc2NvcGUsXG4gICAgICAgIGBNb2RlbEltYWdlJHttZDVoYXNoKHRoaXMuZGlyZWN0b3J5KX1gLFxuICAgICAgICB7XG4gICAgICAgICAgZGlyZWN0b3J5OiB0aGlzLmRpcmVjdG9yeSxcbiAgICAgICAgICAuLi50aGlzLm9wdGlvbnMsXG4gICAgICAgIH0sXG4gICAgICApO1xuICAgIH1cblxuICAgIHRoaXMuYXNzZXQucmVwb3NpdG9yeS5ncmFudFB1bGwoZ3JhbnRhYmxlKTtcblxuICAgIHJldHVybiB7XG4gICAgICBpbWFnZU5hbWU6IHRoaXMuYXNzZXQuaW1hZ2VVcmksXG4gICAgfTtcbiAgfVxufVxuIl19