/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { FlowLog, IVpc, SecurityGroup, Vpc, VpcProps } from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
import { ServiceEndpointTypeEnum } from '../../patterns/gen-ai/aws-rag-appsync-stepfn-kendra/types';
export interface VpcPropsSet {
    readonly existingVpc?: IVpc;
    readonly vpcProps?: VpcProps;
    readonly deployVpc?: boolean;
}
export declare function CheckVpcProps(propsObject: VpcPropsSet | any): void;
export interface BuildVpcProps {
    /**
     * Existing instance of a VPC, if this is set then the all Props are ignored,
     * if this is not set then deafultVPC Props are used.
     */
    readonly existingVpc?: IVpc;
    /**
     * One of the default VPC configurations available in vpc-defaults
     */
    readonly defaultVpcProps: VpcProps;
    /**
     * User provided props to override the default props for the VPC.
     */
    readonly userVpcProps?: VpcProps;
    /**
     * Construct specified props that override both the default props
     * and user props for the VPC.
     */
    readonly constructVpcProps?: VpcProps;
}
export declare function buildVpc(scope: Construct, props: BuildVpcProps): IVpc;
export declare function getPrivateSubnetIDs(vpc: IVpc): string[];
export declare function getlambdaSecuritygroup(scope: Construct, vpc: IVpc): SecurityGroup;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Creates the default vpc props with public , private_with_egress and private_isolated subnet configuration.
 */
export declare function DefaultVpcProps(): VpcProps;
export declare function suppressMapPublicIpWarnings(vpc: Vpc): void;
export declare function suppressEncryptedLogWarnings(flowLog: FlowLog): void;
export declare function createDefaultIsolatedVpcProps(): VpcProps;
export declare function AddAwsServiceEndpoint(scope: Construct, vpc: IVpc, interfaceTag: ServiceEndpointTypeEnum): void;
