/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cdk from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { CfnNagSuppressRule } from '../../patterns/gen-ai/aws-rag-appsync-stepfn-kendra/types';
/**
 * The version of this package
 */
export declare const version: any;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * @summary Creates a physical resource name in the style of the CDK (string+hash) - this value incorporates Stack ID,
 * so it will remain static in multiple updates of a single stack, but will be different in a separate stack instance
 * @param {string} prefix - the prefix for the name
 * @param {string[]} parts - the various string components of the name (eg - stackName, solutions construct ID, L2 construct ID)
 * @param {number} maxLength - the longest string that can be returned
 * @returns {string} - a string with concatenated parts (truncated if necessary) + a hash of the full concatenated parts
 *
 * @deprecated This function is deprecated and will be removed in a future major version.
 * Please use the new function generatePhysicalNameV2 instead.
 */
export declare function generatePhysicalName(prefix: string, parts: string[], maxLength: number): string;
export interface GeneratePhysicalNameV2Options extends cdk.UniqueResourceNameOptions {
    /**
     * Whether to convert the name to lower case.
     *
     * @default false
     */
    lower?: boolean;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * @summary Creates a physical resource name in the style of the CDK (string+hash) - this value incorporates
 * the Stack Name and node ID, so it will remain static in multiple updates of a single stack, but will be
 * different in a separate stack instance.
 *
 * This new version allows for names shorter than 36 characters with control over casing.
 *
 * The minimum length is the length of the prefix and separator plus 10.
 */
export declare function generatePhysicalNameV2(
/**
 * The CDK scope of the resource.
 */
scope: IConstruct, 
/**
 * The prefix for the name.
 */
prefix: string, 
/**
 * Options for generating the name.
 */
options?: GeneratePhysicalNameV2Options): string;
export declare const maximumLambdaMemorySizeContextItem = "maximumLambdaMemorySize";
export declare const recommendedMaximumLambdaMemorySize = 7076;
export declare function lambdaMemorySizeLimiter(construct: IConstruct, requestedMemorySizeInMegabytes: number): number;
/**
 * Adds CFN NAG suppress rules to the CDK resource.
 * @param resource The CDK resource
 * @param rules The CFN NAG suppress rules
 */
export declare function addCfnSuppressRules(resource: cdk.Resource | cdk.CfnResource, rules: CfnNagSuppressRule[]): void;
export declare function isPlainObject(o: object): boolean;
