"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDockerLambdaFunction = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
function buildDockerLambdaFunction(scope, id, constructprops, userprops) {
    if (userprops) { // user provided his own custom lambda function, merge his props with the construct ones
        return new lambda.DockerImageFunction(scope, id, {
            // we force some values to be used from the construct
            functionName: constructprops.functionName,
            description: constructprops.description,
            vpc: constructprops.vpc,
            tracing: constructprops.tracing,
            vpcSubnets: constructprops.vpcSubnets,
            securityGroups: constructprops.securityGroups,
            role: constructprops.role,
            memorySize: constructprops.memorySize,
            timeout: constructprops.timeout,
            // add user props
            ...userprops,
            // merge construct env variables with the ones from the construct
            environment: { ...constructprops.environment, ...userprops.environment },
        });
    }
    else { // use values provided by the construct
        return new lambda.DockerImageFunction(scope, id, constructprops);
    }
}
exports.buildDockerLambdaFunction = buildDockerLambdaFunction;
//# sourceMappingURL=data:application/json;base64,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