"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStepFnLambdaInvoke = exports.overrideProps = exports.consolidateProps = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
const utils_1 = require("./utils");
// https://github.com/webpack/webpack/issues/6584
// eslint-disable-next-line @typescript-eslint/no-require-imports,import/no-extraneous-dependencies
const merge = require('deepmerge');
function consolidateProps(defaultProps, clientProps, constructProps, concatArray = false) {
    let result = defaultProps;
    if (clientProps) {
        result = overrideProps(result, clientProps, concatArray);
    }
    if (constructProps) {
        result = overrideProps(result, constructProps, concatArray);
    }
    return result;
}
exports.consolidateProps = consolidateProps;
function overrideProps(DefaultProps, userProps, concatArray = false) {
    // Override the sensible defaults with user provided props
    if (concatArray) {
        return merge(DefaultProps, userProps, {
            arrayMerge: (destinationArray, sourceArray) => [...destinationArray, ...sourceArray],
        });
    }
    else {
        return merge(DefaultProps, userProps, {
            arrayMerge: (_destinationArray, sourceArray) => sourceArray, // underscore allows arg to be ignored
            isMergeableObject: utils_1.isPlainObject,
        });
    }
}
exports.overrideProps = overrideProps;
function getStepFnLambdaInvoke(cdkStack, id, lambdaFunction, outputPath = '$.Payload') {
    return new cdk.aws_stepfunctions_tasks.LambdaInvoke(cdkStack, id, {
        lambdaFunction,
        // Lambda's result in a field called "status" in the response
        outputPath,
    });
}
exports.getStepFnLambdaInvoke = getStepFnLambdaInvoke;
//# sourceMappingURL=data:application/json;base64,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