import * as cdk from 'aws-cdk-lib';
import { Table } from 'aws-cdk-lib/aws-dynamodb';
import { SecurityGroup, SecurityGroupProps } from 'aws-cdk-lib/aws-ec2';
import * as kendra from 'aws-cdk-lib/aws-kendra';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { StateMachine } from 'aws-cdk-lib/aws-stepfunctions';
import { Stack } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { SecurityGroupRuleDefinition } from '../../patterns/gen-ai/aws-rag-appsync-stepfn-kendra/types';
export declare function createS3DataSource(scope: Construct, targetIndex: kendra.CfnIndex, id: string, clientProps: Partial<kendra.CfnDataSourceProps>): kendra.CfnDataSource;
export declare function createKendraWorkflowStepFunction(cdkStack: Construct, updateKendraJobStatusFn: cdk.aws_lambda.IFunction, kendraSyncLambda: cdk.aws_lambda.IFunction, createCheckJobsStatusLambda: cdk.aws_lambda.IFunction): StateMachine;
export declare function getGeneratePresignedUrlLambdaRole(scope: Construct, bucket: Bucket): cdk.aws_iam.Role;
export declare function getStartKendraSyncStepFnRole(scope: Construct, stateMachine: StateMachine): cdk.aws_iam.Role;
export declare function getKendraStartDataSyncLambdaRole(scope: Construct, table: Table, awsRegion: string, awsAccountId: string, kendraIndexId: string, kendraDataSourceIndexId: string): cdk.aws_iam.Role;
export declare function getCheckJobStatusLambdaRole(scope: Construct, awsRegion: string, awsAccountId: string, kendraIndexId: string, kendraDataSourceIndexId: string): cdk.aws_iam.Role;
export declare function getUpdateKendraJobStatusLambdaRole(scope: Construct, table: Table): cdk.aws_iam.Role;
export declare function createStepFunctionsExecutionHandlerRole(cdkStack: Construct, docProcessingStateMachine: StateMachine): cdk.aws_iam.Role;
export declare function buildSecurityGroup(scope: Construct, name: string, props: SecurityGroupProps, ingressRules: SecurityGroupRuleDefinition[], egressRules: SecurityGroupRuleDefinition[]): SecurityGroup;
export declare function createS3FileUploader(cdkStack: Stack, s3_bucket: Bucket, props: cdk.aws_lambda.DockerImageFunctionProps): cdk.aws_lambda.DockerImageFunction;
export declare function createGeneratePresignedUrlFn(cdkStack: Stack, bucket: Bucket, environment: {
    [p: string]: string;
}): cdk.aws_lambda.Function;
