"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRolePolicies = exports.createIAMRoleWithBasicExecutionPolicy = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
function createIAMRoleWithBasicExecutionPolicy(cdkStack, roleId, roleDescription) {
    const role = new cdk.aws_iam.Role(cdkStack, roleId, {
        description: roleDescription,
        assumedBy: new cdk.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
    });
    role.addManagedPolicy(cdk.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'));
    return role;
}
exports.createIAMRoleWithBasicExecutionPolicy = createIAMRoleWithBasicExecutionPolicy;
function addRolePolicies(role, statements) {
    statements.forEach(props => {
        role.addToPolicy(new cdk.aws_iam.PolicyStatement(props));
    });
    return role;
}
exports.addRolePolicies = addRolePolicies;
//# sourceMappingURL=data:application/json;base64,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