import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as cr from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
export interface CRProviderProps {
    /**
     * A globally unique name for the Custom Resource provider.
     *
     * @default - None.
     */
    readonly providerName: string;
    /**
     * Path to custom resource provider Lambda code. The package will be built using lambda.Code.fromDockerBuild().
     *
     * @default - None.
     */
    readonly codePath: string;
    /**
     * The name of the Lambda handler function.
     *
     * @default - None.
     */
    readonly handler: string;
    /**
     * The runtime of the Lambda function.
     *
     * @default - None.
     */
    readonly runtime: lambda.Runtime;
    /**
     * The list of layers to attach to the Lambda function.
     *
     * @default - None.
     */
    readonly layers?: lambda.ILayerVersion[];
    /**
     * The VPC to deploy Lambda function into.
     *
     * @default - None.
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The security group for Lambda function.
     *
     * @default - None.
     */
    readonly securityGroup?: ec2.SecurityGroup;
}
export interface ICRProvider {
    role: iam.Role;
    provider: cr.Provider;
    serviceToken: string;
}
export interface ICRProviderClass {
    getProvider(scope: Construct): ICRProvider;
}
export declare function buildCustomResourceProvider(props: CRProviderProps): ICRProviderClass;
