"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const appsync = require("aws-cdk-lib/aws-appsync");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const construct_name_enum_1 = require("./construct-name-enum");
const utils_1 = require("../helpers/utils");
class BaseClass extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        /**
         * construct usage metric , added in template description
         */
        this.constructUsageMetric = 'uksb-1tupboc45';
        /**
         * enable disable lambda tracing
         *
         * @default - Active
         */
        this.lambdaTracing = lambda.Tracing.ACTIVE;
        /**
         * enable disable xray tracing
         *
         * @default - True
         */
        this.enablexray = true;
        /**
         * Default  log config for all constructs
         */
        this.fieldLogLevel = appsync.FieldLogLevel.ALL;
        /**
         * Default  log retention config for all constructs
         */
        this.retention = logs.RetentionDays.TEN_YEARS;
    }
    //overwrite default env suffix
    updateEnvSuffix(props) {
        let stage = '-dev';
        if (props?.stage) {
            stage = props.stage;
        }
        this.stage = stage;
    }
    /*
    * update template description with construct usage metric and
    * add AWS_SDK_UA_APP_ID to user agent on aws sdk.
    */
    updateConstructUsageMetricCode(props, scope, lambdaFunctions) {
        const solutionId = `genai_cdk_${utils_1.version}/${props.constructName}/${props.constructId}`;
        if (lambdaFunctions
            && lambdaFunctions.length > 0) {
            for (let lambdaFunction of lambdaFunctions) {
                lambdaFunction.addEnvironment('AWS_SDK_UA_APP_ID', solutionId);
            }
        }
        if (props && BaseClass.usageMetricMap.hasOwnProperty(props.constructName)) {
            BaseClass.usageMetricMap[props.constructName] = BaseClass.usageMetricMap[props.constructName] + 1;
        }
        else {
            throw Error('construct name is not present in usageMetricMap ');
        }
        const usageMetricMapSerialized = JSON.stringify(BaseClass.usageMetricMap).replace(/[{}]/g, '').replace(/"/g, '');
        // Description format :(usage id :uksb-1tupboc45)(version:0.0.0) (constructs :::{\"C1\":1,\"C2\":5,\"C3\":3,\"C4\":0,\"C5\":0,\"C6\":0,\"C7\":0,\"C8\":0}) ",
        // where C1,C2, etc are mapped with construct-name-enum and the values shows the number of time stack created/deleted.
        aws_cdk_lib_1.Stack.of(scope).templateOptions.description =
            `Description: (${this.constructUsageMetric}) (version:${utils_1.version}) (tag:${usageMetricMapSerialized}) `;
    }
    // observability
    addObservabilityToConstruct(props) {
        if (props.observability == false) {
            this.enablexray = false;
            this.lambdaTracing = lambda.Tracing.DISABLED;
            this.fieldLogLevel = appsync.FieldLogLevel.NONE;
            this.retention = logs.RetentionDays.TEN_YEARS;
        }
        ;
    }
}
exports.BaseClass = BaseClass;
_a = JSII_RTTI_SYMBOL_1;
BaseClass[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.BaseClass", version: "0.1.198" };
/**
 * Record<string, number> , maps construct name with number of deployments
 */
BaseClass.usageMetricMap = {
    [construct_name_enum_1.ConstructName.AWSRAGAPPSYNCSTEPFNOPENSEARCH]: 0,
    [construct_name_enum_1.ConstructName.AWSQAAPPSYNCOPENSEARCH]: 0,
    [construct_name_enum_1.ConstructName.AWSSUMMARIZATIONAPPSYNCSTEPFN]: 0,
    [construct_name_enum_1.ConstructName.AWSMODELDEPLOYMENTSAGEMAKER]: 0,
    [construct_name_enum_1.ConstructName.CUSTOMSAGEMAKERENDPOINT]: 0,
    [construct_name_enum_1.ConstructName.HUGGINGFACESAGEMAKERENDPOINT]: 0,
    [construct_name_enum_1.ConstructName.JUMPSTARTSAGEMAKERENDPOINT]: 0,
    [construct_name_enum_1.ConstructName.AWSCONTENTGENAPPSYNCLAMBDA]: 0,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1jbGFzcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21tb24vYmFzZS1jbGFzcy9iYXNlLWNsYXNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7QUFDSCw2Q0FBb0M7QUFDcEMsbURBQW1EO0FBQ25ELGlEQUFpRDtBQUNqRCw2Q0FBNkM7QUFDN0MsMkNBQXVDO0FBQ3ZDLCtEQUFzRDtBQUN0RCw0Q0FBMkM7QUFnQzNDLE1BQWEsU0FBVSxTQUFRLHNCQUFTO0lBc0R0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBdENuQjs7V0FFRztRQUNNLHlCQUFvQixHQUFHLGdCQUFnQixDQUFDO1FBU2pEOzs7O1dBSUc7UUFDSCxrQkFBYSxHQUFpQixNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztRQUVwRDs7OztXQUlHO1FBQ0gsZUFBVSxHQUFZLElBQUksQ0FBQztRQUUzQjs7V0FFRztRQUNILGtCQUFhLEdBQXVCLE9BQU8sQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDO1FBRTlEOztXQUVHO1FBQ0gsY0FBUyxHQUFxQixJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQztJQU0zRCxDQUFDO0lBRUQsOEJBQThCO0lBQ3BCLGVBQWUsQ0FBQyxLQUFxQjtRQUM3QyxJQUFJLEtBQUssR0FBRyxNQUFNLENBQUM7UUFDbkIsSUFBSSxLQUFLLEVBQUUsS0FBSyxFQUFFLENBQUM7WUFDakIsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7UUFDdEIsQ0FBQztRQUNELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFFRDs7O01BR0U7SUFDUSw4QkFBOEIsQ0FBQyxLQUFxQixFQUFFLEtBQWdCLEVBQUUsZUFBNkM7UUFFN0gsTUFBTSxVQUFVLEdBQUcsYUFBYSxlQUFPLElBQUksS0FBSyxDQUFDLGFBQWEsSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFFdEYsSUFBSSxlQUFlO2VBQ1osZUFBZSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNsQyxLQUFLLElBQUksY0FBYyxJQUFJLGVBQWUsRUFBRSxDQUFDO2dCQUMzQyxjQUFjLENBQUMsY0FBYyxDQUMzQixtQkFBbUIsRUFBRSxVQUFVLENBQ2hDLENBQUM7WUFDSixDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksS0FBSyxJQUFJLFNBQVMsQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDO1lBQzFFLFNBQVMsQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxHQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxHQUFDLENBQUMsQ0FBQztRQUNoRyxDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sS0FBSyxDQUFDLGtEQUFrRCxDQUFDLENBQUM7UUFDbEUsQ0FBQztRQUVELE1BQU0sd0JBQXdCLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpILDZKQUE2SjtRQUM3SixzSEFBc0g7UUFDdEgsbUJBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsZUFBZSxDQUFDLFdBQVc7WUFDM0MsaUJBQWlCLElBQUksQ0FBQyxvQkFBb0IsY0FBYyxlQUFPLFVBQVcsd0JBQXdCLElBQUksQ0FBQztJQUV6RyxDQUFDO0lBRUQsZ0JBQWdCO0lBQ04sMkJBQTJCLENBQUMsS0FBcUI7UUFDekQsSUFBSSxLQUFLLENBQUMsYUFBYSxJQUFJLEtBQUssRUFBRSxDQUFDO1lBQ2pDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1lBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUM7WUFDN0MsSUFBSSxDQUFDLGFBQWEsR0FBRSxPQUFPLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztZQUMvQyxJQUFJLENBQUMsU0FBUyxHQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDO1FBQy9DLENBQUM7UUFBQSxDQUFDO0lBQ0osQ0FBQzs7QUE1R0gsOEJBNkdDOzs7QUEzR0M7O0dBRUc7QUFDYyx3QkFBYyxHQUEyQjtJQUN4RCxDQUFDLG1DQUFhLENBQUMsNkJBQTZCLENBQUMsRUFBRSxDQUFDO0lBQ2hELENBQUMsbUNBQWEsQ0FBQyxzQkFBc0IsQ0FBQyxFQUFFLENBQUM7SUFDekMsQ0FBQyxtQ0FBYSxDQUFDLDZCQUE2QixDQUFDLEVBQUUsQ0FBQztJQUNoRCxDQUFDLG1DQUFhLENBQUMsMkJBQTJCLENBQUMsRUFBRSxDQUFDO0lBQzlDLENBQUMsbUNBQWEsQ0FBQyx1QkFBdUIsQ0FBQyxFQUFFLENBQUM7SUFDMUMsQ0FBQyxtQ0FBYSxDQUFDLDRCQUE0QixDQUFDLEVBQUUsQ0FBQztJQUMvQyxDQUFDLG1DQUFhLENBQUMsMEJBQTBCLENBQUMsRUFBRSxDQUFDO0lBQzdDLENBQUMsbUNBQWEsQ0FBQywwQkFBMEIsQ0FBQyxFQUFFLENBQUM7Q0FDOUMsQUFUOEIsQ0FTN0IiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBhcHBzeW5jIGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcHBzeW5jJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxvZ3MnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3ROYW1lIH0gZnJvbSAnLi9jb25zdHJ1Y3QtbmFtZS1lbnVtJztcbmltcG9ydCB7IHZlcnNpb24gfSBmcm9tICcuLi9oZWxwZXJzL3V0aWxzJztcblxuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VDbGFzc1Byb3BzIHtcbiAgLyoqXG4gICAqIFZhbHVlIHdpbGwgYmUgYXBwZW5kZWQgdG8gcmVzb3VyY2VzIG5hbWUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gX2RldlxuICAgKi9cbiAgcmVhZG9ubHkgc3RhZ2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIG5hbWUgb2YgdGhlIGNvbnN0cnVjdC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGNvbnN0cnVjdE5hbWU6IENvbnN0cnVjdE5hbWU7XG5cbiAgLyoqXG4gICAqIGNvbnN0cnVjdCBpZC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGNvbnN0cnVjdElkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEVuYWJsZSBvYnNlcnZhYmlsaXR5LiBXYXJuaW5nOiBhc3NvY2lhdGVkIGNvc3Qgd2l0aCB0aGUgc2VydmljZXNcbiAgICogdXNlZC4gQmVzdCBwcmFjdGljZSB0byBlbmFibGUgYnkgZGVmYXVsdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0cnVlXG4gICAqL1xuICByZWFkb25seSBvYnNlcnZhYmlsaXR5PzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIEJhc2VDbGFzcyBleHRlbmRzIENvbnN0cnVjdCB7XG5cbiAgLyoqXG4gICAqIFJlY29yZDxzdHJpbmcsIG51bWJlcj4gLCBtYXBzIGNvbnN0cnVjdCBuYW1lIHdpdGggbnVtYmVyIG9mIGRlcGxveW1lbnRzXG4gICAqL1xuICBwcm90ZWN0ZWQgc3RhdGljIHVzYWdlTWV0cmljTWFwIDogUmVjb3JkPHN0cmluZywgbnVtYmVyPiA9e1xuICAgIFtDb25zdHJ1Y3ROYW1lLkFXU1JBR0FQUFNZTkNTVEVQRk5PUEVOU0VBUkNIXTogMCxcbiAgICBbQ29uc3RydWN0TmFtZS5BV1NRQUFQUFNZTkNPUEVOU0VBUkNIXTogMCxcbiAgICBbQ29uc3RydWN0TmFtZS5BV1NTVU1NQVJJWkFUSU9OQVBQU1lOQ1NURVBGTl06IDAsXG4gICAgW0NvbnN0cnVjdE5hbWUuQVdTTU9ERUxERVBMT1lNRU5UU0FHRU1BS0VSXTogMCxcbiAgICBbQ29uc3RydWN0TmFtZS5DVVNUT01TQUdFTUFLRVJFTkRQT0lOVF06IDAsXG4gICAgW0NvbnN0cnVjdE5hbWUuSFVHR0lOR0ZBQ0VTQUdFTUFLRVJFTkRQT0lOVF06IDAsXG4gICAgW0NvbnN0cnVjdE5hbWUuSlVNUFNUQVJUU0FHRU1BS0VSRU5EUE9JTlRdOiAwLFxuICAgIFtDb25zdHJ1Y3ROYW1lLkFXU0NPTlRFTlRHRU5BUFBTWU5DTEFNQkRBXTogMCxcbiAgfTtcblxuXG4gIC8qKlxuICAgKiBjb25zdHJ1Y3QgdXNhZ2UgbWV0cmljICwgYWRkZWQgaW4gdGVtcGxhdGUgZGVzY3JpcHRpb25cbiAgICovXG4gIHJlYWRvbmx5IGNvbnN0cnVjdFVzYWdlTWV0cmljID0gJ3Vrc2ItMXR1cGJvYzQ1JztcblxuICAvKipcbiAgICogVmFsdWUgd2lsbCBiZSBhcHBlbmRlZCB0byByZXNvdXJjZXMgbmFtZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBfZGV2XG4gICAqL1xuICBzdGFnZSE6IHN0cmluZztcblxuICAvKipcbiAgICogZW5hYmxlIGRpc2FibGUgbGFtYmRhIHRyYWNpbmdcbiAgICpcbiAgICogQGRlZmF1bHQgLSBBY3RpdmVcbiAgICovXG4gIGxhbWJkYVRyYWNpbmc6IGxhbWJkYS5UcmFjaW5nPWxhbWJkYS5UcmFjaW5nLkFDVElWRTtcblxuICAvKipcbiAgICogZW5hYmxlIGRpc2FibGUgeHJheSB0cmFjaW5nXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gVHJ1ZVxuICAgKi9cbiAgZW5hYmxleHJheTogYm9vbGVhbiA9IHRydWU7XG5cbiAgLyoqXG4gICAqIERlZmF1bHQgIGxvZyBjb25maWcgZm9yIGFsbCBjb25zdHJ1Y3RzXG4gICAqL1xuICBmaWVsZExvZ0xldmVsOmFwcHN5bmMuRmllbGRMb2dMZXZlbD1hcHBzeW5jLkZpZWxkTG9nTGV2ZWwuQUxMO1xuXG4gIC8qKlxuICAgKiBEZWZhdWx0ICBsb2cgcmV0ZW50aW9uIGNvbmZpZyBmb3IgYWxsIGNvbnN0cnVjdHNcbiAgICovXG4gIHJldGVudGlvbjogbG9ncy5SZXRlbnRpb25EYXlzPWxvZ3MuUmV0ZW50aW9uRGF5cy5URU5fWUVBUlM7XG5cblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICB9XG5cbiAgLy9vdmVyd3JpdGUgZGVmYXVsdCBlbnYgc3VmZml4XG4gIHByb3RlY3RlZCB1cGRhdGVFbnZTdWZmaXgocHJvcHM6IEJhc2VDbGFzc1Byb3BzKSB7XG4gICAgbGV0IHN0YWdlID0gJy1kZXYnO1xuICAgIGlmIChwcm9wcz8uc3RhZ2UpIHtcbiAgICAgIHN0YWdlID0gcHJvcHMuc3RhZ2U7XG4gICAgfVxuICAgIHRoaXMuc3RhZ2UgPSBzdGFnZTtcbiAgfVxuXG4gIC8qXG4gICogdXBkYXRlIHRlbXBsYXRlIGRlc2NyaXB0aW9uIHdpdGggY29uc3RydWN0IHVzYWdlIG1ldHJpYyBhbmRcbiAgKiBhZGQgQVdTX1NES19VQV9BUFBfSUQgdG8gdXNlciBhZ2VudCBvbiBhd3Mgc2RrLlxuICAqL1xuICBwcm90ZWN0ZWQgdXBkYXRlQ29uc3RydWN0VXNhZ2VNZXRyaWNDb2RlKHByb3BzOiBCYXNlQ2xhc3NQcm9wcywgc2NvcGU6IENvbnN0cnVjdCwgbGFtYmRhRnVuY3Rpb25zOiBsYW1iZGEuRG9ja2VySW1hZ2VGdW5jdGlvbltdLFxuICApIHtcbiAgICBjb25zdCBzb2x1dGlvbklkID0gYGdlbmFpX2Nka18ke3ZlcnNpb259LyR7cHJvcHMuY29uc3RydWN0TmFtZX0vJHtwcm9wcy5jb25zdHJ1Y3RJZH1gO1xuXG4gICAgaWYgKGxhbWJkYUZ1bmN0aW9uc1xuICAgICAgICAmJiBsYW1iZGFGdW5jdGlvbnMubGVuZ3RoID4gMCkge1xuICAgICAgZm9yIChsZXQgbGFtYmRhRnVuY3Rpb24gb2YgbGFtYmRhRnVuY3Rpb25zKSB7XG4gICAgICAgIGxhbWJkYUZ1bmN0aW9uLmFkZEVudmlyb25tZW50KFxuICAgICAgICAgICdBV1NfU0RLX1VBX0FQUF9JRCcsIHNvbHV0aW9uSWQsXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHByb3BzICYmIEJhc2VDbGFzcy51c2FnZU1ldHJpY01hcC5oYXNPd25Qcm9wZXJ0eShwcm9wcy5jb25zdHJ1Y3ROYW1lKSkge1xuICAgICAgQmFzZUNsYXNzLnVzYWdlTWV0cmljTWFwW3Byb3BzLmNvbnN0cnVjdE5hbWVdPUJhc2VDbGFzcy51c2FnZU1ldHJpY01hcFtwcm9wcy5jb25zdHJ1Y3ROYW1lXSsxO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBFcnJvcignY29uc3RydWN0IG5hbWUgaXMgbm90IHByZXNlbnQgaW4gdXNhZ2VNZXRyaWNNYXAgJyk7XG4gICAgfVxuXG4gICAgY29uc3QgdXNhZ2VNZXRyaWNNYXBTZXJpYWxpemVkID0gSlNPTi5zdHJpbmdpZnkoQmFzZUNsYXNzLnVzYWdlTWV0cmljTWFwKS5yZXBsYWNlKC9be31dL2csICcnKS5yZXBsYWNlKC9cIi9nLCAnJyk7XG5cbiAgICAvLyBEZXNjcmlwdGlvbiBmb3JtYXQgOih1c2FnZSBpZCA6dWtzYi0xdHVwYm9jNDUpKHZlcnNpb246MC4wLjApIChjb25zdHJ1Y3RzIDo6OntcXFwiQzFcXFwiOjEsXFxcIkMyXFxcIjo1LFxcXCJDM1xcXCI6MyxcXFwiQzRcXFwiOjAsXFxcIkM1XFxcIjowLFxcXCJDNlxcXCI6MCxcXFwiQzdcXFwiOjAsXFxcIkM4XFxcIjowfSkgXCIsXG4gICAgLy8gd2hlcmUgQzEsQzIsIGV0YyBhcmUgbWFwcGVkIHdpdGggY29uc3RydWN0LW5hbWUtZW51bSBhbmQgdGhlIHZhbHVlcyBzaG93cyB0aGUgbnVtYmVyIG9mIHRpbWUgc3RhY2sgY3JlYXRlZC9kZWxldGVkLlxuICAgIFN0YWNrLm9mKHNjb3BlKS50ZW1wbGF0ZU9wdGlvbnMuZGVzY3JpcHRpb24gPVxuICAgIGBEZXNjcmlwdGlvbjogKCR7dGhpcy5jb25zdHJ1Y3RVc2FnZU1ldHJpY30pICh2ZXJzaW9uOiR7dmVyc2lvbn0pICh0YWc6JHsgdXNhZ2VNZXRyaWNNYXBTZXJpYWxpemVkfSkgYDtcblxuICB9XG5cbiAgLy8gb2JzZXJ2YWJpbGl0eVxuICBwcm90ZWN0ZWQgYWRkT2JzZXJ2YWJpbGl0eVRvQ29uc3RydWN0KHByb3BzOiBCYXNlQ2xhc3NQcm9wcykge1xuICAgIGlmIChwcm9wcy5vYnNlcnZhYmlsaXR5ID09IGZhbHNlKSB7XG4gICAgICB0aGlzLmVuYWJsZXhyYXkgPSBmYWxzZTtcbiAgICAgIHRoaXMubGFtYmRhVHJhY2luZyA9IGxhbWJkYS5UcmFjaW5nLkRJU0FCTEVEO1xuICAgICAgdGhpcy5maWVsZExvZ0xldmVsPSBhcHBzeW5jLkZpZWxkTG9nTGV2ZWwuTk9ORTtcbiAgICAgIHRoaXMucmV0ZW50aW9uPSBsb2dzLlJldGVudGlvbkRheXMuVEVOX1lFQVJTO1xuICAgIH07XG4gIH1cbn1cbiJdfQ==