import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as logs from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { ConstructName } from './construct-name-enum';
export interface BaseClassProps {
    /**
     * Value will be appended to resources name.
     *
     * @default - _dev
     */
    readonly stage?: string;
    /**
     * name of the construct.
     *
     */
    readonly constructName: ConstructName;
    /**
     * construct id.
     *
     */
    readonly constructId: string;
    /**
     * Enable observability. Warning: associated cost with the services
     * used. Best practice to enable by default.
     *
     * @default - true
     */
    readonly observability?: boolean;
}
export declare class BaseClass extends Construct {
    /**
     * Record<string, number> , maps construct name with number of deployments
     */
    protected static usageMetricMap: Record<string, number>;
    /**
     * construct usage metric , added in template description
     */
    readonly constructUsageMetric = "uksb-1tupboc45";
    /**
     * Value will be appended to resources name.
     *
     * @default - _dev
     */
    stage: string;
    /**
     * enable disable lambda tracing
     *
     * @default - Active
     */
    lambdaTracing: lambda.Tracing;
    /**
     * enable disable xray tracing
     *
     * @default - True
     */
    enablexray: boolean;
    /**
     * Default  log config for all constructs
     */
    fieldLogLevel: appsync.FieldLogLevel;
    /**
     * Default  log retention config for all constructs
     */
    retention: logs.RetentionDays;
    constructor(scope: Construct, id: string);
    protected updateEnvSuffix(props: BaseClassProps): void;
    protected updateConstructUsageMetricCode(props: BaseClassProps, scope: Construct, lambdaFunctions: lambda.DockerImageFunction[]): void;
    protected addObservabilityToConstruct(props: BaseClassProps): void;
}
