"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
class Topic extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.topicConfigList = [];
    }
    financialAdviceTopic(props) {
        this.createTopic({
            name: props?.name ?? 'Financial_Advice',
            definition: props?.definition ?? 'Discussions that involve providing guidance, recommendations, or suggestions related to managing, investing, or handling finances, investments, or assets.',
            examples: props?.examples ?? [
                'Can you suggest some good stocks to invest in right now?',
                "What's the best way to save for retirement?",
                'Should I put my money in a high-risk investment?',
                'How can I maximize my returns on investments?',
                'Is it a good time to buy real estate?',
            ],
            type: props?.type ?? 'DENY',
        });
    }
    politicalAdviceTopic(props) {
        this.createTopic({
            name: props?.name ?? 'Political_Advice',
            definition: props?.definition ?? 'Conversations that express views, opinions, or endorsements related to political parties, political ideologies, elections, or political figures.',
            examples: props?.examples ?? [
                "What's your stance on the current government policies?",
                'Do you support party X or Y in the upcoming election?',
                'Can you tell me which political party is better?',
                'What do you think about the new policy introduced by the president?',
                'Should I vote for this candidate?',
            ],
            type: props?.type ?? 'DENY',
        });
    }
    medicalAdvice(props) {
        this.createTopic({
            name: props?.name ?? 'Medical_Advice',
            definition: props?.definition ?? 'Providing recommendations, diagnosis, treatment options, or guidance on medical conditions, symptoms, medications, or health-related issues.',
            examples: props?.examples ?? [
                'What should I do to treat a persistent cough?',
                'Can you recommend some medication for my headache?',
                'What are the symptoms of a specific medical condition?',
                'Is this drug effective for treating my illness?',
                "Do I need to see a doctor for this pain I'm experiencing?",
            ],
            type: props?.type ?? 'DENY',
        });
    }
    inappropriateContent(props) {
        this.createTopic({
            name: props?.name ?? 'Inappropriate_Content',
            definition: props?.definition ?? 'Any discussions or references that include hate speech, discriminatory remarks, sexual content, or explicit language.',
            examples: props?.examples ?? [
                'Why are people from X country so [discriminatory remark]?',
                'Can you tell me a dirty joke?',
                '[Use of explicit language]',
                'This service is as bad as [hate speech].',
                'Do you have any adult content or products?',
            ],
            type: props?.type ?? 'DENY',
        });
    }
    legalAdvice(props) {
        this.createTopic({
            name: props?.name ?? 'Legal_Advice',
            definition: props?.definition ?? 'Offering guidance or suggestions on legal matters, legal actions, interpretation of laws, or legal rights and responsibilities.',
            examples: props?.examples ?? [
                'Can I sue someone for this?',
                'What are my legal rights in this situation?',
                'Is this action against the law?',
                'What should I do to file a legal complaint?',
                'Can you explain this law to me?',
            ],
            type: props?.type ?? 'DENY',
        });
    }
    createTopic(props) {
        const topicConfig = {
            definition: props.definition || '',
            name: props.name || '',
            type: props.type || '',
            examples: props.examples || [],
        };
        this.topicConfigList.push(topicConfig);
    }
    topicConfigPropertyList() {
        return this.topicConfigList;
    }
}
exports.Topic = Topic;
_a = JSII_RTTI_SYMBOL_1;
Topic[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.Topic", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMtbGlzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jZGstbGliL2JlZHJvY2svdG9waWMtbGlzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWNBLDJDQUF1QztBQVN2QyxNQUFhLEtBQU0sU0FBUSxzQkFBUztJQUdsQyxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxlQUFlLEdBQUcsRUFBRSxDQUFDO0lBQzVCLENBQUM7SUFFTSxvQkFBb0IsQ0FBQyxLQUFrQjtRQUM1QyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ2YsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLElBQUksa0JBQWtCO1lBQ3ZDLFVBQVUsRUFBRSxLQUFLLEVBQUUsVUFBVSxJQUFJLDRKQUE0SjtZQUM3TCxRQUFRLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSTtnQkFDM0IsMERBQTBEO2dCQUMxRCw2Q0FBNkM7Z0JBQzdDLGtEQUFrRDtnQkFDbEQsK0NBQStDO2dCQUMvQyx1Q0FBdUM7YUFDeEM7WUFDRCxJQUFJLEVBQUUsS0FBSyxFQUFFLElBQUksSUFBSSxNQUFNO1NBQzVCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxvQkFBb0IsQ0FBQyxLQUFrQjtRQUM1QyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ2YsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLElBQUksa0JBQWtCO1lBQ3ZDLFVBQVUsRUFBRSxLQUFLLEVBQUUsVUFBVSxJQUFJLGtKQUFrSjtZQUNuTCxRQUFRLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSTtnQkFDM0Isd0RBQXdEO2dCQUN4RCx1REFBdUQ7Z0JBQ3ZELGtEQUFrRDtnQkFDbEQscUVBQXFFO2dCQUNyRSxtQ0FBbUM7YUFDcEM7WUFDRCxJQUFJLEVBQUUsS0FBSyxFQUFFLElBQUksSUFBSSxNQUFNO1NBQzVCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxhQUFhLENBQUMsS0FBa0I7UUFDckMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUNmLElBQUksRUFBRSxLQUFLLEVBQUUsSUFBSSxJQUFJLGdCQUFnQjtZQUNyQyxVQUFVLEVBQUUsS0FBSyxFQUFFLFVBQVUsSUFBSSw4SUFBOEk7WUFDL0ssUUFBUSxFQUFFLEtBQUssRUFBRSxRQUFRLElBQUk7Z0JBQzNCLCtDQUErQztnQkFDL0Msb0RBQW9EO2dCQUNwRCx3REFBd0Q7Z0JBQ3hELGlEQUFpRDtnQkFDakQsMkRBQTJEO2FBRTVEO1lBQ0QsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLElBQUksTUFBTTtTQUM1QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sb0JBQW9CLENBQUMsS0FBa0I7UUFDNUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUNmLElBQUksRUFBRSxLQUFLLEVBQUUsSUFBSSxJQUFJLHVCQUF1QjtZQUM1QyxVQUFVLEVBQUUsS0FBSyxFQUFFLFVBQVUsSUFBSSx1SEFBdUg7WUFDeEosUUFBUSxFQUFFLEtBQUssRUFBRSxRQUFRLElBQUk7Z0JBQzNCLDJEQUEyRDtnQkFDM0QsK0JBQStCO2dCQUMvQiw0QkFBNEI7Z0JBQzVCLDBDQUEwQztnQkFDMUMsNENBQTRDO2FBRTdDO1lBQ0QsSUFBSSxFQUFFLEtBQUssRUFBRSxJQUFJLElBQUksTUFBTTtTQUM1QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sV0FBVyxDQUFDLEtBQWtCO1FBQ25DLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDZixJQUFJLEVBQUUsS0FBSyxFQUFFLElBQUksSUFBSSxjQUFjO1lBQ25DLFVBQVUsRUFBRSxLQUFLLEVBQUUsVUFBVSxJQUFJLGlJQUFpSTtZQUNsSyxRQUFRLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSTtnQkFDM0IsNkJBQTZCO2dCQUM3Qiw2Q0FBNkM7Z0JBQzdDLGlDQUFpQztnQkFDakMsNkNBQTZDO2dCQUM3QyxpQ0FBaUM7YUFFbEM7WUFDRCxJQUFJLEVBQUUsS0FBSyxFQUFFLElBQUksSUFBSSxNQUFNO1NBQzVCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxXQUFXLENBQUMsS0FBaUI7UUFDbEMsTUFBTSxXQUFXLEdBQTZDO1lBQzVELFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxJQUFJLEVBQUU7WUFDbEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJLElBQUksRUFBRTtZQUN0QixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUksSUFBSSxFQUFFO1lBQ3RCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxJQUFJLEVBQUU7U0FDL0IsQ0FBQztRQUNGLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7O0FBbEdILHNCQW1HQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IGF3c19iZWRyb2NrIGFzIGJlZHJvY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBUb3BpY1Byb3BzIHtcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGVmaW5pdGlvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgZXhhbXBsZXM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgdHlwZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFRvcGljIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHJpdmF0ZSByZWFkb25seSB0b3BpY0NvbmZpZ0xpc3Q6IGJlZHJvY2suQ2ZuR3VhcmRyYWlsLlRvcGljQ29uZmlnUHJvcGVydHlbXTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLnRvcGljQ29uZmlnTGlzdCA9IFtdO1xuICB9XG5cbiAgcHVibGljIGZpbmFuY2lhbEFkdmljZVRvcGljKHByb3BzPzogVG9waWNQcm9wcyk6IHZvaWQge1xuICAgIHRoaXMuY3JlYXRlVG9waWMoe1xuICAgICAgbmFtZTogcHJvcHM/Lm5hbWUgPz8gJ0ZpbmFuY2lhbF9BZHZpY2UnLFxuICAgICAgZGVmaW5pdGlvbjogcHJvcHM/LmRlZmluaXRpb24gPz8gJ0Rpc2N1c3Npb25zIHRoYXQgaW52b2x2ZSBwcm92aWRpbmcgZ3VpZGFuY2UsIHJlY29tbWVuZGF0aW9ucywgb3Igc3VnZ2VzdGlvbnMgcmVsYXRlZCB0byBtYW5hZ2luZywgaW52ZXN0aW5nLCBvciBoYW5kbGluZyBmaW5hbmNlcywgaW52ZXN0bWVudHMsIG9yIGFzc2V0cy4nLFxuICAgICAgZXhhbXBsZXM6IHByb3BzPy5leGFtcGxlcyA/PyBbXG4gICAgICAgICdDYW4geW91IHN1Z2dlc3Qgc29tZSBnb29kIHN0b2NrcyB0byBpbnZlc3QgaW4gcmlnaHQgbm93PycsXG4gICAgICAgIFwiV2hhdCdzIHRoZSBiZXN0IHdheSB0byBzYXZlIGZvciByZXRpcmVtZW50P1wiLFxuICAgICAgICAnU2hvdWxkIEkgcHV0IG15IG1vbmV5IGluIGEgaGlnaC1yaXNrIGludmVzdG1lbnQ/JyxcbiAgICAgICAgJ0hvdyBjYW4gSSBtYXhpbWl6ZSBteSByZXR1cm5zIG9uIGludmVzdG1lbnRzPycsXG4gICAgICAgICdJcyBpdCBhIGdvb2QgdGltZSB0byBidXkgcmVhbCBlc3RhdGU/JyxcbiAgICAgIF0sXG4gICAgICB0eXBlOiBwcm9wcz8udHlwZSA/PyAnREVOWScsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgcG9saXRpY2FsQWR2aWNlVG9waWMocHJvcHM/OiBUb3BpY1Byb3BzKTogdm9pZCB7XG4gICAgdGhpcy5jcmVhdGVUb3BpYyh7XG4gICAgICBuYW1lOiBwcm9wcz8ubmFtZSA/PyAnUG9saXRpY2FsX0FkdmljZScsXG4gICAgICBkZWZpbml0aW9uOiBwcm9wcz8uZGVmaW5pdGlvbiA/PyAnQ29udmVyc2F0aW9ucyB0aGF0IGV4cHJlc3Mgdmlld3MsIG9waW5pb25zLCBvciBlbmRvcnNlbWVudHMgcmVsYXRlZCB0byBwb2xpdGljYWwgcGFydGllcywgcG9saXRpY2FsIGlkZW9sb2dpZXMsIGVsZWN0aW9ucywgb3IgcG9saXRpY2FsIGZpZ3VyZXMuJyxcbiAgICAgIGV4YW1wbGVzOiBwcm9wcz8uZXhhbXBsZXMgPz8gW1xuICAgICAgICBcIldoYXQncyB5b3VyIHN0YW5jZSBvbiB0aGUgY3VycmVudCBnb3Zlcm5tZW50IHBvbGljaWVzP1wiLFxuICAgICAgICAnRG8geW91IHN1cHBvcnQgcGFydHkgWCBvciBZIGluIHRoZSB1cGNvbWluZyBlbGVjdGlvbj8nLFxuICAgICAgICAnQ2FuIHlvdSB0ZWxsIG1lIHdoaWNoIHBvbGl0aWNhbCBwYXJ0eSBpcyBiZXR0ZXI/JyxcbiAgICAgICAgJ1doYXQgZG8geW91IHRoaW5rIGFib3V0IHRoZSBuZXcgcG9saWN5IGludHJvZHVjZWQgYnkgdGhlIHByZXNpZGVudD8nLFxuICAgICAgICAnU2hvdWxkIEkgdm90ZSBmb3IgdGhpcyBjYW5kaWRhdGU/JyxcbiAgICAgIF0sXG4gICAgICB0eXBlOiBwcm9wcz8udHlwZSA/PyAnREVOWScsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgbWVkaWNhbEFkdmljZShwcm9wcz86IFRvcGljUHJvcHMpOiB2b2lkIHtcbiAgICB0aGlzLmNyZWF0ZVRvcGljKHtcbiAgICAgIG5hbWU6IHByb3BzPy5uYW1lID8/ICdNZWRpY2FsX0FkdmljZScsXG4gICAgICBkZWZpbml0aW9uOiBwcm9wcz8uZGVmaW5pdGlvbiA/PyAnUHJvdmlkaW5nIHJlY29tbWVuZGF0aW9ucywgZGlhZ25vc2lzLCB0cmVhdG1lbnQgb3B0aW9ucywgb3IgZ3VpZGFuY2Ugb24gbWVkaWNhbCBjb25kaXRpb25zLCBzeW1wdG9tcywgbWVkaWNhdGlvbnMsIG9yIGhlYWx0aC1yZWxhdGVkIGlzc3Vlcy4nLFxuICAgICAgZXhhbXBsZXM6IHByb3BzPy5leGFtcGxlcyA/PyBbXG4gICAgICAgICdXaGF0IHNob3VsZCBJIGRvIHRvIHRyZWF0IGEgcGVyc2lzdGVudCBjb3VnaD8nLFxuICAgICAgICAnQ2FuIHlvdSByZWNvbW1lbmQgc29tZSBtZWRpY2F0aW9uIGZvciBteSBoZWFkYWNoZT8nLFxuICAgICAgICAnV2hhdCBhcmUgdGhlIHN5bXB0b21zIG9mIGEgc3BlY2lmaWMgbWVkaWNhbCBjb25kaXRpb24/JyxcbiAgICAgICAgJ0lzIHRoaXMgZHJ1ZyBlZmZlY3RpdmUgZm9yIHRyZWF0aW5nIG15IGlsbG5lc3M/JyxcbiAgICAgICAgXCJEbyBJIG5lZWQgdG8gc2VlIGEgZG9jdG9yIGZvciB0aGlzIHBhaW4gSSdtIGV4cGVyaWVuY2luZz9cIixcblxuICAgICAgXSxcbiAgICAgIHR5cGU6IHByb3BzPy50eXBlID8/ICdERU5ZJyxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBpbmFwcHJvcHJpYXRlQ29udGVudChwcm9wcz86IFRvcGljUHJvcHMpOiB2b2lkIHtcbiAgICB0aGlzLmNyZWF0ZVRvcGljKHtcbiAgICAgIG5hbWU6IHByb3BzPy5uYW1lID8/ICdJbmFwcHJvcHJpYXRlX0NvbnRlbnQnLFxuICAgICAgZGVmaW5pdGlvbjogcHJvcHM/LmRlZmluaXRpb24gPz8gJ0FueSBkaXNjdXNzaW9ucyBvciByZWZlcmVuY2VzIHRoYXQgaW5jbHVkZSBoYXRlIHNwZWVjaCwgZGlzY3JpbWluYXRvcnkgcmVtYXJrcywgc2V4dWFsIGNvbnRlbnQsIG9yIGV4cGxpY2l0IGxhbmd1YWdlLicsXG4gICAgICBleGFtcGxlczogcHJvcHM/LmV4YW1wbGVzID8/IFtcbiAgICAgICAgJ1doeSBhcmUgcGVvcGxlIGZyb20gWCBjb3VudHJ5IHNvIFtkaXNjcmltaW5hdG9yeSByZW1hcmtdPycsXG4gICAgICAgICdDYW4geW91IHRlbGwgbWUgYSBkaXJ0eSBqb2tlPycsXG4gICAgICAgICdbVXNlIG9mIGV4cGxpY2l0IGxhbmd1YWdlXScsXG4gICAgICAgICdUaGlzIHNlcnZpY2UgaXMgYXMgYmFkIGFzIFtoYXRlIHNwZWVjaF0uJyxcbiAgICAgICAgJ0RvIHlvdSBoYXZlIGFueSBhZHVsdCBjb250ZW50IG9yIHByb2R1Y3RzPycsXG5cbiAgICAgIF0sXG4gICAgICB0eXBlOiBwcm9wcz8udHlwZSA/PyAnREVOWScsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgbGVnYWxBZHZpY2UocHJvcHM/OiBUb3BpY1Byb3BzKTogdm9pZCB7XG4gICAgdGhpcy5jcmVhdGVUb3BpYyh7XG4gICAgICBuYW1lOiBwcm9wcz8ubmFtZSA/PyAnTGVnYWxfQWR2aWNlJyxcbiAgICAgIGRlZmluaXRpb246IHByb3BzPy5kZWZpbml0aW9uID8/ICdPZmZlcmluZyBndWlkYW5jZSBvciBzdWdnZXN0aW9ucyBvbiBsZWdhbCBtYXR0ZXJzLCBsZWdhbCBhY3Rpb25zLCBpbnRlcnByZXRhdGlvbiBvZiBsYXdzLCBvciBsZWdhbCByaWdodHMgYW5kIHJlc3BvbnNpYmlsaXRpZXMuJyxcbiAgICAgIGV4YW1wbGVzOiBwcm9wcz8uZXhhbXBsZXMgPz8gW1xuICAgICAgICAnQ2FuIEkgc3VlIHNvbWVvbmUgZm9yIHRoaXM/JyxcbiAgICAgICAgJ1doYXQgYXJlIG15IGxlZ2FsIHJpZ2h0cyBpbiB0aGlzIHNpdHVhdGlvbj8nLFxuICAgICAgICAnSXMgdGhpcyBhY3Rpb24gYWdhaW5zdCB0aGUgbGF3PycsXG4gICAgICAgICdXaGF0IHNob3VsZCBJIGRvIHRvIGZpbGUgYSBsZWdhbCBjb21wbGFpbnQ/JyxcbiAgICAgICAgJ0NhbiB5b3UgZXhwbGFpbiB0aGlzIGxhdyB0byBtZT8nLFxuXG4gICAgICBdLFxuICAgICAgdHlwZTogcHJvcHM/LnR5cGUgPz8gJ0RFTlknLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGNyZWF0ZVRvcGljKHByb3BzOiBUb3BpY1Byb3BzKTogdm9pZCB7XG4gICAgY29uc3QgdG9waWNDb25maWc6IGJlZHJvY2suQ2ZuR3VhcmRyYWlsLlRvcGljQ29uZmlnUHJvcGVydHkgPSB7XG4gICAgICBkZWZpbml0aW9uOiBwcm9wcy5kZWZpbml0aW9uIHx8ICcnLFxuICAgICAgbmFtZTogcHJvcHMubmFtZSB8fCAnJyxcbiAgICAgIHR5cGU6IHByb3BzLnR5cGUgfHwgJycsXG4gICAgICBleGFtcGxlczogcHJvcHMuZXhhbXBsZXMgfHwgW10sXG4gICAgfTtcbiAgICB0aGlzLnRvcGljQ29uZmlnTGlzdC5wdXNoKHRvcGljQ29uZmlnKTtcbiAgfVxuXG4gIHB1YmxpYyB0b3BpY0NvbmZpZ1Byb3BlcnR5TGlzdCgpOiBiZWRyb2NrLkNmbkd1YXJkcmFpbC5Ub3BpY0NvbmZpZ1Byb3BlcnR5W10ge1xuICAgIHJldHVybiB0aGlzLnRvcGljQ29uZmlnTGlzdDtcbiAgfVxufVxuIl19