/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { aws_bedrock as bedrock } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface TopicProps {
    readonly name?: string;
    readonly definition?: string;
    readonly examples?: string[];
    readonly type?: string;
}
export declare class Topic extends Construct {
    private readonly topicConfigList;
    constructor(scope: Construct, id: string);
    financialAdviceTopic(props?: TopicProps): void;
    politicalAdviceTopic(props?: TopicProps): void;
    medicalAdvice(props?: TopicProps): void;
    inappropriateContent(props?: TopicProps): void;
    legalAdvice(props?: TopicProps): void;
    createTopic(props: TopicProps): void;
    topicConfigPropertyList(): bedrock.CfnGuardrail.TopicConfigProperty[];
}
