"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SensitiveInformationPolicyConfig = exports.PiiEntitiesConfigAction = exports.UKSpecific = exports.CanadaSpecific = exports.USASpecific = exports.InformationTechnology = exports.Finance = exports.General = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
// Enum for Personally Identifiable Information (PersonalIdentifiableInformation) types
var General;
(function (General) {
    General["ADDRESS"] = "ADDRESS";
    General["AGE"] = "AGE";
    General["DRIVER_ID"] = "DRIVER_ID";
    General["EMAIL"] = "EMAIL";
    General["LICENSE_PLATE"] = "LICENSE_PLATE";
    General["NAME"] = "NAME";
    General["PASSWORD"] = "PASSWORD";
    General["PHONE"] = "PHONE";
    General["USERNAME"] = "USERNAME";
    General["VEHICLE_IDENTIFICATION_NUMBER"] = "VEHICLE_IDENTIFICATION_NUMBER";
})(General || (exports.General = General = {}));
var Finance;
(function (Finance) {
    Finance["CREDIT_DEBIT_CARD_CVV"] = "CREDIT_DEBIT_CARD_CVV";
    Finance["CREDIT_DEBIT_CARD_EXPIRY"] = "CREDIT_DEBIT_CARD_EXPIRY";
    Finance["CREDIT_DEBIT_CARD_NUMBER"] = "CREDIT_DEBIT_CARD_NUMBER";
    Finance["PIN"] = "PIN";
    Finance["SWIFT_CODE"] = "SWIFT_CODE";
    Finance["INTERNATIONAL_BANK_ACCOUNT_NUMBER"] = "INTERNATIONAL_BANK_ACCOUNT_NUMBER";
})(Finance || (exports.Finance = Finance = {}));
var InformationTechnology;
(function (InformationTechnology) {
    InformationTechnology["URL"] = "URL";
    InformationTechnology["IP_ADDRESS"] = "IP_ADDRESS";
    InformationTechnology["MAC_ADDRESS"] = "MAC_ADDRESS";
    InformationTechnology["AWS_ACCESS_KEY"] = "AWS_ACCESS_KEY";
    InformationTechnology["AWS_SECRET_KEY"] = "AWS_SECRET_KEY";
})(InformationTechnology || (exports.InformationTechnology = InformationTechnology = {}));
var USASpecific;
(function (USASpecific) {
    USASpecific["US_BANK_ACCOUNT_NUMBER"] = "US_BANK_ACCOUNT_NUMBER";
    USASpecific["US_BANK_ROUTING_NUMBER"] = "US_BANK_ROUTING_NUMBER";
    USASpecific["US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER"] = "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER";
    USASpecific["US_PASSPORT_NUMBER"] = "US_PASSPORT_NUMBER";
    USASpecific["US_SOCIAL_SECURITY_NUMBER"] = "US_SOCIAL_SECURITY_NUMBER";
})(USASpecific || (exports.USASpecific = USASpecific = {}));
var CanadaSpecific;
(function (CanadaSpecific) {
    CanadaSpecific["CA_HEALTH_NUMBER"] = "CA_HEALTH_NUMBER";
    CanadaSpecific["CA_SOCIAL_INSURANCE_NUMBER"] = "CA_SOCIAL_INSURANCE_NUMBER";
})(CanadaSpecific || (exports.CanadaSpecific = CanadaSpecific = {}));
var UKSpecific;
(function (UKSpecific) {
    UKSpecific["UK_NATIONAL_HEALTH_SERVICE_NUMBER"] = "UK_NATIONAL_HEALTH_SERVICE_NUMBER";
    UKSpecific["UK_NATIONAL_INSURANCE_NUMBER"] = "UK_NATIONAL_INSURANCE_NUMBER";
    UKSpecific["UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"] = "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER";
})(UKSpecific || (exports.UKSpecific = UKSpecific = {}));
var PiiEntitiesConfigAction;
(function (PiiEntitiesConfigAction) {
    PiiEntitiesConfigAction["BLOCK"] = "BLOCK";
    PiiEntitiesConfigAction["MASK"] = "MASK";
})(PiiEntitiesConfigAction || (exports.PiiEntitiesConfigAction = PiiEntitiesConfigAction = {}));
class SensitiveInformationPolicyConfig extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.piiConfigList = [];
        this.piiConfigList = this.getPIIFilterList(props);
    }
    getPIIFilterList(props) {
        const piiList = [];
        if (props) {
            for (const pii of props) {
                piiList.push(this.getPIITypeString(pii));
            }
            return piiList;
        }
        else {
            throw new Error('No PII Configurations provided');
        }
    }
    getPIITypeString(props) {
        switch (props.type) {
            case General.ADDRESS:
            case General.AGE:
            case General.DRIVER_ID:
            case General.EMAIL:
            case General.LICENSE_PLATE:
            case General.NAME:
            case General.PASSWORD:
            case General.PHONE:
            case General.USERNAME:
            case General.VEHICLE_IDENTIFICATION_NUMBER:
            case InformationTechnology.URL:
            case InformationTechnology.IP_ADDRESS:
            case InformationTechnology.MAC_ADDRESS:
            case InformationTechnology.AWS_ACCESS_KEY:
            case InformationTechnology.AWS_SECRET_KEY:
            case Finance.CREDIT_DEBIT_CARD_CVV:
            case Finance.CREDIT_DEBIT_CARD_EXPIRY:
            case Finance.CREDIT_DEBIT_CARD_NUMBER:
            case Finance.PIN:
            case Finance.SWIFT_CODE:
            case Finance.INTERNATIONAL_BANK_ACCOUNT_NUMBER:
            case USASpecific.US_BANK_ACCOUNT_NUMBER:
            case USASpecific.US_BANK_ROUTING_NUMBER:
            case USASpecific.US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER:
            case USASpecific.US_PASSPORT_NUMBER:
            case USASpecific.US_SOCIAL_SECURITY_NUMBER:
            case CanadaSpecific.CA_HEALTH_NUMBER:
            case CanadaSpecific.CA_SOCIAL_INSURANCE_NUMBER:
            case UKSpecific.UK_NATIONAL_HEALTH_SERVICE_NUMBER:
            case UKSpecific.UK_NATIONAL_INSURANCE_NUMBER:
            case UKSpecific.UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER:
                return {
                    type: props.type,
                    action: props.action ?? 'BLOCK',
                };
            default:
                throw new Error('No valid PersonalIdentifiableInformation value');
        }
    }
}
exports.SensitiveInformationPolicyConfig = SensitiveInformationPolicyConfig;
_a = JSII_RTTI_SYMBOL_1;
SensitiveInformationPolicyConfig[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.SensitiveInformationPolicyConfig", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,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