/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { aws_bedrock as bedrock } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export declare enum General {
    ADDRESS = "ADDRESS",
    AGE = "AGE",
    DRIVER_ID = "DRIVER_ID",
    EMAIL = "EMAIL",
    LICENSE_PLATE = "LICENSE_PLATE",
    NAME = "NAME",
    PASSWORD = "PASSWORD",
    PHONE = "PHONE",
    USERNAME = "USERNAME",
    VEHICLE_IDENTIFICATION_NUMBER = "VEHICLE_IDENTIFICATION_NUMBER"
}
export declare enum Finance {
    CREDIT_DEBIT_CARD_CVV = "CREDIT_DEBIT_CARD_CVV",
    CREDIT_DEBIT_CARD_EXPIRY = "CREDIT_DEBIT_CARD_EXPIRY",
    CREDIT_DEBIT_CARD_NUMBER = "CREDIT_DEBIT_CARD_NUMBER",
    PIN = "PIN",
    SWIFT_CODE = "SWIFT_CODE",
    INTERNATIONAL_BANK_ACCOUNT_NUMBER = "INTERNATIONAL_BANK_ACCOUNT_NUMBER"
}
export declare enum InformationTechnology {
    URL = "URL",
    IP_ADDRESS = "IP_ADDRESS",
    MAC_ADDRESS = "MAC_ADDRESS",
    AWS_ACCESS_KEY = "AWS_ACCESS_KEY",
    AWS_SECRET_KEY = "AWS_SECRET_KEY"
}
export declare enum USASpecific {
    US_BANK_ACCOUNT_NUMBER = "US_BANK_ACCOUNT_NUMBER",
    US_BANK_ROUTING_NUMBER = "US_BANK_ROUTING_NUMBER",
    US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER = "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER",
    US_PASSPORT_NUMBER = "US_PASSPORT_NUMBER",
    US_SOCIAL_SECURITY_NUMBER = "US_SOCIAL_SECURITY_NUMBER"
}
export declare enum CanadaSpecific {
    CA_HEALTH_NUMBER = "CA_HEALTH_NUMBER",
    CA_SOCIAL_INSURANCE_NUMBER = "CA_SOCIAL_INSURANCE_NUMBER"
}
export declare enum UKSpecific {
    UK_NATIONAL_HEALTH_SERVICE_NUMBER = "UK_NATIONAL_HEALTH_SERVICE_NUMBER",
    UK_NATIONAL_INSURANCE_NUMBER = "UK_NATIONAL_INSURANCE_NUMBER",
    UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER = "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"
}
export declare enum PiiEntitiesConfigAction {
    BLOCK = "BLOCK",
    MASK = "MASK"
}
export interface SensitiveInformationPolicyConfigProps {
    readonly type: General | InformationTechnology | Finance | USASpecific | CanadaSpecific | UKSpecific;
    readonly action: PiiEntitiesConfigAction;
}
export declare class SensitiveInformationPolicyConfig extends Construct {
    readonly piiConfigList: bedrock.CfnGuardrail.PiiEntityConfigProperty[];
    constructor(scope: Construct, id: string, props: SensitiveInformationPolicyConfigProps[]);
    private getPIIFilterList;
    private getPIITypeString;
}
