/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { CfnTag, aws_bedrock as bedrock } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { ContentPolicyConfigProps } from './content-policy';
import { GuardrailVersion } from './guardrail-version';
import { SensitiveInformationPolicyConfigProps } from './pii-list';
import { Topic } from './topic-list';
/**
 * Bedrock guardrail props
 */
export interface GuardrailProps {
    /**
     * The message to return when the guardrail blocks a prompt.
     */
    readonly blockedInputMessaging?: string;
    /**
     * The message to return when the guardrail blocks a model response.
     */
    readonly blockedOutputsMessaging?: string;
    /**
     * The name of the guardrail.
     */
    readonly name?: string;
    /**
      * List of content filter configs in content policy.
      */
    readonly filtersConfig?: ContentPolicyConfigProps[];
    /**
      * PII fields which needs to be masked.
      */
    readonly piiConfig?: SensitiveInformationPolicyConfigProps[];
    /**
     * The description of the guardrail.
     */
    readonly description?: string;
    /**
     * The ARN of the AWS KMS key used to encrypt the guardrail.
     */
    readonly kmsKeyArn?: string;
    /**
     * Metadata that you can assign to a guardrail as key-value pairs
     *
     */
    readonly tags?: Array<CfnTag>;
}
/**
 * Deploy bedrock guardrail .
 */
export declare class Guardrail extends Construct {
    /**
     * The name of the guardrail.
     */
    readonly name: string;
    /**
     * The ARN of the AWS KMS key used to encrypt the guardrail.
     *
     * @default
     */
    readonly kmsKeyArn: string;
    /**
     * guardrail version
     *
     * @default
     */
    readonly guardrailVersion: string;
    /**
     * guardrail Id
     *
     * @default
     */
    readonly guardrailId: string;
    /**
     * Instance of guardrail
     */
    readonly guardrailInstance: bedrock.CfnGuardrail;
    constructor(scope: Construct, id: string, props: GuardrailProps);
    addSensitiveInformationPolicyConfig(props: SensitiveInformationPolicyConfigProps[], guardrailRegexesConfig: bedrock.CfnGuardrail.RegexConfigProperty): void;
    uploadWordPolicyFromFile(filePath: string): Promise<void>;
    addWordPolicyConfig(wordsFilter?: bedrock.CfnGuardrail.WordConfigProperty[]): void;
    addTopicPolicyConfig(topic: Topic): void;
    addTags(props: GuardrailProps): void;
    /**
     * Creates a version of the guardrail.
     */
    addVersion(id: string, description?: string): GuardrailVersion;
}
