"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuardrailVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Creates a version of the guardrail.
 *
 * Use this API to create a snapshot of the guardrail when you are satisfied with
 * a configuration, or to compare the configuration with another version.
 */
class GuardrailVersion extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.guardrailVersionInstance = new aws_cdk_lib_1.aws_bedrock.CfnGuardrailVersion(this, id, props);
    }
}
exports.GuardrailVersion = GuardrailVersion;
_a = JSII_RTTI_SYMBOL_1;
GuardrailVersion[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.GuardrailVersion", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,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