"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentPolicyConfig = exports.FiltersConfigStrength = exports.FiltersConfigType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
var FiltersConfigType;
(function (FiltersConfigType) {
    FiltersConfigType["VIOLENCE"] = "VIOLENCE";
    FiltersConfigType["HATE"] = "HATE";
    FiltersConfigType["INSULTS"] = "INSULTS";
    FiltersConfigType["MISCONDUCT"] = "MISCONDUCT";
    FiltersConfigType["PROMPT_ATTACK"] = "PROMPT_ATTACK";
    FiltersConfigType["SEXUAL"] = "SEXUAL";
})(FiltersConfigType || (exports.FiltersConfigType = FiltersConfigType = {}));
var FiltersConfigStrength;
(function (FiltersConfigStrength) {
    FiltersConfigStrength["NONE"] = "NONE";
    FiltersConfigStrength["LOW"] = "LOW";
    FiltersConfigStrength["MEDIUM"] = "MEDIUM";
    FiltersConfigStrength["HIGH"] = "HIGH";
})(FiltersConfigStrength || (exports.FiltersConfigStrength = FiltersConfigStrength = {}));
class ContentPolicyConfig extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.contentPolicyConfigList = this.createContentPolicyConfigList(props);
    }
    createContentPolicyConfigList(props) {
        const configList = [];
        if (props) {
            for (const prop of props) {
                configList.push(this.createContentFilterConfig(prop));
            }
        }
        else {
            // set deafault content policy config
            configList.push({
                type: FiltersConfigType.HATE,
                inputStrength: FiltersConfigStrength.HIGH,
                outputStrength: FiltersConfigStrength.HIGH,
            }, {
                type: FiltersConfigType.VIOLENCE,
                inputStrength: FiltersConfigStrength.HIGH,
                outputStrength: FiltersConfigStrength.HIGH,
            }, {
                type: FiltersConfigType.MISCONDUCT,
                inputStrength: FiltersConfigStrength.HIGH,
                outputStrength: FiltersConfigStrength.HIGH,
            }, {
                type: FiltersConfigType.PROMPT_ATTACK,
                inputStrength: FiltersConfigStrength.NONE,
                outputStrength: FiltersConfigStrength.NONE,
            }, {
                type: FiltersConfigType.SEXUAL,
                inputStrength: FiltersConfigStrength.HIGH,
                outputStrength: FiltersConfigStrength.HIGH,
            }, {
                type: FiltersConfigType.INSULTS,
                inputStrength: FiltersConfigStrength.HIGH,
                outputStrength: FiltersConfigStrength.HIGH,
            });
        }
        return configList;
    }
    createContentFilterConfig(prop) {
        switch (prop.filtersConfigType) {
            case FiltersConfigType.HATE:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.HATE,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            case FiltersConfigType.PROMPT_ATTACK:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.PROMPT_ATTACK,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            case FiltersConfigType.SEXUAL:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.SEXUAL,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            case FiltersConfigType.MISCONDUCT:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.MISCONDUCT,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            case FiltersConfigType.INSULTS:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.INSULTS,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            case FiltersConfigType.VIOLENCE:
                return {
                    type: prop.filtersConfigType ?? FiltersConfigType.VIOLENCE,
                    inputStrength: prop.inputStrength ?? FiltersConfigStrength.NONE,
                    outputStrength: prop.outputStrength ?? FiltersConfigStrength.NONE,
                };
            default:
                throw new Error('Invalid content ploicy config type');
        }
    }
}
exports.ContentPolicyConfig = ContentPolicyConfig;
_a = JSII_RTTI_SYMBOL_1;
ContentPolicyConfig[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.ContentPolicyConfig", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,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