/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { aws_bedrock as bedrock } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export declare enum FiltersConfigType {
    VIOLENCE = "VIOLENCE",
    HATE = "HATE",
    INSULTS = "INSULTS",
    MISCONDUCT = "MISCONDUCT",
    PROMPT_ATTACK = "PROMPT_ATTACK",
    SEXUAL = "SEXUAL"
}
export declare enum FiltersConfigStrength {
    NONE = "NONE",
    LOW = "LOW",
    MEDIUM = "MEDIUM",
    HIGH = "HIGH"
}
export interface ContentPolicyConfigProps {
    readonly filtersConfigType: FiltersConfigType;
    readonly inputStrength?: FiltersConfigStrength;
    readonly outputStrength?: FiltersConfigStrength;
}
export declare class ContentPolicyConfig extends Construct {
    readonly contentPolicyConfigList: bedrock.CfnGuardrail.ContentFilterConfigProperty[];
    constructor(scope: Construct, id: string, props?: ContentPolicyConfigProps[]);
    private createContentPolicyConfigList;
    private createContentFilterConfig;
}
